/*
 * Decompiled with CFR 0.152.
 */
package COM.ibm.db2.jdbc.net;

import COM.ibm.db2.jdbc.DB2Trace;
import COM.ibm.db2.jdbc.net.DB2Connection;
import COM.ibm.db2.jdbc.net.DB2PreparedStatement;
import java.io.InputStream;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Time;
import java.sql.Timestamp;

public class DB2PreparedStatementTrace
extends DB2PreparedStatement {
    protected double timerSeconds = 0.0;

    public DB2PreparedStatementTrace(String string, DB2Connection dB2Connection) throws SQLException {
        super(string, dB2Connection);
        DB2Trace.getTraceObj(this.connection).traceEntry(this, "DB2PreparedStatement(" + string + ")");
        DB2Trace.getTraceObj(this.connection).println("Statement handle = " + this.getTraceHandle());
        DB2Trace.getTraceObj(this.connection).traceExit(this, "DB2PreparedStatement");
    }

    public void cancel() throws SQLException {
        try {
            DB2Trace.getTraceObj(this.connection).traceEntry(this, "cancel()");
            DB2Trace.getTraceObj(this.connection).println("Statement handle = " + this.getTraceHandle());
            long l = DB2Trace.timer();
            super.cancel();
            long l2 = DB2Trace.timer();
            this.timerSeconds = DB2Trace.computeTimeDiff(l, l2);
        }
        finally {
            Object var2_3 = null;
            DB2Trace.getTraceObj(this.connection).traceExit(this, "cancel - Time Elapsed = " + this.timerSeconds);
        }
    }

    public synchronized void clearParameters() throws SQLException {
        try {
            DB2Trace.getTraceObj(this.connection).traceEntry(this, "clearParameters()");
            DB2Trace.getTraceObj(this.connection).println("Statement handle = " + this.getTraceHandle());
            long l = DB2Trace.timer();
            super.clearParameters();
            long l2 = DB2Trace.timer();
            this.timerSeconds = DB2Trace.computeTimeDiff(l, l2);
        }
        finally {
            Object var2_3 = null;
            DB2Trace.getTraceObj(this.connection).traceExit(this, "clearParameters - Time Elapsed = " + this.timerSeconds);
        }
    }

    public synchronized void clearWarnings() throws SQLException {
        try {
            DB2Trace.getTraceObj(this.connection).traceEntry(this, "clearWarnings()");
            DB2Trace.getTraceObj(this.connection).println("Statement handle = " + this.getTraceHandle());
            long l = DB2Trace.timer();
            super.clearWarnings();
            long l2 = DB2Trace.timer();
            this.timerSeconds = DB2Trace.computeTimeDiff(l, l2);
        }
        finally {
            Object var2_3 = null;
            DB2Trace.getTraceObj(this.connection).traceExit(this, "clearWarnings - Time Elapsed = " + this.timerSeconds);
        }
    }

    public synchronized void close() throws SQLException {
        try {
            DB2Trace.getTraceObj(this.connection).traceEntry(this, "close()");
            DB2Trace.getTraceObj(this.connection).println("Statement handle = " + this.getTraceHandle());
            long l = DB2Trace.timer();
            super.close();
            long l2 = DB2Trace.timer();
            this.timerSeconds = DB2Trace.computeTimeDiff(l, l2);
        }
        finally {
            Object var2_3 = null;
            DB2Trace.getTraceObj(this.connection).traceExit(this, "close - Time Elapsed = " + this.timerSeconds);
        }
    }

    public synchronized boolean execute() throws SQLException {
        try {
            DB2Trace.getTraceObj(this.connection).traceEntry(this, "execute()");
            DB2Trace.getTraceObj(this.connection).println("Statement handle = " + this.getTraceHandle());
            long l = DB2Trace.timer();
            boolean bl = super.execute();
            long l2 = DB2Trace.timer();
            this.timerSeconds = DB2Trace.computeTimeDiff(l, l2);
            DB2Trace.getTraceObj(this.connection).println("Return value = " + bl);
            boolean bl2 = bl;
            Object var3_5 = null;
            DB2Trace.getTraceObj(this.connection).traceExit(this, "execute - Time Elapsed = " + this.timerSeconds);
            return bl2;
        }
        catch (Throwable throwable) {
            Object var3_6 = null;
            DB2Trace.getTraceObj(this.connection).traceExit(this, "execute - Time Elapsed = " + this.timerSeconds);
            throw throwable;
        }
    }

    public synchronized ResultSet executeQuery() throws SQLException {
        try {
            DB2Trace.getTraceObj(this.connection).traceEntry(this, "executeQuery()");
            DB2Trace.getTraceObj(this.connection).println("Statement handle = " + this.getTraceHandle());
            long l = DB2Trace.timer();
            ResultSet resultSet = super.executeQuery();
            long l2 = DB2Trace.timer();
            this.timerSeconds = DB2Trace.computeTimeDiff(l, l2);
            ResultSet resultSet2 = resultSet;
            Object var3_5 = null;
            DB2Trace.getTraceObj(this.connection).traceExit(this, "executeQuery - Time Elapsed = " + this.timerSeconds);
            return resultSet2;
        }
        catch (Throwable throwable) {
            Object var3_6 = null;
            DB2Trace.getTraceObj(this.connection).traceExit(this, "executeQuery - Time Elapsed = " + this.timerSeconds);
            throw throwable;
        }
    }

    public synchronized int executeUpdate() throws SQLException {
        try {
            DB2Trace.getTraceObj(this.connection).traceEntry(this, "executeUpdate()");
            DB2Trace.getTraceObj(this.connection).println("Statement handle = " + this.getTraceHandle());
            long l = DB2Trace.timer();
            int n = super.executeUpdate();
            long l2 = DB2Trace.timer();
            this.timerSeconds = DB2Trace.computeTimeDiff(l, l2);
            DB2Trace.getTraceObj(this.connection).println("Return value = " + n);
            int n2 = n;
            Object var3_5 = null;
            DB2Trace.getTraceObj(this.connection).traceExit(this, "executeUpdate - Time Elapsed = " + this.timerSeconds);
            return n2;
        }
        catch (Throwable throwable) {
            Object var3_6 = null;
            DB2Trace.getTraceObj(this.connection).traceExit(this, "executeUpdate - Time Elapsed = " + this.timerSeconds);
            throw throwable;
        }
    }

    public void finalize() throws SQLException {
        try {
            DB2Trace.getTraceObj(this.connection).traceEntry(this, "finalize()");
            DB2Trace.getTraceObj(this.connection).println("Statement handle = " + this.getTraceHandle());
            long l = DB2Trace.timer();
            super.finalize();
            long l2 = DB2Trace.timer();
            this.timerSeconds = DB2Trace.computeTimeDiff(l, l2);
        }
        finally {
            Object var2_3 = null;
            DB2Trace.getTraceObj(this.connection).traceExit(this, "finalize - Time Elapsed = " + this.timerSeconds);
        }
    }

    public int getMaxFieldSize() throws SQLException {
        try {
            DB2Trace.getTraceObj(this.connection).traceEntry(this, "getMaxFieldSize()");
            DB2Trace.getTraceObj(this.connection).println("Statement handle = " + this.getTraceHandle());
            long l = DB2Trace.timer();
            int n = super.getMaxFieldSize();
            long l2 = DB2Trace.timer();
            this.timerSeconds = DB2Trace.computeTimeDiff(l, l2);
            DB2Trace.getTraceObj(this.connection).println("Return value = " + n);
            int n2 = n;
            Object var3_5 = null;
            DB2Trace.getTraceObj(this.connection).traceExit(this, "getMaxFieldSize - Time Elapsed = " + this.timerSeconds);
            return n2;
        }
        catch (Throwable throwable) {
            Object var3_6 = null;
            DB2Trace.getTraceObj(this.connection).traceExit(this, "getMaxFieldSize - Time Elapsed = " + this.timerSeconds);
            throw throwable;
        }
    }

    public int getMaxRows() throws SQLException {
        try {
            DB2Trace.getTraceObj(this.connection).traceEntry(this, "getMaxRows()");
            DB2Trace.getTraceObj(this.connection).println("Statement handle = " + this.getTraceHandle());
            long l = DB2Trace.timer();
            int n = super.getMaxRows();
            long l2 = DB2Trace.timer();
            this.timerSeconds = DB2Trace.computeTimeDiff(l, l2);
            DB2Trace.getTraceObj(this.connection).println("Return value = " + n);
            int n2 = n;
            Object var3_5 = null;
            DB2Trace.getTraceObj(this.connection).traceExit(this, "getMaxRows - Time Elapsed = " + this.timerSeconds);
            return n2;
        }
        catch (Throwable throwable) {
            Object var3_6 = null;
            DB2Trace.getTraceObj(this.connection).traceExit(this, "getMaxRows - Time Elapsed = " + this.timerSeconds);
            throw throwable;
        }
    }

    public synchronized boolean getMoreResults() throws SQLException {
        try {
            DB2Trace.getTraceObj(this.connection).traceEntry(this, "getMoreResults()");
            DB2Trace.getTraceObj(this.connection).println("Statement handle = " + this.getTraceHandle());
            long l = DB2Trace.timer();
            boolean bl = super.getMoreResults();
            long l2 = DB2Trace.timer();
            this.timerSeconds = DB2Trace.computeTimeDiff(l, l2);
            DB2Trace.getTraceObj(this.connection).println("Return value = " + bl);
            boolean bl2 = bl;
            Object var3_5 = null;
            DB2Trace.getTraceObj(this.connection).traceExit(this, "getMoreResults - Time Elapsed = " + this.timerSeconds);
            return bl2;
        }
        catch (Throwable throwable) {
            Object var3_6 = null;
            DB2Trace.getTraceObj(this.connection).traceExit(this, "getMoreResults - Time Elapsed = " + this.timerSeconds);
            throw throwable;
        }
    }

    public int getQueryTimeout() throws SQLException {
        try {
            DB2Trace.getTraceObj(this.connection).traceEntry(this, "getQueryTimeout()");
            DB2Trace.getTraceObj(this.connection).println("Statement handle = " + this.getTraceHandle());
            long l = DB2Trace.timer();
            int n = super.getQueryTimeout();
            long l2 = DB2Trace.timer();
            this.timerSeconds = DB2Trace.computeTimeDiff(l, l2);
            DB2Trace.getTraceObj(this.connection).println("Return value = " + n);
            int n2 = n;
            Object var3_5 = null;
            DB2Trace.getTraceObj(this.connection).traceExit(this, "getQueryTimeout - Time Elapsed = " + this.timerSeconds);
            return n2;
        }
        catch (Throwable throwable) {
            Object var3_6 = null;
            DB2Trace.getTraceObj(this.connection).traceExit(this, "getQueryTimeout - Time Elapsed = " + this.timerSeconds);
            throw throwable;
        }
    }

    public ResultSet getResultSet() throws SQLException {
        try {
            DB2Trace.getTraceObj(this.connection).traceEntry(this, "getResultSet()");
            DB2Trace.getTraceObj(this.connection).println("Statement handle = " + this.getTraceHandle());
            long l = DB2Trace.timer();
            ResultSet resultSet = super.getResultSet();
            long l2 = DB2Trace.timer();
            this.timerSeconds = DB2Trace.computeTimeDiff(l, l2);
            ResultSet resultSet2 = resultSet;
            Object var3_5 = null;
            DB2Trace.getTraceObj(this.connection).traceExit(this, "getResultSet - Time Elapsed = " + this.timerSeconds);
            return resultSet2;
        }
        catch (Throwable throwable) {
            Object var3_6 = null;
            DB2Trace.getTraceObj(this.connection).traceExit(this, "getResultSet - Time Elapsed = " + this.timerSeconds);
            throw throwable;
        }
    }

    protected String getTraceHandle() {
        int n = this.statementHandle >> 16;
        int n2 = this.statementHandle & 0xFFFF;
        String string = String.valueOf(n) + ":" + n2;
        return string;
    }

    public int getUpdateCount() throws SQLException {
        try {
            DB2Trace.getTraceObj(this.connection).traceEntry(this, "getUpdateCount()");
            DB2Trace.getTraceObj(this.connection).println("Statement handle = " + this.getTraceHandle());
            long l = DB2Trace.timer();
            int n = super.getUpdateCount();
            long l2 = DB2Trace.timer();
            this.timerSeconds = DB2Trace.computeTimeDiff(l, l2);
            DB2Trace.getTraceObj(this.connection).println("Return value = " + n);
            int n2 = n;
            Object var3_5 = null;
            DB2Trace.getTraceObj(this.connection).traceExit(this, "getUpdateCount - Time Elapsed = " + this.timerSeconds);
            return n2;
        }
        catch (Throwable throwable) {
            Object var3_6 = null;
            DB2Trace.getTraceObj(this.connection).traceExit(this, "getUpdateCount - Time Elapsed = " + this.timerSeconds);
            throw throwable;
        }
    }

    public SQLWarning getWarnings() throws SQLException {
        try {
            DB2Trace.getTraceObj(this.connection).traceEntry(this, "getWarnings()");
            DB2Trace.getTraceObj(this.connection).println("Statement handle = " + this.getTraceHandle());
            long l = DB2Trace.timer();
            SQLWarning sQLWarning = super.getWarnings();
            long l2 = DB2Trace.timer();
            this.timerSeconds = DB2Trace.computeTimeDiff(l, l2);
            SQLWarning sQLWarning2 = sQLWarning;
            Object var3_5 = null;
            DB2Trace.getTraceObj(this.connection).traceExit(this, "getWarnings - Time Elapsed = " + this.timerSeconds);
            return sQLWarning2;
        }
        catch (Throwable throwable) {
            Object var3_6 = null;
            DB2Trace.getTraceObj(this.connection).traceExit(this, "getWarnings - Time Elapsed = " + this.timerSeconds);
            throw throwable;
        }
    }

    public synchronized void setAsciiStream(int n, InputStream inputStream, int n2) throws SQLException {
        try {
            DB2Trace.getTraceObj(this.connection).traceEntry(this, "setAsciiStream(" + n + ", ~~, " + n2 + ")");
            DB2Trace.getTraceObj(this.connection).println("Statement handle = " + this.getTraceHandle());
            long l = DB2Trace.timer();
            super.setAsciiStream(n, inputStream, n2);
            long l2 = DB2Trace.timer();
            this.timerSeconds = DB2Trace.computeTimeDiff(l, l2);
        }
        finally {
            Object var5_6 = null;
            DB2Trace.getTraceObj(this.connection).traceExit(this, "setAsciiStream - Time Elapsed = " + this.timerSeconds);
        }
    }

    public synchronized void setBigDecimal(int n, BigDecimal bigDecimal) throws SQLException {
        try {
            DB2Trace.getTraceObj(this.connection).traceEntry(this, "setBigDecimal(" + n + ", " + bigDecimal + ")");
            DB2Trace.getTraceObj(this.connection).println("Statement handle = " + this.getTraceHandle());
            long l = DB2Trace.timer();
            super.setBigDecimal(n, bigDecimal);
            long l2 = DB2Trace.timer();
            this.timerSeconds = DB2Trace.computeTimeDiff(l, l2);
        }
        finally {
            Object var4_5 = null;
            DB2Trace.getTraceObj(this.connection).traceExit(this, "setBigDecimal - Time Elapsed = " + this.timerSeconds);
        }
    }

    public synchronized void setBinaryStream(int n, InputStream inputStream, int n2) throws SQLException {
        try {
            DB2Trace.getTraceObj(this.connection).traceEntry(this, "setBinaryStream(" + n + ", ~~, " + n2 + ")");
            DB2Trace.getTraceObj(this.connection).println("Statement handle = " + this.getTraceHandle());
            long l = DB2Trace.timer();
            super.setBinaryStream(n, inputStream, n2);
            long l2 = DB2Trace.timer();
            this.timerSeconds = DB2Trace.computeTimeDiff(l, l2);
        }
        finally {
            Object var5_6 = null;
            DB2Trace.getTraceObj(this.connection).traceExit(this, "setBinaryStream - Time Elapsed = " + this.timerSeconds);
        }
    }

    public synchronized void setBoolean(int n, boolean bl) throws SQLException {
        try {
            DB2Trace.getTraceObj(this.connection).traceEntry(this, "setBoolean(" + n + ", " + bl + ")");
            DB2Trace.getTraceObj(this.connection).println("Statement handle = " + this.getTraceHandle());
            long l = DB2Trace.timer();
            super.setBoolean(n, bl);
            long l2 = DB2Trace.timer();
            this.timerSeconds = DB2Trace.computeTimeDiff(l, l2);
        }
        finally {
            Object var4_5 = null;
            DB2Trace.getTraceObj(this.connection).traceExit(this, "setBoolean - Time Elapsed = " + this.timerSeconds);
        }
    }

    public synchronized void setByte(int n, byte by) throws SQLException {
        try {
            DB2Trace.getTraceObj(this.connection).traceEntry(this, "setByte(" + n + ", " + by + ")");
            DB2Trace.getTraceObj(this.connection).println("Statement handle = " + this.getTraceHandle());
            long l = DB2Trace.timer();
            super.setByte(n, by);
            long l2 = DB2Trace.timer();
            this.timerSeconds = DB2Trace.computeTimeDiff(l, l2);
        }
        finally {
            Object var4_5 = null;
            DB2Trace.getTraceObj(this.connection).traceExit(this, "setByte - Time Elapsed = " + this.timerSeconds);
        }
    }

    public synchronized void setBytes(int n, byte[] byArray) throws SQLException {
        try {
            DB2Trace.getTraceObj(this.connection).traceEntry(this, "setBytes(" + n + ", " + byArray + ")");
            DB2Trace.getTraceObj(this.connection).println("Statement handle = " + this.getTraceHandle());
            DB2Trace.getTraceObj(this.connection).println("Input bytes = ", byArray);
            long l = DB2Trace.timer();
            super.setBytes(n, byArray);
            long l2 = DB2Trace.timer();
            this.timerSeconds = DB2Trace.computeTimeDiff(l, l2);
        }
        finally {
            Object var4_5 = null;
            DB2Trace.getTraceObj(this.connection).traceExit(this, "setBytes - Time Elapsed = " + this.timerSeconds);
        }
    }

    public void setCursorName(String string) throws SQLException {
        try {
            DB2Trace.getTraceObj(this.connection).traceEntry(this, "setCursorName(" + string + ")");
            DB2Trace.getTraceObj(this.connection).println("Statement handle = " + this.getTraceHandle());
            long l = DB2Trace.timer();
            super.setCursorName(string);
            long l2 = DB2Trace.timer();
            this.timerSeconds = DB2Trace.computeTimeDiff(l, l2);
        }
        finally {
            Object var3_4 = null;
            DB2Trace.getTraceObj(this.connection).traceExit(this, "setCursorName - Time Elapsed = " + this.timerSeconds);
        }
    }

    public synchronized void setDate(int n, Date date) throws SQLException {
        try {
            DB2Trace.getTraceObj(this.connection).traceEntry(this, "setDate(" + n + ", " + date + ")");
            DB2Trace.getTraceObj(this.connection).println("Statement handle = " + this.getTraceHandle());
            long l = DB2Trace.timer();
            super.setDate(n, date);
            long l2 = DB2Trace.timer();
            this.timerSeconds = DB2Trace.computeTimeDiff(l, l2);
        }
        finally {
            Object var4_5 = null;
            DB2Trace.getTraceObj(this.connection).traceExit(this, "setDate - Time Elapsed = " + this.timerSeconds);
        }
    }

    public synchronized void setDouble(int n, double d) throws SQLException {
        try {
            DB2Trace.getTraceObj(this.connection).traceEntry(this, "setDouble(" + n + ", " + d + ")");
            DB2Trace.getTraceObj(this.connection).println("Statement handle = " + this.getTraceHandle());
            long l = DB2Trace.timer();
            super.setDouble(n, d);
            long l2 = DB2Trace.timer();
            this.timerSeconds = DB2Trace.computeTimeDiff(l, l2);
        }
        finally {
            Object var5_5 = null;
            DB2Trace.getTraceObj(this.connection).traceExit(this, "setDouble - Time Elapsed = " + this.timerSeconds);
        }
    }

    public void setEscapeProcessing(boolean bl) throws SQLException {
        try {
            DB2Trace.getTraceObj(this.connection).traceEntry(this, "setEscapeProcessing(" + bl + ")");
            DB2Trace.getTraceObj(this.connection).println("Statement handle = " + this.getTraceHandle());
            long l = DB2Trace.timer();
            super.setEscapeProcessing(bl);
            long l2 = DB2Trace.timer();
            this.timerSeconds = DB2Trace.computeTimeDiff(l, l2);
        }
        finally {
            Object var3_4 = null;
            DB2Trace.getTraceObj(this.connection).traceExit(this, "setEscapeProcessing - Time Elapsed = " + this.timerSeconds);
        }
    }

    public synchronized void setFloat(int n, float f) throws SQLException {
        try {
            DB2Trace.getTraceObj(this.connection).traceEntry(this, "setFloat(" + n + ", " + f + ")");
            DB2Trace.getTraceObj(this.connection).println("Statement handle = " + this.getTraceHandle());
            long l = DB2Trace.timer();
            super.setFloat(n, f);
            long l2 = DB2Trace.timer();
            this.timerSeconds = DB2Trace.computeTimeDiff(l, l2);
        }
        finally {
            Object var4_5 = null;
            DB2Trace.getTraceObj(this.connection).traceExit(this, "setFloat - Time Elapsed = " + this.timerSeconds);
        }
    }

    public synchronized void setInt(int n, int n2) throws SQLException {
        try {
            DB2Trace.getTraceObj(this.connection).traceEntry(this, "setInt(" + n + ", " + n2 + ")");
            DB2Trace.getTraceObj(this.connection).println("Statement handle = " + this.getTraceHandle());
            long l = DB2Trace.timer();
            super.setInt(n, n2);
            long l2 = DB2Trace.timer();
            this.timerSeconds = DB2Trace.computeTimeDiff(l, l2);
        }
        finally {
            Object var4_5 = null;
            DB2Trace.getTraceObj(this.connection).traceExit(this, "setInt - Time Elapsed = " + this.timerSeconds);
        }
    }

    public synchronized void setLong(int n, long l) throws SQLException {
        try {
            DB2Trace.getTraceObj(this.connection).traceEntry(this, "setLong(" + n + ", " + l + ")");
            DB2Trace.getTraceObj(this.connection).println("Statement handle = " + this.getTraceHandle());
            long l2 = DB2Trace.timer();
            super.setLong(n, l);
            long l3 = DB2Trace.timer();
            this.timerSeconds = DB2Trace.computeTimeDiff(l2, l3);
        }
        finally {
            Object var5_5 = null;
            DB2Trace.getTraceObj(this.connection).traceExit(this, "setLong - Time Elapsed = " + this.timerSeconds);
        }
    }

    public synchronized void setMaxFieldSize(int n) throws SQLException {
        try {
            DB2Trace.getTraceObj(this.connection).traceEntry(this, "setMaxFieldSize(" + n + ")");
            DB2Trace.getTraceObj(this.connection).println("Statement handle = " + this.getTraceHandle());
            long l = DB2Trace.timer();
            super.setMaxFieldSize(n);
            long l2 = DB2Trace.timer();
            this.timerSeconds = DB2Trace.computeTimeDiff(l, l2);
        }
        finally {
            Object var3_4 = null;
            DB2Trace.getTraceObj(this.connection).traceExit(this, "setMaxFieldSize - Time Elapsed = " + this.timerSeconds);
        }
    }

    public synchronized void setMaxRows(int n) throws SQLException {
        try {
            DB2Trace.getTraceObj(this.connection).traceEntry(this, "setMaxRows(" + n + ")");
            DB2Trace.getTraceObj(this.connection).println("Statement handle = " + this.getTraceHandle());
            long l = DB2Trace.timer();
            super.setMaxRows(n);
            long l2 = DB2Trace.timer();
            this.timerSeconds = DB2Trace.computeTimeDiff(l, l2);
        }
        finally {
            Object var3_4 = null;
            DB2Trace.getTraceObj(this.connection).traceExit(this, "setMaxRows - Time Elapsed = " + this.timerSeconds);
        }
    }

    public synchronized void setNull(int n, int n2) throws SQLException {
        try {
            DB2Trace.getTraceObj(this.connection).traceEntry(this, "setNull(" + n + ", " + n2 + ")");
            DB2Trace.getTraceObj(this.connection).println("Statement handle = " + this.getTraceHandle());
            long l = DB2Trace.timer();
            super.setNull(n, n2);
            long l2 = DB2Trace.timer();
            this.timerSeconds = DB2Trace.computeTimeDiff(l, l2);
        }
        finally {
            Object var4_5 = null;
            DB2Trace.getTraceObj(this.connection).traceExit(this, "setNull - Time Elapsed = " + this.timerSeconds);
        }
    }

    public synchronized void setObject(int n, Object object) throws SQLException {
        try {
            DB2Trace.getTraceObj(this.connection).traceEntry(this, "setObject(" + n + ", " + object + ")");
            DB2Trace.getTraceObj(this.connection).println("Statement handle = " + this.getTraceHandle());
            long l = DB2Trace.timer();
            super.setObject(n, object);
            long l2 = DB2Trace.timer();
            this.timerSeconds = DB2Trace.computeTimeDiff(l, l2);
        }
        finally {
            Object var4_5 = null;
            DB2Trace.getTraceObj(this.connection).traceExit(this, "setObject - Time Elapsed = " + this.timerSeconds);
        }
    }

    public void setObject(int n, Object object, int n2) throws SQLException {
        try {
            DB2Trace.getTraceObj(this.connection).traceEntry(this, "setObject(" + n + ", " + object + ", " + n2 + ")");
            DB2Trace.getTraceObj(this.connection).println("Statement handle = " + this.getTraceHandle());
            long l = DB2Trace.timer();
            super.setObject(n, object, n2);
            long l2 = DB2Trace.timer();
            this.timerSeconds = DB2Trace.computeTimeDiff(l, l2);
        }
        finally {
            Object var5_6 = null;
            DB2Trace.getTraceObj(this.connection).traceExit(this, "setObject - Time Elapsed = " + this.timerSeconds);
        }
    }

    public synchronized void setObject(int n, Object object, int n2, int n3) throws SQLException {
        try {
            DB2Trace.getTraceObj(this.connection).traceEntry(this, "setObject(" + n + ", " + object + ", " + n2 + ", " + n3 + ")");
            DB2Trace.getTraceObj(this.connection).println("Statement handle = " + this.getTraceHandle());
            long l = DB2Trace.timer();
            super.setObject(n, object, n2, n3);
            long l2 = DB2Trace.timer();
            this.timerSeconds = DB2Trace.computeTimeDiff(l, l2);
        }
        finally {
            Object var6_7 = null;
            DB2Trace.getTraceObj(this.connection).traceExit(this, "setObject - Time Elapsed = " + this.timerSeconds);
        }
    }

    public void setQueryTimeout(int n) throws SQLException {
        try {
            DB2Trace.getTraceObj(this.connection).traceEntry(this, "setQueryTimeout(" + n + ")");
            DB2Trace.getTraceObj(this.connection).println("Statement handle = " + this.getTraceHandle());
            long l = DB2Trace.timer();
            super.setQueryTimeout(n);
            long l2 = DB2Trace.timer();
            this.timerSeconds = DB2Trace.computeTimeDiff(l, l2);
        }
        finally {
            Object var3_4 = null;
            DB2Trace.getTraceObj(this.connection).traceExit(this, "setQueryTimeout - Time Elapsed = " + this.timerSeconds);
        }
    }

    public synchronized void setShort(int n, short s) throws SQLException {
        try {
            DB2Trace.getTraceObj(this.connection).traceEntry(this, "setShort(" + n + ", " + s + ")");
            DB2Trace.getTraceObj(this.connection).println("Statement handle = " + this.getTraceHandle());
            long l = DB2Trace.timer();
            super.setShort(n, s);
            long l2 = DB2Trace.timer();
            this.timerSeconds = DB2Trace.computeTimeDiff(l, l2);
        }
        finally {
            Object var4_5 = null;
            DB2Trace.getTraceObj(this.connection).traceExit(this, "setShort - Time Elapsed = " + this.timerSeconds);
        }
    }

    public synchronized void setString(int n, String string) throws SQLException {
        try {
            DB2Trace.getTraceObj(this.connection).traceEntry(this, "setString(" + n + ", " + string + ")");
            DB2Trace.getTraceObj(this.connection).println("Statement handle = " + this.getTraceHandle());
            long l = DB2Trace.timer();
            super.setString(n, string);
            long l2 = DB2Trace.timer();
            this.timerSeconds = DB2Trace.computeTimeDiff(l, l2);
        }
        finally {
            Object var4_5 = null;
            DB2Trace.getTraceObj(this.connection).traceExit(this, "setString - Time Elapsed = " + this.timerSeconds);
        }
    }

    public synchronized void setTime(int n, Time time) throws SQLException {
        try {
            DB2Trace.getTraceObj(this.connection).traceEntry(this, "setTime(" + n + ", " + time + ")");
            DB2Trace.getTraceObj(this.connection).println("Statement handle = " + this.getTraceHandle());
            long l = DB2Trace.timer();
            super.setTime(n, time);
            long l2 = DB2Trace.timer();
            this.timerSeconds = DB2Trace.computeTimeDiff(l, l2);
        }
        finally {
            Object var4_5 = null;
            DB2Trace.getTraceObj(this.connection).traceExit(this, "setTime - Time Elapsed = " + this.timerSeconds);
        }
    }

    public synchronized void setTimestamp(int n, Timestamp timestamp) throws SQLException {
        try {
            DB2Trace.getTraceObj(this.connection).traceEntry(this, "setTimestamp(" + n + ", " + timestamp + ")");
            DB2Trace.getTraceObj(this.connection).println("Statement handle = " + this.getTraceHandle());
            long l = DB2Trace.timer();
            super.setTimestamp(n, timestamp);
            long l2 = DB2Trace.timer();
            this.timerSeconds = DB2Trace.computeTimeDiff(l, l2);
        }
        finally {
            Object var4_5 = null;
            DB2Trace.getTraceObj(this.connection).traceExit(this, "setTimestamp - Time Elapsed = " + this.timerSeconds);
        }
    }

    public synchronized void setUnicodeStream(int n, InputStream inputStream, int n2) throws SQLException {
        try {
            DB2Trace.getTraceObj(this.connection).traceEntry(this, "setUnicodeStream(" + n + ", ~~, " + n2 + ")");
            DB2Trace.getTraceObj(this.connection).println("Statement handle = " + this.getTraceHandle());
            long l = DB2Trace.timer();
            super.setUnicodeStream(n, inputStream, n2);
            long l2 = DB2Trace.timer();
            this.timerSeconds = DB2Trace.computeTimeDiff(l, l2);
        }
        finally {
            Object var5_6 = null;
            DB2Trace.getTraceObj(this.connection).traceExit(this, "setUnicodeStream - Time Elapsed = " + this.timerSeconds);
        }
    }
}

