/*
 * Decompiled with CFR 0.152.
 */
package COM.ibm.db2.jdbc.net;

import COM.ibm.db2.jdbc.DB2Trace;
import COM.ibm.db2.jdbc.net.DB2Request;
import COM.ibm.db2.jdbc.net.DB2RequestTrace;
import COM.ibm.db2.jdbc.net.DB2ResultSet;
import COM.ibm.db2.jdbc.net.DB2Statement;
import java.io.IOException;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;

public class DB2ResultSetMetaData
implements ResultSetMetaData {
    protected DB2Statement statement;
    protected DB2ResultSet resultset;
    protected DB2Request db2req;
    protected boolean mappedRS = false;
    protected int arrayLen = 0;
    protected int colCount;
    protected String[] colNames = null;
    protected int[] colTypes = null;
    protected int[] colBaseTypesNotAdjusted = null;
    protected int[] precisions = null;
    protected int[] scales = null;

    public DB2ResultSetMetaData(DB2Statement dB2Statement, DB2ResultSet dB2ResultSet, int n, boolean bl) throws SQLException {
        this.statement = dB2Statement;
        this.resultset = dB2ResultSet;
        this.db2req = !DB2Trace.TraceOn ? new DB2Request(this.statement.db2req) : new DB2RequestTrace(this.statement.db2req);
        this.mappedRS = bl;
        this.activate(dB2Statement.colCount);
        this.colCount = n;
    }

    protected int SQLColAttributes_int(int n, int n2) throws SQLException {
        n = this.resultset.getMappedColumn(n);
        int n3 = 0;
        try {
            DB2Request dB2Request = this.db2req;
            synchronized (dB2Request) {
                this.db2req.write((short)92);
                this.db2req.write(this.statement.statementHandle);
                this.db2req.write(n);
                this.db2req.write(n2);
                this.db2req.sendAndRecv();
                int n4 = this.db2req.readInt();
                if (n4 != 1 && n4 != 0) {
                    this.statement.sqlExcptGen.check_return_code(this.statement, n4);
                }
                n3 = this.db2req.readInt();
            }
        }
        catch (IOException iOException) {
            this.statement.sqlExcptGen.socketException("08S01a");
        }
        return n3;
    }

    protected String SQLColAttributes_str(int n, int n2) throws SQLException {
        n = this.resultset.getMappedColumn(n);
        String string = null;
        try {
            DB2Request dB2Request = this.db2req;
            synchronized (dB2Request) {
                this.db2req.write((short)91);
                this.db2req.write(this.statement.statementHandle);
                this.db2req.write(n);
                this.db2req.write(n2);
                this.db2req.sendAndRecv();
                int n3 = this.db2req.readInt();
                if (n3 != 1 && n3 != 0) {
                    this.statement.sqlExcptGen.check_return_code(this.statement, n3);
                }
                string = this.db2req.readString();
            }
        }
        catch (IOException iOException) {
            this.statement.sqlExcptGen.socketException("08S01a");
        }
        return string;
    }

    protected void activate(int n) throws SQLException {
        if (n < 0) {
            return;
        }
        this.colCount = n;
        if (n > this.arrayLen) {
            this.arrayLen = n;
            this.colTypes = new int[n];
            this.colBaseTypesNotAdjusted = new int[n];
            this.precisions = new int[n];
            this.scales = new int[n];
            this.colNames = new String[n];
            this.resultset.preFetched = new boolean[n];
        }
        if (n < 1) {
            return;
        }
        try {
            this.db2req.write((short)90);
            this.db2req.write(this.statement.statementHandle);
            this.db2req.sendAndRecv();
            int n2 = this.db2req.readInt();
            if (n2 != 0) {
                if (n2 != -99) {
                    this.statement.sqlExcptGen.check_return_code(this.statement, n2);
                }
                int n3 = 0;
                while (n3 < n) {
                    this.resultset.preFetched[n3] = false;
                    this.colTypes[n3] = -99999;
                    this.colBaseTypesNotAdjusted[n3] = -99999;
                    this.precisions[n3] = 0;
                    this.scales[n3] = 0;
                    this.colNames[n3] = "";
                    ++n3;
                }
                return;
            }
            int n4 = 0;
            while (n4 < n) {
                this.resultset.preFetched[n4] = this.db2req.readBoolean();
                this.colTypes[n4] = this.db2req.readShort();
                this.colBaseTypesNotAdjusted[n4] = this.db2req.readShort();
                this.precisions[n4] = this.db2req.readInt();
                this.scales[n4] = this.db2req.readShort();
                this.colNames[n4] = this.db2req.readString();
                ++n4;
            }
        }
        catch (IOException iOException) {
            this.statement.sqlExcptGen.socketException("08S01a");
        }
    }

    protected int checkColumnIndex(int n) throws SQLException {
        if (!this.mappedRS) {
            if (n < 1 || n > this.colCount) {
                this.statement.sqlExcptGen.throwColumnIndexError();
            }
            return n;
        }
        return this.resultset.getMappedColumn(n);
    }

    public String getCatalogName(int n) throws SQLException {
        String string = this.SQLColAttributes_str(n = this.checkColumnIndex(n), 17);
        if (string == null) {
            return new String("");
        }
        return string;
    }

    public String getColumnClassName(int n) throws SQLException {
        if (DB2Trace.TraceOn) {
            DB2Trace.methodEntry(this, "getColumnClassName( " + n + " )");
        }
        String string = null;
        int n2 = this.resultset.connection.adjust(this.colBaseTypesNotAdjusted[n - 1]);
        if (DB2Trace.TraceOn) {
            DB2Trace.data(10, "colBaseType", n2);
        }
        switch (n2) {
            case -1: 
            case 1: 
            case 12: {
                string = "java.lang.String";
                break;
            }
            case 2: 
            case 3: {
                string = "java.math.BigDecimal";
                break;
            }
            case -7: {
                string = "java.lang.Boolean";
                break;
            }
            case -6: {
                string = "java.lang.Integer";
                break;
            }
            case 5: {
                string = "java.lang.Short";
                break;
            }
            case 4: {
                string = "java.lang.Integer";
                break;
            }
            case -5: {
                string = "java.lang.Long";
                break;
            }
            case 6: 
            case 7: {
                string = "java.lang.Float";
                break;
            }
            case 8: {
                string = "java.lang.Double";
                break;
            }
            case -4: 
            case -3: 
            case -2: {
                string = "[B";
                break;
            }
            case 91: {
                string = "java.sql.Date";
                break;
            }
            case 92: {
                string = "java.sql.Time";
                break;
            }
            case 93: {
                string = "java.sql.Timestamp";
                break;
            }
            case 70: {
                string = null;
                break;
            }
            case 2004: {
                string = "java.sql.Blob";
                break;
            }
            case 2005: {
                string = "java.sql.Clob";
                break;
            }
            case 2001: {
                string = "java.sql.Distinct";
                break;
            }
            case 2006: {
                string = "java.sql.Ref";
                break;
            }
            case 2002: {
                string = "java.sql.Struct";
                break;
            }
            default: {
                this.statement.sqlExcptGen.rsException("S1004");
            }
        }
        if (DB2Trace.TraceOn) {
            DB2Trace.methodExit((Object)this, "getColumnClassName()", string);
        }
        return string;
    }

    public int getColumnCount() throws SQLException {
        if (!this.mappedRS) {
            if (this.colCount == 0) {
                this.colCount = this.SQLColAttributes_int(1, 0);
            }
            return this.colCount;
        }
        return this.resultset.getColumnCount();
    }

    public int getColumnDisplaySize(int n) throws SQLException {
        n = this.checkColumnIndex(n);
        return this.SQLColAttributes_int(n, 6);
    }

    public String getColumnLabel(int n) throws SQLException {
        n = this.checkColumnIndex(n);
        return this.SQLColAttributes_str(n, 18);
    }

    public String getColumnName(int n) throws SQLException {
        n = this.checkColumnIndex(n);
        if (this.colNames != null) {
            return this.colNames[n - 1];
        }
        return this.SQLColAttributes_str(n, 1);
    }

    public int getColumnType(int n) throws SQLException {
        n = this.checkColumnIndex(n);
        return this.resultset.connection.adjust(this.colTypes[n - 1]);
    }

    public String getColumnTypeName(int n) throws SQLException {
        n = this.checkColumnIndex(n);
        return this.SQLColAttributes_str(n, 14);
    }

    public int getPrecision(int n) throws SQLException {
        n = this.checkColumnIndex(n);
        if (this.precisions != null) {
            return this.precisions[n - 1];
        }
        return this.SQLColAttributes_int(n, 4);
    }

    public int getScale(int n) throws SQLException {
        n = this.checkColumnIndex(n);
        if (this.scales != null) {
            return this.scales[n - 1];
        }
        return this.SQLColAttributes_int(n, 5);
    }

    public String getSchemaName(int n) throws SQLException {
        String string = this.SQLColAttributes_str(n = this.checkColumnIndex(n), 16);
        if (string == null) {
            return new String("");
        }
        return string;
    }

    public String getTableName(int n) throws SQLException {
        String string = this.SQLColAttributes_str(n = this.checkColumnIndex(n), 15);
        if (string == null) {
            return new String("");
        }
        return string;
    }

    public boolean isAutoIncrement(int n) throws SQLException {
        int n2 = this.SQLColAttributes_int(n = this.checkColumnIndex(n), 11);
        return n2 == 1;
    }

    public boolean isCaseSensitive(int n) throws SQLException {
        int n2 = this.SQLColAttributes_int(n = this.checkColumnIndex(n), 0);
        return n2 == 1;
    }

    public boolean isCurrency(int n) throws SQLException {
        int n2 = this.SQLColAttributes_int(n = this.checkColumnIndex(n), 9);
        return n2 == 1;
    }

    public boolean isDefinitelyWritable(int n) throws SQLException {
        n = this.checkColumnIndex(n);
        return false;
    }

    public int isNullable(int n) throws SQLException {
        int n2 = this.SQLColAttributes_int(n = this.checkColumnIndex(n), 7);
        if (n2 == 1) {
            return 1;
        }
        if (n2 == 0) {
            return 0;
        }
        return 2;
    }

    public boolean isReadOnly(int n) throws SQLException {
        int n2 = this.SQLColAttributes_int(n = this.checkColumnIndex(n), 10);
        return n2 == 0;
    }

    public boolean isSearchable(int n) throws SQLException {
        int n2 = this.SQLColAttributes_int(n = this.checkColumnIndex(n), 13);
        return n2 != 0;
    }

    public boolean isSigned(int n) throws SQLException {
        int n2 = this.SQLColAttributes_int(n = this.checkColumnIndex(n), 8);
        return n2 != 1;
    }

    public boolean isWritable(int n) throws SQLException {
        int n2 = this.SQLColAttributes_int(n = this.checkColumnIndex(n), 10);
        return n2 != 0;
    }
}

