/*
 * Decompiled with CFR 0.152.
 */
package COM.ibm.db2.jdbc.net;

import COM.ibm.db2.jdbc.DB2Trace;
import COM.ibm.db2.jdbc.net.DB2Binary2AsciiInputStream;
import COM.ibm.db2.jdbc.net.DB2Blob;
import COM.ibm.db2.jdbc.net.DB2CharReader;
import COM.ibm.db2.jdbc.net.DB2Clob;
import COM.ibm.db2.jdbc.net.DB2Connection;
import COM.ibm.db2.jdbc.net.DB2DataObject;
import COM.ibm.db2.jdbc.net.DB2InputStream;
import COM.ibm.db2.jdbc.net.DB2Request;
import COM.ibm.db2.jdbc.net.DB2ResultSet;
import COM.ibm.db2.jdbc.net.DB2Statement;
import COM.ibm.db2.jdbc.net.SQLExceptionGenerator;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.sql.DataTruncation;
import java.sql.Date;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;

public class DB2RowObject {
    protected DB2Connection connection = null;
    protected DB2Statement statement = null;
    protected DB2ResultSet resultset = null;
    protected DB2Request db2req = null;
    protected SQLExceptionGenerator sqlExcptGen = null;
    protected int length = 0;
    protected Object[] sqldata = null;
    protected int[] sqlind = null;
    protected short[] sqltype = null;
    protected boolean cleared = true;
    protected int rowsBlocked = 0;
    protected int arrayLen = 0;
    protected int SQL_NULL_DATA = -1;

    public DB2RowObject() throws SQLException {
    }

    public DB2RowObject(DB2ResultSet dB2ResultSet) throws SQLException {
        this.connection = dB2ResultSet.statement.connection;
        this.resultset = dB2ResultSet;
        this.statement = dB2ResultSet.statement;
        this.db2req = dB2ResultSet.db2req;
        this.sqlExcptGen = dB2ResultSet.sqlExcptGen;
    }

    protected int absolute(int n) throws SQLException {
        return this.fetchScroll(5, n);
    }

    protected void activate() throws SQLException {
        boolean bl = false;
        this.cleared = false;
        this.length = this.resultset.statement.colCount;
        this.rowsBlocked = 0;
        if (this.length > this.arrayLen) {
            this.arrayLen = this.length;
            this.sqltype = new short[this.length];
            this.sqlind = new int[this.length];
            this.sqldata = new Object[this.length];
            bl = true;
        }
        int n = 0;
        while (n < this.length) {
            short s = (short)this.resultset.rsMetaData.colBaseTypesNotAdjusted[n];
            if (bl || s != this.sqltype[n]) {
                this.sqltype[n] = s;
                if (DB2Trace.TraceOn) {
                    DB2Trace.data(10, "sqltype[" + n + "]", this.sqltype[n]);
                }
                switch (s) {
                    case 5: {
                        this.sqldata[n] = new DB2DataObject();
                        break;
                    }
                    case 4: {
                        this.sqldata[n] = new DB2DataObject();
                        break;
                    }
                    case -5: {
                        this.sqldata[n] = new DB2DataObject();
                        break;
                    }
                    case 91: {
                        this.sqldata[n] = new Date(0L);
                        break;
                    }
                    case 92: {
                        this.sqldata[n] = new Time(0L);
                        break;
                    }
                    case 93: {
                        this.sqldata[n] = new Timestamp(0L);
                        break;
                    }
                    case 6: 
                    case 8: {
                        this.sqldata[n] = new DB2DataObject();
                        break;
                    }
                    case 7: {
                        this.sqldata[n] = new DB2DataObject();
                        break;
                    }
                    case -351: 
                    case -350: 
                    case -99: 
                    case -98: 
                    case 31: 
                    case 41: {
                        this.sqldata[n] = new DB2DataObject();
                        break;
                    }
                }
            }
            ++n;
        }
    }

    protected static String cvtScientific(String string, DB2Connection dB2Connection) throws SQLException {
        string = string.trim().replace(',', '.');
        int n = string.indexOf(101);
        try {
            if (n > 0) {
                String string2 = string.substring(0, n);
                Double d = new Double(string.substring(n + 1, string.length()));
                int n2 = d.intValue();
                int n3 = 0;
                String string3 = new String();
                int n4 = string2.length();
                if (n2 > 0) {
                    n3 = string2.indexOf(46);
                    string3 = String.valueOf(string3) + string2.substring(0, n3);
                    if (n4 - n3 - 1 > n2) {
                        string3 = String.valueOf(string3) + string2.substring(n3 + 1, n3 + n2 + 1) + "." + string2.substring(n3 + 1 + n2, n4);
                    } else {
                        string3 = String.valueOf(string3) + string2.substring(n3 + 1, n4);
                        if (n4 - n3 - 1 < n2) {
                            int n5 = n2 - n4 + n3 + 1;
                            while (n5 > 0) {
                                string3 = String.valueOf(string3) + "0";
                                --n5;
                            }
                        }
                    }
                } else if (n2 < 0) {
                    n2 = Math.abs(n2);
                    string3 = string2.charAt(0) == '-' || string2.charAt(0) == '+' ? String.valueOf(string2.substring(0, 1)) + "0." : "0.";
                    int n6 = string2.indexOf(46);
                    while (n3 < n2 - 1) {
                        string3 = String.valueOf(string3) + "0";
                        ++n3;
                    }
                    string3 = String.valueOf(string3) + string2.substring(n6 - 1, n6) + string2.substring(n6 + 1, n4);
                } else {
                    string3 = string2;
                }
                return string3;
            }
        }
        catch (NumberFormatException numberFormatException) {
            SQLExceptionGenerator.throwTypeError(dB2Connection);
        }
        return string;
    }

    protected int fetchScroll(int n, int n2) throws SQLException {
        int n3 = 0;
        this.resultset.clearWarnings();
        if (this.cleared) {
            this.activate();
        }
        try {
            this.db2req.write((short)203);
            this.db2req.write(this.resultset.stmtHandle);
            this.db2req.write(n);
            this.db2req.write(n2);
            this.db2req.sendAndRecv();
            n3 = this.db2req.readInt();
            if (n3 != 0 && n3 != 1) {
                return n3;
            }
            this.getDataFromBuffer();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            this.sqlExcptGen.socketException("08S01a");
        }
        return n3;
    }

    protected int first() throws SQLException {
        return this.fetchScroll(2, 0);
    }

    protected int forwardOnlyNext() throws SQLException {
        int n = 0;
        this.resultset.clearWarnings();
        if (this.cleared) {
            this.activate();
        }
        try {
            if (this.rowsBlocked <= 0) {
                this.db2req.write((short)34);
                this.db2req.write(this.resultset.stmtHandle);
                this.db2req.sendAndRecv();
                if (DB2Connection.DB2JDBC_SERVER_VERSION > 1) {
                    this.rowsBlocked = this.db2req.readInt();
                }
            }
            if ((n = this.db2req.readInt()) != 0 && n != 1) {
                return n;
            }
            this.getDataFromBuffer();
            if (this.rowsBlocked > 0) {
                --this.rowsBlocked;
            }
        }
        catch (IOException iOException) {
            this.sqlExcptGen.socketException("08S01a");
        }
        return n;
    }

    protected InputStream getAsciiStream(int n) throws SQLException {
        InputStream inputStream = null;
        String string = null;
        if (this.sqlind[n] == this.SQL_NULL_DATA) {
            if (this.resultset != null) {
                this.resultset.nullTag = true;
            }
            return null;
        }
        if (this.resultset != null) {
            this.resultset.nullTag = false;
        }
        switch (this.sqltype[n]) {
            case -351: 
            case -350: 
            case -99: 
            case 41: {
                int n2 = this.sqltype[n];
                if (this.sqltype[n] == -99) {
                    n2 = 41;
                } else if (this.sqltype[n] == -350) {
                    n2 = -351;
                }
                int n3 = (int)((DB2DataObject)this.sqldata[n]).lValue;
                inputStream = new DB2InputStream(this.resultset.statement, n3, n2, false);
                this.resultset.addIsList((DB2InputStream)inputStream);
                break;
            }
            case -98: 
            case 31: {
                int n4 = (int)((DB2DataObject)this.sqldata[n]).lValue;
                inputStream = new DB2Binary2AsciiInputStream(this.resultset.statement, n4, 31);
                this.resultset.addIsList((DB2InputStream)inputStream);
                break;
            }
            case -97: 
            case -96: 
            case -95: 
            case -1: 
            case 1: 
            case 2: 
            case 3: 
            case 12: {
                string = (String)this.sqldata[n];
                break;
            }
            default: {
                string = this.getDataAsString(n);
            }
        }
        if (inputStream == null) {
            inputStream = string == null ? new ByteArrayInputStream(new byte[0]) : new ByteArrayInputStream(string.getBytes());
        }
        return inputStream;
    }

    protected BigDecimal getBigDecimal(int n) throws SQLException {
        if (this.sqlind[n] == this.SQL_NULL_DATA) {
            if (this.resultset != null) {
                this.resultset.nullTag = true;
            }
            return null;
        }
        if (this.resultset != null) {
            this.resultset.nullTag = false;
        }
        BigDecimal bigDecimal = null;
        switch (this.sqltype[n]) {
            case -1: 
            case 1: 
            case 2: 
            case 3: 
            case 12: {
                bigDecimal = this.getDecimalValueData(n);
                break;
            }
            default: {
                Object object = this.getObject(n);
                String string = object.toString();
                if (string != null) {
                    bigDecimal = new BigDecimal(string.trim());
                    break;
                }
                if (this.resultset == null) break;
                this.resultset.nullTag = false;
            }
        }
        return bigDecimal;
    }

    protected InputStream getBinaryStream(int n) throws SQLException {
        InputStream inputStream = null;
        if (this.sqlind[n] == this.SQL_NULL_DATA) {
            if (this.resultset != null) {
                this.resultset.nullTag = true;
            }
            return null;
        }
        if (this.resultset != null) {
            this.resultset.nullTag = false;
        }
        switch (this.sqltype[n]) {
            case -351: 
            case -350: 
            case -99: 
            case -98: 
            case 31: 
            case 41: {
                int n2 = this.sqltype[n];
                if (this.sqltype[n] == -99) {
                    n2 = 41;
                } else if (this.sqltype[n] == -98) {
                    n2 = 31;
                } else if (this.sqltype[n] == -350) {
                    n2 = -351;
                }
                int n3 = (int)((DB2DataObject)this.sqldata[n]).lValue;
                inputStream = new DB2InputStream(this.resultset.statement, n3, n2, false);
                this.resultset.addIsList((DB2InputStream)inputStream);
                break;
            }
            default: {
                inputStream = new ByteArrayInputStream(this.getBytes(n));
            }
        }
        return inputStream;
    }

    protected DB2Blob getBlob(int n) throws SQLException {
        DB2Blob dB2Blob = null;
        if (this.sqlind[n] == this.SQL_NULL_DATA) {
            if (this.resultset != null) {
                this.resultset.nullTag = true;
            }
            return null;
        }
        if (this.resultset != null) {
            this.resultset.nullTag = false;
        }
        int n2 = (int)((DB2DataObject)this.sqldata[n]).lValue;
        dB2Blob = new DB2Blob(this.resultset.statement, n2);
        return dB2Blob;
    }

    protected boolean getBoolean(int n) throws SQLException {
        if (this.sqlind[n] == this.SQL_NULL_DATA) {
            if (this.resultset != null) {
                this.resultset.nullTag = true;
            }
            return false;
        }
        if (this.resultset != null) {
            this.resultset.nullTag = false;
        }
        boolean bl = false;
        switch (this.sqltype[n]) {
            case -5: 
            case 4: 
            case 5: {
                long l = this.getLongValueData(n);
                if (l == 0L) break;
                bl = true;
                break;
            }
            case -4: 
            case -3: 
            case -2: {
                byte by = this.getByteValueData(n);
                if (by == 0) break;
                bl = true;
                break;
            }
            case 7: {
                float f = this.getFloatValueData(n);
                if (f == 0.0f) break;
                bl = true;
                break;
            }
            case 6: 
            case 8: {
                double d = this.getDoubleValueData(n);
                if (d == 0.0) break;
                bl = true;
                break;
            }
            case 2: 
            case 3: {
                BigDecimal bigDecimal = this.getDecimalValueData(n);
                if (bigDecimal.compareTo(new BigDecimal(0.0)) == 0) break;
                bl = true;
                break;
            }
            case 91: {
                SQLExceptionGenerator.throwColumnDataTypeError(this.connection);
                break;
            }
            case 92: {
                SQLExceptionGenerator.throwColumnDataTypeError(this.connection);
                break;
            }
            case 93: {
                SQLExceptionGenerator.throwColumnDataTypeError(this.connection);
                break;
            }
            default: {
                Object object = this.getObject(n);
                String string = object.toString();
                if (string != null) {
                    long l = Long.parseLong(string.trim());
                    if (l == 0L) break;
                    bl = true;
                    break;
                }
                if (this.resultset == null) break;
                this.resultset.nullTag = false;
            }
        }
        return bl;
    }

    protected byte getByte(int n) throws SQLException {
        if (this.sqlind[n] == this.SQL_NULL_DATA) {
            if (this.resultset != null) {
                this.resultset.nullTag = true;
            }
            return 0;
        }
        if (this.resultset != null) {
            this.resultset.nullTag = false;
        }
        byte by = 0;
        switch (this.sqltype[n]) {
            case -5: 
            case 4: 
            case 5: {
                long l = this.getLongValueData(n);
                by = (byte)l;
                if ((long)by == l) break;
                this.statement.addWarning(new DataTruncation(-1, true, false, -1, -1));
                break;
            }
            case -4: 
            case -3: 
            case -2: {
                by = this.getByteValueData(n);
                break;
            }
            case 7: {
                float f = this.getFloatValueData(n);
                by = (byte)f;
                if ((float)by == f) break;
                this.statement.addWarning(new DataTruncation(-1, true, false, -1, -1));
                break;
            }
            case 6: 
            case 8: {
                double d = this.getDoubleValueData(n);
                by = (byte)d;
                if ((double)by == d) break;
                this.statement.addWarning(new DataTruncation(-1, true, false, -1, -1));
                break;
            }
            case 91: {
                SQLExceptionGenerator.throwColumnDataTypeError(this.connection);
                break;
            }
            case 92: {
                SQLExceptionGenerator.throwColumnDataTypeError(this.connection);
                break;
            }
            case 93: {
                SQLExceptionGenerator.throwColumnDataTypeError(this.connection);
                break;
            }
            default: {
                Object object = this.getObject(n);
                String string = object.toString();
                if (string != null) {
                    char c = string.trim().charAt(0);
                    by = (byte)c;
                    break;
                }
                if (this.resultset == null) break;
                this.resultset.nullTag = false;
            }
        }
        return by;
    }

    private byte getByteValueData(int n) {
        byte[] byArray = (byte[])this.sqldata[n];
        return byArray[0];
    }

    protected byte[] getBytes(int n) throws SQLException {
        if (this.sqlind[n] == this.SQL_NULL_DATA) {
            if (this.resultset != null) {
                this.resultset.nullTag = true;
            }
            return null;
        }
        if (this.resultset != null) {
            this.resultset.nullTag = false;
        }
        byte[] byArray = null;
        switch (this.sqltype[n]) {
            case -4: 
            case -3: 
            case -2: {
                byArray = this.getBytesValueData(n);
                break;
            }
            case -351: 
            case -350: 
            case -99: 
            case -98: 
            case 31: 
            case 41: {
                byArray = this.resultset.getBytesData(n + 1);
                break;
            }
            default: {
                Object object = this.getObject(n);
                String string = object.toString();
                if (string != null) {
                    byArray = string.trim().getBytes();
                    break;
                }
                if (this.resultset == null) break;
                this.resultset.nullTag = false;
            }
        }
        return byArray;
    }

    private byte[] getBytesValueData(int n) {
        byte[] byArray = (byte[])this.sqldata[n];
        int n2 = byArray.length;
        byte[] byArray2 = new byte[n2];
        System.arraycopy(byArray, 0, byArray2, 0, n2);
        return byArray2;
    }

    private char getCharValueData(int n) {
        char c = this.sqldata[n].toString().charAt(0);
        return c;
    }

    protected Reader getCharacterStream(int n) throws SQLException {
        Reader reader = null;
        if (this.sqlind[n] == this.SQL_NULL_DATA) {
            if (this.resultset != null) {
                this.resultset.nullTag = true;
            }
            return null;
        }
        if (this.resultset != null) {
            this.resultset.nullTag = false;
        }
        short s = this.sqltype[n];
        int n2 = 41;
        if (s == -99 || s == -350) {
            switch (s) {
                case -99: {
                    n2 = 41;
                    break;
                }
                case -350: {
                    n2 = -351;
                    break;
                }
            }
            int n3 = (int)((DB2DataObject)this.sqldata[n]).lValue;
            reader = new DB2CharReader(this.resultset.statement, n3, n2);
        } else {
            String string = this.resultset.getString(n + 1);
            if (this.resultset.nullTag) {
                return null;
            }
            if (string == null) {
                return new StringReader(new String());
            }
            reader = new StringReader(string);
        }
        return reader;
    }

    protected DB2Clob getClob(int n) throws SQLException {
        DB2Clob dB2Clob = null;
        if (this.sqlind[n] == this.SQL_NULL_DATA) {
            if (this.resultset != null) {
                this.resultset.nullTag = true;
            }
            return null;
        }
        if (this.resultset != null) {
            this.resultset.nullTag = false;
        }
        short s = this.sqltype[n];
        int n2 = 41;
        if (s == -99 || s == -350) {
            switch (s) {
                case -99: {
                    n2 = 41;
                    break;
                }
                case -350: {
                    n2 = -351;
                    break;
                }
            }
            int n3 = (int)((DB2DataObject)this.sqldata[n]).lValue;
            dB2Clob = new DB2Clob(this.resultset.statement, n3, n2);
        }
        return dB2Clob;
    }

    private String getDataAsString(int n) throws SQLException {
        String string;
        if (DB2Trace.TraceOn) {
            DB2Trace.methodEntry(this, "getDataAsString( " + n + " )");
        }
        switch (this.sqltype[n]) {
            case -4: 
            case -3: 
            case -2: {
                byte[] byArray = (byte[])this.sqldata[n];
                StringBuffer stringBuffer = new StringBuffer("");
                int n2 = 0;
                while (n2 < byArray.length) {
                    byte by = byArray[n2];
                    String string2 = Integer.toHexString(by).toUpperCase();
                    int n3 = string2.length();
                    if (n3 == 1) {
                        stringBuffer.append("0");
                    } else if (n3 > 2) {
                        string2 = string2.substring(n3 - 2);
                    }
                    stringBuffer.append(string2);
                    ++n2;
                }
                string = stringBuffer.toString();
                break;
            }
            case 93: {
                StringBuffer stringBuffer = new StringBuffer("");
                String string3 = this.sqldata[n].toString();
                int n4 = string3.indexOf(45);
                if (n4 < 4) {
                    switch (n4) {
                        case 1: {
                            stringBuffer.append("000");
                            break;
                        }
                        case 2: {
                            stringBuffer.append("00");
                            break;
                        }
                        case 3: {
                            stringBuffer.append("0");
                            break;
                        }
                    }
                }
                stringBuffer.append(this.sqldata[n].toString());
                stringBuffer.append("000000");
                stringBuffer.setLength(26);
                string = stringBuffer.toString();
                break;
            }
            default: {
                string = this.sqldata[n].toString();
            }
        }
        if (DB2Trace.TraceOn) {
            DB2Trace.methodExit((Object)this, "getDataAsString()", string);
        }
        return string;
    }

    protected void getDataFromBuffer() throws IOException {
        try {
            if (DB2Trace.TraceOn) {
                DB2Trace.methodEntry(this, "getDataFromBuffer()");
            }
            short s = 0;
            short s2 = 0;
            short s3 = 0;
            short s4 = 0;
            short s5 = 0;
            short s6 = 0;
            int n = 0;
            int n2 = 0;
            while (n2 < this.length) {
                if (this.resultset == null || this.resultset.preFetched[n2]) {
                    this.sqlind[n2] = this.db2req.readInt();
                    if (this.sqlind[n2] != this.SQL_NULL_DATA) {
                        if (DB2Trace.TraceOn) {
                            DB2Trace.data(10, "sqltype[" + n2 + "]", this.sqltype[n2]);
                        }
                        switch (this.sqltype[n2]) {
                            case 5: {
                                ((DB2DataObject)this.sqldata[n2]).set(this.db2req.readShort());
                                break;
                            }
                            case 4: {
                                ((DB2DataObject)this.sqldata[n2]).set(this.db2req.readInt());
                                break;
                            }
                            case -5: {
                                ((DB2DataObject)this.sqldata[n2]).set(this.db2req.readLong());
                                break;
                            }
                            case 91: {
                                s = this.db2req.readShort();
                                s2 = this.db2req.readShort();
                                s3 = this.db2req.readShort();
                                ((Date)this.sqldata[n2]).setYear(s);
                                ((Date)this.sqldata[n2]).setMonth(s2);
                                ((Date)this.sqldata[n2]).setDate(s3);
                                break;
                            }
                            case 92: {
                                s4 = this.db2req.readShort();
                                s5 = this.db2req.readShort();
                                s6 = this.db2req.readShort();
                                ((Time)this.sqldata[n2]).setHours(s4);
                                ((Time)this.sqldata[n2]).setMinutes(s5);
                                ((Time)this.sqldata[n2]).setSeconds(s6);
                                break;
                            }
                            case 93: {
                                s = this.db2req.readShort();
                                s2 = this.db2req.readShort();
                                s3 = this.db2req.readShort();
                                s4 = this.db2req.readShort();
                                s5 = this.db2req.readShort();
                                s6 = this.db2req.readShort();
                                n = this.db2req.readInt();
                                ((Timestamp)this.sqldata[n2]).setYear(s);
                                ((Timestamp)this.sqldata[n2]).setMonth(s2);
                                ((Timestamp)this.sqldata[n2]).setDate(s3);
                                ((Timestamp)this.sqldata[n2]).setHours(s4);
                                ((Timestamp)this.sqldata[n2]).setMinutes(s5);
                                ((Timestamp)this.sqldata[n2]).setSeconds(s6);
                                ((Timestamp)this.sqldata[n2]).setNanos(n);
                                break;
                            }
                            case 6: 
                            case 8: {
                                ((DB2DataObject)this.sqldata[n2]).set(this.db2req.readDouble());
                                break;
                            }
                            case 7: {
                                ((DB2DataObject)this.sqldata[n2]).set(this.db2req.readFloat());
                                break;
                            }
                            case -97: 
                            case -96: 
                            case -95: 
                            case -10: 
                            case -9: 
                            case -8: 
                            case -1: 
                            case 1: 
                            case 2: 
                            case 3: 
                            case 12: {
                                this.sqldata[n2] = this.db2req.readString();
                                break;
                            }
                            case -4: 
                            case -3: 
                            case -2: {
                                this.sqldata[n2] = this.db2req.readBytes();
                                break;
                            }
                            case -351: 
                            case -350: 
                            case -99: 
                            case -98: 
                            case 31: 
                            case 41: {
                                ((DB2DataObject)this.sqldata[n2]).set(this.db2req.readInt());
                                break;
                            }
                            default: {
                                this.sqldata[n2] = null;
                                break;
                            }
                        }
                    }
                }
                ++n2;
            }
        }
        finally {
            Object var2_9 = null;
            if (DB2Trace.TraceOn) {
                DB2Trace.methodExit(this, "getDataFromBuffer()");
            }
        }
    }

    protected Date getDate(int n) throws SQLException {
        if (this.sqlind[n] == this.SQL_NULL_DATA) {
            if (this.resultset != null) {
                this.resultset.nullTag = true;
            }
            return null;
        }
        if (this.resultset != null) {
            this.resultset.nullTag = false;
        }
        Date date = null;
        if (this.sqltype[n] == 91) {
            date = new Date(((Date)this.sqldata[n]).getYear(), ((Date)this.sqldata[n]).getMonth(), ((Date)this.sqldata[n]).getDate());
        } else if (this.sqltype[n] == 93) {
            this.statement.addWarning(new DataTruncation(-1, true, false, -1, -1));
            date = new Date(((Timestamp)this.sqldata[n]).getYear(), ((Timestamp)this.sqldata[n]).getMonth(), ((Timestamp)this.sqldata[n]).getDate());
        } else {
            Object object = this.getObject(n);
            String string = object.toString();
            if (string != null) {
                date = Date.valueOf(string.trim());
            } else if (this.resultset != null) {
                this.resultset.nullTag = false;
            }
        }
        return date;
    }

    private BigDecimal getDecimalValueData(int n) throws SQLException {
        String string = this.sqldata[n].toString();
        String string2 = null;
        try {
            string2 = DB2RowObject.cvtScientific(string, this.connection);
            Double d = new Double(string2);
        }
        catch (NumberFormatException numberFormatException) {
            this.sqlExcptGen.rsException("22005");
        }
        return new BigDecimal(string2);
    }

    protected double getDouble(int n) throws SQLException {
        if (this.sqlind[n] == this.SQL_NULL_DATA) {
            if (this.resultset != null) {
                this.resultset.nullTag = true;
            }
            return 0.0;
        }
        if (this.resultset != null) {
            this.resultset.nullTag = false;
        }
        double d = 0.0;
        switch (this.sqltype[n]) {
            case -5: 
            case 4: 
            case 5: {
                d = this.getLongValueData(n);
                break;
            }
            case 7: {
                d = this.getFloatValueData(n);
                break;
            }
            case 6: 
            case 8: {
                d = this.getDoubleValueData(n);
                break;
            }
            default: {
                Object object = this.getObject(n);
                String string = object.toString();
                if (string != null) {
                    Double d2 = new Double(string.trim());
                    d = d2;
                    break;
                }
                if (this.resultset == null) break;
                this.resultset.nullTag = false;
            }
        }
        return d;
    }

    private double getDoubleValueData(int n) {
        return ((DB2DataObject)this.sqldata[n]).dValue;
    }

    protected float getFloat(int n) throws SQLException {
        if (this.sqlind[n] == this.SQL_NULL_DATA) {
            if (this.resultset != null) {
                this.resultset.nullTag = true;
            }
            return 0.0f;
        }
        if (this.resultset != null) {
            this.resultset.nullTag = false;
        }
        float f = 0.0f;
        switch (this.sqltype[n]) {
            case -5: 
            case 4: 
            case 5: {
                f = this.getLongValueData(n);
                break;
            }
            case 7: {
                f = this.getFloatValueData(n);
                break;
            }
            case 6: 
            case 8: {
                double d = this.getDoubleValueData(n);
                double d2 = Math.abs(d);
                if (d2 >= (double)1.4E-45f && d2 <= 3.4028234663852886E38 || d2 == 0.0) {
                    f = (float)d;
                    if ((double)f == d) break;
                    this.statement.addWarning(new DataTruncation(-1, true, false, -1, -1));
                    break;
                }
                throw new NumberFormatException();
            }
            default: {
                Object object = this.getObject(n);
                String string = object.toString();
                if (string != null) {
                    Float f2 = new Float(string.trim());
                    f = f2.floatValue();
                    break;
                }
                if (this.resultset == null) break;
                this.resultset.nullTag = false;
            }
        }
        return f;
    }

    private float getFloatValueData(int n) {
        return ((DB2DataObject)this.sqldata[n]).fValue;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected int getInt(int n) throws SQLException {
        int n2;
        int n3;
        block18: {
            int n4;
            block17: {
                n3 = 0;
                try {
                    if (DB2Trace.TraceOn) {
                        DB2Trace.methodEntry(this, "getInt( " + n + " )");
                    }
                    if (this.sqlind[n] == this.SQL_NULL_DATA) {
                        if (this.resultset != null) {
                            this.resultset.nullTag = true;
                        }
                        n4 = 0;
                        Object var5_5 = null;
                        if (!DB2Trace.TraceOn) return n4;
                        break block17;
                    }
                    if (this.resultset != null) {
                        this.resultset.nullTag = false;
                    }
                    switch (this.sqltype[n]) {
                        case 4: 
                        case 5: {
                            long l = this.getLongValueData(n);
                            n3 = (int)l;
                            break;
                        }
                        case -5: {
                            long l = this.getLongValueData(n);
                            if (l < Integer.MIN_VALUE) throw new NumberFormatException();
                            if (l > Integer.MAX_VALUE) throw new NumberFormatException();
                            n3 = (int)l;
                            if ((long)n3 == l) break;
                            this.statement.addWarning(new DataTruncation(-1, true, false, -1, -1));
                            break;
                        }
                        case 7: {
                            float f = this.getFloatValueData(n);
                            n3 = new Double(f).intValue();
                            if ((float)n3 == f) break;
                            this.statement.addWarning(new DataTruncation(-1, true, false, -1, -1));
                            break;
                        }
                        case 6: 
                        case 8: {
                            double d = this.getDoubleValueData(n);
                            n3 = new Double(d).intValue();
                            if ((double)n3 == d) break;
                            this.statement.addWarning(new DataTruncation(-1, true, false, -1, -1));
                            break;
                        }
                        case 2: 
                        case 3: {
                            BigDecimal bigDecimal = this.getDecimalValueData(n);
                            long l = bigDecimal.longValue();
                            if (l < Integer.MIN_VALUE) throw new NumberFormatException();
                            if (l > Integer.MAX_VALUE) throw new NumberFormatException();
                            n3 = (int)l;
                            if ((float)n3 == bigDecimal.floatValue()) break;
                            this.statement.addWarning(new DataTruncation(-1, true, false, -1, -1));
                            break;
                        }
                        case 91: {
                            SQLExceptionGenerator.throwColumnDataTypeError(this.connection);
                            break;
                        }
                        case 92: {
                            SQLExceptionGenerator.throwColumnDataTypeError(this.connection);
                            break;
                        }
                        case 93: {
                            SQLExceptionGenerator.throwColumnDataTypeError(this.connection);
                            break;
                        }
                        default: {
                            Object object = this.getObject(n);
                            String string = object.toString();
                            if (string != null) {
                                n3 = Integer.parseInt(string.trim());
                                break;
                            }
                            if (this.resultset == null) break;
                            this.resultset.nullTag = false;
                        }
                    }
                    n2 = n3;
                    break block18;
                }
                catch (Throwable throwable) {
                    Object var5_7 = null;
                    if (!DB2Trace.TraceOn) throw throwable;
                    DB2Trace.methodExit((Object)this, "getInt()", n3);
                    throw throwable;
                }
            }
            DB2Trace.methodExit((Object)this, "getInt()", n3);
            return n4;
        }
        Object var5_6 = null;
        if (!DB2Trace.TraceOn) return n2;
        DB2Trace.methodExit((Object)this, "getInt()", n3);
        return n2;
    }

    protected long getLong(int n) throws SQLException {
        if (this.sqlind[n] == this.SQL_NULL_DATA) {
            if (this.resultset != null) {
                this.resultset.nullTag = true;
            }
            return 0L;
        }
        if (this.resultset != null) {
            this.resultset.nullTag = false;
        }
        long l = 0L;
        switch (this.sqltype[n]) {
            case -5: 
            case 4: 
            case 5: {
                l = this.getLongValueData(n);
                break;
            }
            case 7: {
                float f = this.getFloatValueData(n);
                l = new Double(f).longValue();
                if ((float)l == f) break;
                this.statement.addWarning(new DataTruncation(-1, true, false, -1, -1));
                break;
            }
            case 6: 
            case 8: {
                double d = this.getDoubleValueData(n);
                l = new Double(d).longValue();
                if ((double)l == d) break;
                this.statement.addWarning(new DataTruncation(-1, true, false, -1, -1));
                break;
            }
            case 2: 
            case 3: {
                BigDecimal bigDecimal = this.getDecimalValueData(n);
                l = bigDecimal.longValue();
                if ((float)l == bigDecimal.floatValue()) break;
                this.statement.addWarning(new DataTruncation(-1, true, false, -1, -1));
                break;
            }
            case 91: {
                SQLExceptionGenerator.throwColumnDataTypeError(this.connection);
                break;
            }
            case 92: {
                SQLExceptionGenerator.throwColumnDataTypeError(this.connection);
                break;
            }
            case 93: {
                SQLExceptionGenerator.throwColumnDataTypeError(this.connection);
                break;
            }
            default: {
                Object object = this.getObject(n);
                String string = object.toString();
                if (string != null) {
                    l = Long.parseLong(string.trim());
                    break;
                }
                if (this.resultset == null) break;
                this.resultset.nullTag = false;
            }
        }
        return l;
    }

    private long getLongValueData(int n) {
        return ((DB2DataObject)this.sqldata[n]).lValue;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected Object getObject(int n) throws SQLException {
        Object var2_15;
        block33: {
            DB2Clob dB2Clob;
            block32: {
                DB2Blob dB2Blob;
                block31: {
                    Timestamp timestamp;
                    block30: {
                        Time time;
                        block29: {
                            Date date;
                            block28: {
                                byte[] byArray;
                                block27: {
                                    Double d;
                                    block26: {
                                        Float f;
                                        block25: {
                                            Long l;
                                            block24: {
                                                Integer n2;
                                                block23: {
                                                    BigDecimal bigDecimal;
                                                    block22: {
                                                        String string;
                                                        block21: {
                                                            Object var2_2;
                                                            block20: {
                                                                try {
                                                                    if (DB2Trace.TraceOn) {
                                                                        DB2Trace.methodEntry(this, "getObject( " + n + " )");
                                                                    }
                                                                    if (this.sqlind[n] == this.SQL_NULL_DATA) {
                                                                        if (this.resultset != null) {
                                                                            this.resultset.nullTag = true;
                                                                        }
                                                                        var2_2 = null;
                                                                        Object var4_16 = null;
                                                                        if (!DB2Trace.TraceOn) return var2_2;
                                                                        break block20;
                                                                    }
                                                                    if (this.resultset != null) {
                                                                        this.resultset.nullTag = false;
                                                                    }
                                                                    switch (this.sqltype[n]) {
                                                                        case -97: 
                                                                        case -96: 
                                                                        case -95: 
                                                                        case -10: 
                                                                        case -9: 
                                                                        case -8: 
                                                                        case -1: 
                                                                        case 1: 
                                                                        case 12: {
                                                                            string = this.getStringValueData(n);
                                                                            break block21;
                                                                        }
                                                                        case 2: 
                                                                        case 3: {
                                                                            bigDecimal = this.getDecimalValueData(n);
                                                                            break block22;
                                                                        }
                                                                        case 4: 
                                                                        case 5: {
                                                                            n2 = new Integer((int)this.getLongValueData(n));
                                                                            break block23;
                                                                        }
                                                                        case -5: {
                                                                            l = new Long(this.getLongValueData(n));
                                                                            break block24;
                                                                        }
                                                                        case 7: {
                                                                            f = new Float(this.getFloatValueData(n));
                                                                            break block25;
                                                                        }
                                                                        case 6: 
                                                                        case 8: {
                                                                            d = new Double(this.getDoubleValueData(n));
                                                                            break block26;
                                                                        }
                                                                        case -4: 
                                                                        case -3: 
                                                                        case -2: {
                                                                            byArray = this.getBytesValueData(n);
                                                                            break block27;
                                                                        }
                                                                        case 91: {
                                                                            date = new Date(((Date)this.sqldata[n]).getYear(), ((Date)this.sqldata[n]).getMonth(), ((Date)this.sqldata[n]).getDate());
                                                                            break block28;
                                                                        }
                                                                        case 92: {
                                                                            time = new Time(((Time)this.sqldata[n]).getTime());
                                                                            break block29;
                                                                        }
                                                                        case 93: {
                                                                            Timestamp timestamp2 = new Timestamp(((java.util.Date)((Timestamp)this.sqldata[n])).getTime());
                                                                            timestamp2.setNanos(((Timestamp)this.sqldata[n]).getNanos());
                                                                            timestamp = timestamp2;
                                                                            break block30;
                                                                        }
                                                                        case -98: 
                                                                        case 31: {
                                                                            dB2Blob = this.getBlob(n);
                                                                            break block31;
                                                                        }
                                                                        case -351: 
                                                                        case -350: 
                                                                        case -99: 
                                                                        case 41: {
                                                                            dB2Clob = this.getClob(n);
                                                                            break block32;
                                                                        }
                                                                        default: {
                                                                            this.sqlExcptGen.rsException("22005");
                                                                            var2_15 = null;
                                                                            break;
                                                                        }
                                                                    }
                                                                    break block33;
                                                                }
                                                                catch (Throwable throwable) {
                                                                    Object var4_30 = null;
                                                                    if (!DB2Trace.TraceOn) throw throwable;
                                                                    DB2Trace.methodExit(this, "getObject()");
                                                                    throw throwable;
                                                                }
                                                            }
                                                            DB2Trace.methodExit(this, "getObject()");
                                                            return var2_2;
                                                        }
                                                        Object var4_17 = null;
                                                        if (!DB2Trace.TraceOn) return string;
                                                        DB2Trace.methodExit(this, "getObject()");
                                                        return string;
                                                    }
                                                    Object var4_18 = null;
                                                    if (!DB2Trace.TraceOn) return bigDecimal;
                                                    DB2Trace.methodExit(this, "getObject()");
                                                    return bigDecimal;
                                                }
                                                Object var4_19 = null;
                                                if (!DB2Trace.TraceOn) return n2;
                                                DB2Trace.methodExit(this, "getObject()");
                                                return n2;
                                            }
                                            Object var4_20 = null;
                                            if (!DB2Trace.TraceOn) return l;
                                            DB2Trace.methodExit(this, "getObject()");
                                            return l;
                                        }
                                        Object var4_21 = null;
                                        if (!DB2Trace.TraceOn) return f;
                                        DB2Trace.methodExit(this, "getObject()");
                                        return f;
                                    }
                                    Object var4_22 = null;
                                    if (!DB2Trace.TraceOn) return d;
                                    DB2Trace.methodExit(this, "getObject()");
                                    return d;
                                }
                                Object var4_23 = null;
                                if (!DB2Trace.TraceOn) return byArray;
                                DB2Trace.methodExit(this, "getObject()");
                                return byArray;
                            }
                            Object var4_24 = null;
                            if (!DB2Trace.TraceOn) return date;
                            DB2Trace.methodExit(this, "getObject()");
                            return date;
                        }
                        Object var4_25 = null;
                        if (!DB2Trace.TraceOn) return time;
                        DB2Trace.methodExit(this, "getObject()");
                        return time;
                    }
                    Object var4_26 = null;
                    if (!DB2Trace.TraceOn) return timestamp;
                    DB2Trace.methodExit(this, "getObject()");
                    return timestamp;
                }
                Object var4_27 = null;
                if (!DB2Trace.TraceOn) return dB2Blob;
                DB2Trace.methodExit(this, "getObject()");
                return dB2Blob;
            }
            Object var4_28 = null;
            if (!DB2Trace.TraceOn) return dB2Clob;
            DB2Trace.methodExit(this, "getObject()");
            return dB2Clob;
        }
        Object var4_29 = null;
        if (!DB2Trace.TraceOn) return var2_15;
        DB2Trace.methodExit(this, "getObject()");
        return var2_15;
    }

    protected short getShort(int n) throws SQLException {
        if (this.sqlind[n] == this.SQL_NULL_DATA) {
            if (this.resultset != null) {
                this.resultset.nullTag = true;
            }
            return 0;
        }
        if (this.resultset != null) {
            this.resultset.nullTag = false;
        }
        short s = 0;
        switch (this.sqltype[n]) {
            case 5: {
                long l = this.getLongValueData(n);
                s = (short)l;
                break;
            }
            case -5: 
            case 4: {
                long l = this.getLongValueData(n);
                if (l >= -32768L && l <= 32767L) {
                    s = (short)l;
                    if ((long)s == l) break;
                    this.statement.addWarning(new DataTruncation(-1, true, false, -1, -1));
                    break;
                }
                throw new NumberFormatException();
            }
            case 7: {
                float f = this.getFloatValueData(n);
                s = new Double(f).shortValue();
                if ((float)s == f) break;
                this.statement.addWarning(new DataTruncation(-1, true, false, -1, -1));
                break;
            }
            case 6: 
            case 8: {
                double d = this.getDoubleValueData(n);
                s = new Double(d).shortValue();
                if ((double)s == d) break;
                this.statement.addWarning(new DataTruncation(-1, true, false, -1, -1));
                break;
            }
            case 2: 
            case 3: {
                BigDecimal bigDecimal = this.getDecimalValueData(n);
                long l = bigDecimal.longValue();
                if (l >= -32768L && l <= 32767L) {
                    s = (short)l;
                    if ((float)s == bigDecimal.floatValue()) break;
                    this.statement.addWarning(new DataTruncation(-1, true, false, -1, -1));
                    break;
                }
                throw new NumberFormatException();
            }
            case 91: {
                SQLExceptionGenerator.throwColumnDataTypeError(this.connection);
                break;
            }
            case 92: {
                SQLExceptionGenerator.throwColumnDataTypeError(this.connection);
                break;
            }
            case 93: {
                SQLExceptionGenerator.throwColumnDataTypeError(this.connection);
                break;
            }
            default: {
                Object object = this.getObject(n);
                String string = object.toString();
                if (string != null) {
                    s = Short.parseShort(string.trim());
                    break;
                }
                if (this.resultset == null) break;
                this.resultset.nullTag = false;
            }
        }
        return s;
    }

    protected String getString(int n) throws SQLException {
        if (this.sqlind[n] == this.SQL_NULL_DATA) {
            if (this.resultset != null) {
                this.resultset.nullTag = true;
            }
            return null;
        }
        if (this.resultset != null) {
            this.resultset.nullTag = false;
        }
        String string = null;
        switch (this.sqltype[n]) {
            case -97: 
            case -96: 
            case -95: 
            case -1: 
            case 1: 
            case 2: 
            case 3: 
            case 12: {
                string = this.getStringValueData(n);
                break;
            }
            case -351: 
            case -350: 
            case -99: 
            case -98: 
            case 31: 
            case 41: {
                string = this.resultset.getStringData(n + 1);
                break;
            }
            default: {
                string = this.getDataAsString(n);
            }
        }
        return string;
    }

    private String getStringValueData(int n) {
        return new String((String)this.sqldata[n]);
    }

    protected Time getTime(int n) throws SQLException {
        if (this.sqlind[n] == this.SQL_NULL_DATA) {
            if (this.resultset != null) {
                this.resultset.nullTag = true;
            }
            return null;
        }
        if (this.resultset != null) {
            this.resultset.nullTag = false;
        }
        Time time = null;
        if (this.sqltype[n] == 92) {
            time = new Time(((Time)this.sqldata[n]).getTime());
        } else if (this.sqltype[n] == 93) {
            time = new Time(((java.util.Date)((Timestamp)this.sqldata[n])).getTime());
            this.statement.addWarning(new DataTruncation(-1, true, false, -1, -1));
        } else {
            Object object = this.getObject(n);
            String string = object.toString();
            if (string != null) {
                string = string.trim().replace('.', ':');
                time = Time.valueOf(string);
            } else if (this.resultset != null) {
                this.resultset.nullTag = false;
            }
        }
        return time;
    }

    protected Timestamp getTimestamp(int n) throws SQLException {
        if (this.sqlind[n] == this.SQL_NULL_DATA) {
            if (this.resultset != null) {
                this.resultset.nullTag = true;
            }
            return null;
        }
        if (this.resultset != null) {
            this.resultset.nullTag = false;
        }
        Timestamp timestamp = null;
        if (this.sqltype[n] == 93) {
            timestamp = new Timestamp(((java.util.Date)((Timestamp)this.sqldata[n])).getTime());
            timestamp.setNanos(((Timestamp)this.sqldata[n]).getNanos());
        } else if (this.sqltype[n] == 91) {
            Calendar calendar = Calendar.getInstance();
            calendar.setTime((Date)this.sqldata[n]);
            timestamp = new Timestamp(calendar.get(1) - 1900, calendar.get(2), calendar.get(5), 0, 0, 0, 0);
        } else {
            Object object = this.getObject(n);
            String string = object.toString();
            if (string != null) {
                String string2 = "0000-00-00 00:00:00.000000000";
                StringBuffer stringBuffer = new StringBuffer(string.trim());
                int n2 = stringBuffer.length();
                if (n2 >= 10) {
                    stringBuffer.setCharAt(4, '-');
                    stringBuffer.setCharAt(7, '-');
                    if (n2 >= 19) {
                        stringBuffer.setCharAt(10, ' ');
                        stringBuffer.setCharAt(13, ':');
                        stringBuffer.setCharAt(16, ':');
                        if (n2 >= 21) {
                            stringBuffer.setCharAt(19, '.');
                        }
                    }
                }
                if (n2 < 29) {
                    stringBuffer.append(string2.substring(n2));
                }
                string = stringBuffer.toString();
                timestamp = Timestamp.valueOf(string);
            } else if (this.resultset != null) {
                this.resultset.nullTag = false;
            }
        }
        return timestamp;
    }

    protected InputStream getUnicodeStream(int n) throws SQLException {
        InputStream inputStream = null;
        String string = null;
        if (this.sqlind[n] == this.SQL_NULL_DATA) {
            if (this.resultset != null) {
                this.resultset.nullTag = true;
            }
            return null;
        }
        if (this.resultset != null) {
            this.resultset.nullTag = false;
        }
        switch (this.sqltype[n]) {
            case -351: 
            case -350: 
            case -99: 
            case 41: {
                int n2 = this.sqltype[n];
                if (this.sqltype[n] == -99) {
                    n2 = 41;
                } else if (this.sqltype[n] == -350) {
                    n2 = -351;
                }
                int n3 = (int)((DB2DataObject)this.sqldata[n]).lValue;
                inputStream = new DB2InputStream(this.resultset.statement, n3, n2, true);
                this.resultset.addIsList((DB2InputStream)inputStream);
                break;
            }
            case -98: 
            case 31: {
                int n4 = (int)((DB2DataObject)this.sqldata[n]).lValue;
                inputStream = new DB2Binary2AsciiInputStream(this.resultset.statement, n4, 31);
                this.resultset.addIsList((DB2InputStream)inputStream);
                break;
            }
            case -97: 
            case -96: 
            case -95: 
            case -1: 
            case 1: 
            case 2: 
            case 3: 
            case 12: {
                string = (String)this.sqldata[n];
                break;
            }
            default: {
                string = this.getDataAsString(n);
            }
        }
        if (inputStream == null) {
            if (string == null) {
                inputStream = new ByteArrayInputStream(new byte[0]);
            } else {
                try {
                    inputStream = new ByteArrayInputStream(string.getBytes("UTF8"));
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    throw new SQLException(unsupportedEncodingException.toString());
                }
            }
        }
        return inputStream;
    }

    protected int last() throws SQLException {
        return this.fetchScroll(3, 0);
    }

    protected int next() throws SQLException {
        return this.fetchScroll(1, 1);
    }

    protected int previous() throws SQLException {
        return this.fetchScroll(4, 1);
    }

    protected int relative(int n) throws SQLException {
        return this.fetchScroll(6, n);
    }

    protected void reset() {
        this.cleared = true;
    }
}

