/*
 * Decompiled with CFR 0.152.
 */
package COM.ibm.db2.jdbc.net;

import COM.ibm.db2.jdbc.net.DB2ResultSet;
import COM.ibm.db2.jdbc.net.DB2Statement;
import java.sql.SQLException;

public class DB2ScrollableResultSet
extends DB2ResultSet {
    private int rowNumber = 0;
    private int currentRowId = 0;

    public DB2ScrollableResultSet(DB2Statement dB2Statement, int n, int n2) throws SQLException {
        super(dB2Statement, n, false);
        this.rowNumber = n2;
        this.rsType = 1004;
        this.currentRowId = 0;
    }

    public boolean absolute(int n) throws SQLException {
        if (n == 0) {
            this.sqlExcptGen.throwInvalidAbsoluteCall();
        }
        if (this.rowNumber == 0) {
            return false;
        }
        if (n > this.rowNumber) {
            if (this.currentRowId > this.rowNumber) {
                return false;
            }
            n = this.rowNumber + 1;
        } else if (-n > this.rowNumber) {
            if (this.currentRowId < 1) {
                return false;
            }
            n = 0;
        } else if (n < 0) {
            n = this.rowNumber + n + 1;
        }
        if (n == this.currentRowId) {
            return true;
        }
        int n2 = this.rowObj.absolute(n);
        if (n2 != 0) {
            this.sqlExcptGen.check_return_code(this.statement, n2);
        }
        this.currentRowId = n;
        return n2 != 100;
    }

    public void afterLast() throws SQLException {
        if (this.rowNumber == 0 || this.currentRowId > this.rowNumber) {
            return;
        }
        int n = this.rowObj.absolute(this.rowNumber + 1);
        if (n != 0) {
            this.sqlExcptGen.check_return_code(this.statement, n);
        }
        this.currentRowId = this.rowNumber + 1;
    }

    public void beforeFirst() throws SQLException {
        if (this.rowNumber == 0 || this.currentRowId < 1) {
            return;
        }
        int n = this.rowObj.absolute(0);
        if (n != 0) {
            this.sqlExcptGen.check_return_code(this.statement, n);
        }
        this.currentRowId = 0;
    }

    public boolean first() throws SQLException {
        if (this.rowNumber == 0) {
            return false;
        }
        if (this.currentRowId == 1) {
            return true;
        }
        int n = this.rowObj.first();
        if (n != 0) {
            this.sqlExcptGen.check_return_code(this.statement, n);
        }
        this.currentRowId = 1;
        return n != 100;
    }

    public int getRow() throws SQLException {
        if (this.rowNumber == 0 || this.currentRowId < 1 || this.currentRowId > this.rowNumber) {
            return 0;
        }
        return this.currentRowId;
    }

    public boolean isAfterLast() throws SQLException {
        return this.rowNumber > 0 && this.currentRowId > this.rowNumber;
    }

    public boolean isBeforeFirst() throws SQLException {
        return this.rowNumber > 0 && this.currentRowId < 1;
    }

    public boolean isFirst() throws SQLException {
        return this.rowNumber > 0 && this.currentRowId == 1;
    }

    public boolean isLast() throws SQLException {
        return this.rowNumber > 0 && this.currentRowId == this.rowNumber;
    }

    public boolean last() throws SQLException {
        if (this.rowNumber == 0) {
            return false;
        }
        if (this.currentRowId == this.rowNumber) {
            return true;
        }
        int n = this.rowObj.last();
        if (n != 0) {
            this.sqlExcptGen.check_return_code(this.statement, n);
        }
        this.currentRowId = this.rowNumber;
        return n != 100;
    }

    public boolean next() throws SQLException {
        if (this.rowNumber == 0 || this.currentRowId > this.rowNumber) {
            return false;
        }
        int n = this.rowObj.next();
        if (n != 0) {
            this.sqlExcptGen.check_return_code(this.statement, n);
        }
        ++this.currentRowId;
        return n != 100;
    }

    public boolean previous() throws SQLException {
        if (this.rowNumber == 0 || this.currentRowId < 1) {
            return false;
        }
        int n = this.rowObj.previous();
        if (n != 0) {
            this.sqlExcptGen.check_return_code(this.statement, n);
        }
        --this.currentRowId;
        return n != 100;
    }

    public boolean relative(int n) throws SQLException {
        if (this.getRow() == 0) {
            this.sqlExcptGen.throwInvalidRelativeCall();
        }
        if (this.rowNumber == 0) {
            return false;
        }
        int n2 = this.currentRowId + n;
        if (n2 <= 0) {
            this.beforeFirst();
            return false;
        }
        return this.absolute(n2);
    }

    public void resetRowNum(int n) {
        this.rowNumber = n;
        this.currentRowId = 0;
    }

    public void setFetchDirection(int n) throws SQLException {
        this.fetchDirection = n;
    }
}

