/*
 * Decompiled with CFR 0.152.
 */
package COM.ibm.db2.jdbc.net;

import COM.ibm.db2.jdbc.DB2Trace;
import COM.ibm.db2.jdbc.net.DB2Connection;
import COM.ibm.db2.jdbc.net.DB2Request;
import COM.ibm.db2.jdbc.net.DB2RequestTrace;
import COM.ibm.db2.jdbc.net.DB2ResultSet;
import COM.ibm.db2.jdbc.net.DB2ResultSetTrace;
import COM.ibm.db2.jdbc.net.DB2ScrollableResultSet;
import COM.ibm.db2.jdbc.net.DB2ScrollableResultSetTrace;
import COM.ibm.db2.jdbc.net.SQLExceptionGenerator;
import java.io.IOException;
import java.sql.BatchUpdateException;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;

public class DB2Statement
implements Statement {
    protected int statementHandle;
    protected DB2Connection connection;
    protected SQLWarning warnings = null;
    protected int maxRows = 0;
    protected int maxFieldSize = 0;
    protected int rowCount = 0;
    protected int colCount = 0;
    protected boolean closed = false;
    protected boolean internalStmt = false;
    protected String[] colNames4JSQL = null;
    protected int colCount4JSQL = 0;
    protected boolean isJSQL = false;
    protected DB2Request db2req;
    protected SQLExceptionGenerator sqlExcptGen;
    protected DB2ResultSet resultSet = null;
    protected boolean moreResults = true;
    protected int SQL_SUCCESS = 0;
    protected int SQL_SUCCESS_WITH_INFO = 1;
    protected int rsType = 1003;
    protected int rsConcur = 1007;
    protected int fetchDirection = 1000;
    protected int fetchSize = 1;
    protected StringBuffer stmtBatch = new StringBuffer();
    protected int batchSize = 0;
    protected int[] batchReturn = null;

    public DB2Statement() throws SQLException {
    }

    public DB2Statement(DB2Connection dB2Connection) throws SQLException {
        this(dB2Connection, false);
    }

    public DB2Statement(DB2Connection dB2Connection, boolean bl) throws SQLException {
        this(dB2Connection, bl, 1003, 1007);
    }

    public DB2Statement(DB2Connection dB2Connection, boolean bl, int n, int n2) throws SQLException {
        this.connection = dB2Connection;
        this.internalStmt = bl;
        this.sqlExcptGen = dB2Connection.sqlExcptGen;
        this.checkResultSetType(n, n2);
        this.rsType = n;
        this.rsConcur = n2;
        this.db2req = !DB2Trace.TraceOn ? new DB2Request(dB2Connection) : new DB2RequestTrace(dB2Connection);
        int n3 = 0;
        try {
            this.db2req.write((short)11);
            this.db2req.write((short)this.rsType);
            this.db2req.sendAndRecv();
            n3 = this.db2req.readInt();
            this.statementHandle = this.db2req.readInt();
        }
        catch (IOException iOException) {
            this.sqlExcptGen.socketException("08S01a");
        }
        if (n3 != this.SQL_SUCCESS) {
            this.sqlExcptGen.check_return_code(this, n3);
        }
    }

    public void addBatch(String string) throws SQLException {
        if (this.connection.closed) {
            SQLExceptionGenerator.throwConnectionClosedError();
        }
        if (this.batchSize == 0) {
            this.stmtBatch.append(string);
        } else {
            this.stmtBatch.append(";" + string);
        }
        ++this.batchSize;
    }

    public synchronized void addWarning(SQLWarning sQLWarning) {
        if (this.warnings == null) {
            this.warnings = sQLWarning;
        } else {
            SQLWarning sQLWarning2 = this.warnings;
            while (sQLWarning2.getNextWarning() != null) {
                sQLWarning2 = sQLWarning2.getNextWarning();
            }
            sQLWarning2.setNextWarning(sQLWarning);
        }
    }

    public void cancel() throws SQLException {
        if (this.connection.closed) {
            SQLExceptionGenerator.throwConnectionClosedError();
        }
        try {
            DB2Request dB2Request = this.db2req;
            synchronized (dB2Request) {
                this.db2req.write((short)23);
                this.db2req.write(this.statementHandle);
                this.db2req.sendAndRecv();
                int n = this.db2req.readInt();
            }
        }
        catch (IOException iOException) {
            this.sqlExcptGen.socketException("08S01a");
        }
    }

    protected void checkFetchDirection(int n, int n2) throws SQLException {
        if (n2 != 1000 && n2 != 1001 && n2 != 1002) {
            this.sqlExcptGen.throwFetchDirectionError();
        }
        if (n == 1003 && n2 == 1001) {
            this.sqlExcptGen.throwFetchDirectionError();
        }
    }

    protected void checkFetchSize(int n, int n2) throws SQLException {
        if (n != 0 && n2 > n || n2 < 0) {
            this.sqlExcptGen.throwFetchSizeError();
        }
    }

    protected void checkResultSetType(int n, int n2) throws SQLException {
        if (n2 == 1008) {
            this.sqlExcptGen.throwNotSupportedByDB2("Updatable result set");
        }
        if (n2 != 1007) {
            this.sqlExcptGen.throwUnknownResultSetType(n2);
        }
        if (n == 1005) {
            this.sqlExcptGen.throwNotSupportedByDB2("Scroll sensitive result set");
        }
        if (n != 1003 && n != 1004) {
            this.sqlExcptGen.throwUnknownResultSetType(n);
        }
    }

    public void clearBatch() throws SQLException {
        if (this.connection.closed) {
            SQLExceptionGenerator.throwConnectionClosedError();
        }
        this.batchSize = 0;
        this.stmtBatch = new StringBuffer();
    }

    public synchronized void clearWarnings() throws SQLException {
        this.warnings = null;
    }

    public synchronized void close() throws SQLException {
        if (this.closed) {
            return;
        }
        this.closed = true;
        if (this.connection == null) {
            return;
        }
        DB2Connection dB2Connection = this.connection;
        synchronized (dB2Connection) {
            if (this.connection.closed) {
                Object var2_2 = null;
                return;
            }
            if (this.resultSet != null) {
                this.resultSet.clearIsList();
                this.resultSet = null;
            }
            int n = 0;
            try {
                DB2Request dB2Request = this.db2req;
                synchronized (dB2Request) {
                    this.db2req.write((short)13);
                    this.db2req.write(this.statementHandle);
                    this.db2req.sendAndRecv();
                    n = this.db2req.readInt();
                }
            }
            catch (IOException iOException) {
                this.sqlExcptGen.socketException("08S01a");
            }
            this.statementHandle = 0;
            if (n != this.SQL_SUCCESS) {
                this.sqlExcptGen.check_return_code(this, n);
            }
        }
    }

    public boolean execute(String string) throws SQLException {
        this.execute2(string);
        return this.colCount > 0;
    }

    protected void execute2(String string) throws SQLException {
        if (this.connection.closed) {
            SQLExceptionGenerator.throwConnectionClosedError();
        }
        this.warnings = null;
        this.moreResults = true;
        if (this.resultSet != null) {
            this.resultSet.close();
        }
        int n = 0;
        try {
            DB2Request dB2Request = this.db2req;
            synchronized (dB2Request) {
                this.db2req.write((short)12);
                this.db2req.write(this.statementHandle);
                this.db2req.write(string);
                this.db2req.sendAndRecv();
                n = this.db2req.readInt();
                if (n == 100) {
                    this.rowCount = 0;
                    this.colCount = 0;
                    if (this.rsType == 1004) {
                        ((DB2ScrollableResultSet)this.resultSet).resetRowNum(0);
                    }
                } else if (n == this.SQL_SUCCESS) {
                    this.rowCount = this.db2req.readInt();
                    this.colCount = this.db2req.readShort();
                    if (this.resultSet != null && this.colCount > 0) {
                        this.resultSet.reset(this.colCount);
                        if (this.rsType == 1004) {
                            ((DB2ScrollableResultSet)this.resultSet).resetRowNum(this.rowCount);
                        }
                    }
                } else if (n == this.SQL_SUCCESS_WITH_INFO) {
                    this.sqlExcptGen.check_return_code(this, n);
                    this.getCounts();
                    if (this.resultSet != null && this.colCount > 0) {
                        this.resultSet.reset(this.colCount);
                        if (this.rsType == 1004) {
                            ((DB2ScrollableResultSet)this.resultSet).resetRowNum(this.rowCount);
                        }
                    }
                } else {
                    this.sqlExcptGen.check_return_code(this, n);
                }
            }
        }
        catch (IOException iOException) {
            this.sqlExcptGen.socketException("08S01a");
        }
    }

    public int[] executeBatch() throws SQLException {
        if (this.connection.closed) {
            SQLExceptionGenerator.throwConnectionClosedError();
        }
        if (this.batchSize == 0) {
            this.batchReturn = new int[0];
            return this.batchReturn;
        }
        try {
            DB2Request dB2Request = this.db2req;
            synchronized (dB2Request) {
                this.db2req.write((short)201);
                this.db2req.write(this.statementHandle);
                this.db2req.write(this.stmtBatch.toString());
                this.db2req.write(this.batchSize);
                this.db2req.sendAndRecv();
                int n = this.db2req.readInt();
                this.batchReturn = new int[this.batchSize];
                int n2 = 0;
                while (n2 < this.batchSize) {
                    this.batchReturn[n2] = this.db2req.readInt();
                    ++n2;
                }
                if (this.SQL_SUCCESS_WITH_INFO == n) {
                    BatchUpdateException batchUpdateException = null;
                    SQLException sQLException = null;
                    int n3 = this.db2req.readInt();
                    while (n3 > 0) {
                        BatchUpdateException batchUpdateException2 = this.db2req.readBoolean() ? new BatchUpdateException(SQLExceptionGenerator.errMsgClass.getString("0641"), "HY000", -99999, this.batchReturn) : new BatchUpdateException(this.db2req.readString(), this.db2req.readString(), this.db2req.readInt(), this.batchReturn);
                        if (batchUpdateException == null) {
                            batchUpdateException = batchUpdateException2;
                        } else {
                            sQLException.setNextException(batchUpdateException2);
                        }
                        sQLException = batchUpdateException2;
                        --n3;
                    }
                    if (batchUpdateException != null) {
                        throw batchUpdateException;
                    }
                } else if (n != this.SQL_SUCCESS) {
                    this.sqlExcptGen.check_batch_return_code(this, n);
                }
            }
            this.clearBatch();
            return this.batchReturn;
        }
        catch (IOException iOException) {
            this.sqlExcptGen.socketException("08S01a");
            return null;
        }
    }

    public ResultSet executeQuery(String string) throws SQLException {
        this.execute2(string);
        this.getResultSet();
        return this.resultSet;
    }

    public int executeUpdate(String string) throws SQLException {
        this.execute2(string);
        return this.getUpdateCount();
    }

    public void finalize() throws SQLException {
        this.close();
    }

    protected int[] getBatchReturn() {
        return this.batchReturn;
    }

    public Connection getConnection() {
        return this.connection;
    }

    protected void getCounts() throws SQLException {
        int n = 0;
        try {
            DB2Request dB2Request = this.db2req;
            synchronized (dB2Request) {
                this.db2req.write((short)16);
                this.db2req.write(this.statementHandle);
                this.db2req.sendAndRecv();
                n = this.db2req.readInt();
                if (n == this.SQL_SUCCESS) {
                    this.rowCount = this.db2req.readInt();
                    this.colCount = this.db2req.readShort();
                }
            }
        }
        catch (IOException iOException) {
            this.sqlExcptGen.socketException("08S01a");
        }
    }

    public DB2Connection getDB2Connection() {
        return this.connection;
    }

    public int getFetchDirection() throws SQLException {
        if (this.connection.closed) {
            SQLExceptionGenerator.throwConnectionClosedError();
        }
        return this.fetchDirection;
    }

    public int getFetchSize() throws SQLException {
        if (this.connection.closed) {
            SQLExceptionGenerator.throwConnectionClosedError();
        }
        return this.fetchSize;
    }

    public int getHandle() {
        return this.statementHandle;
    }

    public int getMaxFieldSize() throws SQLException {
        if (this.connection.closed) {
            SQLExceptionGenerator.throwConnectionClosedError();
        }
        return this.maxFieldSize;
    }

    public int getMaxRows() throws SQLException {
        if (this.connection.closed) {
            SQLExceptionGenerator.throwConnectionClosedError();
        }
        return this.maxRows;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public synchronized boolean getMoreResults() throws SQLException {
        if (this.connection.closed) {
            SQLExceptionGenerator.throwConnectionClosedError();
        }
        if (!this.moreResults) {
            return false;
        }
        try {
            DB2Request dB2Request = this.db2req;
            synchronized (dB2Request) {
                this.db2req.write((short)15);
                this.db2req.write(this.statementHandle);
                this.db2req.sendAndRecv();
                int n = this.db2req.readInt();
                if (n == 100) {
                    this.moreResults = false;
                    return false;
                }
                if (n == this.SQL_SUCCESS || n == this.SQL_SUCCESS_WITH_INFO) {
                    if (n != this.SQL_SUCCESS) {
                        this.sqlExcptGen.check_return_code(this, n);
                    }
                    this.colCount = this.db2req.readShort();
                    if (this.resultSet != null && this.colCount > 0) {
                        this.resultSet.reset(this.colCount);
                    }
                    if (this.colCount != 0) return true;
                    this.rowCount = this.db2req.readInt();
                    return true;
                }
                this.sqlExcptGen.check_return_code(this, n);
                this.moreResults = false;
                return false;
            }
        }
        catch (IOException iOException) {
            this.sqlExcptGen.socketException("08S01a");
            this.moreResults = false;
            return false;
        }
    }

    public int getQueryTimeout() throws SQLException {
        if (this.connection.closed) {
            SQLExceptionGenerator.throwConnectionClosedError();
        }
        int n = 0;
        try {
            DB2Request dB2Request = this.db2req;
            synchronized (dB2Request) {
                this.db2req.write((short)21);
                this.db2req.write(this.statementHandle);
                this.db2req.sendAndRecv();
                int n2 = this.db2req.readInt();
                if (n2 != this.SQL_SUCCESS) {
                    this.sqlExcptGen.check_return_code(this, n2);
                } else {
                    n = this.db2req.readInt();
                }
            }
        }
        catch (IOException iOException) {
            this.sqlExcptGen.socketException("08S01a");
        }
        return n;
    }

    public ResultSet getResultSet() throws SQLException {
        if (this.connection.closed) {
            SQLExceptionGenerator.throwConnectionClosedError();
        }
        if (this.resultSet == null) {
            this.resultSet = this.rsType != 1003 ? (DB2Trace.TraceOn ? new DB2ScrollableResultSetTrace(this, this.colCount, this.rowCount) : new DB2ScrollableResultSet(this, this.colCount, this.rowCount)) : (DB2Trace.TraceOn ? new DB2ResultSetTrace(this, this.colCount) : new DB2ResultSet(this, this.colCount));
        }
        if (this.colCount <= 0 || !this.moreResults) {
            return null;
        }
        return this.resultSet;
    }

    public int getResultSetConcurrency() throws SQLException {
        if (this.connection.closed) {
            SQLExceptionGenerator.throwConnectionClosedError();
        }
        return this.rsConcur;
    }

    public int getResultSetType() throws SQLException {
        if (this.connection.closed) {
            SQLExceptionGenerator.throwConnectionClosedError();
        }
        return this.rsType;
    }

    public int getStatementHandle() throws SQLException {
        return this.statementHandle;
    }

    protected String getTraceHandle() {
        int n = this.statementHandle >> 16;
        int n2 = this.statementHandle & 0xFFFF;
        String string = String.valueOf(n) + ":" + n2;
        return string;
    }

    public int getUpdateCount() throws SQLException {
        if (this.connection.closed) {
            SQLExceptionGenerator.throwConnectionClosedError();
        }
        if (this.colCount > 0 || !this.moreResults) {
            return -1;
        }
        if (this.rowCount < 0) {
            return 0;
        }
        return this.rowCount;
    }

    public SQLWarning getWarnings() throws SQLException {
        return this.warnings;
    }

    boolean isClosed() {
        return this.closed;
    }

    public int numberColumns() throws SQLException {
        if (this.connection.closed) {
            SQLExceptionGenerator.throwConnectionClosedError();
        }
        if (this.colCount != -1) {
            return this.colCount;
        }
        try {
            DB2Request dB2Request = this.db2req;
            synchronized (dB2Request) {
                this.db2req.write((short)49);
                this.db2req.write(this.statementHandle);
                this.db2req.sendAndRecv();
                int n = this.db2req.readInt();
                if (n != this.SQL_SUCCESS) {
                    this.sqlExcptGen.check_return_code(this, n);
                }
                this.colCount = this.db2req.readShort();
            }
        }
        catch (IOException iOException) {
            this.sqlExcptGen.socketException("08S01a");
        }
        return this.colCount;
    }

    public void setCursorName(String string) throws SQLException {
        if (this.connection.closed) {
            SQLExceptionGenerator.throwConnectionClosedError();
        }
        try {
            int n;
            DB2Request dB2Request = this.db2req;
            synchronized (dB2Request) {
                this.db2req.write((short)22);
                this.db2req.write(this.statementHandle);
                this.db2req.write(string);
                this.db2req.sendAndRecv();
                n = this.db2req.readInt();
            }
            if (n != this.SQL_SUCCESS) {
                this.sqlExcptGen.check_return_code(this, n);
            }
        }
        catch (IOException iOException) {
            this.sqlExcptGen.socketException("08S01a");
        }
    }

    public void setEscapeProcessing(boolean bl) throws SQLException {
        if (this.connection.closed) {
            SQLExceptionGenerator.throwConnectionClosedError();
        }
        try {
            int n;
            DB2Request dB2Request = this.db2req;
            synchronized (dB2Request) {
                this.db2req.write((short)19);
                this.db2req.write(this.statementHandle);
                short s = 0;
                if (bl) {
                    s = 1;
                }
                this.db2req.write(s);
                this.db2req.sendAndRecv();
                n = this.db2req.readInt();
            }
            if (n != this.SQL_SUCCESS) {
                this.sqlExcptGen.check_return_code(this, n);
            }
        }
        catch (IOException iOException) {
            this.sqlExcptGen.socketException("08S01a");
        }
    }

    public void setFetchDirection(int n) throws SQLException {
        if (this.connection.closed) {
            SQLExceptionGenerator.throwConnectionClosedError();
        }
        this.checkFetchDirection(this.rsType, n);
        this.fetchDirection = n;
    }

    public void setFetchSize(int n) throws SQLException {
        if (this.connection.closed) {
            SQLExceptionGenerator.throwConnectionClosedError();
        }
        this.checkFetchSize(this.maxRows, n);
        this.fetchSize = n;
    }

    public synchronized void setMaxFieldSize(int n) throws SQLException {
        if (this.connection.closed) {
            SQLExceptionGenerator.throwConnectionClosedError();
        }
        if (n < 0) {
            SQLExceptionGenerator.throwOutOfRangeError();
        }
        if (this.maxFieldSize == n) {
            return;
        }
        try {
            int n2;
            DB2Request dB2Request = this.db2req;
            synchronized (dB2Request) {
                this.db2req.write((short)17);
                this.db2req.write(this.statementHandle);
                this.db2req.write(n);
                this.db2req.sendAndRecv();
                n2 = this.db2req.readInt();
            }
            if (n2 != this.SQL_SUCCESS) {
                this.sqlExcptGen.check_return_code(this, n2);
            }
        }
        catch (IOException iOException) {
            this.sqlExcptGen.socketException("08S01a");
        }
        this.maxFieldSize = n;
    }

    public synchronized void setMaxRows(int n) throws SQLException {
        if (this.connection.closed) {
            SQLExceptionGenerator.throwConnectionClosedError();
        }
        if (this.maxRows == n) {
            return;
        }
        if (n < 0) {
            SQLExceptionGenerator.throwOutOfRangeError();
        }
        try {
            int n2;
            DB2Request dB2Request = this.db2req;
            synchronized (dB2Request) {
                this.db2req.write((short)18);
                this.db2req.write(this.statementHandle);
                this.db2req.write(n);
                this.db2req.sendAndRecv();
                n2 = this.db2req.readInt();
            }
            if (n2 != this.SQL_SUCCESS) {
                this.sqlExcptGen.check_return_code(this, n2);
            }
        }
        catch (IOException iOException) {
            this.sqlExcptGen.socketException("08S01a");
        }
        this.maxRows = n;
    }

    public void setQueryTimeout(int n) throws SQLException {
        if (this.connection.closed) {
            SQLExceptionGenerator.throwConnectionClosedError();
        }
        if (n < 0) {
            SQLExceptionGenerator.throwOutOfRangeError();
        }
        try {
            int n2;
            DB2Request dB2Request = this.db2req;
            synchronized (dB2Request) {
                this.db2req.write((short)20);
                this.db2req.write(this.statementHandle);
                this.db2req.write(n);
                this.db2req.sendAndRecv();
                n2 = this.db2req.readInt();
            }
            if (n2 != this.SQL_SUCCESS) {
                this.sqlExcptGen.check_return_code(this, n2);
            }
        }
        catch (IOException iOException) {
            this.sqlExcptGen.socketException("08S01a");
        }
    }
}

