/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.persist;

import java.io.IOException;
import org.hsqldb.HsqlException;
import org.hsqldb.Row;
import org.hsqldb.RowAVL;
import org.hsqldb.RowAVLDiskData;
import org.hsqldb.RowAction;
import org.hsqldb.Session;
import org.hsqldb.Table;
import org.hsqldb.error.Error;
import org.hsqldb.index.Index;
import org.hsqldb.lib.ArrayUtil;
import org.hsqldb.persist.CachedObject;
import org.hsqldb.persist.PersistentStore;
import org.hsqldb.persist.PersistentStoreCollection;
import org.hsqldb.persist.RowStoreAVLDisk;
import org.hsqldb.persist.TextCache;
import org.hsqldb.rowio.RowInputInterface;

public class RowStoreAVLDiskData
extends RowStoreAVLDisk {
    RowAVLDiskData currentRow;

    public RowStoreAVLDiskData(PersistentStoreCollection persistentStoreCollection, Table table) {
        super(persistentStoreCollection, null, table);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CachedObject get(CachedObject cachedObject, boolean bl) {
        this.writeLock();
        try {
            this.currentRow = (RowAVLDiskData)cachedObject;
            CachedObject cachedObject2 = cachedObject = this.cache.get(cachedObject, (PersistentStore)this, bl);
            return cachedObject2;
        }
        finally {
            this.currentRow = null;
            this.writeUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void add(CachedObject cachedObject) {
        this.writeLock();
        try {
            int n = cachedObject.getRealSize(this.cache.rowOut);
            cachedObject.setStorageSize(n);
            this.cache.add(cachedObject);
        }
        finally {
            this.writeUnlock();
        }
    }

    @Override
    public CachedObject get(RowInputInterface rowInputInterface) {
        try {
            Object[] objectArray = RowAVLDiskData.getRowData(this.table, rowInputInterface);
            if (this.currentRow == null) {
                RowAVLDiskData rowAVLDiskData = new RowAVLDiskData((PersistentStore)this, this.table, objectArray);
                rowAVLDiskData.setPos(rowInputInterface.getPos());
                rowAVLDiskData.setStorageSize(rowInputInterface.getSize());
                rowAVLDiskData.setChanged(false);
                ((TextCache)this.cache).addInit(rowAVLDiskData);
                return rowAVLDiskData;
            }
            this.currentRow.setData(objectArray);
            return this.currentRow;
        }
        catch (IOException iOException) {
            throw Error.error(484, iOException);
        }
    }

    @Override
    public CachedObject getNewCachedObject(Session session, Object object, boolean bl) {
        RowAVLDiskData rowAVLDiskData = new RowAVLDiskData((PersistentStore)this, this.table, (Object[])object);
        this.add(rowAVLDiskData);
        if (bl) {
            RowAction.addInsertAction(session, this.table, rowAVLDiskData);
        }
        return rowAVLDiskData;
    }

    @Override
    public void indexRow(Session session, Row row) {
        super.indexRow(session, row);
    }

    @Override
    public void set(CachedObject cachedObject) {
    }

    @Override
    public void removeAll() {
        this.elementCount = 0;
        ArrayUtil.fillArray(this.accessorList, null);
    }

    @Override
    public void remove(int n) {
        this.cache.remove(n, this);
    }

    public void removePersistence(Row row) {
        this.cache.removePersistence(row);
    }

    @Override
    public void release(int n) {
        this.cache.release(n);
    }

    @Override
    public CachedObject getAccessor(Index index) {
        int n = index.getPosition();
        if (n >= this.accessorList.length) {
            throw Error.runtimeError(201, "RowStoreAVL");
        }
        return this.accessorList[n];
    }

    @Override
    public void commitPersistence(CachedObject cachedObject) {
        try {
            this.cache.saveRow(cachedObject);
        }
        catch (HsqlException hsqlException) {
            // empty catch block
        }
    }

    @Override
    public void commitRow(Session session, Row row, int n, int n2) {
        switch (n) {
            case 2: {
                this.removePersistence(row);
                break;
            }
            case 1: {
                this.commitPersistence(row);
                break;
            }
            case 4: {
                if (n2 == 0) {
                    this.remove(row.getPos());
                    break;
                }
                this.delete(session, row);
                this.remove(row.getPos());
                break;
            }
            case 3: {
                if (n2 == 0) break;
                this.delete(session, row);
                this.remove(row.getPos());
            }
        }
    }

    @Override
    public void rollbackRow(Session session, Row row, int n, int n2) {
        switch (n) {
            case 2: {
                if (n2 != 0) break;
                ((RowAVL)row).setNewNodes(this);
                this.indexRow(session, row);
                break;
            }
            case 1: {
                if (n2 != 0) break;
                this.delete(session, row);
                this.remove(row.getPos());
                break;
            }
            case 4: {
                if (n2 == 0) {
                    this.remove(row.getPos());
                    break;
                }
                this.delete(session, row);
                this.remove(row.getPos());
            }
        }
    }

    @Override
    public void release() {
        ArrayUtil.fillArray(this.accessorList, null);
        this.table.database.logger.closeTextCache((Table)this.table);
        this.cache = null;
    }
}

