/*
 * Decompiled with CFR 0.152.
 */
package com.raqsoft.lib.mongo.function;

import com.mongodb.Cursor;
import com.mongodb.DBObject;
import com.raqsoft.common.RQException;
import com.raqsoft.dm.Context;
import com.raqsoft.dm.DataStruct;
import com.raqsoft.dm.IResource;
import com.raqsoft.dm.ListBase1;
import com.raqsoft.dm.Record;
import com.raqsoft.dm.Sequence;
import com.raqsoft.dm.Table;
import com.raqsoft.dm.cursor.ICursor;
import com.raqsoft.lib.mongo.function.ImMongoDB;
import java.util.ArrayList;
import java.util.Set;

public class ImCursor
extends ICursor {
    private ImMongoDB db;
    private Cursor cursor;
    private DataStruct ds;
    private ArrayList<DataStruct> subDsList = new ArrayList();

    public ImCursor(ImMongoDB db, Cursor cursor, String opt, Context ctx) {
        this.cursor = cursor;
        this.ctx = ctx;
        if (ctx != null) {
            ctx.addResource((IResource)this);
        }
        if (opt != null && opt.indexOf(120) != -1) {
            this.db = db;
        }
    }

    protected long skipOver(long n) {
        Cursor cursor = this.cursor;
        if (cursor == null || n == 0L) {
            return 0L;
        }
        long count = 0L;
        while (count < n && cursor.hasNext()) {
            cursor.next();
            ++count;
        }
        if (count < n) {
            this.close();
        }
        return count;
    }

    public synchronized void close() {
        super.close();
        try {
            if (this.ctx != null) {
                this.ctx.removeResource((IResource)this);
            }
            if (this.cursor != null) {
                this.cursor.close();
                this.cursor = null;
            }
            if (this.db != null) {
                this.db.close();
                this.db = null;
            }
        }
        catch (Exception e) {
            throw new RQException(e.getMessage(), (Throwable)e);
        }
    }

    protected Sequence get(int n) {
        Record r;
        Cursor cursor = this.cursor;
        if (cursor == null || n < 1) {
            return null;
        }
        DBObject obj = null;
        if (this.ds == null) {
            if (!cursor.hasNext()) {
                this.close();
                return null;
            }
            obj = (DBObject)cursor.next();
            Set set = obj.keySet();
            int size = set.size();
            if (size == 0) {
                this.close();
                return null;
            }
            String[] fnames = new String[size];
            set.toArray(fnames);
            this.ds = new DataStruct(fnames);
        }
        Table table = n > 99999 ? new Table(this.ds, 99999) : new Table(this.ds, n);
        DataStruct ds = this.ds;
        ArrayList<DataStruct> subDsList = this.subDsList;
        ListBase1 mems = table.getMems();
        if (obj != null) {
            r = ImMongoDB.toRecord(ds, obj, subDsList);
            mems.add((Object)r);
            --n;
        }
        while (n > 0 && cursor.hasNext()) {
            obj = (DBObject)cursor.next();
            r = ImMongoDB.toRecord(ds, obj, subDsList);
            mems.add((Object)r);
            --n;
        }
        if (n > 0) {
            this.close();
            if (table.length() > 0) {
                table.trimToSize();
                return table;
            }
            return null;
        }
        return table;
    }

    protected void finalize() throws Throwable {
        this.close();
    }
}

