/*
 * Decompiled with CFR 0.152.
 */
package com.raqsoft.lib.mongo.function;

import com.mongodb.AggregationOptions;
import com.mongodb.BasicDBObject;
import com.mongodb.Cursor;
import com.mongodb.DB;
import com.mongodb.DBCollection;
import com.mongodb.DBCursor;
import com.mongodb.DBObject;
import com.mongodb.Mongo;
import com.mongodb.MongoClient;
import com.mongodb.MongoClientURI;
import com.mongodb.util.JSON;
import com.raqsoft.common.ArgumentTokenizer;
import com.raqsoft.common.MessageManager;
import com.raqsoft.common.RQException;
import com.raqsoft.common.Sentence;
import com.raqsoft.dm.Context;
import com.raqsoft.dm.DataStruct;
import com.raqsoft.dm.IResource;
import com.raqsoft.dm.Record;
import com.raqsoft.dm.Sequence;
import com.raqsoft.dm.Table;
import com.raqsoft.dm.cursor.ICursor;
import com.raqsoft.lib.mongo.function.ImCursor;
import com.raqsoft.resources.EngineMessage;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.bson.types.ObjectId;

public class ImMongoDB
implements IResource {
    private Mongo mongo;
    private DB db;
    private Context ctx;

    public ImMongoDB(String str, Context ctx) {
        this.ctx = ctx;
        try {
            MongoClientURI conn = new MongoClientURI(str);
            this.mongo = new MongoClient(conn);
            String dbs = conn.getDatabase();
            this.db = this.mongo.getDB(conn.getDatabase());
            if (ctx != null) {
                ctx.addResource((IResource)this);
            }
        }
        catch (Exception e) {
            throw new RQException((Throwable)e);
        }
    }

    private static void readArgs(String str, int index, ArrayList<String> attrList, ArrayList<String> valList) {
        char[] chars = str.toCharArray();
        int len = chars.length;
        while (index < len) {
            int keyStart = index;
            int keyEnd = -1;
            int valStart = -1;
            while (index < len) {
                if (chars[index] == '=') {
                    keyEnd = index++;
                    valStart = index;
                    break;
                }
                ++index;
            }
            if (valStart == -1) break;
            int valEnd = len;
            while (index < len) {
                if (chars[index] == '&') {
                    valEnd = index++;
                    break;
                }
                ++index;
            }
            attrList.add(str.substring(keyStart, keyEnd));
            valList.add(str.substring(valStart, valEnd));
        }
    }

    public void close() {
        if (this.ctx != null) {
            this.ctx.removeResource((IResource)this);
        }
        this.mongo.close();
    }

    public ICursor find(String tableName, String opt) {
        DBCollection collection = this.db.getCollection(tableName);
        DBCursor cursor = collection.find();
        return new ImCursor(this, (Cursor)cursor, opt, this.ctx);
    }

    public ICursor find(String tableName, String filter, String fields, String sort, Number limit, String opt) {
        Object val;
        DBCursor cursor;
        BasicDBObject ref;
        if (filter == null || filter.length() == 0) {
            ref = new BasicDBObject();
        } else {
            Object val2 = JSON.parse((String)filter);
            if (!(val2 instanceof DBObject)) {
                MessageManager mm = EngineMessage.get();
                throw new RQException("find" + mm.getMessage("function.invalidParam"));
            }
            ref = (DBObject)val2;
        }
        DBCollection collection = this.db.getCollection(tableName);
        if (fields == null || fields.length() == 0) {
            cursor = collection.find((DBObject)ref);
        } else {
            val = JSON.parse((String)fields);
            if (!(val instanceof DBObject)) {
                MessageManager mm = EngineMessage.get();
                throw new RQException("find" + mm.getMessage("function.invalidParam"));
            }
            cursor = collection.find((DBObject)ref, (DBObject)val);
        }
        if (sort != null && sort.length() > 0) {
            val = JSON.parse((String)sort);
            if (!(val instanceof DBObject)) {
                MessageManager mm = EngineMessage.get();
                throw new RQException("find" + mm.getMessage("function.invalidParam"));
            }
            cursor = cursor.sort((DBObject)val);
        }
        if (limit != null) {
            cursor = cursor.limit(limit.intValue());
        }
        return new ImCursor(this, (Cursor)cursor, opt, this.ctx);
    }

    public static Record toRecord(DBObject obj, ArrayList<DataStruct> subDsList) {
        DataStruct ds2;
        Set set = obj.toMap().entrySet();
        int size = set.size();
        String[] names = new String[size];
        Object[] vals = new Object[size];
        int i = 0;
        for (Map.Entry entry : set) {
            names[i] = (String)entry.getKey();
            vals[i] = ImMongoDB.mongoDataToDMData(entry.getValue(), subDsList);
            ++i;
        }
        for (DataStruct ds2 : subDsList) {
            if (!ds2.isCompatible(names)) continue;
            return new Record(ds2, vals);
        }
        ds2 = new DataStruct(names);
        subDsList.add(ds2);
        return new Record(ds2, vals);
    }

    public static Object mongoDataToDMData(Object val, ArrayList<DataStruct> subDsList) {
        if (val instanceof List) {
            List list = (List)val;
            int size = list.size();
            Sequence seq = new Sequence(size);
            int i = 0;
            while (i < size) {
                val = list.get(i);
                seq.add(ImMongoDB.mongoDataToDMData(val, subDsList));
                ++i;
            }
            return seq;
        }
        if (val instanceof DBObject) {
            return ImMongoDB.toRecord((DBObject)val, subDsList);
        }
        if (val instanceof ObjectId) {
            return ((ObjectId)val).toString();
        }
        return val;
    }

    public static Record toRecord(DataStruct ds, DBObject obj, ArrayList<DataStruct> subDsList) {
        String[] names = ds.getFieldNames();
        int fcount = names.length;
        Object[] vals = new Object[fcount];
        int i = 0;
        while (i < fcount) {
            Object val = obj.get(names[i]);
            vals[i] = ImMongoDB.mongoDataToDMData(val, subDsList);
            ++i;
        }
        return new Record(ds, vals);
    }

    public long count(String tableName) {
        DBCollection collection = this.db.getCollection(tableName);
        return collection.count();
    }

    public long count(String tableName, String filter) {
        if (filter == null || filter.length() == 0) {
            return this.count(tableName);
        }
        Object val = JSON.parse((String)filter);
        if (!(val instanceof DBObject)) {
            MessageManager mm = EngineMessage.get();
            throw new RQException("count" + mm.getMessage("function.invalidParam"));
        }
        DBCollection collection = this.db.getCollection(tableName);
        return collection.count((DBObject)val);
    }

    public Table aggregate(String tableName, String arg) {
        Object val = JSON.parse((String)arg);
        if (!(val instanceof List)) {
            MessageManager mm = EngineMessage.get();
            throw new RQException("aggregate" + mm.getMessage("function.invalidParam"));
        }
        AggregationOptions aggregationOptions = AggregationOptions.builder().batchSize(Integer.valueOf(9999)).outputMode(AggregationOptions.OutputMode.CURSOR).allowDiskUse(Boolean.valueOf(true)).build();
        List list = (List)val;
        DBCollection collection = this.db.getCollection(tableName);
        Cursor cursor = collection.aggregate(list, aggregationOptions);
        ImCursor tmp = new ImCursor(this, cursor, null, this.ctx);
        return (Table)tmp.fetch();
    }

    public Sequence distinct(String tableName, String field, String filter) {
        List list;
        DBCollection collection = this.db.getCollection(tableName);
        if (filter == null || filter.length() == 0) {
            list = collection.distinct(field);
        } else {
            Object val = JSON.parse((String)filter);
            if (!(val instanceof DBObject)) {
                MessageManager mm = EngineMessage.get();
                throw new RQException("distinct" + mm.getMessage("function.invalidParam"));
            }
            list = collection.distinct(field, (DBObject)val);
        }
        int size = list.size();
        ArrayList<DataStruct> subDsList = new ArrayList<DataStruct>();
        Sequence seq = new Sequence(size);
        int i = 0;
        while (i < size) {
            seq.add(ImMongoDB.mongoDataToDMData(list.get(i), subDsList));
            ++i;
        }
        return seq;
    }

    public Object shell(String cmd, String opt) {
        int i = (cmd = cmd.trim()).indexOf(46);
        if (i < 0) {
            MessageManager mm = EngineMessage.get();
            throw new RQException(String.valueOf(mm.getMessage("Expression.unknownExpression")) + cmd);
        }
        String tableName = cmd.substring(0, i);
        DBCollection collection = this.db.getCollection(tableName);
        if (collection == null) {
            return null;
        }
        return this.shell(collection, cmd, i + 1, opt);
    }

    private ArrayList<String> scanParam(String param) {
        if (param == null) {
            return null;
        }
        if ((param = param.trim()).length() == 0) {
            return null;
        }
        ArrayList<String> paramList = new ArrayList<String>();
        ArgumentTokenizer arg = new ArgumentTokenizer(param);
        while (arg.hasMoreElements()) {
            String cur = arg.nextToken();
            if (cur == null) {
                paramList.add(null);
                continue;
            }
            paramList.add(cur.trim());
        }
        return paramList;
    }

    private DBCursor shell(DBCursor dbCursor, String cmd, int index) {
        int i;
        int len = cmd.length();
        if (index == len) {
            return dbCursor;
        }
        if (cmd.charAt(index) != '.') {
            MessageManager mm = EngineMessage.get();
            throw new RQException(String.valueOf(mm.getMessage("Expression.unknownExpression")) + cmd);
        }
        if ((i = cmd.indexOf(40, ++index)) < 0) {
            MessageManager mm = EngineMessage.get();
            throw new RQException(String.valueOf(mm.getMessage("Expression.unknownExpression")) + cmd);
        }
        int end = Sentence.scanParenthesis((String)cmd, (int)i);
        if (end < 0) {
            MessageManager mm = EngineMessage.get();
            throw new RQException("(,)" + mm.getMessage("Expression.illMatched"));
        }
        String func = cmd.substring(index, i);
        String param = cmd.substring(i + 1, end);
        ArrayList<String> paramList = this.scanParam(param);
        ++end;
        if (func.equals("sort")) {
            if (paramList == null || paramList.size() != 1) {
                MessageManager mm = EngineMessage.get();
                throw new RQException("sort" + mm.getMessage("function.invalidParam"));
            }
            Object val = JSON.parse((String)paramList.get(0));
            if (!(val instanceof DBObject)) {
                MessageManager mm = EngineMessage.get();
                throw new RQException("sort" + mm.getMessage("function.invalidParam"));
            }
            dbCursor = dbCursor.sort((DBObject)val);
        } else if (func.equals("limit")) {
            if (paramList == null || paramList.size() != 1) {
                MessageManager mm = EngineMessage.get();
                throw new RQException("limit" + mm.getMessage("function.invalidParam"));
            }
            Object val = JSON.parse((String)paramList.get(0));
            if (!(val instanceof Number)) {
                MessageManager mm = EngineMessage.get();
                throw new RQException("limit" + mm.getMessage("function.invalidParam"));
            }
            dbCursor = dbCursor.limit(((Number)val).intValue());
        } else if (func.equals("pretty")) {
            cmd = cmd.replace(".pretty()", "");
            end = cmd.length();
        } else if (!func.equals("skip")) {
            MessageManager mm = EngineMessage.get();
            throw new RQException(String.valueOf(mm.getMessage("Expression.unknownFunction")) + func);
        }
        return this.shell(dbCursor, cmd, end);
    }

    private Object shell(DBCollection collection, String cmd, int index, String opt) {
        Object result;
        int i = cmd.indexOf(40, index);
        if (i < 0) {
            MessageManager mm = EngineMessage.get();
            throw new RQException(String.valueOf(mm.getMessage("Expression.unknownExpression")) + cmd);
        }
        int end = Sentence.scanParenthesis((String)cmd, (int)i);
        if (end < 0) {
            MessageManager mm = EngineMessage.get();
            throw new RQException("(,)" + mm.getMessage("Expression.illMatched"));
        }
        String func = cmd.substring(index, i);
        String param = cmd.substring(i + 1, end);
        ArrayList<String> paramList = this.scanParam(param);
        int len = cmd.length();
        ++end;
        if (func.equals("find")) {
            DBCursor dbCursor = this.find(collection, paramList);
            dbCursor = this.shell(dbCursor, cmd, end);
            return new ImCursor(this, (Cursor)dbCursor, opt, this.ctx);
        }
        if (func.equals("count")) {
            if (end != len) {
                MessageManager mm = EngineMessage.get();
                throw new RQException(String.valueOf(mm.getMessage("Expression.unknownExpression")) + cmd.substring(end));
            }
            long count = this.count(collection, paramList);
            result = new Long(count);
        } else if (func.equals("distinct")) {
            if (end != len) {
                MessageManager mm = EngineMessage.get();
                throw new RQException(String.valueOf(mm.getMessage("Expression.unknownExpression")) + cmd.substring(end));
            }
            result = this.distinct(collection, paramList);
        } else if (func.equals("aggregate")) {
            if (end != len) {
                MessageManager mm = EngineMessage.get();
                throw new RQException(String.valueOf(mm.getMessage("Expression.unknownExpression")) + cmd.substring(end));
            }
            result = this.aggregate(collection, paramList);
        } else {
            MessageManager mm = EngineMessage.get();
            throw new RQException(String.valueOf(mm.getMessage("Expression.unknownFunction")) + func);
        }
        if (opt != null && opt.indexOf(120) != -1) {
            this.close();
        }
        return result;
    }

    private Sequence aggregate(DBCollection collection, ArrayList<String> paramList) {
        if (paramList == null || paramList.size() != 1) {
            MessageManager mm = EngineMessage.get();
            throw new RQException("aggregate" + mm.getMessage("function.invalidParam"));
        }
        Object val = JSON.parse((String)paramList.get(0));
        if (!(val instanceof List)) {
            MessageManager mm = EngineMessage.get();
            throw new RQException("find" + mm.getMessage("function.invalidParam"));
        }
        AggregationOptions aggregationOptions = AggregationOptions.builder().batchSize(Integer.valueOf(9999)).outputMode(AggregationOptions.OutputMode.CURSOR).allowDiskUse(Boolean.valueOf(true)).build();
        List list = (List)val;
        Cursor cursor = collection.aggregate(list, aggregationOptions);
        ImCursor tmp = new ImCursor(this, cursor, null, this.ctx);
        return tmp.fetch();
    }

    private long count(DBCollection collection, ArrayList<String> paramList) {
        if (paramList == null) {
            return collection.count();
        }
        if (paramList.size() != 1) {
            MessageManager mm = EngineMessage.get();
            throw new RQException("count" + mm.getMessage("function.invalidParam"));
        }
        Object val = JSON.parse((String)paramList.get(0));
        if (!(val instanceof DBObject)) {
            MessageManager mm = EngineMessage.get();
            throw new RQException("count" + mm.getMessage("function.invalidParam"));
        }
        return collection.count((DBObject)val);
    }

    private Sequence distinct(DBCollection collection, ArrayList<String> paramList) {
        List list;
        if (paramList == null || paramList.size() > 2) {
            MessageManager mm = EngineMessage.get();
            throw new RQException("distinct" + mm.getMessage("function.invalidParam"));
        }
        String field = paramList.get(0);
        String filter = null;
        if (paramList.size() > 1) {
            filter = paramList.get(1);
        }
        if (filter == null || filter.length() == 0) {
            list = collection.distinct(field);
        } else {
            Object val = JSON.parse((String)filter);
            if (!(val instanceof DBObject)) {
                MessageManager mm = EngineMessage.get();
                throw new RQException("distinct" + mm.getMessage("function.invalidParam"));
            }
            list = collection.distinct(field, (DBObject)val);
        }
        int size = list.size();
        ArrayList<DataStruct> subDsList = new ArrayList<DataStruct>();
        Sequence seq = new Sequence(size);
        int i = 0;
        while (i < size) {
            seq.add(ImMongoDB.mongoDataToDMData(list.get(i), subDsList));
            ++i;
        }
        return seq;
    }

    private DBCursor find(DBCollection collection, ArrayList<String> paramList) {
        BasicDBObject ref;
        if (paramList == null) {
            return collection.find();
        }
        int size = paramList.size();
        if (size > 2) {
            MessageManager mm = EngineMessage.get();
            throw new RQException("find" + mm.getMessage("function.invalidParam"));
        }
        String filter = paramList.get(0);
        if (filter == null || filter.length() == 0) {
            ref = new BasicDBObject();
        } else {
            Object val = JSON.parse((String)filter);
            if (!(val instanceof DBObject)) {
                MessageManager mm = EngineMessage.get();
                throw new RQException("find" + mm.getMessage("function.invalidParam"));
            }
            ref = (DBObject)val;
        }
        if (size == 1) {
            return collection.find((DBObject)ref);
        }
        String fields = paramList.get(1);
        if (fields == null || fields.length() == 0) {
            return collection.find((DBObject)ref);
        }
        Object val = JSON.parse((String)fields);
        if (!(val instanceof DBObject)) {
            MessageManager mm = EngineMessage.get();
            throw new RQException("find" + mm.getMessage("function.invalidParam"));
        }
        return collection.find((DBObject)ref, (DBObject)val);
    }
}

