/*
 * Decompiled with CFR 0.152.
 */
package com.raqsoft.lib.webservice.function;

import com.raqsoft.common.Logger;
import com.raqsoft.common.MessageManager;
import com.raqsoft.common.RQException;
import com.raqsoft.dm.Context;
import com.raqsoft.expression.Function;
import com.raqsoft.expression.Node;
import com.raqsoft.lib.webservice.function.WsClientImpl;
import com.raqsoft.resources.EngineMessage;
import java.util.ArrayList;

public class WsCall
extends Function {
    public Node optimize(Context ctx) {
        if (this.param != null) {
            this.param.optimize(ctx);
        }
        return this;
    }

    public Object calculate(Context ctx) {
        if (this.param == null) {
            MessageManager mm = EngineMessage.get();
            throw new RQException("ws_call" + mm.getMessage("function.missingParam"));
        }
        int size = this.param.getSubSize();
        if (size < 2) {
            MessageManager mm = EngineMessage.get();
            throw new RQException("ws_call" + mm.getMessage("function.invalidParam"));
        }
        Logger.debug((Object)("size : " + size));
        Object[] objs = new Object[size];
        WsClientImpl client = null;
        String service = null;
        String port = null;
        String func = null;
        ArrayList<String> values = new ArrayList<String>();
        int i = 0;
        while (i < size) {
            char type;
            if (this.param.getSub(i) == null) {
                MessageManager mm = EngineMessage.get();
                throw new RQException("ws_call" + mm.getMessage("function.invalidParam"));
            }
            if (i == 0) {
                client = (WsClientImpl)((Object)this.param.getSub(i).getLeafExpression().calculate(ctx));
                if (client == null) {
                    throw new RQException("first parameter is not ws_client");
                }
            } else if (i == 1) {
                type = this.param.getSub(i).getType();
                if (type == ':') {
                    if (this.param.getSub(i).getSubSize() != 3) {
                        throw new RQException("should like \"service:port:operation\"");
                    }
                    service = this.param.getSub(i).getSub(0).getLeafExpression().calculate(ctx).toString();
                    port = this.param.getSub(i).getSub(1).getLeafExpression().calculate(ctx).toString();
                    func = this.param.getSub(i).getSub(2).getLeafExpression().calculate(ctx).toString();
                } else {
                    func = this.param.getSub(i).getLeafExpression().calculate(ctx).toString();
                }
            } else {
                type = this.param.getSub(i).getType();
                if (type == ':') {
                    String n = this.param.getSub(i).getSub(1).getLeafExpression().getIdentifierName();
                    n = n.replaceAll("\"", "");
                    values.add(String.valueOf(this.param.getSub(i).getSub(0).getLeafExpression().calculate(ctx).toString()) + ":" + n);
                } else {
                    values.add(this.param.getSub(i).getLeafExpression().calculate(ctx).toString());
                }
            }
            ++i;
        }
        try {
            return client.call(service, port, func, values.size() > 0 ? values.toArray(new String[values.size()]) : new String[]{});
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RQException("ws_call : " + e.getMessage());
        }
    }
}

