/*
 * Decompiled with CFR 0.152.
 */
package com.raqsoft.lib.webservice.function;

import com.raqsoft.common.Logger;
import com.raqsoft.common.StringUtils;
import com.raqsoft.dm.Context;
import com.raqsoft.dm.Record;
import com.raqsoft.dm.Sequence;
import com.raqsoft.dm.Table;
import com.raqsoft.expression.Expression;
import com.raqsoft.lib.webservice.function.Binding;
import com.raqsoft.lib.webservice.function.BindingOperation;
import com.raqsoft.lib.webservice.function.Http;
import com.raqsoft.lib.webservice.function.Message;
import com.raqsoft.lib.webservice.function.Operation;
import com.raqsoft.lib.webservice.function.Part;
import com.raqsoft.lib.webservice.function.Port;
import com.raqsoft.lib.webservice.function.PortType;
import com.raqsoft.lib.webservice.function.Service;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import javax.xml.soap.MessageFactory;
import javax.xml.soap.Name;
import javax.xml.soap.SOAPBody;
import javax.xml.soap.SOAPBodyElement;
import javax.xml.soap.SOAPEnvelope;
import javax.xml.soap.SOAPMessage;
import javax.xml.ws.Dispatch;
import javax.xml.ws.Service;
import org.jdom.Attribute;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.input.SAXBuilder;

public class WsClientImpl
extends Table {
    private String url;
    private Table t = null;
    private String targetNamespace;
    private Map<String, String> alias = new HashMap<String, String>();
    private String currAlias;
    private Map<String, Message> messages = new HashMap<String, Message>();
    private Map<String, PortType> portTypes = new HashMap<String, PortType>();
    private Map<String, Binding> bindings = new HashMap<String, Binding>();
    private Map<String, Service> services = new HashMap<String, Service>();
    private Sequence operations = null;
    public static final String XML_ATTR = "_a_";
    public static final String XML_CHILD = "_c_";
    public static final String XML_TEXT = "_t_";
    public static final int MAX = Integer.MAX_VALUE;

    public WsClientImpl(String url) {
        try {
            Object p;
            Table tj;
            int j;
            Table ti;
            this.url = url;
            String xml = Http.httpsRequest(url, "GET", null);
            this.t = WsClientImpl.xml2Table(xml);
            this.ds = this.t.dataStruct();
            this.mems = this.t.getMems();
            Object o = WsClientImpl.getXmlValue(this.t, new String[]{WsClientImpl.attr("targetNamespace")}, new int[0]);
            if (o == null || !(o instanceof String)) {
                throw new Exception("wsdl targetNamespace not find");
            }
            this.targetNamespace = o.toString();
            String[] fs = this.t.dataStruct().getFieldNames();
            Record r1 = this.t.getRecord(1);
            int i = 0;
            while (i < fs.length) {
                String[] fsi;
                if (fs[i].startsWith(XML_ATTR) && (fsi = fs[i].split(":")).length > 1) {
                    String uri = r1.getFieldValue(fs[i]).toString();
                    this.alias.put(fsi[1], uri);
                    if (uri.equals(this.targetNamespace)) {
                        this.currAlias = fsi[1];
                    }
                }
                ++i;
            }
            i = 1;
            while (i < Integer.MAX_VALUE) {
                ti = WsClientImpl.getXmlTable(this.t, new String[]{WsClientImpl.child("message")}, new int[]{i});
                if (ti == null) break;
                Message mi = new Message();
                mi.name = WsClientImpl.getXmlAttr(ti, new String[]{WsClientImpl.attr("name")}, new int[0]);
                j = 1;
                while (j < Integer.MAX_VALUE) {
                    tj = WsClientImpl.getXmlTable(ti, new String[]{WsClientImpl.child("part")}, new int[]{j++});
                    if (tj == null) break;
                    p = new Part();
                    ((Part)p).name = WsClientImpl.getXmlAttr(tj, new String[]{WsClientImpl.attr("name")}, new int[0]);
                    ((Part)p).type = WsClientImpl.getXmlAttr(tj, new String[]{WsClientImpl.attr("type")}, new int[0]);
                    ((Part)p).element = WsClientImpl.getXmlAttr(tj, new String[]{WsClientImpl.attr("element")}, new int[0]);
                    mi.parts.put(((Part)p).name, (Part)p);
                    mi.partNames.add(((Part)p).name);
                }
                this.messages.put(mi.name, mi);
                ++i;
            }
            i = 1;
            while (i < Integer.MAX_VALUE) {
                ti = WsClientImpl.getXmlTable(this.t, new String[]{WsClientImpl.child("portType")}, new int[]{i});
                if (ti == null) break;
                PortType portType = new PortType();
                portType.name = WsClientImpl.getXmlAttr(ti, new String[]{WsClientImpl.attr("name")}, new int[0]);
                j = 1;
                while (j < Integer.MAX_VALUE) {
                    tj = WsClientImpl.getXmlTable(ti, new String[]{WsClientImpl.child("operation")}, new int[]{j++});
                    if (tj == null) break;
                    Operation mi = new Operation();
                    mi.name = WsClientImpl.getXmlAttr(tj, new String[]{WsClientImpl.attr("name")}, new int[0]);
                    mi.input = this.messages.get(this.getRelationAndCheck(WsClientImpl.getXmlAttr(tj, new String[]{WsClientImpl.child("input"), WsClientImpl.attr("message")}, new int[]{1})));
                    mi.output = this.messages.get(this.getRelationAndCheck(WsClientImpl.getXmlAttr(tj, new String[]{WsClientImpl.child("output"), WsClientImpl.attr("message")}, new int[]{1})));
                    portType.operations.put(mi.name, mi);
                }
                this.portTypes.put(portType.name, portType);
                ++i;
            }
            i = 1;
            while (i < Integer.MAX_VALUE) {
                ti = WsClientImpl.getXmlTable(this.t, new String[]{WsClientImpl.child("binding")}, new int[]{i});
                if (ti == null) break;
                Binding b = new Binding();
                b.name = WsClientImpl.getXmlAttr(ti, new String[]{WsClientImpl.attr("name")}, new int[0]);
                b.port = this.portTypes.get(this.getRelationAndCheck(WsClientImpl.getXmlAttr(ti, new String[]{WsClientImpl.attr("type")}, new int[0])));
                b.style = WsClientImpl.getXmlAttr(ti, new String[]{WsClientImpl.child("binding"), WsClientImpl.attr("style")}, new int[0]);
                b.transport = WsClientImpl.getXmlAttr(ti, new String[]{WsClientImpl.child("binding"), WsClientImpl.attr("transport")}, new int[0]);
                if (b.port != null) {
                    j = 1;
                    while (j < Integer.MAX_VALUE) {
                        tj = WsClientImpl.getXmlTable(ti, new String[]{WsClientImpl.child("operation")}, new int[]{j++});
                        if (tj == null) break;
                        BindingOperation bo = new BindingOperation();
                        bo.operation = b.port.operations.get(WsClientImpl.getXmlAttr(tj, new String[]{WsClientImpl.attr("name")}, new int[0]));
                        b.bindingOperations.put(bo.operation.name, bo);
                        b.names.add(bo.operation.name);
                    }
                }
                this.bindings.put(b.name, b);
                ++i;
            }
            i = 1;
            while (i < Integer.MAX_VALUE) {
                ti = WsClientImpl.getXmlTable(this.t, new String[]{WsClientImpl.child("service")}, new int[]{i});
                if (ti != null) {
                    Service s = new Service();
                    s.name = WsClientImpl.getXmlAttr(ti, new String[]{WsClientImpl.attr("name")}, new int[0]);
                    j = 1;
                    while (j < Integer.MAX_VALUE) {
                        tj = WsClientImpl.getXmlTable(ti, new String[]{WsClientImpl.child("port")}, new int[]{j++});
                        if (tj == null) break;
                        p = new Port();
                        ((Port)p).name = WsClientImpl.getXmlAttr(tj, new String[]{WsClientImpl.attr("name")}, new int[0]);
                        ((Port)p).binding = this.bindings.get(this.getRelationAndCheck(WsClientImpl.getXmlAttr(tj, new String[]{WsClientImpl.attr("binding")}, new int[0])));
                        ((Port)p).location = WsClientImpl.getXmlAttr(tj, new String[]{WsClientImpl.child("address"), WsClientImpl.attr("location")}, new int[]{1});
                        s.ports.put(((Port)p).name, (Port)p);
                    }
                    this.services.put(s.name, s);
                    ++i;
                    continue;
                }
                break;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private String getRelationAndCheck(String s) throws Exception {
        if (s == null) {
            return null;
        }
        String[] ss = s.split(":");
        if (ss.length == 1) {
            return s;
        }
        return ss[1];
    }

    private static String child(String name) {
        return XML_CHILD + name;
    }

    private static String attr(String name) {
        return XML_ATTR + name;
    }

    private static String text() {
        return XML_TEXT;
    }

    private Table getOperation(String name) throws Exception {
        int i = 1;
        while (i <= this.operations.length()) {
            Table ti = (Table)this.operations.get(i);
            Object oi = ti.getRecord(1).getFieldValue("_a_name");
            if (oi == null) {
                throw new Exception("wsdl operation not found name");
            }
            if (name.equals(oi.toString())) {
                return ti;
            }
            ++i;
        }
        return null;
    }

    public Object call2(String serviceName, String port, String functionName, String[] values) throws Exception {
        Object enve;
        block21: {
            URL url = new URL(this.url);
            QName sname = new QName(this.targetNamespace, serviceName);
            javax.xml.ws.Service service = javax.xml.ws.Service.create((URL)url, (QName)sname);
            if (this.services.size() == 0) {
                throw new Exception("no service found");
            }
            Service serv = this.services.get(serviceName);
            if (serv == null) {
                if (this.services.size() == 1 && !StringUtils.isValidString((Object)serviceName)) {
                    serviceName = this.services.keySet().iterator().next();
                    serv = this.services.get(serviceName);
                } else {
                    throw new Exception("no service found");
                }
            }
            if (serv.ports.size() == 0) {
                throw new Exception("no port found");
            }
            Port portObj = serv.ports.get(port);
            if (portObj == null) {
                if (serv.ports.size() == 1 && !StringUtils.isValidString((Object)port)) {
                    port = serv.ports.keySet().iterator().next();
                    portObj = serv.ports.get(port);
                } else {
                    throw new Exception("no port found");
                }
            }
            Dispatch dispatch = service.createDispatch(new QName(this.targetNamespace, port), SOAPMessage.class, Service.Mode.MESSAGE);
            dispatch.getRequestContext().put("javax.xml.ws.soap.http.soapaction.uri", "http://WebXml.com.cn/getWeatherbyCityName");
            SOAPMessage msg = MessageFactory.newInstance().createMessage();
            SOAPEnvelope envelope = msg.getSOAPPart().getEnvelope();
            SOAPBody body = envelope.getBody();
            if (StringUtils.isValidString((Object)functionName)) {
                Name n = envelope.createName(functionName, "raqsoftSoap", this.targetNamespace);
                SOAPBodyElement ele = body.addBodyElement(n);
                if (values != null) {
                    int i = 0;
                    while (i < values.length) {
                        String[] ss = values[i].split(":");
                        if (ss.length != 2) {
                            throw new Exception(String.valueOf(values[i]) + " \u53c2\u6570\u683c\u5f0f\u4e3a\u201c\"value\":paramName\u201d");
                        }
                        ele.addChildElement(ss[1]).setValue(new String(ss[0].getBytes("GBK"), "UTF-8"));
                        ++i;
                    }
                }
            } else if (values != null) {
                int i = 0;
                while (i < values.length) {
                    String[] ss = values[i].split(":");
                    if (ss.length != 2) {
                        throw new Exception(String.valueOf(values[i]) + " \u53c2\u6570\u683c\u5f0f\u4e3a\u201c\"value\":paramName\u201d");
                    }
                    body.addChildElement(ss[1]).setValue(new String(ss[0].getBytes("GBK"), "UTF-8"));
                    ++i;
                }
            }
            msg.writeTo((OutputStream)System.out);
            System.out.println("\n invoking.....");
            SOAPMessage response = (SOAPMessage)dispatch.invoke((Object)msg);
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            response.writeTo((OutputStream)baos);
            String s = baos.toString();
            baos.close();
            Logger.debug((Object)("web service response:" + s));
            Context c1 = new Context();
            c1.setParamValue("xml", (Object)s);
            Object r = new Expression("xml.import@x()").calculate(c1);
            Record rec = (Record)r;
            enve = rec.getFieldValue(0);
            if (enve != null) break block21;
            return null;
        }
        try {
            String[] ns = ((Record)enve).getFieldNames();
            int i = 0;
            while (i < ns.length) {
                if (ns[i].indexOf("ody") >= 0) {
                    Object ody = ((Record)enve).getFieldValue(i);
                    return ((Record)((Record)ody).getFieldValue(0)).getFieldValue(0);
                }
                ++i;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new Exception("web service response soap not support");
        }
        return null;
    }

    public Object call(String serviceName, String port, String functionName, String[] values) throws Exception {
        Object enve;
        block13: {
            if (this.services.size() == 0) {
                throw new Exception("no service found [" + serviceName + "]");
            }
            Service serv = this.services.get(serviceName);
            if (serv == null) {
                if (this.services.size() == 1 && !StringUtils.isValidString((Object)serviceName)) {
                    serviceName = this.services.keySet().iterator().next();
                    serv = this.services.get(serviceName);
                } else {
                    throw new Exception("no service found [" + serviceName + "]");
                }
            }
            if (serv.ports.size() == 0) {
                throw new Exception("no port found [" + port + "]");
            }
            Port portObj = serv.ports.get(port);
            if (portObj == null) {
                if (serv.ports.size() == 1 && !StringUtils.isValidString((Object)port)) {
                    port = serv.ports.keySet().iterator().next();
                    portObj = serv.ports.get(port);
                } else {
                    throw new Exception("no port found [" + serviceName + "]");
                }
            }
            String url = portObj.location;
            String soap = this.getRequestSoap(portObj.binding.bindingOperations.get((Object)functionName).operation, values);
            Logger.debug((Object)("web service request:" + soap));
            String s = Http.httpsRequest(url, "POST", soap);
            Logger.debug((Object)("web service response:" + s));
            Context c1 = new Context();
            c1.setParamValue("xml", (Object)s);
            Object r = new Expression("xml.import@x()").calculate(c1);
            Record rec = (Record)r;
            enve = rec.getFieldValue(0);
            if (enve != null) break block13;
            return null;
        }
        try {
            String[] ns = ((Record)enve).getFieldNames();
            int i = 0;
            while (i < ns.length) {
                if (ns[i].indexOf("ody") >= 0) {
                    Object ody = ((Record)enve).getFieldValue(i);
                    return ((Record)((Record)ody).getFieldValue(0)).getFieldValue(0);
                }
                ++i;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new Exception("web service response soap not support");
        }
        return null;
    }

    public String getRequestSoap(Operation operation, String[] values) throws Exception {
        String ps = "";
        Message input = operation.input;
        int i = 0;
        while (i < values.length) {
            String[] vi = values[i].split(":");
            String name = null;
            if (vi.length > 1) {
                name = vi[1];
            } else {
                if (input.partNames.size() <= i) {
                    throw new Exception("parameter number " + i + " not exist in wsdl");
                }
                name = input.partNames.get(i);
            }
            ps = String.valueOf(ps) + "<" + name + ">" + vi[0] + "</" + name + ">";
            ++i;
        }
        String soap = "";
        soap = String.valueOf(soap) + "<raqsoftSoap:Envelope xmlns:raqsoftSoap=\"http://schemas.xmlsoap.org/soap/envelope/\" xmlns=\"" + this.targetNamespace + "\">" + "<raqsoftSoap:Header/>" + "<raqsoftSoap:Body>" + "<" + operation.name + ">" + ps + "</" + operation.name + ">" + "</raqsoftSoap:Body>" + "</raqsoftSoap:Envelope>";
        return soap;
    }

    public static Table xml2Table(String xml) throws Exception {
        Table t = new Table();
        if (xml == null || "".equals(xml)) {
            return t;
        }
        HashMap m = new HashMap();
        ByteArrayInputStream in = new ByteArrayInputStream(xml.getBytes("UTF-8"));
        SAXBuilder builder = new SAXBuilder();
        Document doc = builder.build((InputStream)in);
        Element root = doc.getRootElement();
        t = WsClientImpl.getElementTable(root);
        ((InputStream)in).close();
        return t;
    }

    private static Table getElementTable(Element e) {
        String n = e.getName();
        ArrayList<String> names = new ArrayList<String>();
        ArrayList<String> objs = new ArrayList<String>();
        List attrs = e.getAttributes();
        int i = 0;
        while (i < attrs.size()) {
            String ns = ((Attribute)attrs.get(i)).getNamespacePrefix();
            ns = ns != null && ns.length() > 0 ? String.valueOf(ns) + ":" : "";
            ns = "";
            names.add(XML_ATTR + ns + ((Attribute)attrs.get(i)).getName());
            objs.add(((Attribute)attrs.get(i)).getValue());
            ++i;
        }
        List childs = e.getChildren();
        int i2 = 0;
        while (i2 < childs.size()) {
            Object oi = childs.get(i2);
            if (oi instanceof Element) {
                String ns = ((Element)childs.get(i2)).getNamespacePrefix();
                ns = ns != null && ns.length() > 0 ? String.valueOf(ns) + ":" : "";
                ns = "";
                String ni = XML_CHILD + ns + ((Element)oi).getName();
                int idx = names.indexOf(ni);
                Sequence seq = null;
                if (names.indexOf(ni) == -1) {
                    seq = new Sequence();
                    names.add(ni);
                    objs.add((String)seq);
                } else {
                    seq = (Sequence)objs.get(idx);
                }
                seq.add((Object)WsClientImpl.getElementTable((Element)oi));
            }
            ++i2;
        }
        if (childs.size() == 0) {
            names.add(XML_TEXT);
            objs.add(e.getText());
        }
        Table t = new Table(names.toArray(new String[names.size()]));
        Record r = t.insert(0);
        int i3 = 0;
        while (i3 < names.size()) {
            r.set((String)names.get(i3), objs.get(i3));
            ++i3;
        }
        return t;
    }

    public static Table getXmlTable(Table t, String[] names, int[] pos) {
        Object o = WsClientImpl.getXmlValue(t, names, pos);
        if (o != null && o instanceof Table) {
            return (Table)o;
        }
        return null;
    }

    public static String getXmlAttr(Table t, String[] names, int[] pos) {
        Object o = WsClientImpl.getXmlValue(t, names, pos);
        if (o != null) {
            return o.toString();
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Object getXmlValue(Table t, String[] names, int[] pos) {
        try {
            Object o = t.getRecord(1).getFieldValue(names[0]);
            int pos0 = 1;
            if (pos != null && pos.length > 0 && pos[0] > 0) {
                pos0 = pos[0];
            }
            if (o instanceof Sequence) {
                o = ((Sequence)o).get(pos0);
            }
            int i = 1;
            while (true) {
                if (i >= names.length) {
                    return o;
                }
                if (o == null) {
                    return null;
                }
                if (o instanceof Table) {
                    o = ((Table)o).getRecord(1).getFieldValue(names[i]);
                }
                int posi = 1;
                if (pos != null && pos.length > i && pos[i] > 0) {
                    posi = pos[i];
                }
                if (o instanceof Sequence) {
                    o = ((Sequence)o).get(posi);
                }
                ++i;
            }
        }
        catch (Exception e) {
            return null;
        }
    }

    public static String getChildrenText(List children) {
        StringBuffer sb = new StringBuffer();
        if (!children.isEmpty()) {
            for (Element e : children) {
                String name = e.getName();
                String value = e.getTextNormalize();
                List list = e.getChildren();
                sb.append("<" + name + ">");
                if (!list.isEmpty()) {
                    sb.append(WsClientImpl.getChildrenText(list));
                }
                sb.append(value);
                sb.append("</" + name + ">");
            }
        }
        return sb.toString();
    }

    public static void main(String[] args) {
        try {
            String s2 = "http://www.webxml.com.cn/WebServices/WeatherWebService.asmx?wsdl";
            WsClientImpl wc = new WsClientImpl(s2);
            System.out.println(wc.call("WeatherWebService", "WeatherWebServiceSoap", "getWeatherbyCityName", new String[]{"\u4e0a\u6d77:theCityName"}));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

