/*
 * Decompiled with CFR 0.152.
 */
package com.csii.payment.client.core;

import com.csii.payment.client.core.MerchantSignTool;
import com.csii.payment.client.entity.SignParameterObject;
import com.csii.payment.client.entity.VerifyParameterObject;
import com.csii.payment.client.util.Log;

public class CebMerchantSignVerify {
    private static Log log = new Log(CebMerchantSignVerify.class);

    public static String merchantSignData_ABA(String plain) {
        log.info(new StringBuffer("\r\n").append("\u5546\u6237\u4e0a\u9001\u5f85\u7b7e\u540d\u660e\u6587\uff1a").append(plain).append("\r\n"));
        SignParameterObject signParam = new SignParameterObject();
        signParam.setPlain(plain);
        signParam.setCharset("GBK");
        signParam.setType(0);
        signParam.setTransId("");
        signParam.setAlgorithm("MD5withRSA");
        try {
            return MerchantSignTool.sign(signParam);
        }
        catch (Exception e) {
            log.error("\u7b7e\u540d\u5931\u8d25\uff01\r\n", e);
            return null;
        }
    }

    public static String merchantSignData_ABA(String plain, String merchantId) {
        log.info(new StringBuffer("\r\n").append("\u5546\u6237\u4e0a\u9001\u5546\u6237\u53f7\uff1a").append(merchantId).append("\r\n").append("\u5546\u6237\u4e0a\u9001\u5f85\u7b7e\u540d\u660e\u6587\uff1a").append(plain).append("\r\n"));
        SignParameterObject signParam = new SignParameterObject();
        signParam.setMerchantId(merchantId);
        signParam.setPlain(plain);
        signParam.setCharset("GBK");
        signParam.setType(0);
        signParam.setTransId("");
        signParam.setAlgorithm("MD5withRSA");
        try {
            return MerchantSignTool.sign(signParam);
        }
        catch (Exception e) {
            log.error("\u7b7e\u540d\u5931\u8d25\uff01\r\n", e);
            return null;
        }
    }

    public static boolean merchantVerifyPayGate_ABA(String sign, String plain) {
        log.info(new StringBuffer("\r\n").append("\u5546\u6237\u4e0a\u9001\u660e\u6587\uff1a").append(plain).append("\r\n").append("\u5546\u6237\u4e0a\u9001\u7b7e\u540d\u4e32\uff1a").append(sign).append("\r\n"));
        VerifyParameterObject verifyParam = new VerifyParameterObject();
        verifyParam.setPlain(plain);
        verifyParam.setPlainCharset("GBK");
        verifyParam.setSign(sign);
        verifyParam.setSignCharset("");
        verifyParam.setType(0);
        verifyParam.setAlgorithm("MD5withRSA");
        try {
            return MerchantSignTool.verify(verifyParam);
        }
        catch (Exception e) {
            log.error("\u9a8c\u7b7e\u5931\u8d25\uff01\r\n", e);
            return false;
        }
    }
}

