/*
 * Decompiled with CFR 0.152.
 */
package com.csii.payment.client.core;

import com.csii.payment.client.core.OfflineResolver;
import com.csii.payment.client.entity.CebMerchantProperties;
import com.csii.payment.client.entity.SignParameterObject;
import com.csii.payment.client.entity.VerifyParameterObject;
import com.csii.payment.client.key.KeyManager;
import com.csii.payment.client.util.Log;
import com.csii.payment.client.util.Util;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.OutputStream;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.nio.charset.Charset;
import java.nio.charset.UnsupportedCharsetException;
import java.security.Key;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.Signature;
import java.util.Collections;
import javax.xml.crypto.dsig.CanonicalizationMethod;
import javax.xml.crypto.dsig.DigestMethod;
import javax.xml.crypto.dsig.Reference;
import javax.xml.crypto.dsig.SignatureMethod;
import javax.xml.crypto.dsig.SignedInfo;
import javax.xml.crypto.dsig.Transform;
import javax.xml.crypto.dsig.XMLSignature;
import javax.xml.crypto.dsig.XMLSignatureFactory;
import javax.xml.crypto.dsig.dom.DOMSignContext;
import javax.xml.crypto.dsig.dom.DOMValidateContext;
import javax.xml.crypto.dsig.spec.C14NMethodParameterSpec;
import javax.xml.crypto.dsig.spec.TransformParameterSpec;
import org.apache.commons.codec.binary.Base64;
import org.apache.xml.security.Init;
import org.apache.xml.security.transforms.Transforms;
import org.apache.xml.security.utils.XMLUtils;
import org.apache.xml.security.utils.resolver.ResourceResolverSpi;
import org.apache.xpath.XPathAPI;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class MerchantSignTool {
    private static Log log = new Log(MerchantSignTool.class);

    static {
        Init.init();
        CebMerchantProperties.getCafile();
    }

    public static String sign(SignParameterObject signParam) throws Exception {
        try {
            String algorithm = MerchantSignTool.convertAlgorithm(signParam.getType(), signParam.getAlgorithm());
            String uuid = new StringBuffer("\u3010").append(Util.getUUID()).append("\u3011   ").toString();
            log.info(new StringBuffer(uuid).append("\u5546\u6237\u4e0a\u9001\u6570\u636e\uff1a").append("\r\n").append("\u3010--------\u7b7e\u540d--------\u3011").append("\r\n").append(signParam).append("xml\u62a5\u6587\u7b97\u6cd5\u8f6c\u6362\uff1a").append(algorithm).append("\r\n"));
            MerchantSignTool.checkSignParam(signParam, uuid);
            signParam.setAlgorithm(algorithm);
            String sign = "";
            switch (signParam.getType()) {
                case 0: {
                    sign = Util.byteToHex(MerchantSignTool.innerSign(signParam, uuid));
                    break;
                }
                case 1: {
                    sign = new String(MerchantSignTool.signXMLUseJDK(signParam, uuid), signParam.getCharset());
                    break;
                }
                case 2: {
                    sign = new String(MerchantSignTool.signXMLUseApache(signParam, uuid), signParam.getCharset());
                    break;
                }
                case 3: {
                    sign = Util.byteToHex(MerchantSignTool.signFile(signParam, uuid));
                    break;
                }
                case 4: {
                    sign = MerchantSignTool.signURL(signParam, uuid);
                    break;
                }
                default: {
                    throw new Exception("\u4e0d\u5b58\u5728\u7684\u7b7e\u540d\u7c7b\u578b\uff01\u4e0a\u9001\u7684\u7c7b\u578b\u4e3a\uff1a" + signParam.getType());
                }
            }
            log.info(new StringBuffer(uuid).append("\u7b7e\u540d\u7ed3\u679c\u4e3a\uff1a\r\n").append(sign).append("\r\n"));
            if (signParam.getType() == 1 || signParam.getType() == 2) {
                log.info(new StringBuffer(uuid).append("\u5bf9XML\u7b7e\u540d\u4e32\u8fdb\u884c\u683c\u5f0f\u5316\u8f93\u51fa\uff1a\r\n").append(Util.formatXML(sign, signParam.getCharset(), 0)).append("\r\n"));
            }
            return sign;
        }
        catch (Exception e) {
            log.error("", e);
            throw e;
        }
    }

    public static boolean verify(VerifyParameterObject verifyParam) throws Exception {
        try {
            String uuid = new StringBuffer("\u3010").append(Util.getUUID()).append("\u3011   ").toString();
            log.info(new StringBuffer(uuid).append("\u5546\u6237\u4e0a\u9001\u6570\u636e\uff1a").append("\r\n").append("\u3010--------\u9a8c\u7b7e--------\u3011").append("\r\n").append(verifyParam).append("\r\n"));
            MerchantSignTool.checkVerifyParam(verifyParam, uuid);
            boolean result = false;
            switch (verifyParam.getType()) {
                case 0: {
                    result = MerchantSignTool.verifyCommon(verifyParam);
                    break;
                }
                case 1: {
                    result = MerchantSignTool.verifyXMLUseJDK(verifyParam);
                    break;
                }
                case 2: {
                    result = MerchantSignTool.verifyXMLUseApache(verifyParam);
                    break;
                }
                case 3: {
                    result = MerchantSignTool.verifyFile(verifyParam);
                    break;
                }
                case 4: {
                    result = MerchantSignTool.verifyURL(verifyParam, uuid);
                    break;
                }
                default: {
                    result = false;
                }
            }
            log.info(new StringBuffer(uuid).append("\u9a8c\u7b7e\u7ed3\u679c\uff1a\u3010").append(result).append("\u3011\r\n"));
            return result;
        }
        catch (Exception e) {
            log.error("", e);
            throw e;
        }
    }

    private static boolean verifyURL(VerifyParameterObject verifyParam, String uuid) throws Exception {
        String signURLDecode = URLDecoder.decode(verifyParam.getSign(), verifyParam.getSignCharset());
        log.info(new StringBuffer(uuid).append("URL\u89e3\u7801\u540e\uff1a").append(signURLDecode).append("\r\n"));
        byte[] plainByte = verifyParam.getPlain().getBytes(verifyParam.getPlainCharset());
        byte[] signByte = Base64.decodeBase64((byte[])signURLDecode.getBytes(verifyParam.getSignCharset()));
        return MerchantSignTool.innerVerify(plainByte, signByte, KeyManager.getPublicKey(), verifyParam.getAlgorithm());
    }

    private static byte[] innerSign(SignParameterObject signParam, String uuid) throws Exception {
        String plain = signParam.getPlain();
        String charset = signParam.getCharset();
        PrivateKey privateKey = KeyManager.getPrivateKey(signParam.getMerchantId());
        String algorithm = signParam.getAlgorithm();
        return MerchantSignTool.innerSign(plain.getBytes(charset), privateKey, algorithm);
    }

    private static byte[] signXMLUseJDK(SignParameterObject signParam, String uuid) throws Exception {
        String plain = Util.formatXML(signParam.getPlain(), signParam.getCharset(), 1);
        signParam.setPlain(plain);
        log.info(new StringBuffer(uuid).append("\u8f6c\u6362\u4e3a\u7d27\u51d1\u578bXML\u8fdb\u884c\u7b7e\u540d\uff1a").append("\r\n").append(signParam.getPlain()).append("\r\n"));
        PrivateKey privateKey = KeyManager.getPrivateKey(signParam.getMerchantId());
        String algorithm = signParam.getAlgorithm();
        XMLSignatureFactory factory = XMLSignatureFactory.getInstance("DOM");
        Transform transform = factory.newTransform("http://www.w3.org/2000/09/xmldsig#enveloped-signature", (TransformParameterSpec)null);
        DigestMethod digestMethod = factory.newDigestMethod("http://www.w3.org/2000/09/xmldsig#sha1", null);
        Reference reference = factory.newReference("#" + signParam.getTransId(), digestMethod, Collections.singletonList(transform), null, null);
        CanonicalizationMethod canonicalizationMethod = factory.newCanonicalizationMethod("http://www.w3.org/TR/2001/REC-xml-c14n-20010315", (C14NMethodParameterSpec)null);
        SignatureMethod signatureMethod = factory.newSignatureMethod(algorithm, null);
        SignedInfo signedInfo = factory.newSignedInfo(canonicalizationMethod, signatureMethod, Collections.singletonList(reference));
        XMLSignature xmlSignature = factory.newXMLSignature(signedInfo, null);
        Document doc = Util.parseDom(signParam.getPlain(), signParam.getCharset());
        Element element = (Element)doc.getElementsByTagName("Plain").item(0);
        element.setIdAttributeNode(element.getAttributeNode("id"), true);
        DOMSignContext domSignContext = new DOMSignContext(privateKey, (Node)doc.getDocumentElement());
        xmlSignature.sign(domSignContext);
        return Util.domConvertToXML(doc).getBytes(signParam.getCharset());
    }

    private static byte[] signXMLUseApache(SignParameterObject signParam, String uuid) throws Exception {
        String plain = Util.formatXML(signParam.getPlain(), signParam.getCharset(), 1);
        signParam.setPlain(plain);
        log.info(new StringBuffer(uuid).append("\u8f6c\u6362\u4e3a\u7d27\u51d1\u578bXML\u8fdb\u884c\u7b7e\u540d\uff1a").append("\r\n").append(signParam.getPlain()).append("\r\n"));
        PrivateKey privateKey = KeyManager.getPrivateKey(signParam.getMerchantId());
        Document doc = Util.parseDom(signParam.getPlain(), signParam.getCharset());
        Element element = (Element)doc.getElementsByTagName("Plain").item(0);
        element.setIdAttributeNode(element.getAttributeNode("id"), true);
        org.apache.xml.security.signature.XMLSignature xmlSignature = new org.apache.xml.security.signature.XMLSignature(doc, "", signParam.getAlgorithm());
        xmlSignature.getSignedInfo().addResourceResolver((ResourceResolverSpi)new OfflineResolver());
        Node messageNode = doc.getElementsByTagName("Message").item(0);
        Transforms transforms = new Transforms(doc);
        transforms.addTransform("http://www.w3.org/2000/09/xmldsig#enveloped-signature");
        xmlSignature.addDocument("#" + signParam.getTransId(), transforms, "http://www.w3.org/2000/09/xmldsig#sha1");
        xmlSignature.sign((Key)privateKey);
        messageNode.appendChild(xmlSignature.getElement());
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        try {
            XMLUtils.outputDOM((Node)doc, (OutputStream)os);
            byte[] byArray = os.toByteArray();
            return byArray;
        }
        finally {
            Util.closeStream(os);
        }
    }

    private static byte[] signFile(SignParameterObject signParam, String uuid) throws Exception {
        PrivateKey privateKey = KeyManager.getPrivateKey(signParam.getMerchantId());
        FileInputStream fis = new FileInputStream(signParam.getCheckFilePath());
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        try {
            byte[] sign;
            Util.copyInputStreamToOutStream(fis, bos);
            byte[] byArray = sign = MerchantSignTool.innerSign(bos.toByteArray(), privateKey, signParam.getAlgorithm());
            return byArray;
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            Util.closeStream(fis);
            Util.closeStream(bos);
        }
    }

    private static String signURL(SignParameterObject signParam, String uuid) throws Exception {
        byte[] tmpSignURL = MerchantSignTool.innerSign(signParam, uuid);
        String tmpResult = new String(Base64.encodeBase64((byte[])tmpSignURL, (boolean)false), signParam.getCharset());
        return URLEncoder.encode(tmpResult, signParam.getCharset());
    }

    private static boolean verifyCommon(VerifyParameterObject verifyParam) throws Exception {
        String plain = verifyParam.getPlain();
        String plainCharset = verifyParam.getPlainCharset();
        String sign = verifyParam.getSign();
        String algorithm = verifyParam.getAlgorithm();
        return MerchantSignTool.innerVerify(plain.getBytes(plainCharset), Util.hexToByte(sign), KeyManager.getPublicKey(), algorithm);
    }

    private static boolean verifyXMLUseJDK(VerifyParameterObject verifyParam) throws Exception {
        Document doc = Util.parseDom(verifyParam.getSign(), "UTF-8");
        Element element = (Element)doc.getElementsByTagName("Plain").item(0);
        element.setIdAttributeNode(element.getAttributeNode("id"), true);
        NodeList nodeList = doc.getElementsByTagNameNS("http://www.w3.org/2000/09/xmldsig#", verifyParam.getSignatureLable());
        if (nodeList.getLength() == 0) {
            log.error("\u5f85\u9a8c\u7b7e\u7684\u7b7e\u540d\u4e32\u4e2d\u4e0d\u542b\u6709\u7b7e\u540d\u4fe1\u606f\uff01\r\n");
            throw new Exception("\u5f85\u9a8c\u7b7e\u7684\u7b7e\u540d\u4e32\u4e2d\u4e0d\u542b\u6709\u7b7e\u540d\u4fe1\u606f\uff01");
        }
        DOMValidateContext validateContext = new DOMValidateContext(KeyManager.getPublicKey(), nodeList.item(0));
        XMLSignatureFactory fac = XMLSignatureFactory.getInstance("DOM");
        XMLSignature signature = fac.unmarshalXMLSignature(validateContext);
        return signature.validate(validateContext);
    }

    private static boolean verifyXMLUseApache(VerifyParameterObject verifyParam) throws Exception {
        Document doc = Util.parseDom(verifyParam.getSign(), "UTF-8");
        Element element = (Element)doc.getElementsByTagName("Plain").item(0);
        element.setIdAttributeNode(element.getAttributeNode("id"), true);
        Element nscontext = XMLUtils.createDSctx((Document)doc, (String)"ds", (String)"http://www.w3.org/2000/09/xmldsig#");
        Element signElement = (Element)XPathAPI.selectSingleNode((Node)doc, (String)("//" + verifyParam.getSignatureLable() + "[1]"), (Node)nscontext);
        if (signElement == null) {
            return false;
        }
        org.apache.xml.security.signature.XMLSignature signature = new org.apache.xml.security.signature.XMLSignature(signElement, "");
        return signature.checkSignatureValue((Key)KeyManager.getPublicKey());
    }

    private static boolean verifyFile(VerifyParameterObject verifyParam) throws Exception {
        boolean bl;
        FileInputStream fis = null;
        ByteArrayOutputStream bos = null;
        try {
            fis = new FileInputStream(verifyParam.getCheckFilePath());
            bos = new ByteArrayOutputStream();
            Util.copyInputStreamToOutStream(fis, bos);
            bl = MerchantSignTool.innerVerify(bos.toByteArray(), Util.hexToByte(verifyParam.getSign()), KeyManager.getPublicKey(), verifyParam.getAlgorithm());
        }
        catch (Exception e) {
            try {
                throw e;
            }
            catch (Throwable throwable) {
                Util.closeStream(fis);
                Util.closeStream(bos);
                throw throwable;
            }
        }
        Util.closeStream(fis);
        Util.closeStream(bos);
        return bl;
    }

    private static byte[] innerSign(byte[] plain, PrivateKey privateKey, String algorithm) throws Exception {
        Signature signature = Util.isNullOrEmpty(CebMerchantProperties.getProvider()) ? Signature.getInstance(algorithm) : Signature.getInstance(algorithm, CebMerchantProperties.getProvider());
        signature.initSign(privateKey);
        signature.update(plain);
        return signature.sign();
    }

    private static boolean innerVerify(byte[] plain, byte[] sign, PublicKey publicKey, String algorithm) throws Exception {
        Signature signature = Util.isNullOrEmpty(CebMerchantProperties.getProvider()) ? Signature.getInstance(algorithm) : Signature.getInstance(algorithm, CebMerchantProperties.getProvider());
        signature.initVerify(publicKey);
        signature.update(plain);
        return signature.verify(sign);
    }

    private static void checkSignParam(SignParameterObject signParam, String uuid) throws Exception {
        if (CebMerchantProperties.isNewMerchantPropertiesFile()) {
            if (Util.isNullOrEmpty(signParam.getMerchantId())) {
                log.error(new StringBuffer(uuid).append("\u5546\u6237\u53f7\u4e0d\u80fd\u4e3a\u7a7a").append("\r\n"));
                throw new Exception("\u5546\u6237\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (KeyManager.getPrivateKey(signParam.getMerchantId()) == null) {
                log.error(new StringBuffer(uuid).append("\u8be5\u5546\u6237\u53f7\u3010").append(signParam.getMerchantId()).append("\u3011\u5728\u914d\u7f6e\u6587\u4ef6\u4e2d\u6ca1\u6709\u7ef4\u62a4\u79c1\u94a5").append("\r\n"));
                throw new Exception("\u8be5\u5546\u6237\u53f7\u5728\u914d\u7f6e\u6587\u4ef6\u4e2d\u6ca1\u6709\u7ef4\u62a4\u79c1\u94a5\uff0c\u5546\u6237\u53f7\u4e3a\uff1a" + signParam.getMerchantId());
            }
        }
        if (Util.isNullOrEmpty(signParam.getAlgorithm())) {
            log.error(new StringBuffer(uuid).append("\u7b97\u6cd5\u4e0d\u80fd\u4e3a\u7a7a").append("\r\n"));
            throw new Exception("\u7b97\u6cd5\u4e0d\u80fd\u4e3a\u7a7a");
        }
        switch (signParam.getType()) {
            case 0: {
                MerchantSignTool.checkSignParamCommon(signParam, uuid);
                break;
            }
            case 1: {
                MerchantSignTool.checkSignParamXML(signParam, uuid);
                break;
            }
            case 2: {
                MerchantSignTool.checkSignParamXML(signParam, uuid);
                break;
            }
            case 3: {
                MerchantSignTool.checkSignParamFile(signParam, uuid);
                break;
            }
            case 4: {
                MerchantSignTool.checkSignParamURL(signParam, uuid);
                break;
            }
            default: {
                throw new Exception("\u4e0d\u5b58\u5728\u7684\u7b7e\u540d\u7c7b\u578b\uff01\u4e0a\u9001\u7684\u7c7b\u578b\u4e3a\uff1a" + signParam.getType());
            }
        }
    }

    private static void checkSignParamURL(SignParameterObject signParam, String uuid) throws Exception {
        if (Util.isNullOrEmpty(signParam.getPlain())) {
            log.error(new StringBuffer(uuid).append("\u660e\u6587\u4e0d\u80fd\u4e3a\u7a7a").append("\r\n"));
            throw new Exception("\u660e\u6587\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (Util.isNullOrEmpty(signParam.getCharset())) {
            log.error(new StringBuffer(uuid).append("\u5b57\u7b26\u96c6\u4e0d\u80fd\u4e3a\u7a7a").append("\r\n"));
            throw new Exception("\u5b57\u7b26\u96c6\u4e0d\u80fd\u4e3a\u7a7a");
        }
        try {
            Charset.forName(signParam.getCharset());
        }
        catch (UnsupportedCharsetException e) {
            log.error(new StringBuffer(uuid).append("\u4e0d\u652f\u6301\u7684\u5b57\u7b26\u96c6").append("\r\n"));
            throw e;
        }
    }

    private static void checkSignParamCommon(SignParameterObject signParam, String uuid) throws Exception {
        MerchantSignTool.checkSignParamURL(signParam, uuid);
        if (CebMerchantProperties.isNewMerchantPropertiesFile() && signParam.isVerifyMerchantId() && signParam.getPlain().indexOf(signParam.getMerchantId()) < 0) {
            log.error(new StringBuffer().append("\u8bf7\u6c42\u6570\u636e\u4e2d\u7684\u5546\u6237\u53f7\u4e0e\u7b7e\u540d\u5bf9\u8c61\u4e2d\u7684\u5546\u6237\u53f7\u4e0d\u4e00\u81f4,\u7b7e\u540d\u5bf9\u8c61\u4e2d\u4f7f\u7528\u7684\u5546\u6237\u53f7\u4e3a\uff1a\u3010").append(signParam.getMerchantId()).append("\u3011\r\n"));
            throw new Exception("\u8bf7\u6c42\u6570\u636e\u4e2d\u7684\u5546\u6237\u53f7\u4e0e\u7b7e\u540d\u5bf9\u8c61\u4e2d\u8bbe\u7f6e\u7684\u5546\u6237\u53f7\u4e0d\u4e00\u81f4");
        }
    }

    private static void checkSignParamXML(SignParameterObject signParam, String uuid) throws Exception {
        MerchantSignTool.checkSignParamCommon(signParam, uuid);
        if (Util.isNullOrEmpty(signParam.getTransId())) {
            log.error(new StringBuffer(uuid).append("\u4ea4\u6613\u7801\u4e0d\u80fd\u4e3a\u7a7a").append("\r\n"));
            throw new Exception("\u4ea4\u6613\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        }
        try {
            String xmlMessage = Util.formatXML(signParam.getPlain(), signParam.getCharset(), 0);
            log.info(new StringBuffer(uuid).append("\u5546\u6237\u4e0a\u9001XML\u62a5\u6587\u8fdb\u884c\u683c\u5f0f\u5316\u8f93\u51fa\uff1a\r\n").append(xmlMessage).append("\r\n"));
        }
        catch (Exception e) {
            log.error(new StringBuffer(uuid).append("\u4e0a\u9001XML\u62a5\u6587\u683c\u5f0f\u4e0d\u6b63\u786e\uff0c\u8bf7\u68c0\u67e5\uff01").append("\r\n"), e);
            throw new Exception("\u4e0a\u9001XML\u62a5\u6587\u683c\u5f0f\u4e0d\u6b63\u786e\uff0c\u8bf7\u68c0\u67e5\uff01");
        }
    }

    private static void checkSignParamFile(SignParameterObject signParam, String uuid) throws Exception {
        if (Util.isNullOrEmpty(signParam.getCheckFilePath())) {
            log.error(new StringBuffer(uuid).append("\u6587\u4ef6\u8def\u5f84\u4e0d\u80fd\u4e3a\u7a7a").append("\r\n"));
            throw new Exception("\u6587\u4ef6\u8def\u5f84\u4e0d\u80fd\u4e3a\u7a7a");
        }
        File file = new File(signParam.getCheckFilePath());
        if (!file.exists()) {
            log.error(new StringBuffer(uuid).append("\u6587\u4ef6\u4e0d\u5b58\u5728\uff0c\u6587\u4ef6\u8def\u5f84\u4e3a\uff1a").append(signParam.getCheckFilePath()).append("\r\n"));
            throw new Exception("\u6587\u4ef6\u4e0d\u5b58\u5728\uff01" + signParam.getCheckFilePath());
        }
    }

    private static void checkVerifyParam(VerifyParameterObject verifyParam, String uuid) throws Exception {
        if (Util.isNullOrEmpty(verifyParam.getSign())) {
            log.error(new StringBuffer(uuid).append("\u7b7e\u540d\u4e32\u4e0d\u80fd\u4e3a\u7a7a").append("\r\n"));
            throw new Exception("\u7b7e\u540d\u4e32\u4e0d\u80fd\u4e3a\u7a7a");
        }
        switch (verifyParam.getType()) {
            case 0: {
                MerchantSignTool.checkVerifyParamCommon(verifyParam, uuid);
                break;
            }
            case 1: {
                MerchantSignTool.checkVerifyParamXML(verifyParam, uuid);
                break;
            }
            case 2: {
                MerchantSignTool.checkVerifyParamXML(verifyParam, uuid);
                break;
            }
            case 3: {
                MerchantSignTool.checkVerifyParamFile(verifyParam, uuid);
                break;
            }
            case 4: {
                MerchantSignTool.checkVerifyParamURL(verifyParam, uuid);
                break;
            }
            default: {
                throw new Exception("\u4e0d\u5b58\u5728\u7684\u7b7e\u540d\u7c7b\u578b\uff01\u4e0a\u9001\u7684\u7c7b\u578b\u4e3a\uff1a" + verifyParam.getType());
            }
        }
    }

    private static void checkVerifyParamCommon(VerifyParameterObject verifyParam, String uuid) throws Exception {
        if (Util.isNullOrEmpty(verifyParam.getPlain())) {
            log.error(new StringBuffer(uuid).append("\u660e\u6587\u4e3a\u7a7a\uff01").append("\r\n"));
            throw new Exception("\u660e\u6587\u4e3a\u7a7a\uff01");
        }
        if (Util.isNullOrEmpty(verifyParam.getPlainCharset())) {
            log.error(new StringBuffer(uuid).append("\u660e\u6587\u6240\u4f7f\u7528\u5b57\u7b26\u96c6\u4e3a\u7a7a").append("\r\n"));
            throw new Exception("\u660e\u6587\u6240\u4f7f\u7528\u5b57\u7b26\u96c6\u4e3a\u7a7a");
        }
        try {
            Charset.forName(verifyParam.getPlainCharset());
        }
        catch (Exception e) {
            log.error(new StringBuffer(uuid).append("\u660e\u6587\u6240\u4f7f\u7528\u5b57\u7b26\u96c6(").append(verifyParam.getPlainCharset()).append(") \u4e0d\u652f\u6301\uff01").append("\r\n"), e);
            throw new Exception("\u660e\u6587\u6240\u4f7f\u7528\u5b57\u7b26\u96c6(" + verifyParam.getPlainCharset() + ") \u4e0d\u652f\u6301\uff01");
        }
        if (Util.isNullOrEmpty(verifyParam.getAlgorithm())) {
            log.error(new StringBuffer(uuid).append("\u7b97\u6cd5\u4e0d\u80fd\u4e3a\u7a7a").append("\r\n"));
            throw new Exception("\u7b97\u6cd5\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }

    private static void checkVerifyParamXML(VerifyParameterObject verifyParam, String uuid) throws Exception {
        if (Util.isNullOrEmpty(verifyParam.getSignatureLable())) {
            log.error(new StringBuffer(uuid).append("XML\u7b7e\u540d\u4e32\u7684\u7b7e\u540d\u6807\u7b7e\u4e0d\u80fd\u4e3a\u7a7a").append("\r\n"));
            throw new Exception("XML\u7b7e\u540d\u4e32\u7684\u7b7e\u540d\u6807\u7b7e\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }

    private static void checkVerifyParamFile(VerifyParameterObject verifyParam, String uuid) throws Exception {
        if (Util.isNullOrEmpty(verifyParam.getCheckFilePath())) {
            log.error(new StringBuffer(uuid).append("\u6587\u4ef6\u8def\u5f84\u4e0d\u80fd\u4e3a\u7a7a").append("\r\n"));
            throw new Exception("\u6587\u4ef6\u8def\u5f84\u4e0d\u80fd\u4e3a\u7a7a");
        }
        File file = new File(verifyParam.getCheckFilePath());
        if (!file.exists()) {
            log.error(new StringBuffer(uuid).append("\u6587\u4ef6\u4e0d\u5b58\u5728\uff0c\u6587\u4ef6\u8def\u5f84\u4e3a\uff1a").append(verifyParam.getCheckFilePath()).append("\r\n"));
            throw new Exception("\u6587\u4ef6\u4e0d\u5b58\u5728");
        }
        if (Util.isNullOrEmpty(verifyParam.getAlgorithm())) {
            log.error(new StringBuffer(uuid).append("\u7b7e\u540d\u7b97\u6cd5\u4e0d\u80fd\u4e3a\u7a7a").append("\r\n"));
            throw new Exception("\u7b7e\u540d\u7b97\u6cd5\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }

    private static void checkVerifyParamURL(VerifyParameterObject verifyParam, String uuid) throws Exception {
        MerchantSignTool.checkVerifyParamCommon(verifyParam, uuid);
        if (Util.isNullOrEmpty(verifyParam.getSignCharset())) {
            log.error(new StringBuffer(uuid).append("\u7b7e\u540d\u4e32\u4f7f\u7528\u7684\u5b57\u7b26\u96c6\u4e0d\u80fd\u4e3a\u7a7a").append("\r\n"));
            throw new Exception("\u7b7e\u540d\u4e32\u4f7f\u7528\u7684\u5b57\u7b26\u96c6\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }

    private static String convertAlgorithm(int type, String algorithm) {
        if (type == 1 || type == 2) {
            if ("DSAwithSHA1".equals(algorithm)) {
                return "http://www.w3.org/2000/09/xmldsig#dsa-sha1";
            }
            if ("RSAwithSHA1".equals(algorithm)) {
                return "http://www.w3.org/2000/09/xmldsig#rsa-sha1";
            }
            if ("HMAC-SHA1".equals(algorithm)) {
                return "http://www.w3.org/2000/09/xmldsig#hmac-sha1";
            }
        }
        return algorithm;
    }
}

