/*
 * Decompiled with CFR 0.152.
 */
package com.csii.payment.client.core;

import com.csii.payment.client.core.MerchantSignTool;
import com.csii.payment.client.entity.SignParameterObject;
import com.csii.payment.client.entity.VerifyParameterObject;
import com.csii.payment.client.util.Log;

public class MerchantXmlSignVerify {
    private static Log log = new Log(MerchantXmlSignVerify.class);

    public static String merchantSignXmlData_ABA(String plain, String transId) {
        log.info(new StringBuffer("\r\n").append("\u5546\u6237\u4e0a\u9001\u4ea4\u6613\u7801\uff1a").append(transId).append("\r\n").append("\u5546\u6237\u4e0a\u9001\u5f85\u7b7e\u540d\u660e\u6587\uff1a").append(plain).append("\r\n"));
        SignParameterObject signParam = new SignParameterObject();
        signParam.setPlain(plain);
        signParam.setTransId(transId);
        signParam.setCharset("UTF-8");
        signParam.setType(2);
        signParam.setAlgorithm("RSAwithSHA1");
        try {
            return MerchantSignTool.sign(signParam);
        }
        catch (Exception e) {
            log.error("XML\u62a5\u6587\u7b7e\u540d\u5931\u8d25\uff01\r\n", e);
            return null;
        }
    }

    public static String merchantSignXmlData_ABA(String plain, String transId, String merchantId) {
        log.info(new StringBuffer("\r\n").append("\u5546\u6237\u4e0a\u9001\u5546\u6237\u53f7\uff1a").append(merchantId).append("\r\n").append("\u5546\u6237\u4e0a\u9001\u4ea4\u6613\u7801\uff1a").append(transId).append("\r\n").append("\u5546\u6237\u4e0a\u9001\u5f85\u7b7e\u540d\u660e\u6587\uff1a").append(plain).append("\r\n"));
        SignParameterObject signParam = new SignParameterObject();
        signParam.setMerchantId(merchantId);
        signParam.setPlain(plain);
        signParam.setTransId(transId);
        signParam.setCharset("UTF-8");
        signParam.setType(2);
        signParam.setAlgorithm("RSAwithSHA1");
        try {
            return MerchantSignTool.sign(signParam);
        }
        catch (Exception e) {
            log.error("XML\u62a5\u6587\u7b7e\u540d\u5931\u8d25\uff01\r\n", e);
            return null;
        }
    }

    public static boolean merchantVerifyXmlData_ABA(String sign) {
        log.info(new StringBuffer("\r\n").append("\u5546\u6237\u4e0a\u9001\u7b7e\u540d\u4e32\uff1a").append(sign).append("\r\n"));
        VerifyParameterObject verifyParam = new VerifyParameterObject();
        verifyParam.setSign(sign);
        verifyParam.setType(2);
        verifyParam.setSignatureLable("ds:Signature");
        try {
            return MerchantSignTool.verify(verifyParam);
        }
        catch (Exception e) {
            log.error("XML\u62a5\u6587\u9a8c\u7b7e\u5931\u8d25\uff01\r\n", e);
            return false;
        }
    }
}

