/*
 * Decompiled with CFR 0.152.
 */
package com.csii.payment.client.entity;

import com.csii.payment.client.util.Log;
import com.csii.payment.client.util.Util;
import java.io.FileInputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;

public class CebMerchantProperties {
    private static String development;
    private static String cafile;
    private static String trustKeyStore;
    private static String storePassword;
    private static String keyAlias;
    private static String merchantPrivateKeyCNName;
    private static String merchantIdCNName;
    private static String keyPassword;
    private static String paygateAlias;
    private static String paygatePublicKeyCNName;
    private static String provider;
    private static String log4jFilePath;
    private static String SSLVersion;
    private static Log log;
    private static Map CNNameAndPasswordMap;
    private static Map merchantIdAndCNNameMap;
    private static String[] cafiles;

    static {
        SSLVersion = "SSL";
        log = new Log(CebMerchantProperties.class);
        CNNameAndPasswordMap = new HashMap();
        merchantIdAndCNNameMap = new HashMap();
        FileInputStream fis = null;
        try {
            try {
                String merchantPropertiesPath = System.getProperty("guangda.merchant.parameter.file.path");
                if (Util.isNullOrEmpty(merchantPropertiesPath)) {
                    merchantPropertiesPath = String.valueOf(Util.getClassPath()) + "/" + "ceb_merchant.properties";
                } else if (merchantPropertiesPath.startsWith("classPath:")) {
                    String path = merchantPropertiesPath.substring("classPath:".length());
                    merchantPropertiesPath = String.valueOf(Util.getClassPath()) + "/" + path;
                }
                log.info("\u5546\u6237\u914d\u7f6e\u6587\u4ef6\u8def\u5f84\uff1a" + merchantPropertiesPath);
                fis = new FileInputStream(merchantPropertiesPath);
                Properties properties = new Properties();
                properties.load(fis);
                CebMerchantProperties.init(properties);
                if (CebMerchantProperties.isNewMerchantPropertiesFile()) {
                    CebMerchantProperties.verifyPropertiesColumn(properties);
                    cafiles = CebMerchantProperties.getBranceContantSplitComma(cafile);
                    CebMerchantProperties.innerCNNameAndPasswordMap();
                    CebMerchantProperties.innerMerchantIdAndCNNameMap();
                }
                log.info(CebMerchantProperties.getMerchantSetInfo());
                if (!Util.isNullOrEmpty(development) && development.equalsIgnoreCase("yes")) {
                    System.setProperty("javax.net.debug", "all");
                }
            }
            catch (Exception e) {
                log.error("\u52a0\u8f7d\u5546\u6237\u914d\u7f6e\u6587\u4ef6\u5931\u8d25\uff01\r\n", e);
                throw new RuntimeException(e);
            }
        }
        catch (Throwable throwable) {
            Util.closeStream(fis);
            throw throwable;
        }
        Util.closeStream(fis);
    }

    private static void verifyPropertiesColumn(Properties properties) {
        if (Util.isNullOrEmpty(cafile)) {
            throw new RuntimeException("\u5546\u6237\u914d\u7f6e\u6587\u4ef6\u4e2d\uff0c\u5bb9\u5668\u8def\u5f84\u503c\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (Util.isNullOrEmpty(trustKeyStore)) {
            throw new RuntimeException("\u5546\u6237\u914d\u7f6e\u6587\u4ef6\u4e2d\uff0c\u53d7\u4fe1\u4efb\u8bc1\u4e66\u5bb9\u5668\u8def\u5f84\u503c\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (Util.isNullOrEmpty(merchantPrivateKeyCNName)) {
            throw new RuntimeException("\u5546\u6237\u914d\u7f6e\u6587\u4ef6\u4e2d\uff0c\u5546\u6237CNName \u4e0e   \u79c1\u94a5\u5bc6\u7801\u6620\u5c04\u503c\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (Util.isNullOrEmpty(merchantIdCNName)) {
            throw new RuntimeException("\u5546\u6237\u914d\u7f6e\u6587\u4ef6\u4e2d\uff0c\u5546\u6237\u5546\u6237\u53f7  \u4e0e  CNName\u6620\u5c04\u503c\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (Util.isNullOrEmpty(paygatePublicKeyCNName)) {
            throw new RuntimeException("\u5546\u6237\u914d\u7f6e\u6587\u4ef6\u4e2d\uff0c\u5149\u5927\u94f6\u884c\u7f51\u5173\u516c\u94a5CNName\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        String[] cafiles = CebMerchantProperties.getBranceContantSplitComma(cafile);
        if (cafiles == null || cafiles.length == 0) {
            throw new RuntimeException("\u5546\u6237\u914d\u7f6e\u6587\u4ef6\u4e2d\uff0c\u5bb9\u5668\u8def\u5f84\u503c\u7684\u683c\u5f0f\u4e0d\u6b63\u786e\uff01\u4f20\u5165\u7684\u503c\u4e3a\uff1a" + cafile);
        }
        int i = 0;
        while (i < cafiles.length) {
            String signleCafile = cafiles[i];
            if (Util.isNullOrEmpty(signleCafile) || signleCafile.split("[~][|][~]").length != 3) {
                log.info(new StringBuffer().append("\u5355\u4e2a\u5bb9\u5668\u7684\u8def\u5f84\u4e3a\uff1a").append(signleCafile));
                throw new RuntimeException("\u5546\u6237\u914d\u7f6e\u6587\u4ef6\u4e2d\uff0c\u5bb9\u5668\u8def\u5f84\u503c\u7684\u683c\u5f0f\u4e0d\u6b63\u786e\uff01\u4f20\u5165\u7684\u503c\u4e3a\uff1a" + cafile);
            }
            ++i;
        }
        String[] merchantPrivateKeyCNNames = CebMerchantProperties.getBranceContantSplitComma(merchantPrivateKeyCNName);
        if (merchantPrivateKeyCNNames == null || merchantPrivateKeyCNNames.length == 0) {
            throw new RuntimeException("\u5546\u6237\u914d\u7f6e\u6587\u4ef6\u4e2d\uff0cCNName \u4e0e   \u79c1\u94a5\u5bc6\u7801\u6620\u5c04\u7684\u683c\u5f0f\u4e0d\u6b63\u786e\uff01\u4f20\u5165\u7684\u503c\u4e3a\uff1a" + merchantPrivateKeyCNName);
        }
        int i2 = 0;
        while (i2 < merchantPrivateKeyCNNames.length) {
            String signle = merchantPrivateKeyCNNames[i2];
            if (Util.isNullOrEmpty(signle) || signle.split("[~][|][~]").length != 2) {
                log.info(new StringBuffer().append("\u5355\u4e2aCNName \u4e0e   \u79c1\u94a5\u5bc6\u7801\u6620\u5c04\u4e3a\uff1a").append(signle));
                throw new RuntimeException("\u5546\u6237\u914d\u7f6e\u6587\u4ef6\u4e2d\uff0cCNName \u4e0e   \u79c1\u94a5\u5bc6\u7801\u6620\u5c04\u7684\u683c\u5f0f\u4e0d\u6b63\u786e\uff01\u4f20\u5165\u7684\u503c\u4e3a\uff1a" + merchantPrivateKeyCNName);
            }
            ++i2;
        }
        String[] merchantIdCNNames = CebMerchantProperties.getBranceContantSplitComma(merchantIdCNName);
        if (merchantIdCNNames == null || merchantIdCNNames.length == 0) {
            throw new RuntimeException("\u5546\u6237\u914d\u7f6e\u6587\u4ef6\u4e2d\uff0c\u5546\u6237\u53f7  \u4e0e  CNName\u6620\u5c04\u7684\u683c\u5f0f\u4e0d\u6b63\u786e\uff01\u4f20\u5165\u7684\u503c\u4e3a\uff1a" + merchantIdCNName);
        }
        int i3 = 0;
        while (i3 < merchantIdCNNames.length) {
            String signle = merchantIdCNNames[i3];
            if (Util.isNullOrEmpty(signle) || signle.split("[~][|][~]").length != 2) {
                log.info(new StringBuffer().append("\u5355\u4e2a\u5546\u6237\u53f7  \u4e0e  CNName\u6620\u5c04\u4e3a\uff1a").append(signle));
                throw new RuntimeException("\u5546\u6237\u914d\u7f6e\u6587\u4ef6\u4e2d\uff0c\u5546\u6237\u53f7  \u4e0e  CNName\u6620\u5c04\u7684\u683c\u5f0f\u4e0d\u6b63\u786e\uff01\u4f20\u5165\u7684\u503c\u4e3a\uff1a" + merchantIdCNName);
            }
            ++i3;
        }
    }

    private static void init(Properties properties) {
        development = Util.covertPropertiesValue(properties.getProperty("development"));
        cafile = Util.covertPropertiesValue(properties.getProperty("cafile"));
        trustKeyStore = Util.covertPropertiesValue(properties.getProperty("trustKeyStore"));
        storePassword = Util.covertPropertiesValue(properties.getProperty("store_password"));
        keyAlias = Util.covertPropertiesValue(properties.getProperty("key_alias"));
        merchantPrivateKeyCNName = Util.covertPropertiesValue(properties.getProperty("merchantPrivateKeyCNName"));
        merchantIdCNName = Util.covertPropertiesValue(properties.getProperty("merchantIdCNName"));
        keyPassword = Util.covertPropertiesValue(properties.getProperty("key_password"));
        paygateAlias = Util.covertPropertiesValue(properties.getProperty("alias_paygate"));
        paygatePublicKeyCNName = Util.covertPropertiesValue(properties.getProperty("paygatePublicKeyCNName"));
        provider = Util.covertPropertiesValue(properties.getProperty("provider"));
        log4jFilePath = Util.covertPropertiesValue(properties.getProperty("log4jFilePath"));
        String tmpSSL = Util.covertPropertiesValue(properties.getProperty("SSLVersion"));
        SSLVersion = Util.isNullOrEmpty(tmpSSL) ? SSLVersion : tmpSSL;
    }

    private static String getMerchantSetInfo() {
        return "\r\n" + CebMerchantProperties.format("\u5f00\u53d1\u8005\u6a21\u5f0f", "\u3010development\u3011") + development + "\r\n" + CebMerchantProperties.format("\u5bb9\u5668\u8def\u5f84", "\u3010cafile\u3011") + CebMerchantProperties.assembleCafile() + "\r\n" + CebMerchantProperties.format("\u53d7\u4fe1\u4efb\u8bc1\u4e66\u5e93", "\u3010trustKeyStore\u3011") + CebMerchantProperties.assembleTrustKeyStorePath() + "\r\n" + CebMerchantProperties.format("\u5546\u6237\u79c1\u94a5\u522b\u540d", "\u3010keyAlias\u3011") + keyAlias + "\r\n" + CebMerchantProperties.format("\u7f51\u5173\u8bc1\u4e66\u516c\u94a5\u522b\u540d", "\u3010paygateAlias\u3011") + paygateAlias + "\r\n" + CebMerchantProperties.format("\u7b97\u6cd5\u63d0\u4f9b\u8005", "\u3010provider\u3011") + provider + "\r\n" + CebMerchantProperties.format("\u65e5\u5fd7\u914d\u7f6e\u6587\u4ef6\u8def\u5f84", "\u3010log4jFilePath\u3011") + log4jFilePath + "\r\n" + CebMerchantProperties.format("SSL/TLS\u534f\u8bae\u7248\u672c", "\u3010SSLVersion\u3011") + SSLVersion + "\r\n" + CebMerchantProperties.format("\u7f51\u5173\u516c\u94a5CNName", "\u3010paygatePublicKeyCNName\u3011") + paygatePublicKeyCNName + "\r\n" + CebMerchantProperties.format("\u5546\u6237\u53f7\u4e0e\u5546\u6237\u79c1\u94a5CNName\u6620\u5c04", "\u3010merchantIdCNName\u3011") + merchantIdCNName + "\r\n" + CebMerchantProperties.format("\u5546\u6237\u79c1\u94a5CNName\u4e0e\u79c1\u94a5\u5bc6\u7801\u7684\u6620\u5c04", "\u3010merchantPrivateKeyCNName\u3011") + merchantPrivateKeyCNName + "\r\n";
    }

    private static String assembleCafile() {
        if (!CebMerchantProperties.isNewMerchantPropertiesFile()) {
            return cafile;
        }
        StringBuffer cafilesTmp = new StringBuffer();
        cafilesTmp.append("{");
        if (!Util.isNullOrEmpty(cafiles)) {
            int i = 0;
            while (i < cafiles.length) {
                String tmpCafile = cafiles[0];
                cafilesTmp.append(tmpCafile.split("[~][|][~]")[0]);
                if (i != cafiles.length - 1) {
                    cafilesTmp.append(",");
                }
                ++i;
            }
        } else {
            cafilesTmp.append(cafile);
        }
        cafilesTmp.append("}");
        return cafilesTmp.toString();
    }

    private static String assembleTrustKeyStorePath() {
        if (CebMerchantProperties.isNewMerchantPropertiesFile() && !Util.isNullOrEmpty(trustKeyStore)) {
            return trustKeyStore.split("[~][|][~]")[0];
        }
        return trustKeyStore;
    }

    private static String format(String chinese, String english) {
        try {
            return new StringBuffer().append(Util.formatCharsequence(chinese, "GBK", 30, " ")).append(Util.formatCharsequence(english, "GBK", 30, " ")).append("----->").toString();
        }
        catch (Exception e) {
            log.error("", e);
            return "";
        }
    }

    public static boolean isNewMerchantPropertiesFile() {
        return Util.isNullOrEmpty(development) || Util.isNullOrEmpty(storePassword) || Util.isNullOrEmpty(keyAlias) || Util.isNullOrEmpty(keyPassword) || Util.isNullOrEmpty(paygateAlias);
    }

    private static void innerCNNameAndPasswordMap() {
        String[] CNNames = CebMerchantProperties.getBranceContantSplitComma(merchantPrivateKeyCNName);
        int i = 0;
        while (i < CNNames.length) {
            String[] CNName = CNNames[i].split("[~][|][~]");
            CNNameAndPasswordMap.put(CNName[0], CNName[1]);
            ++i;
        }
    }

    private static void innerMerchantIdAndCNNameMap() {
        String[] CNNames = CebMerchantProperties.getBranceContantSplitComma(merchantIdCNName);
        int i = 0;
        while (i < CNNames.length) {
            String[] CNName = CNNames[i].split("[~][|][~]");
            merchantIdAndCNNameMap.put(CNName[0], CNName[1]);
            ++i;
        }
    }

    private static String[] getBranceContantSplitComma(String contant) {
        int leftBrace = contant.indexOf("{");
        int rightBrace = contant.lastIndexOf("}");
        if (leftBrace > -1 && rightBrace > -1) {
            return contant.substring(leftBrace + 1, rightBrace).split(",");
        }
        return null;
    }

    public static String getCafile() {
        return cafile;
    }

    public static String getTrustKeyStore() {
        return trustKeyStore;
    }

    public static String getStorePassword() {
        return storePassword;
    }

    public static String getKeyAlias() {
        return keyAlias;
    }

    public static String getMerchantPrivateKeyCNName() {
        return merchantPrivateKeyCNName;
    }

    public static String getKeyPassword() {
        return keyPassword;
    }

    public static String getPaygateAlias() {
        return paygateAlias;
    }

    public static String getPaygatePublicKeyCNName() {
        return paygatePublicKeyCNName;
    }

    public static String getProvider() {
        return provider;
    }

    public static String getLog4jFilePath() {
        return log4jFilePath;
    }

    public static String getDevelopment() {
        return development;
    }

    public static String[] getCafiles() {
        return cafiles;
    }

    public static Map getCNNameAndPasswordMap() {
        return CNNameAndPasswordMap;
    }

    public static Map getMerchantIdAndCNNameMap() {
        return merchantIdAndCNNameMap;
    }

    public static String getMerchantIdCNName() {
        return merchantIdCNName;
    }

    public static String getSSLVersion() {
        return SSLVersion;
    }
}

