/*
 * Decompiled with CFR 0.152.
 */
package com.csii.payment.client.http;

import com.csii.payment.client.entity.CebMerchantProperties;
import com.csii.payment.client.entity.RequestParameterObject;
import com.csii.payment.client.key.KeyManager;
import com.csii.payment.client.util.Log;
import com.csii.payment.client.util.Util;
import java.io.BufferedInputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URLConnection;
import java.util.Map;
import javax.net.ssl.HttpsURLConnection;

public class HttpUtil {
    private static Log log = new Log(HttpUtil.class);

    public static byte[] sendHost(RequestParameterObject requestParam) throws Exception {
        try {
            String uuid = new StringBuffer("\u3010").append(Util.getUUID()).append("\u3011   ").toString();
            log.info(new StringBuffer(uuid).append(requestParam));
            HttpUtil.checkParam(requestParam);
            if (Util.isNullOrEmpty(requestParam.getRequestData())) {
                requestParam.setRequestData("");
            }
            if ("https".equalsIgnoreCase(requestParam.getProtocal())) {
                byte[] result = HttpUtil.innerSendHostUseHTTPS(requestParam);
                log.info(new StringBuffer(uuid).append("\u8fd4\u56de\u54cd\u5e94\uff1a\r\n").append(new String(result, requestParam.getResponseCharset())));
                return result;
            }
            if ("http".equalsIgnoreCase(requestParam.getProtocal())) {
                byte[] result = HttpUtil.innerSendHostUseHTTP(requestParam);
                log.info(new StringBuffer(uuid).append("\u8fd4\u56de\u54cd\u5e94\uff1a\r\n").append(new String(result, requestParam.getResponseCharset())));
                return result;
            }
            throw new Exception("\u6682\u4e0d\u652f\u6301\u7684\u901a\u8baf\u534f\u8bae\u3010" + requestParam.getProtocal() + "\u3011\uff01");
        }
        catch (Exception e) {
            log.error("", e);
            throw e;
        }
    }

    private static byte[] innerSendHostUseHTTPS(RequestParameterObject requestParam) throws Exception {
        byte[] byArray;
        HttpsURLConnection urlConn = null;
        if (Util.isNullOrEmpty(requestParam.getProxy())) {
            urlConn = (HttpsURLConnection)requestParam.getUrl().openConnection();
        } else {
            String hostname = requestParam.getProxy().split(":")[0];
            String port = requestParam.getProxy().split(":")[1];
            urlConn = (HttpsURLConnection)requestParam.getUrl().openConnection(Util.getProxy(hostname, port));
        }
        urlConn.setDoInput(true);
        urlConn.setDoOutput(true);
        urlConn.setSSLSocketFactory(KeyManager.getSSLSocketFactory(requestParam.isVerifyFlag(), CebMerchantProperties.getSSLVersion()));
        urlConn.setHostnameVerifier(KeyManager.getHostnameVerifier(requestParam.isVerifyFlag(), requestParam.getRequestURL(), requestParam.getDomain()));
        urlConn.setRequestMethod("POST");
        HttpUtil.setHeader(urlConn, requestParam.getRequestHeaderMap());
        HttpUtil.setTimeout(urlConn, requestParam);
        urlConn.connect();
        OutputStream os = null;
        BufferedInputStream bis = null;
        try {
            os = urlConn.getOutputStream();
            os.write(requestParam.getRequestData().getBytes(requestParam.getRequestCharset()));
            os.flush();
            os.close();
            bis = new BufferedInputStream(urlConn.getInputStream());
            byArray = Util.convertInputStreamToByteArray(bis);
        }
        catch (Throwable throwable) {
            Util.closeStream(os);
            Util.closeStream(bis);
            if (urlConn != null) {
                urlConn.disconnect();
            }
            throw throwable;
        }
        Util.closeStream(os);
        Util.closeStream(bis);
        if (urlConn != null) {
            urlConn.disconnect();
        }
        return byArray;
    }

    private static byte[] innerSendHostUseHTTP(RequestParameterObject requestParam) throws Exception {
        byte[] byArray;
        HttpURLConnection urlConn = null;
        urlConn = (HttpURLConnection)requestParam.getUrl().openConnection();
        urlConn.setDoInput(true);
        urlConn.setDoOutput(true);
        urlConn.setRequestMethod("POST");
        HttpUtil.setHeader(urlConn, requestParam.getRequestHeaderMap());
        HttpUtil.setTimeout(urlConn, requestParam);
        urlConn.connect();
        OutputStream os = null;
        BufferedInputStream bis = null;
        try {
            os = urlConn.getOutputStream();
            os.write(requestParam.getRequestData().getBytes(requestParam.getRequestCharset()));
            os.flush();
            os.close();
            bis = new BufferedInputStream(urlConn.getInputStream());
            byArray = Util.convertInputStreamToByteArray(bis);
        }
        catch (Throwable throwable) {
            Util.closeStream(os);
            Util.closeStream(bis);
            if (urlConn != null) {
                urlConn.disconnect();
            }
            throw throwable;
        }
        Util.closeStream(os);
        Util.closeStream(bis);
        if (urlConn != null) {
            urlConn.disconnect();
        }
        return byArray;
    }

    private static void setHeader(HttpURLConnection urlConn, Map requestHeaderMap) {
        if (!Util.isNullOrEmpty(requestHeaderMap)) {
            for (String key : requestHeaderMap.keySet()) {
                urlConn.addRequestProperty(key, (String)requestHeaderMap.get(key));
            }
        }
    }

    private static void setTimeout(URLConnection urlConn, RequestParameterObject requestParam) {
        if (!Util.isNullOrEmpty(requestParam.getConnectTimeout())) {
            urlConn.setConnectTimeout(Integer.parseInt(requestParam.getConnectTimeout()));
        } else {
            urlConn.setConnectTimeout(30000);
        }
        if (!Util.isNullOrEmpty(requestParam.getSocketTimeout())) {
            urlConn.setReadTimeout(Integer.parseInt(requestParam.getSocketTimeout()));
        } else {
            urlConn.setReadTimeout(30000);
        }
    }

    private static void checkParam(RequestParameterObject requestParam) throws Exception {
        if (Util.isNullOrEmpty(requestParam.getRequestURL())) {
            throw new Exception("\u8bf7\u6c42\u5730\u5740\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
    }
}

