/*
 * Decompiled with CFR 0.152.
 */
package com.csii.payment.client.key;

import com.csii.payment.client.entity.CebMerchantProperties;
import com.csii.payment.client.entity.CertificateInfo;
import com.csii.payment.client.entity.MerchantKeyInfo;
import com.csii.payment.client.key.MyHostnameVerifier;
import com.csii.payment.client.key.MyX509TrustManagerWithoutVerify;
import com.csii.payment.client.util.Log;
import com.csii.payment.client.util.Util;
import java.security.KeyStore;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.PublicKey;
import java.security.Security;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import org.bouncycastle.jce.provider.BouncyCastleProvider;

public class KeyManager {
    private static Log log = new Log(KeyManager.class);
    private static Map merchentKeyInfoMapKeyIsCN = new HashMap();
    private static Map certificateInfoMapKeyIsCN = new HashMap();
    private static Map merchantKeyInfoMapKeyIsAlias = new HashMap();
    private static Map certificateInfoMapKeyIsAlias = new HashMap();
    private static javax.net.ssl.KeyManager[] keyManagers = new javax.net.ssl.KeyManager[0];
    private static TrustManager[] trustManagers = new TrustManager[0];
    private static TrustManager[] trustManagersWithoutVerify = new TrustManager[]{new MyX509TrustManagerWithoutVerify()};

    static {
        try {
            if (CebMerchantProperties.isNewMerchantPropertiesFile()) {
                KeyManager.initJKSInfoUseNewMerchantProperties();
            } else {
                KeyManager.initJKSInfoUseOldMerchantProperties();
            }
            if ("BC".equals(CebMerchantProperties.getProvider())) {
                Security.addProvider((Provider)new BouncyCastleProvider());
            }
        }
        catch (Exception e) {
            log.error("\u52a0\u8f7d\u5bb9\u5668\u5931\u8d25\uff01\r\n", e);
            throw new RuntimeException(e);
        }
    }

    private static void initJKSInfoUseNewMerchantProperties() throws Exception {
        KeyManager.initMerchantJKS();
        KeyManager.initTrustKeyStoreJKS();
    }

    private static void initTrustKeyStoreJKS() throws Exception {
        KeyStore keyStore = KeyManager.getKeyStore(CebMerchantProperties.getTrustKeyStore());
        KeyManager.initMerchantKeyORCertificateInfoMap(keyStore);
        KeyManager.setTrustManager(keyStore);
    }

    private static void initMerchantJKS() throws Exception {
        String[] cafiles = CebMerchantProperties.getCafiles();
        int i = 0;
        while (i < cafiles.length) {
            KeyStore keyStore = KeyManager.getKeyStore(cafiles[i]);
            KeyManager.initMerchantKeyORCertificateInfoMap(keyStore);
            ++i;
        }
    }

    private static KeyStore getKeyStore(String storePath) throws Exception {
        String[] keystoreParam = storePath.trim().split("[~][|][~]");
        String containPath = keystoreParam[0];
        String containPassword = keystoreParam[1];
        String containType = keystoreParam[2];
        if (containPath.startsWith("classPath:")) {
            String path = containPath.substring("classPath:".length());
            containPath = String.valueOf(Util.getClassPath()) + "/" + path;
        }
        return Util.getKeyStore(containType, containPath, containPassword);
    }

    private static void initJKSInfoUseOldMerchantProperties() throws Exception {
        KeyStore keyStore = Util.getKeyStore("JKS", CebMerchantProperties.getCafile().trim(), CebMerchantProperties.getStorePassword());
        KeyManager.initMerchantKeyORCertificateInfoMap(keyStore);
        KeyManager.setTrustManager(keyStore);
    }

    private static void initMerchantKeyORCertificateInfoMap(KeyStore keyStore) throws Exception {
        Map CNNamePasswordMap = CebMerchantProperties.getCNNameAndPasswordMap();
        Enumeration<String> aliases = keyStore.aliases();
        while (aliases.hasMoreElements()) {
            String alias = aliases.nextElement();
            if (keyStore.isKeyEntry(alias)) {
                MerchantKeyInfo merchantKeyInfo = (MerchantKeyInfo)KeyManager.getCertificateInfo(keyStore, alias);
                merchantKeyInfo.setCertificateChain(keyStore.getCertificateChain(alias));
                merchantKeyInfo.setKeyType(1);
                if (CebMerchantProperties.isNewMerchantPropertiesFile()) {
                    String CNNamePassword = (String)CNNamePasswordMap.get(merchantKeyInfo.getCNName());
                    if (Util.isNullOrEmpty(CNNamePassword)) {
                        log.warn(new StringBuffer("CN\u4e3a\uff1a\u3010").append(merchantKeyInfo.getCNName()).append("\u3011\u7684\u5bc6\u94a5\u6ca1\u6709\u5728\u5546\u6237\u914d\u7f6e\u6587\u4ef6\u4e2d\u7ef4\u62a4").toString());
                    } else {
                        PrivateKey privateKey = KeyManager.innerGetPrivateKey(keyStore, alias, CNNamePassword);
                        merchantKeyInfo.setPrivateKey(privateKey);
                        KeyManager.setKeyManager(keyStore, CNNamePassword);
                    }
                } else {
                    PrivateKey privateKey = KeyManager.innerGetPrivateKey(keyStore, alias, CebMerchantProperties.getKeyPassword());
                    merchantKeyInfo.setPrivateKey(privateKey);
                    KeyManager.setKeyManager(keyStore, CebMerchantProperties.getKeyPassword());
                }
                KeyManager.putMerchantKeyInfoToMap(merchantKeyInfo);
                continue;
            }
            if (!keyStore.isCertificateEntry(alias)) continue;
            CertificateInfo certificateInfo = KeyManager.getCertificateInfo(keyStore, alias);
            certificateInfo.setKeyType(2);
            KeyManager.putCertificateInfoToMap(certificateInfo);
        }
    }

    private static void putMerchantKeyInfoToMap(MerchantKeyInfo merchantKeyInfo) {
        X509Certificate cert;
        String CNName = merchantKeyInfo.getCNName();
        String alias = merchantKeyInfo.getAlias();
        if (merchentKeyInfoMapKeyIsCN.get(CNName) == null) {
            merchentKeyInfoMapKeyIsCN.put(CNName, merchantKeyInfo);
        } else {
            cert = (X509Certificate)merchantKeyInfo.getCertificate();
            try {
                cert.checkValidity();
                log.warn(new StringBuffer().append("\u5bb9\u5668\u4e2d\u5b58\u5728\u540cCN\u7684\u79c1\u94a5\uff0cCN\u4e3a\uff1a\u3010").append(CNName).append("\u3011\uff0c\u8fdb\u884c\u8986\u76d6\u64cd\u4f5c\uff01"));
                merchentKeyInfoMapKeyIsCN.put(CNName, merchantKeyInfo);
            }
            catch (Exception e) {
                log.error(new StringBuffer().append("\u5bb9\u5668\u4e2d\u5b58\u5728\u540cCN\u7684\u79c1\u94a5\uff0cCN\u4e3a\uff1a\u3010").append(CNName).append("\u3011\uff0c\u5f85\u8986\u76d6\u79c1\u94a5\u4e0d\u662f\u6709\u6548\u7684\uff0c\u4e0d\u8fdb\u884c\u8986\u76d6\u64cd\u4f5c\uff01"));
            }
        }
        if (merchantKeyInfoMapKeyIsAlias.get(alias) == null) {
            merchantKeyInfoMapKeyIsAlias.put(alias, merchantKeyInfo);
        } else {
            cert = (X509Certificate)merchantKeyInfo.getCertificate();
            try {
                cert.checkValidity();
                log.warn(new StringBuffer().append("\u5bb9\u5668\u4e2d\u5b58\u5728\u540c\u522b\u540d\u7684\u79c1\u94a5\uff0c\u522b\u540d\u4e3a\uff1a\u3010").append(alias).append("\u3011\uff0c\u8fdb\u884c\u8986\u76d6\u64cd\u4f5c\uff01"));
                merchantKeyInfoMapKeyIsAlias.put(alias, merchantKeyInfo);
            }
            catch (Exception e) {
                log.error(new StringBuffer().append("\u5bb9\u5668\u4e2d\u5b58\u5728\u540c\u522b\u540d\u7684\u79c1\u94a5\uff0c\u522b\u540d\u4e3a\uff1a\u3010").append(alias).append("\u3011\uff0c\u5f85\u8986\u76d6\u79c1\u94a5\u4e0d\u662f\u6709\u6548\u7684\uff0c\u4e0d\u8fdb\u884c\u8986\u76d6\u64cd\u4f5c\uff01"));
            }
        }
    }

    private static void putCertificateInfoToMap(CertificateInfo certificateInfo) {
        X509Certificate cert;
        String CNName = certificateInfo.getCNName();
        String alias = certificateInfo.getAlias();
        if (certificateInfoMapKeyIsCN.get(CNName) == null) {
            certificateInfoMapKeyIsCN.put(CNName, certificateInfo);
        } else {
            cert = (X509Certificate)certificateInfo.getCertificate();
            try {
                cert.checkValidity();
                log.warn(new StringBuffer().append("\u5bb9\u5668\u4e2d\u5b58\u5728\u540cCN\u7684\u516c\u94a5\uff0cCN\u4e3a\uff1a\u3010").append(CNName).append("\u3011\uff0c\u8fdb\u884c\u8986\u76d6\u64cd\u4f5c\uff01"));
                certificateInfoMapKeyIsCN.put(CNName, certificateInfo);
            }
            catch (Exception e) {
                log.error(new StringBuffer().append("\u5bb9\u5668\u4e2d\u5b58\u5728\u540cCN\u7684\u516c\u94a5\uff0cCN\u4e3a\uff1a\u3010").append(CNName).append("\u3011\uff0c\u5f85\u8986\u76d6\u516c\u94a5\u4e0d\u662f\u6709\u6548\u7684\uff0c\u4e0d\u8fdb\u884c\u8986\u76d6\u64cd\u4f5c\uff01"));
            }
        }
        if (certificateInfoMapKeyIsAlias.get(alias) == null) {
            certificateInfoMapKeyIsAlias.put(alias, certificateInfo);
        } else {
            cert = (X509Certificate)certificateInfo.getCertificate();
            try {
                cert.checkValidity();
                log.warn(new StringBuffer().append("\u5bb9\u5668\u4e2d\u5b58\u5728\u540c\u522b\u540d\u7684\u516c\u94a5\uff0c\u522b\u540d\u4e3a\uff1a\u3010").append(alias).append("\u3011\uff0c\u8fdb\u884c\u8986\u76d6\u64cd\u4f5c\uff01"));
                certificateInfoMapKeyIsAlias.put(alias, certificateInfo);
            }
            catch (Exception e) {
                log.error(new StringBuffer().append("\u5bb9\u5668\u4e2d\u5b58\u5728\u540c\u522b\u540d\u7684\u516c\u94a5\uff0c\u522b\u540d\u4e3a\uff1a\u3010").append(alias).append("\u3011\uff0c\u5f85\u8986\u76d6\u516c\u94a5\u4e0d\u662f\u6709\u6548\u7684\uff0c\u4e0d\u8fdb\u884c\u8986\u76d6\u64cd\u4f5c\uff01"));
            }
        }
    }

    private static PrivateKey innerGetPrivateKey(KeyStore keyStore, String alias, String password) {
        try {
            return (PrivateKey)keyStore.getKey(alias, password.toCharArray());
        }
        catch (Exception e) {
            log.error("", e);
            return null;
        }
    }

    private static void setKeyManager(KeyStore keyStore, String password) throws Exception {
        KeyManagerFactory kmf = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
        kmf.init(keyStore, password.toCharArray());
        javax.net.ssl.KeyManager[] kms = kmf.getKeyManagers();
        javax.net.ssl.KeyManager[] keyManagersNew = new javax.net.ssl.KeyManager[kms.length + keyManagers.length];
        System.arraycopy(keyManagers, 0, keyManagersNew, 0, keyManagers.length);
        System.arraycopy(kms, 0, keyManagersNew, keyManagers.length, kms.length);
        keyManagers = keyManagersNew;
    }

    private static void setTrustManager(KeyStore keyStore) throws Exception {
        TrustManagerFactory tmf = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
        tmf.init(keyStore);
        trustManagers = tmf.getTrustManagers();
    }

    private static CertificateInfo getCertificateInfo(KeyStore keyStore, String alias) throws Exception {
        X509Certificate certificate = (X509Certificate)keyStore.getCertificate(alias);
        MerchantKeyInfo merchantKeyInfo = new MerchantKeyInfo();
        merchantKeyInfo.setAlias(alias);
        merchantKeyInfo.setCertificate(certificate);
        merchantKeyInfo.setPublicKey(certificate.getPublicKey());
        merchantKeyInfo.setSubject(certificate.getSubjectX500Principal().toString());
        merchantKeyInfo.setCNName(Util.getCNFromCertificate(certificate));
        log.debug(new StringBuffer().append("\u522b\u540d\u4e3a\uff1a\u3010").append(alias).append("\u3011\uff0cCN\u4e3a\uff1a\u3010").append(merchantKeyInfo.getCNName()).append("\u3011"));
        return merchantKeyInfo;
    }

    public static SSLSocketFactory getSSLSocketFactory(boolean verifyFlag, String sslProtocal) throws Exception {
        SSLContext sslContext = SSLContext.getInstance(sslProtocal);
        if (verifyFlag) {
            KeyManager.checkCertValidation(merchantKeyInfoMapKeyIsAlias);
            KeyManager.checkCertValidation(certificateInfoMapKeyIsAlias);
            sslContext.init(keyManagers, trustManagers, null);
        } else {
            sslContext.init(null, trustManagersWithoutVerify, null);
        }
        return sslContext.getSocketFactory();
    }

    private static void checkCertValidation(Map certInfoMapKeyIsAlias) {
        if (!Util.isNullOrEmpty(certInfoMapKeyIsAlias)) {
            for (String alias : certInfoMapKeyIsAlias.keySet()) {
                if (!(certInfoMapKeyIsAlias.get(alias) instanceof CertificateInfo)) continue;
                CertificateInfo certificateInfo = (CertificateInfo)certInfoMapKeyIsAlias.get(alias);
                X509Certificate cert = (X509Certificate)certificateInfo.getCertificate();
                try {
                    cert.checkValidity();
                }
                catch (Exception e) {
                    log.warn(new StringBuffer().append("Cert_Error_Info \u3010").append(e.getMessage()).append("\u3011").append(",\u8bc1\u4e66\u65e0\u6548(\u8fc7\u671f\u6216\u672a\u751f\u6548)\uff0c\u8bc1\u4e66\u522b\u540d\u4e3a\uff1a\u3010").append(alias).append("\u3011").append(",\u8bc1\u4e66CN\u4e3a\u3010").append(certificateInfo.getCNName()).append("\u3011").append(",\u8bc1\u4e66\u5f00\u59cb\u65e5\u671f\u3010").append(Util.formatDate(cert.getNotBefore(), "yyyy-MM-dd HH:mm:ss")).append("\u3011").append(",\u8bc1\u4e66\u7ed3\u675f\u65e5\u671f\u3010").append(Util.formatDate(cert.getNotAfter(), "yyyy-MM-dd HH:mm:ss")).append("\u3011").append("\r\n"));
                }
            }
        }
    }

    public static HostnameVerifier getHostnameVerifier(boolean verifyFlag, String url, String domain) {
        return new MyHostnameVerifier(verifyFlag, url, domain);
    }

    public static PrivateKey getPrivateKey(String ... args) throws Exception {
        switch (args.length) {
            case 0: {
                return KeyManager.getPrivateKeyByAlias(CebMerchantProperties.getKeyAlias());
            }
            case 1: {
                if (!CebMerchantProperties.isNewMerchantPropertiesFile()) {
                    return KeyManager.getPrivateKeyByAlias(CebMerchantProperties.getKeyAlias());
                }
                String merchantId = args[0];
                return KeyManager.getPrivateKeyByMerchantId(merchantId);
            }
        }
        log.error("\u8be5\u65b9\u6cd5\u53ea\u80fd\u63a5\u53d7\u4e00\u4e2a\u53c2\u6570\uff0c\u4f60\u4f20\u5165\u7684\u53c2\u6570\u4e3a\uff1a" + Arrays.toString(args));
        throw new Exception("\u8be5\u65b9\u6cd5\u53ea\u80fd\u63a5\u53d7\u4e00\u4e2a\u53c2\u6570");
    }

    public static PublicKey getPublicKey() {
        if (CebMerchantProperties.isNewMerchantPropertiesFile()) {
            return KeyManager.getPublicKeyByCNName(CebMerchantProperties.getPaygatePublicKeyCNName());
        }
        return KeyManager.getPublicKeyByAlias(CebMerchantProperties.getPaygateAlias());
    }

    private static PrivateKey getPrivateKeyByMerchantId(String merchantId) throws Exception {
        String CNName = (String)CebMerchantProperties.getMerchantIdAndCNNameMap().get(merchantId);
        if (Util.isNullOrEmpty(CNName)) {
            throw new Exception(new StringBuffer("\u5546\u6237\u3010").append(merchantId).append("\u3011\u5bf9\u5e94\u7684\u79c1\u94a5\u7684CN\u6ca1\u6709\u914d\u7f6e\uff0c\u8bf7\u68c0\u67e5\u5546\u6237\u914d\u7f6e\u6587\u4ef6(\u68c0\u67e5\u9879\u4e3a\uff1amerchantIdCNName)\uff01").toString());
        }
        log.info(new StringBuffer().append("\u6839\u636e\u5546\u6237\u53f7\u83b7\u53d6\u5546\u6237\u79c1\u94a5,\u5546\u6237\u53f7\u3010").append(merchantId).append("\u3011").append(",").append("\u5bf9\u5e94\u914d\u7f6e\u4e2d\u7684CNName\u3010").append(CNName).append("\u3011\r\n"));
        return KeyManager.getPrivateKeyByCNName(CNName);
    }

    private static PrivateKey getPrivateKeyByCNName(String CNName) throws Exception {
        PrivateKey privateKey = ((MerchantKeyInfo)merchentKeyInfoMapKeyIsCN.get(CNName)).getPrivateKey();
        if (privateKey == null) {
            throw new Exception(new StringBuffer("\u5546\u6237\u79c1\u94a5CN\u4e3a\u3010").append(CNName).append("\u3011\u5bf9\u5e94\u7684\u79c1\u94a5\u4e0e\u5bc6\u7801\u7684\u6620\u5c04\u6ca1\u6709\u914d\u7f6e\u6216\u8005\u5bc6\u7801\u9519\u8bef\u7b49\uff0c\u8bf7\u68c0\u67e5\u5546\u6237\u914d\u7f6e\u6587\u4ef6(\u68c0\u67e5\u9879\u4e3a\uff1amerchantPrivateKeyCNName)\uff01").toString());
        }
        return privateKey;
    }

    private static PrivateKey getPrivateKeyByAlias(String alias) throws Exception {
        MerchantKeyInfo merchantKeyInfo = (MerchantKeyInfo)merchantKeyInfoMapKeyIsAlias.get(alias);
        PrivateKey privateKey = merchantKeyInfo.getPrivateKey();
        if (privateKey == null) {
            throw new Exception(new StringBuffer().append("\u5546\u6237\u79c1\u94a5\u522b\u540d\u4e3a\u3010").append(alias).append("\u3011,").append("CNName\u4e3a\u3010").append(merchantKeyInfo.getCNName()).append("\u3011").append("\u5bf9\u5e94\u7684\u79c1\u94a5\u4e0e\u5bc6\u7801\u7684\u6620\u5c04\u6ca1\u6709\u914d\u7f6e\u6216\u8005\u5bc6\u7801\u9519\u8bef\u7b49\uff0c\u8bf7\u68c0\u67e5\u5546\u6237\u914d\u7f6e\u6587\u4ef6(\u68c0\u67e5\u9879\u4e3a\uff1amerchantPrivateKeyCNName)\uff01").toString());
        }
        return privateKey;
    }

    private static PublicKey getPublicKeyByCNName(String CNName) {
        return ((CertificateInfo)certificateInfoMapKeyIsCN.get(CNName)).getPublicKey();
    }

    private static PublicKey getPublicKeyByAlias(String alias) {
        return ((CertificateInfo)certificateInfoMapKeyIsAlias.get(alias)).getPublicKey();
    }
}

