/*
 * Decompiled with CFR 0.152.
 */
package com.csii.payment.client.ui;

import com.csii.payment.client.core.MerchantSignTool;
import com.csii.payment.client.entity.CebMerchantProperties;
import com.csii.payment.client.entity.SignParameterObject;
import com.csii.payment.client.entity.VerifyParameterObject;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Map;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;

public class SignTool
extends JFrame {
    private JPanel mainPanel;
    private JLabel signLabel;
    private JScrollPane signScrollPane;
    private JTextArea signTextArea;
    private JLabel plainLabel;
    private JScrollPane plainScrollPane;
    private JTextArea plainTextArea;
    private JLabel merIdLabel;
    private JComboBox merIdCombobox;
    private JLabel charsetLabel;
    private JComboBox charsetCombobox;
    private JLabel typeLabel;
    private JComboBox typeCombobox;
    private JLabel algorithmLabel;
    private JComboBox algorithmCombobox;
    private JLabel transIdLabel;
    private JTextField transIdField;
    private JButton sumbitButton;
    private JRadioButtonMenuItem signRadioItem;
    private JRadioButtonMenuItem verifyRadioItem;
    private ButtonGroup radioItems;

    public SignTool() {
        this.setSize(805, 800);
        this.setDefaultCloseOperation(3);
        this.setResizable(false);
        this.setTitle("\u7b7e\u540d\u9a8c\u7b7e\u5de5\u5177");
        this.setContentPane(this.getMainPanel());
        this.setLocationRelativeTo(null);
        this.setVisible(true);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                System.exit(0);
            }
        });
    }

    private JPanel getMainPanel() {
        this.mainPanel = new JPanel();
        this.mainPanel.setLayout(null);
        this.merIdLabel = new JLabel();
        this.merIdLabel.setBounds(40, 20, 50, 27);
        this.merIdLabel.setText("\u5546\u6237\u53f7:");
        this.mainPanel.add(this.merIdLabel);
        this.merIdCombobox = new JComboBox();
        this.merIdCombobox.setBounds(90, 20, 240, 25);
        this.mainPanel.add(this.merIdCombobox);
        this.charsetLabel = new JLabel();
        this.charsetLabel.setBounds(400, 20, 50, 27);
        this.charsetLabel.setText("\u5b57\u7b26\u96c6:");
        this.mainPanel.add(this.charsetLabel);
        this.charsetCombobox = new JComboBox();
        this.charsetCombobox.setBounds(450, 20, 240, 25);
        this.mainPanel.add(this.charsetCombobox);
        this.typeLabel = new JLabel();
        this.typeLabel.setBounds(40, 60, 50, 27);
        this.typeLabel.setText("\u7c7b\u3000\u578b:");
        this.mainPanel.add(this.typeLabel);
        this.typeCombobox = new JComboBox();
        this.typeCombobox.setBounds(90, 60, 240, 25);
        this.mainPanel.add(this.typeCombobox);
        this.algorithmLabel = new JLabel();
        this.algorithmLabel.setBounds(400, 60, 50, 27);
        this.algorithmLabel.setText("\u7b97\u3000\u6cd5:");
        this.mainPanel.add(this.algorithmLabel);
        this.algorithmCombobox = new JComboBox();
        this.algorithmCombobox.setBounds(450, 60, 240, 25);
        this.mainPanel.add(this.algorithmCombobox);
        this.radioItems = new ButtonGroup();
        this.signRadioItem = new JRadioButtonMenuItem("\u7b7e\u540d", true);
        this.signRadioItem.setBounds(100, 100, 50, 27);
        this.verifyRadioItem = new JRadioButtonMenuItem("\u9a8c\u7b7e");
        this.verifyRadioItem.setBounds(240, 100, 50, 27);
        this.radioItems.add(this.signRadioItem);
        this.radioItems.add(this.verifyRadioItem);
        this.mainPanel.add(this.signRadioItem);
        this.mainPanel.add(this.verifyRadioItem);
        this.transIdLabel = new JLabel();
        this.transIdLabel.setBounds(400, 100, 50, 27);
        this.transIdLabel.setText("\u4ea4\u6613\u7801:");
        this.mainPanel.add(this.transIdLabel);
        this.transIdField = new JTextField();
        this.transIdField.setBounds(450, 100, 240, 25);
        this.mainPanel.add(this.transIdField);
        this.plainLabel = new JLabel();
        this.plainLabel.setBounds(30, 150, 30, 27);
        this.plainLabel.setText("\u660e\u6587:");
        this.mainPanel.add(this.plainLabel);
        this.plainScrollPane = new JScrollPane();
        this.plainTextArea = new JTextArea();
        this.plainScrollPane.setBounds(70, 150, 720, 270);
        this.plainScrollPane.setViewportView(this.plainTextArea);
        this.mainPanel.add(this.plainScrollPane);
        this.signLabel = new JLabel();
        this.signLabel.setBounds(30, 430, 30, 27);
        this.signLabel.setText("\u5bc6\u6587:");
        this.mainPanel.add(this.signLabel);
        this.signScrollPane = new JScrollPane();
        this.signTextArea = new JTextArea();
        this.signScrollPane.setBounds(70, 430, 720, 270);
        this.signScrollPane.setViewportView(this.signTextArea);
        this.mainPanel.add(this.signScrollPane);
        this.sumbitButton = new JButton();
        this.sumbitButton.setBounds(700, 720, 85, 27);
        this.sumbitButton.setText("\u786e\u5b9a");
        this.sumbitButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionevent) {
                if (SignTool.this.plainTextArea.getText() == null || SignTool.this.plainTextArea.getText().trim().length() == 0) {
                    JOptionPane.showMessageDialog(null, "\u660e\u6587\u4e0d\u80fd\u4e3a\u7a7a!");
                    return;
                }
                if (SignTool.this.signRadioItem.isSelected()) {
                    SignParameterObject signParam = new SignParameterObject();
                    signParam.setMerchantId(SignTool.this.merIdCombobox.getSelectedItem().toString());
                    signParam.setPlain(SignTool.this.plainTextArea.getText().trim());
                    signParam.setCharset(SignTool.this.charsetCombobox.getSelectedItem().toString());
                    signParam.setType(SignTool.this.typeCombobox.getSelectedIndex());
                    signParam.setTransId(SignTool.this.transIdField.getText().trim());
                    signParam.setAlgorithm(SignTool.this.algorithmCombobox.getSelectedItem().toString());
                    System.out.println(signParam);
                    try {
                        SignTool.this.signTextArea.setText(MerchantSignTool.sign(signParam));
                    }
                    catch (Exception e) {
                        JOptionPane.showMessageDialog(null, "\u7b7e\u540d\u5931\u8d25\uff1a" + e.getMessage());
                    }
                } else {
                    if (SignTool.this.signTextArea.getText() == null || SignTool.this.signTextArea.getText().trim().length() == 0) {
                        JOptionPane.showMessageDialog(null, "\u5bc6\u6587\u4e0d\u80fd\u4e3a\u7a7a!");
                        return;
                    }
                    VerifyParameterObject verifyParam = new VerifyParameterObject();
                    verifyParam.setPlain(SignTool.this.plainTextArea.getText().trim());
                    verifyParam.setPlainCharset(SignTool.this.charsetCombobox.getSelectedItem().toString());
                    verifyParam.setSign(SignTool.this.signTextArea.getText().trim());
                    verifyParam.setSignCharset("");
                    verifyParam.setType(SignTool.this.typeCombobox.getSelectedIndex());
                    verifyParam.setAlgorithm(SignTool.this.algorithmCombobox.getSelectedItem().toString());
                    verifyParam.setSignatureLable("ds:Signature");
                    try {
                        boolean result = MerchantSignTool.verify(verifyParam);
                        JOptionPane.showMessageDialog(null, "\u9a8c\u7b7e\u7ed3\u679c\uff1a" + result);
                    }
                    catch (Exception e) {
                        JOptionPane.showMessageDialog(null, "\u9a8c\u7b7e\u5931\u8d25\uff1a" + e.getMessage());
                    }
                }
            }
        });
        this.mainPanel.add(this.sumbitButton);
        try {
            this.init();
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(this, "\u521d\u59cb\u5316\u9519\u8bef\uff1a" + e.getMessage());
        }
        return this.mainPanel;
    }

    private void init() {
        Object[] objectArray;
        Map map = CebMerchantProperties.getMerchantIdAndCNNameMap();
        Object[] objectArray2 = objectArray = map.entrySet().toArray();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object object = objectArray2[n2];
            Map.Entry entry = (Map.Entry)object;
            this.merIdCombobox.addItem(entry.getKey());
            ++n2;
        }
        this.charsetCombobox.addItem("GBK");
        this.charsetCombobox.addItem("UTF-8");
        this.typeCombobox.addItem("0-\u666e\u901a\u7b7e\u540d");
        this.typeCombobox.addItem("1-XML\u7b7e\u540d\u4f7f\u7528JDK\u65b9\u5f0f");
        this.typeCombobox.addItem("2-XML\u7b7e\u540d\u4f7f\u7528Apache\u65b9\u5f0f");
        this.typeCombobox.addItem("3-\u6587\u4ef6\u7b7e\u540d");
        this.typeCombobox.addItem("4-URL\u7b7e\u540d");
        this.algorithmCombobox.addItem("MD5withRSA");
        this.algorithmCombobox.addItem("SHA1WithRSA");
        this.algorithmCombobox.addItem("DSAwithSHA1");
        this.algorithmCombobox.addItem("RSAwithSHA1");
        this.algorithmCombobox.addItem("HMAC-SHA1");
    }

    public static void main(String[] args) {
        new SignTool();
    }
}

