/*
 * Decompiled with CFR 0.152.
 */
package com.csii.payment.client.util;

import com.csii.payment.client.util.Util;
import java.io.FileInputStream;
import java.util.Properties;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.PropertyConfigurator;

public class Log {
    private Logger log;
    private static String defaultLog4jFilePath = String.valueOf(Util.getClassPath()) + "/" + "log4jMerchant.properties";

    static {
        Log.init(Log.getMerchantProperties());
    }

    public Log(String className) {
        this.log = Logger.getLogger((String)className);
    }

    public Log(Class clazz) {
        this.log = Logger.getLogger((Class)clazz);
    }

    private static Properties getMerchantProperties() {
        Properties properties;
        FileInputStream fis = null;
        try {
            String merchantPropertiesPath = System.getProperty("guangda.merchant.parameter.file.path");
            if (Util.isNullOrEmpty(merchantPropertiesPath)) {
                merchantPropertiesPath = String.valueOf(Util.getClassPath()) + "/" + "ceb_merchant.properties";
            } else if (merchantPropertiesPath.startsWith("classPath:")) {
                String path = merchantPropertiesPath.substring("classPath:".length());
                merchantPropertiesPath = String.valueOf(Util.getClassPath()) + "/" + path;
            }
            fis = new FileInputStream(merchantPropertiesPath);
            Properties properties2 = new Properties();
            properties2.load(fis);
            properties = properties2;
        }
        catch (Exception e) {
            try {
                throw new RuntimeException("\u52a0\u8f7d\u5546\u6237\u914d\u7f6e\u6587\u4ef6\u5931\u8d25\uff01", e);
            }
            catch (Throwable throwable) {
                Util.closeStream(fis);
                throw throwable;
            }
        }
        Util.closeStream(fis);
        return properties;
    }

    private static void init(Properties properties) {
        String log4jFilePath = properties.getProperty("log4jFilePath");
        if (!Util.isNullOrEmpty(log4jFilePath)) {
            if (log4jFilePath.startsWith("classPath:")) {
                String log4jName = log4jFilePath.substring("classPath:".length());
                try {
                    PropertyConfigurator.configure((String)(String.valueOf(Util.getClassPath()) + log4jName));
                }
                catch (Exception e) {
                    PropertyConfigurator.configure((String)log4jFilePath);
                }
            } else {
                PropertyConfigurator.configure((String)log4jFilePath);
            }
        } else {
            PropertyConfigurator.configure((String)defaultLog4jFilePath);
        }
    }

    public void setLevel(String level) {
        if (Util.isNullOrEmpty(level = Util.toUpperCase(level)) || "OFF".equals(level)) {
            this.log.setLevel(Level.OFF);
        } else if ("FATAL".equals(level)) {
            this.log.setLevel(Level.FATAL);
        } else if ("ERROR".equals(level)) {
            this.log.setLevel(Level.ERROR);
        } else if ("WARN".equals(level)) {
            this.log.setLevel(Level.WARN);
        } else if ("INFO".equals(level)) {
            this.log.setLevel(Level.INFO);
        } else if ("DEBUG".equals(level)) {
            this.log.setLevel(Level.DEBUG);
        } else if ("ALL".equals(level)) {
            this.log.setLevel(Level.ALL);
        } else {
            this.log.setLevel(Level.OFF);
        }
    }

    public void debug(Object message) {
        if (this.log.isDebugEnabled()) {
            this.log.debug(message);
        }
    }

    public void debug(Object message, Throwable t) {
        if (this.log.isDebugEnabled()) {
            this.log.debug(message, t);
        }
    }

    public void info(Object message) {
        if (this.log.isInfoEnabled()) {
            this.log.info(message);
        }
    }

    public void info(Object message, Throwable t) {
        if (this.log.isInfoEnabled()) {
            this.log.info(message, t);
        }
    }

    public void warn(Object message) {
        this.log.warn(message);
    }

    public void warn(Object message, Throwable t) {
        this.log.warn(message, t);
    }

    public void error(Object message) {
        this.log.error(message);
    }

    public void error(Object message, Throwable t) {
        this.log.error(message, t);
    }

    public void fatal(Object message) {
        this.log.fatal(message);
    }

    public void fatal(Object message, Throwable t) {
        this.log.fatal(message, t);
    }
}

