/*
 * Decompiled with CFR 0.152.
 */
package com.csii.payment.client.util;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.net.URLDecoder;
import java.security.KeyStore;
import java.security.cert.X509Certificate;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.UUID;
import javax.security.auth.x500.X500Principal;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.dom4j.Document;
import org.dom4j.io.OutputFormat;
import org.dom4j.io.SAXReader;
import org.dom4j.io.XMLWriter;

public class Util {
    public static String toUpperCase(String word) {
        return Util.isNullOrEmpty(word) ? word : word.toUpperCase();
    }

    public static String trim(String word) {
        return Util.isNullOrEmpty(word) ? word : word.trim();
    }

    public static void copyInputStreamToOutStream(InputStream is, OutputStream os) throws Exception {
        byte[] buffer = new byte[10240];
        int length = is.read(buffer);
        while (length != -1) {
            os.write(buffer, 0, length);
            length = is.read(buffer);
        }
    }

    public static byte[] convertInputStreamToByteArray(InputStream is) throws Exception {
        byte[] buffer = new byte[10240];
        int length = is.read(buffer);
        ByteArrayOutputStream os = null;
        try {
            os = new ByteArrayOutputStream();
            while (length != -1) {
                os.write(buffer, 0, length);
                length = is.read(buffer);
            }
            byte[] byArray = os.toByteArray();
            return byArray;
        }
        finally {
            Util.closeStream(os);
        }
    }

    public static boolean isNullOrEmpty(Object obj) {
        if (obj == null) {
            return true;
        }
        if (obj instanceof String) {
            return "".equals(obj);
        }
        if (obj instanceof List) {
            return ((List)obj).isEmpty();
        }
        if (obj instanceof Map) {
            return ((Map)obj).isEmpty();
        }
        if (obj instanceof Set) {
            return ((Set)obj).isEmpty();
        }
        if (obj instanceof Queue) {
            return ((Queue)obj).isEmpty();
        }
        return false;
    }

    public static void closeStream(Object stream) {
        if (stream == null) {
            return;
        }
        if (stream instanceof InputStream) {
            try {
                ((InputStream)stream).close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        if (stream instanceof OutputStream) {
            try {
                ((OutputStream)stream).close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public static org.w3c.dom.Document parseDom(String xmlMessage, String charset) throws Exception {
        org.w3c.dom.Document document;
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setNamespaceAware(true);
        ByteArrayInputStream bis = null;
        try {
            bis = new ByteArrayInputStream(xmlMessage.getBytes(charset));
            document = factory.newDocumentBuilder().parse(bis);
        }
        catch (Exception e) {
            try {
                throw e;
            }
            catch (Throwable throwable) {
                Util.closeStream(bis);
                throw throwable;
            }
        }
        Util.closeStream(bis);
        return document;
    }

    public static String domConvertToXML(org.w3c.dom.Document doc) throws Exception {
        TransformerFactory transformerFactory = TransformerFactory.newInstance();
        Transformer transformer = transformerFactory.newTransformer();
        StringWriter sw = null;
        try {
            sw = new StringWriter();
            transformer.transform(new DOMSource(doc), new StreamResult(sw));
            String string = sw.toString();
            return string;
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            Util.closeStream(sw);
        }
    }

    public static String byteToHex(byte[] bytes) {
        StringBuffer buffer = new StringBuffer();
        int i = 0;
        while (i < bytes.length) {
            String byteStr = Integer.toHexString(bytes[i] & 0xFF);
            if (byteStr.length() != 2) {
                buffer.append('0').append(byteStr);
            } else {
                buffer.append(byteStr);
            }
            ++i;
        }
        return new String(buffer);
    }

    public static byte[] hexToByte(String hexString) {
        int length = hexString.length() / 2;
        byte[] result = new byte[length];
        int i = 0;
        while (i < length) {
            String tmp = hexString.substring(i * 2, i * 2 + 2);
            result[i] = (byte)Integer.parseInt(tmp, 16);
            ++i;
        }
        return result;
    }

    public static String getUUID() {
        return Util.toUpperCase(UUID.randomUUID().toString().replaceAll("-", ""));
    }

    public static String formatXML(String xmlMessage, String charset, int type) throws Exception {
        Document document = Util.parseDocument(xmlMessage, charset);
        OutputFormat format = null;
        if (type == 0) {
            format = OutputFormat.createPrettyPrint();
            format.setIndent(true);
            format.setIndentSize(4);
            format.setExpandEmptyElements(true);
            format.setNewlines(true);
            format.setLineSeparator(System.getProperty("line.separator"));
        } else {
            format = OutputFormat.createCompactFormat();
        }
        format.setEncoding(charset);
        StringWriter sw = new StringWriter();
        try {
            XMLWriter xmlWriter = new XMLWriter((Writer)sw, format);
            xmlWriter.write(document);
            String result = sw.toString();
            if (type == 1) {
                String string = result.replaceFirst("\n", "");
                return string;
            }
            String string = result;
            return string;
        }
        finally {
            Util.closeStream(sw);
        }
    }

    public static Document parseDocument(String xmlMessage, String charset) throws Exception {
        Document document;
        SAXReader reader = new SAXReader();
        BufferedReader br = null;
        try {
            br = new BufferedReader(new InputStreamReader((InputStream)new ByteArrayInputStream(xmlMessage.getBytes(charset)), charset));
            document = reader.read((Reader)br);
        }
        catch (Exception e) {
            try {
                throw e;
            }
            catch (Throwable throwable) {
                Util.closeStream(br);
                throw throwable;
            }
        }
        Util.closeStream(br);
        return document;
    }

    public static String getXMLMessageFromFile(String fileName, String charset) throws Exception {
        BufferedReader br = null;
        String line = "";
        StringBuffer sb = new StringBuffer();
        try {
            br = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(fileName), charset));
            while ((line = br.readLine()) != null) {
                sb.append(line).append("\r\n");
            }
        }
        catch (Throwable throwable) {
            Util.closeStream(br);
            throw throwable;
        }
        Util.closeStream(br);
        return sb.toString();
    }

    public static Proxy getProxy(String hostname, String port) {
        InetSocketAddress isa = new InetSocketAddress(hostname, Integer.parseInt(port));
        Proxy proxy = new Proxy(Proxy.Type.HTTP, isa);
        return proxy;
    }

    public static KeyStore getKeyStore(String containType, String containPath, String containPassword) throws Exception {
        KeyStore keyStore = KeyStore.getInstance(containType);
        keyStore.load(new FileInputStream(containPath), containPassword.toCharArray());
        return keyStore;
    }

    public static String getSignType(int type) {
        switch (type) {
            case 0: {
                return String.valueOf(type) + "-\u666e\u901a\u62a5\u6587";
            }
            case 1: {
                return String.valueOf(type) + "-XML\u62a5\u6587\u7b7e\u540d(\u4f7f\u7528JDK)";
            }
            case 2: {
                return String.valueOf(type) + "-XML\u62a5\u6587\u7b7e\u540d(\u4f7f\u7528Apache)";
            }
            case 3: {
                return String.valueOf(type) + "-\u6587\u4ef6\u6d41\u7b7e\u540d";
            }
            case 4: {
                return String.valueOf(type) + "-URL\u7b7e\u540d";
            }
        }
        return String.valueOf(type) + "-\u8be5\u7b7e\u540d\u7c7b\u578b\u672a\u5b9a\u4e49";
    }

    public static String getCNFromCertificate(X509Certificate certificate) {
        X500Principal principal = certificate.getSubjectX500Principal();
        String[] subjectItem = principal.toString().split(",");
        int i = 0;
        while (i < subjectItem.length) {
            String item = subjectItem[i];
            if (item.startsWith("CN")) {
                return item.split("=")[1];
            }
            ++i;
        }
        return principal.toString();
    }

    public static String formatCharsequence(String charsequence, String charset, int fillLength, String fillSymbol) throws Exception {
        StringBuffer sb = new StringBuffer();
        byte[] chineseByte = charsequence.getBytes(charset);
        int fillBlankChinese = fillLength - chineseByte.length;
        sb.append(charsequence);
        if (fillBlankChinese > 0) {
            int i = 0;
            while (i < fillBlankChinese) {
                sb.append(fillSymbol);
                ++i;
            }
        }
        return sb.toString();
    }

    public static String formatDate(Date date, String pattern) {
        SimpleDateFormat sdf = new SimpleDateFormat();
        sdf.applyPattern(pattern);
        return sdf.format(date);
    }

    public static String getClassPath() {
        String classPathTmp = Util.class.getResource("/").getPath();
        try {
            return URLDecoder.decode(classPathTmp, "UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return classPathTmp;
        }
    }

    public static String covertPropertiesValue(String propertiesValue) {
        if (Util.isNullOrEmpty(propertiesValue)) {
            return propertiesValue;
        }
        try {
            return new String(propertiesValue.getBytes("ISO-8859-1"));
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return propertiesValue;
        }
    }
}

