/*
 * Decompiled with CFR 0.152.
 */
package com.chinaunicom.base.aop;

import com.chinaunicom.base.util.LogUtils;
import com.chinaunicom.common.exception.ResourceException;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import org.aspectj.lang.ProceedingJoinPoint;
import org.springframework.core.Ordered;

public class BusiAopAdvisor
implements Ordered {
    public int getOrder() {
        return 100;
    }

    public Object throwAopTreat(ProceedingJoinPoint pjp) throws Throwable {
        String[] infos = LogUtils.printBusiAopStartLog(pjp);
        Object returnObj = null;
        try {
            returnObj = pjp.proceed();
        }
        catch (ResourceException e) {
            infos[18] = e.getMsgCode();
            if (e.getArgs() != null && e.getArgs().length == 1) {
                infos[19] = e.getArgs()[0];
            }
            throw e;
        }
        catch (Throwable e) {
            LogUtils.printBusiAopErrorLog(infos, e);
            throw e;
        }
        if (infos != null) {
            if (returnObj != null) {
                try {
                    infos[17] = new ObjectMapper().writeValueAsString(returnObj);
                }
                catch (JsonProcessingException e) {
                    infos[17] = ("\u8bf7\u6c42\u62a5\u6587\u8f6cjson\u51fa\u9519\uff0c\u6539\u7528toString\u65b9\u6cd5" + returnObj).replace("\r\n", "");
                }
            }
            LogUtils.printBusiAopEndLog(infos);
        }
        return returnObj;
    }
}

