/*
 * Decompiled with CFR 0.152.
 */
package com.chinaunicom.base.cache;

import com.chinaunicom.base.cache.CacheManager;
import com.chinaunicom.base.util.SerializeUtils;
import com.chinaunicom.common.cache.service.CacheExecuterService;
import com.chinaunicom.common.cache.service.CacheService;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CacheServiceImpl
implements CacheService {
    private static final Logger log = LoggerFactory.getLogger(CacheServiceImpl.class);
    private CacheManager cacheManager;

    public CacheManager getCacheManager() {
        return this.cacheManager;
    }

    public void setCacheManager(CacheManager cacheManager) {
        this.cacheManager = cacheManager;
    }

    public void put(String key, Object value) {
        this.cacheManager.set(key.getBytes(), SerializeUtils.serialize(value));
    }

    public void put(String key, Object value, int expire) {
        this.cacheManager.set(key.getBytes(), SerializeUtils.serialize(value), expire);
    }

    public Object get(String key) {
        byte[] value = this.cacheManager.get(key.getBytes());
        if (value == null) {
            return null;
        }
        return SerializeUtils.deserialize(value);
    }

    public <T> T get(String key, Class<T> requiredType) {
        byte[] value = this.cacheManager.get(key.getBytes());
        if (value == null) {
            return null;
        }
        return (T)SerializeUtils.deserialize(value);
    }

    public void delete(String key) {
        this.cacheManager.del(key.getBytes());
    }

    public <T> T getFinal(CacheExecuterService<T> executer, String ... key) {
        String finalKey = this.getFinalKey(key);
        log.debug("finalKey=" + finalKey);
        byte[] value = this.cacheManager.get(finalKey.getBytes());
        if (value == null || value.length == 0) {
            log.debug("\u6570\u636e\u5728\u7f13\u5b58\u4e2d\u4e0d\u5b58\u5728\uff01\u6267\u884c\u672c\u5730\u6570\u636e\u67e5\u8be2\u5668\u67e5\u8be2\u6570\u636e");
            Object obj = executer.getParamFromDb(key);
            if (obj != null && !"".equals(obj)) {
                log.debug("value=" + obj.toString());
                this.put(finalKey, obj);
                return (T)obj;
            }
            log.debug("\u6570\u636e\u5728\u6570\u636e\u5e93\u4e2d\u4e0d\u5b58\u5728\uff01");
            return null;
        }
        Object finalValue = SerializeUtils.deserialize(value);
        log.debug("value=" + finalValue);
        return (T)finalValue;
    }

    private String getFinalKey(String ... key) {
        StringBuffer fkey = new StringBuffer();
        for (String s : key) {
            fkey.append(s);
            fkey.append("_");
        }
        fkey.setLength(fkey.length() - 1);
        return fkey.toString();
    }

    public List<String> getNumStatusDesc(List<String> numStatusList) {
        ArrayList<String> statusDescList = new ArrayList<String>();
        for (String s : numStatusList) {
            String statusDesc = this.get("NUM_STATUS_" + s, String.class);
            statusDescList.add(statusDesc);
        }
        return statusDescList;
    }

    public List<String> getCardStatusDesc(List<String> cardStatusList) {
        ArrayList<String> statusDescList = new ArrayList<String>();
        for (String s : cardStatusList) {
            String statusDesc = this.get("CARD_STATUS_" + s, String.class);
            statusDescList.add(statusDesc);
        }
        return statusDescList;
    }

    public Set<String> getkeys(String pattern) {
        HashSet<String> keys = new HashSet<String>();
        Set<byte[]> keybs = this.cacheManager.keys(pattern);
        for (byte[] bs : keybs) {
            keys.add(new String(bs));
        }
        return keys;
    }

    public Long getExpireTimeByKey(String key) {
        return this.cacheManager.getExpireTimeByKey(key.getBytes());
    }

    public Long incr(String key) {
        return this.cacheManager.incr(key.getBytes());
    }

    public Long incrExpireTime(String key, int expire) {
        return this.cacheManager.incrExpireTime(key.getBytes(), expire);
    }

    public Long incrBy(String key, long num) {
        return this.cacheManager.incrBy(key.getBytes(), num);
    }

    public Long incrExpireTimeBy(String key, long num, int expire) {
        return this.cacheManager.incrExpireTimeBy(key.getBytes(), num, expire);
    }

    public Long getIncr(String key) {
        return this.cacheManager.getIncr(key.getBytes());
    }

    public Long rpush(String key, String ... objs) {
        return this.cacheManager.rpush(key, objs);
    }

    public String lpop(String key) {
        return this.cacheManager.lpop(key);
    }

    public Long llen(String key) {
        return this.cacheManager.llen(key);
    }

    public Long setnx(String key, Object value) {
        return this.cacheManager.setnx(key.getBytes(), SerializeUtils.serialize(value));
    }

    public Object getSet(String key, Object value) {
        byte[] bytes = this.cacheManager.getSet(key.getBytes(), SerializeUtils.serialize(value));
        return bytes == null ? null : SerializeUtils.deserialize(bytes);
    }
}

