/*
 * Decompiled with CFR 0.152.
 */
package com.chinaunicom.base.dict.manager;

import com.chinaunicom.base.dict.DictRecord;
import com.chinaunicom.base.dict.config.DictConfig;
import com.chinaunicom.base.dict.config.EntityConfig;
import com.chinaunicom.base.dict.exception.DictException;
import com.chinaunicom.base.dict.manager.DictAccess;
import com.chinaunicom.base.dict.util.StaticOrderMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class AbstractDictAccess
implements DictAccess {
    private static Log log = LogFactory.getLog(AbstractDictAccess.class);
    protected DictConfig config;

    @Override
    public void initConfig(DictConfig cfg) {
        this.config = cfg;
    }

    @Override
    public EntityConfig getDictConfig(String entityName) throws DictException {
        Object o = this.config.getEntitis().get(entityName);
        if (o == null) {
            throw new DictException("\u4e0d\u5b58\u5728\u5b57\u5178:" + entityName);
        }
        return (EntityConfig)o;
    }

    @Override
    public Map getDictEntity(String entityName) throws DictException {
        return this.getDictEntity(entityName, null);
    }

    @Override
    public Map getDictEntityByAlisa(String alisaName) throws DictException {
        return this.getDictEntity(alisaName);
    }

    @Override
    public List getDictEntityList(String entityName) throws DictException {
        StaticOrderMap map = (StaticOrderMap)this.getDictEntity(entityName);
        return map.getValues();
    }

    @Override
    public List getDictEntityList(String entityName, String filter) throws DictException {
        StaticOrderMap map = (StaticOrderMap)this.getDictEntity(entityName, filter);
        return map.getValues();
    }

    @Override
    public List getDictEntityListByAlisa(String alisaName) throws DictException {
        return this.getDictEntityList(alisaName);
    }

    @Override
    public List getDictEntityListByAlisa(String alisaName, String filter) throws DictException {
        return this.getDictEntityList(alisaName, filter);
    }

    @Override
    public DictRecord getDict(String entityName, String key) throws DictException {
        Map map = this.getDictEntity(entityName);
        Object obj = map.get(key);
        if (obj != null) {
            return (DictRecord)obj;
        }
        return new DictRecord();
    }

    @Override
    public DictRecord getParentDict(String entityName, String key) throws DictException {
        String parentID = this.getDictConfig(entityName).getDyna();
        DictRecord dict = this.getDict(entityName + "#all", key);
        String pid = dict.getAttribute(parentID).toString();
        dict = this.getDict(entityName + "#all", pid);
        return dict;
    }

    @Override
    public DictRecord getDictByAlisa(String alisaName, String key) throws DictException {
        int i = alisaName.indexOf("#");
        if (i != -1) {
            alisaName = alisaName.substring(0, i);
            return this.getDict(alisaName + "#all", key);
        }
        return this.getDict(alisaName, key);
    }

    @Override
    public DictRecord getParentDictByAlisa(String alisaName, String key) throws DictException {
        return this.getParentDict(alisaName, key);
    }

    public static void main(String[] args) {
        System.out.println("aa#all".substring(0, 2));
    }
}

