/*
 * Decompiled with CFR 0.152.
 */
package com.chinaunicom.base.dict.taglib;

import com.chinaunicom.base.dict.DictRecord;
import com.chinaunicom.base.dict.exception.DictException;
import com.chinaunicom.base.dict.manager.DictAccess;
import com.chinaunicom.base.dict.manager.DictsManager;
import com.chinaunicom.base.dict.util.ApplicationContextUtil;
import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.JspWriter;
import javax.servlet.jsp.tagext.TagSupport;
import org.apache.commons.beanutils.PropertyUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DictNestedTag
extends TagSupport {
    private Log log = LogFactory.getLog(DictNestedTag.class);
    protected String dicts;
    protected String select;
    protected boolean showCode = false;
    private String style;
    private String styleClass;
    private String props;
    private boolean confirm;
    private boolean debug;
    private DictsManager mgr = (DictsManager)ApplicationContextUtil.getBean("dictsManager");

    public int doStartTag() throws JspException {
        int i;
        JspWriter out = this.pageContext.getOut();
        String[] dictarray = this.dicts.split(",");
        String[] selectarray = this.select.split(",");
        String[] propsarray = this.props.split(",");
        List[] dictList = new List[dictarray.length];
        try {
            DictAccess access = this.mgr.getAccess();
            String filterStr = null;
            for (i = 0; i < dictarray.length; ++i) {
                dictList[i] = access.getDictEntityListByAlisa(dictarray[i], filterStr);
                if (i >= dictarray.length - 1 || dictList[i].size() <= 0) continue;
                String dictID = ((DictRecord)dictList[i].get(0)).getDictID();
                filterStr = "{" + propsarray[i] + "}.equals(\"" + dictID + "\")";
            }
        }
        catch (DictException ex) {
            throw new JspException("nested select tag");
        }
        StringBuffer sb = new StringBuffer();
        String contextPath = ((HttpServletRequest)this.pageContext.getRequest()).getContextPath();
        sb.append("<script type='text/javascript' src='" + contextPath + "/dwr/interface/DictManager.js'></script>\n" + "<script type='text/javascript' src='" + contextPath + "/dwr/engine.js'></script>\n" + "<script type='text/javascript' src='" + contextPath + "/dwr/util.js'></script>");
        sb.append("<script type=\"text/javascript\">\n");
        for (i = 1; i < dictarray.length; ++i) {
            sb.append("var change_dwr_" + selectarray[i].replaceAll("\\.", "_") + " = function(data) {\n" + "        DWRUtil.removeAllOptions(\"" + selectarray[i] + "\");\n" + "        DWRUtil.addOptions(\"" + selectarray[i] + "\", data, \"dictID\", \"dictContent\");\n" + "    }\n");
        }
        sb.append("</script>\n");
        for (i = 0; i < dictarray.length; ++i) {
            String selectValue;
            Object beanValue;
            String beanName;
            sb.append(dictarray[i] + ":");
            sb.append("<select name=\"" + selectarray[i] + "\"  ");
            if (this.style != null) {
                sb.append(" style=\"" + this.style + "\" ");
            }
            if (this.styleClass != null) {
                sb.append(" class=\"" + this.styleClass + "\" ");
            }
            if (i < dictarray.length - 1) {
                sb.append("onchange='DictManager.getDictEntityListByAlisa(\"" + dictarray[i + 1] + "\",\"{" + propsarray[i] + "}.equals(\\\"\"+this.value+\"\\\")\"" + ",change_dwr_" + selectarray[i + 1].replaceAll("\\.", "_") + ")'");
            }
            sb.append(">\n");
            if (this.confirm) {
                sb.append("<option value=\"-1\"> \u8bf7\u9009\u62e9 ...</option>");
            }
            Iterator iter = dictList[i].iterator();
            String tmp = beanName = selectarray[i];
            if (beanName.indexOf(".") != -1) {
                tmp = beanName.substring(0, selectarray[i].indexOf("."));
            }
            if ((beanValue = this.pageContext.findAttribute(tmp)) == null) {
                throw new JspException("\u4f1a\u8bdd\u4e2d\u4e0d\u5b58\u5728\u5c5e\u6027\uff1a" + tmp);
            }
            if (beanName.indexOf(".") != -1) {
                String prop = beanName.substring(beanName.indexOf(".") + 1);
                try {
                    Object tmp1 = PropertyUtils.getProperty((Object)beanValue, (String)prop);
                    if (tmp1 != null) {
                        selectValue = tmp1.toString();
                    }
                    selectValue = null;
                }
                catch (Exception e) {
                    throw new JspException("dict:write error," + beanName + "\u5bf9\u8c61\u4e2d\u4e0d\u5b58\u5728\u5c5e\u6027\uff1a" + prop, (Throwable)e);
                }
            } else {
                selectValue = beanValue.toString();
            }
            while (iter.hasNext()) {
                DictRecord bean = (DictRecord)iter.next();
                String stringLabel = this.showCode ? bean.getDictID() + "-" + bean.getDictContent() : bean.getDictContent();
                String stringValue = bean.getDictID();
                if (stringValue == null) {
                    stringValue = "";
                }
                boolean matched = false;
                if (selectValue != null && selectValue.equalsIgnoreCase(stringValue)) {
                    matched = true;
                }
                this.addOption(sb, stringLabel, stringValue, matched);
            }
            sb.append("</select>\n");
        }
        try {
            out.write(sb.toString());
        }
        catch (IOException e) {
            throw new JspException((Throwable)e);
        }
        return 0;
    }

    public void release() {
        super.release();
        this.dicts = null;
        this.select = null;
        this.props = null;
        this.showCode = false;
        this.style = null;
        this.styleClass = null;
    }

    protected void addOption(StringBuffer sb, String label, String value, boolean matched) {
        sb.append("<option value=\"");
        sb.append(value);
        sb.append("\"");
        if (matched) {
            sb.append(" selected=\"selected\"");
        }
        if (this.style != null) {
            sb.append(" style=\"");
            sb.append(this.style);
            sb.append("\"");
        }
        if (this.styleClass != null) {
            sb.append(" class=\"");
            sb.append(this.styleClass);
            sb.append("\"");
        }
        sb.append(">");
        sb.append(label);
        sb.append("</option>\r\n");
    }

    public String getDicts() {
        return this.dicts;
    }

    public void setDicts(String dicts) {
        this.dicts = dicts;
    }

    public String getSelect() {
        return this.select;
    }

    public void setSelect(String select) {
        this.select = select;
    }

    public boolean isShowCode() {
        return this.showCode;
    }

    public void setShowCode(boolean showCode) {
        this.showCode = showCode;
    }

    public String getStyle() {
        return this.style;
    }

    public void setStyle(String style) {
        this.style = style;
    }

    public String getStyleClass() {
        return this.styleClass;
    }

    public void setStyleClass(String styleClass) {
        this.styleClass = styleClass;
    }

    public String getProps() {
        return this.props;
    }

    public void setProps(String props) {
        this.props = props;
    }

    public boolean isDebug() {
        return this.debug;
    }

    public void setDebug(boolean debug) {
        this.debug = debug;
    }

    public boolean isConfirm() {
        return this.confirm;
    }

    public void setConfirm(boolean confirm) {
        this.confirm = confirm;
    }
}

