/*
 * Decompiled with CFR 0.152.
 */
package com.chinaunicom.base.dict.taglib;

import com.chinaunicom.base.dict.DictRecord;
import com.chinaunicom.base.dict.exception.DictException;
import com.chinaunicom.base.dict.manager.DictAccess;
import com.chinaunicom.base.dict.manager.DictsManager;
import com.chinaunicom.base.dict.util.ApplicationContextUtil;
import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.JspWriter;
import javax.servlet.jsp.tagext.TagSupport;

public class DictOptionsTag
extends TagSupport {
    protected String filter = null;
    protected String type = null;
    protected boolean showCode = false;
    private String style = null;
    private String styleClass = null;
    private String value = null;
    private DictsManager mgr = (DictsManager)ApplicationContextUtil.getBean("dictsManager");

    public String getFilter() {
        return this.filter;
    }

    public void setFilter(String filter) {
        this.filter = filter;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getStyle() {
        return this.style;
    }

    public void setStyle(String style) {
        this.style = style;
    }

    public String getStyleClass() {
        return this.styleClass;
    }

    public void setStyleClass(String styleClass) {
        this.styleClass = styleClass;
    }

    public boolean getShowCode() {
        return this.showCode;
    }

    public void setShowCode(boolean showCode) {
        this.showCode = showCode;
    }

    public int doStartTag() throws JspException {
        List collection;
        JspWriter out = this.pageContext.getOut();
        try {
            DictAccess access = this.mgr.getAccess();
            collection = access.getDictEntityListByAlisa(this.type, this.filter);
        }
        catch (DictException e) {
            throw new JspException((Throwable)e);
        }
        if (collection == null) {
            throw new JspException("Failed to obtain specified collection");
        }
        Iterator iter = collection.iterator();
        StringBuffer sb = new StringBuffer();
        while (iter.hasNext()) {
            DictRecord bean = (DictRecord)iter.next();
            String stringLabel = this.showCode ? bean.getDictID() + "-" + bean.getDictContent() : bean.getDictContent();
            String stringValue = bean.getDictID();
            if (stringValue == null) {
                stringValue = "";
            }
            boolean matched = false;
            if (this.value != null) {
                matched = this.isMatched(this.value, stringValue);
            }
            this.addOption(sb, stringLabel, stringValue, matched);
        }
        try {
            System.out.println(sb.toString());
            out.print(sb.toString());
        }
        catch (IOException e) {
            throw new JspException((Throwable)e);
        }
        return 0;
    }

    private boolean isMatched(String val1, String val2) {
        if (val1 != null && val2 != null) {
            return val1.equals(val2);
        }
        return false;
    }

    public void release() {
        super.release();
        this.filter = null;
        this.type = null;
        this.style = null;
        this.styleClass = null;
        this.value = null;
    }

    protected void addOption(StringBuffer sb, String label, String value, boolean matched) {
        sb.append("<option value=\"");
        sb.append(value);
        sb.append("\"");
        if (matched) {
            sb.append(" selected=\"selected\"");
        }
        if (this.style != null) {
            sb.append(" style=\"");
            sb.append(this.style);
            sb.append("\"");
        }
        if (this.styleClass != null) {
            sb.append(" class=\"");
            sb.append(this.styleClass);
            sb.append("\"");
        }
        sb.append(">");
        sb.append(label);
        sb.append("</option>\r\n");
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
    }
}

