/*
 * Decompiled with CFR 0.152.
 */
package com.chinaunicom.base.dict.util;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Properties;
import java.util.UUID;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ApplicationUtils {
    private static final Log LOGGER = LogFactory.getLog(ApplicationUtils.class);
    private static final Properties PROPS = new Properties();

    public static final String getEnvProp(String name) {
        return PROPS.getProperty(name);
    }

    public static String randomUUID() {
        return UUID.randomUUID().toString();
    }

    public static String md5Hex(String value) {
        return DigestUtils.md5Hex((String)value);
    }

    public static String sha1Hex(String value) {
        return DigestUtils.sha1Hex((String)value);
    }

    public static String sha256Hex(String value) {
        return DigestUtils.sha256Hex((String)value);
    }

    public static String getIpAddr(HttpServletRequest request) {
        String ipAddress = null;
        ipAddress = request.getHeader("x-forwarded-for");
        if (ipAddress == null || ipAddress.length() == 0 || "unknown".equalsIgnoreCase(ipAddress)) {
            ipAddress = request.getHeader("Proxy-Client-IP");
        }
        if (ipAddress == null || ipAddress.length() == 0 || "unknown".equalsIgnoreCase(ipAddress)) {
            ipAddress = request.getHeader("WL-Proxy-Client-IP");
        }
        if ((ipAddress == null || ipAddress.length() == 0 || "unknown".equalsIgnoreCase(ipAddress)) && (ipAddress = request.getRemoteAddr()).equals("127.0.0.1")) {
            InetAddress inet = null;
            try {
                inet = InetAddress.getLocalHost();
            }
            catch (UnknownHostException e) {
                e.printStackTrace();
            }
            ipAddress = inet.getHostAddress();
        }
        if (ipAddress != null && ipAddress.length() > 15 && ipAddress.indexOf(",") > 0) {
            ipAddress = ipAddress.substring(0, ipAddress.indexOf(","));
        }
        return ipAddress;
    }

    static {
        LOGGER.info((Object)"\u52a0\u8f7d[env.properties]");
        String envFile = ApplicationUtils.class.getClassLoader().getResource("env.properties").getFile();
        FileInputStream ins = null;
        try {
            ins = new FileInputStream(envFile);
            PROPS.load(ins);
        }
        catch (FileNotFoundException e) {
            throw new RuntimeException("\u6587\u4ef6[" + envFile + "\u4e0d\u5b58\u5728]", e);
        }
        catch (IOException e) {
            throw new RuntimeException("\u8bfb\u53d6\u6587\u4ef6[" + envFile + "\u9519\u8bef]", e);
        }
        catch (Throwable t) {
            throw new RuntimeException("\u52a0\u8f7d\u6587\u4ef6[" + envFile + "\u9519\u8bef]", t);
        }
        finally {
            if (ins != null) {
                try {
                    ((InputStream)ins).close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            LOGGER.info((Object)"[env.properties]\u52a0\u8f7d\u5b8c\u6bd5");
        }
    }
}

