/*
 * Decompiled with CFR 0.152.
 */
package com.chinaunicom.base.file.oss;

import com.aliyun.oss.ClientConfiguration;
import com.aliyun.oss.ClientException;
import com.aliyun.oss.OSSClient;
import com.aliyun.oss.OSSException;
import com.aliyun.oss.model.GetObjectRequest;
import com.aliyun.oss.model.OSSObject;
import com.aliyun.oss.model.ObjectMetadata;
import com.chinaunicom.base.file.oss.OssConfig;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.util.UUID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OssUtil {
    private static final Logger log = LoggerFactory.getLogger(OssUtil.class);
    private static OSSClient ossClient;

    public static OSSClient getOssclient(OssConfig ossConfig) {
        if (ossClient == null) {
            ClientConfiguration conf = new ClientConfiguration();
            conf.setSupportCname(false);
            ossClient = new OSSClient(ossConfig.getEndpoint(), ossConfig.getAccessKeyId(), ossConfig.getAccessKeySecret(), conf);
        }
        return ossClient;
    }

    public static void uploadFile(File file, OssConfig ossConfig, String uploadPath) {
        String fileName = file.getName();
        try {
            OSSClient ossClient = OssUtil.getOssclient(ossConfig);
            FileInputStream content = new FileInputStream(file);
            ObjectMetadata meta = new ObjectMetadata();
            meta.setContentLength(file.length());
            ossClient.putObject(ossConfig.getBucketName(), uploadPath + fileName, (InputStream)content, meta);
        }
        catch (OSSException e) {
            log.error("\u8fde\u63a5\u8fdc\u7a0boss\u670d\u52a1\u5668\u51fa\u9519\uff01", (Throwable)e);
        }
        catch (FileNotFoundException e) {
            log.error("\u68c0\u67e5\u6587\u4ef6\u3010" + fileName + "\u662f\u5426\u5b58\u5728\u3011", (Throwable)e);
        }
        catch (ClientException e) {
            log.error("\u8fde\u63a5oss\u5ba2\u6237\u7aef\u51fa\u9519\uff01", (Throwable)e);
        }
    }

    public static void uploadFileByInputStream(String fileName, OssConfig ossConfig, InputStream inputStream, String uploadPath) {
        try {
            OSSClient ossClient = OssUtil.getOssclient(ossConfig);
            ossClient.putObject(ossConfig.getBucketName(), uploadPath + fileName, inputStream);
        }
        catch (OSSException e) {
            log.error("\u8fde\u63a5\u8fdc\u7a0boss\u670d\u52a1\u5668\u51fa\u9519\uff01", (Throwable)e);
        }
        catch (ClientException e) {
            log.error("\u8fde\u63a5oss\u5ba2\u6237\u7aef\u51fa\u9519\uff01", (Throwable)e);
        }
    }

    public static void uploadFileToOssByInputStream(String filePath, OssConfig ossConfig, InputStream inputStream) {
        try {
            OSSClient ossClient = OssUtil.getOssclient(ossConfig);
            ossClient.putObject(ossConfig.getBucketName(), filePath, inputStream);
        }
        catch (OSSException e) {
            log.error("\u8fde\u63a5\u8fdc\u7a0boss\u670d\u52a1\u5668\u51fa\u9519\uff01", (Throwable)e);
        }
        catch (ClientException e) {
            log.error("\u8fde\u63a5oss\u5ba2\u6237\u7aef\u51fa\u9519\uff01", (Throwable)e);
        }
    }

    public static File downloadFile(String filePath, OssConfig ossConfig) {
        OSSClient ossClient = OssUtil.getOssclient(ossConfig);
        String fileName = UUID.randomUUID() + filePath.substring(filePath.lastIndexOf("."), filePath.length());
        String dir = System.getProperty("java.io.tmpdir");
        fileName = dir + File.separator + fileName;
        File dirFile = new File(dir);
        if (!dirFile.exists()) {
            dirFile.mkdirs();
        }
        dirFile = new File(fileName);
        try {
            GetObjectRequest getObjectRequest = new GetObjectRequest(ossConfig.getBucketName(), filePath);
            ossClient.getObject(getObjectRequest, dirFile);
        }
        catch (Throwable e) {
            log.error("\u4eceoss\u4e0a\u4e0b\u8f7d\u6587\u4ef6,bucketName\uff1a" + ossConfig.getBucketName() + ";osskey\uff1a" + filePath + ";\u4e0b\u8f7d\u7684\u6587\u4ef6\u8def\u5f84:" + fileName, e);
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new RuntimeException(e);
        }
        return dirFile;
    }

    public static InputStream downloadByInputStream(String filePath, OssConfig ossConfig) {
        InputStream in = null;
        OSSClient ossClient = OssUtil.getOssclient(ossConfig);
        try {
            OSSObject ossObject = ossClient.getObject(ossConfig.getBucketName(), filePath);
            in = ossObject.getObjectContent();
        }
        catch (Throwable e) {
            log.error("\u4eceoss\u4e0a\u4e0b\u8f7d\u6587\u4ef6,bucketName\uff1a" + ossConfig.getBucketName() + ";osskey\uff1a" + filePath, e);
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new RuntimeException(e);
        }
        return in;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void deleteFile(String filePath, OssConfig ossConfig) {
        OSSClient ossClient = OssUtil.getOssclient(ossConfig);
        try {
            ossClient.deleteObject(ossConfig.getBucketName(), filePath);
        }
        catch (OSSException e) {
            log.error("Caught an OSSException, which means your request made it to OSS, but was rejected with an error response for some reason.");
        }
        catch (ClientException e) {
            log.error("Caught an ClientException, which means the client encountered a serious internal problem while trying to communicate with OSS, such as not being able to access the network.");
        }
        finally {
            ossClient.shutdown();
        }
    }
}

