/*
 * Decompiled with CFR 0.152.
 */
package com.chinaunicom.base.fileanalyzing;

import com.chinaunicom.base.fileanalyzing.ParserFactory;
import com.chinaunicom.base.fileanalyzing.ParserRule;
import java.text.DateFormat;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.DateUtil;

public abstract class BaseXlsParser
extends ParserFactory {
    private static final DateFormat DATEFORMAT_YYYY_MM_DD = new SimpleDateFormat("yyyy-MM-dd");
    private static final DecimalFormat DECIMAL_FORMAT = new DecimalFormat("#");
    protected static final int SHEET_INDEX = 0;

    public BaseXlsParser(ParserRule parserRule) {
        super(parserRule);
    }

    protected String getStringCellValue(Cell cell) {
        if (cell == null) {
            return "";
        }
        switch (cell.getCellType()) {
            case 1: {
                return cell.getStringCellValue().trim();
            }
            case 0: {
                if (DateUtil.isCellDateFormatted((Cell)cell)) {
                    return DATEFORMAT_YYYY_MM_DD.format(cell.getDateCellValue()).trim();
                }
                return String.valueOf(DECIMAL_FORMAT.format(cell.getNumericCellValue())).trim();
            }
            case 4: {
                return String.valueOf(cell.getBooleanCellValue()).trim();
            }
            case 3: {
                return "";
            }
        }
        return "";
    }
}

