/*
 * Decompiled with CFR 0.152.
 */
package com.chinaunicom.base.fileanalyzing;

import com.chinaunicom.base.fileanalyzing.FileParserResult;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipInputStream;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CardInputStoreZipParser {
    private static Logger logger = LoggerFactory.getLogger(CardInputStoreZipParser.class);
    private static final String SPLIT_EN = " ";
    private static final String SPLIT_POS = " ";
    private static final String SPLIT_IND = " ";
    private static final String SPLIT_TXT = ",";
    private static final String SUFFIX_EN = ".en";
    private static final String SUFFIX_POS = ".pos";
    private static final String SUFFIX_IND = ".ind";
    private static final String SUFFIX_TXT = ".txt";
    private static final String KEY_IMSI = "imsi";
    private static final String KEY_ICCID = "iccid";
    private static final String KEY_PIN1 = "pin";
    private static final String KEY_PIN2 = "pin2";
    private static final String KEY_PUK1 = "puk";
    private static final String KEY_PUK2 = "puk2";
    private static final String KEY_KEY = "key";
    private static final String KEY_A4 = "afourKey";
    private static final String KEY_OP = "opKey";
    private static final String KEY_DEVICE_NUMBER = "deviceNumber";
    private static final String KEY_PROD_ID = "prodId";
    private static final String KEY_EXP_DATE = "expDate";

    public List<Map<String, String>> parseTxt(String directory) {
        logger.debug("\u89e3\u6790\u5165\u5e93\u901a\u77e5\u4e2d\u7684txt\u6587\u4ef6");
        logger.debug("\u5165\u53c2\uff0cdirectory = " + directory);
        File file = new File(directory);
        return null;
    }

    private FileParserResult unzip(File file) throws IOException {
        String[] lineData;
        String line;
        BufferedReader br;
        String childFileName;
        ZipEntry ze;
        ZipFile zipFile = new ZipFile(file);
        HashMap<String, Map> tempMap = new HashMap<String, Map>();
        ZipInputStream zipInputStream = new ZipInputStream(new BufferedInputStream(new FileInputStream(file)));
        while ((ze = zipInputStream.getNextEntry()) != null) {
            String imsi;
            if (ze.isDirectory() || ze.getSize() <= 0L) continue;
            childFileName = ze.getName();
            if (childFileName.endsWith(SUFFIX_EN)) {
                br = new BufferedReader(new InputStreamReader(zipFile.getInputStream(ze)));
                while (StringUtils.isNotBlank((CharSequence)(line = br.readLine()))) {
                    lineData = line.split(" ");
                    imsi = lineData[0];
                    String key = lineData[1];
                    HashMap<String, String> map = (HashMap<String, String>)tempMap.get(imsi);
                    if (map == null) {
                        map = new HashMap<String, String>();
                    }
                    map.put(KEY_IMSI, imsi.trim());
                    map.put(KEY_KEY, key.trim());
                    tempMap.put(imsi, map);
                }
                br.close();
                continue;
            }
            if (childFileName.endsWith(SUFFIX_POS)) {
                br = new BufferedReader(new InputStreamReader(zipFile.getInputStream(ze)));
                while (StringUtils.isNotBlank((CharSequence)(line = br.readLine()))) {
                    lineData = line.split(" ");
                    imsi = lineData[0];
                    String iccid = lineData[1];
                    String pin1 = lineData[2];
                    String pin2 = lineData[3];
                    String puk1 = lineData[4];
                    String puk2 = lineData[5];
                    HashMap<String, String> map = (HashMap<String, String>)tempMap.get(imsi);
                    if (map == null) {
                        map = new HashMap<String, String>();
                    }
                    map.put(KEY_IMSI, imsi.trim());
                    map.put(KEY_ICCID, iccid.trim());
                    map.put(KEY_PIN1, pin1.trim());
                    map.put(KEY_PIN2, pin2.trim());
                    map.put(KEY_PUK1, puk1.trim());
                    map.put(KEY_PUK2, puk2.trim());
                    tempMap.put(imsi, map);
                }
                br.close();
                continue;
            }
            if (!childFileName.endsWith(SUFFIX_IND)) continue;
            br = new BufferedReader(new InputStreamReader(zipFile.getInputStream(ze)));
            while (StringUtils.isNotBlank((CharSequence)(line = br.readLine()))) {
                lineData = line.split(" ");
                imsi = lineData[0];
                String a4 = lineData[1];
                String op = lineData[2];
                HashMap<String, String> map = (HashMap<String, String>)tempMap.get(imsi);
                if (map == null) {
                    map = new HashMap<String, String>();
                }
                map.put(KEY_IMSI, imsi.trim());
                map.put(KEY_A4, a4.trim());
                map.put(KEY_OP, op.trim());
                tempMap.put(imsi, map);
            }
            br.close();
        }
        zipInputStream.closeEntry();
        zipInputStream.close();
        zipInputStream = new ZipInputStream(new BufferedInputStream(new FileInputStream(file)));
        while ((ze = zipInputStream.getNextEntry()) != null) {
            childFileName = ze.getName();
            if (!childFileName.endsWith(SUFFIX_TXT)) continue;
            br = new BufferedReader(new InputStreamReader(zipFile.getInputStream(ze)));
            while (StringUtils.isNotBlank((CharSequence)(line = br.readLine()))) {
                lineData = line.split(SPLIT_TXT);
                String iccid = lineData[0];
                String imsi = lineData[1];
                String deviceNumber = lineData[2];
                String prodId = lineData[3];
                String expDate = lineData[4];
                Map map = (Map)tempMap.get(imsi);
                if (map == null || !iccid.equals(map.get(KEY_ICCID))) continue;
                map.put(KEY_DEVICE_NUMBER, deviceNumber.trim());
                map.put(KEY_PROD_ID, prodId.trim());
                map.put(KEY_EXP_DATE, expDate.trim());
                tempMap.put(imsi, map);
            }
            br.close();
        }
        zipInputStream.closeEntry();
        zipInputStream.close();
        FileParserResult fileParserResult = new FileParserResult();
        fileParserResult.setTotal(tempMap.size());
        fileParserResult.setData(new ArrayList<Map<String, Object>>(tempMap.values()));
        zipFile.close();
        tempMap = null;
        return fileParserResult;
    }

    public static void main(String[] args) {
    }
}

