/*
 * Decompiled with CFR 0.152.
 */
package com.chinaunicom.base.fileanalyzing;

import com.chinaunicom.base.fileanalyzing.IRowReader;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.poi.openxml4j.opc.OPCPackage;
import org.apache.poi.ss.usermodel.BuiltinFormats;
import org.apache.poi.ss.usermodel.DataFormatter;
import org.apache.poi.xssf.eventusermodel.XSSFReader;
import org.apache.poi.xssf.model.SharedStringsTable;
import org.apache.poi.xssf.model.StylesTable;
import org.apache.poi.xssf.usermodel.XSSFCellStyle;
import org.apache.poi.xssf.usermodel.XSSFRichTextString;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;
import org.xml.sax.helpers.XMLReaderFactory;

public class Excel2007Reader<T>
extends DefaultHandler {
    private SharedStringsTable sst;
    private String lastContents;
    private boolean nextIsString;
    private int sheetIndex = -1;
    private List<String> rowlist = new ArrayList<String>();
    private int curRow = 0;
    private int curCol = 0;
    private boolean dateFlag;
    private boolean numberFlag;
    private CellDataType nextDataType = CellDataType.SSTINDEX;
    private boolean isTElement;
    private IRowReader<T> rowReader;
    private final DataFormatter formatter = new DataFormatter();
    private short formatIndex;
    private String formatString;
    private StylesTable stylesTable;
    private String maxRef = null;

    public void setRowReader(IRowReader<T> rowReader) {
        this.rowReader = rowReader;
    }

    public void processOneSheet(String filename, int sheetId) throws Exception {
        OPCPackage pkg = OPCPackage.open((String)filename);
        XSSFReader r = new XSSFReader(pkg);
        SharedStringsTable sst = r.getSharedStringsTable();
        XMLReader parser = this.fetchSheetParser(sst);
        InputStream sheet2 = r.getSheet("rId" + sheetId);
        ++this.sheetIndex;
        InputSource sheetSource = new InputSource(sheet2);
        parser.parse(sheetSource);
        sheet2.close();
    }

    public void process(String filename) throws Exception {
        OPCPackage pkg = OPCPackage.open((String)filename);
        XSSFReader r = new XSSFReader(pkg);
        this.stylesTable = r.getStylesTable();
        SharedStringsTable sst = r.getSharedStringsTable();
        XMLReader parser = this.fetchSheetParser(sst);
        Iterator sheets = r.getSheetsData();
        while (sheets.hasNext()) {
            this.curRow = 0;
            ++this.sheetIndex;
            InputStream sheet = (InputStream)sheets.next();
            InputSource sheetSource = new InputSource(sheet);
            parser.parse(sheetSource);
            sheet.close();
        }
    }

    public XMLReader fetchSheetParser(SharedStringsTable sst) throws SAXException {
        XMLReader parser = XMLReaderFactory.createXMLReader("org.apache.xerces.parsers.SAXParser");
        this.sst = sst;
        parser.setContentHandler(this);
        return parser;
    }

    @Override
    public void startElement(String uri, String localName, String name, Attributes attributes) throws SAXException {
        this.setNextDataType(attributes);
        if ("c".equals(name)) {
            String cellType = attributes.getValue("t");
            this.nextIsString = "s".equals(cellType);
        }
        this.isTElement = "t".equals(name);
        this.lastContents = "";
    }

    @Override
    public void endElement(String uri, String localName, String name) throws SAXException {
        if (this.nextIsString) {
            try {
                int idx = Integer.parseInt(this.lastContents);
                this.lastContents = new XSSFRichTextString(this.sst.getEntryAt(idx)).toString();
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        if (this.isTElement) {
            String value = this.lastContents.trim();
            this.rowlist.add(this.curCol, value);
            ++this.curCol;
            this.isTElement = false;
        } else if ("v".equals(name)) {
            String value = this.getDataValue(this.lastContents.trim(), "");
            this.rowlist.add(this.curCol, value);
            ++this.curCol;
        } else if (name.equals("row")) {
            this.rowReader.setRows(this.sheetIndex, this.curRow, this.rowlist);
            this.rowlist.clear();
            ++this.curRow;
            this.curCol = 0;
        }
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        this.lastContents = this.lastContents + new String(ch, start, length);
    }

    public void setNextDataType(Attributes attributes) {
        this.nextDataType = CellDataType.NUMBER;
        this.formatIndex = (short)-1;
        this.formatString = null;
        String cellType = attributes.getValue("t");
        String cellStyleStr = attributes.getValue("s");
        String columData = attributes.getValue("r");
        if ("b".equals(cellType)) {
            this.nextDataType = CellDataType.BOOL;
        } else if ("e".equals(cellType)) {
            this.nextDataType = CellDataType.ERROR;
        } else if ("inlineStr".equals(cellType)) {
            this.nextDataType = CellDataType.INLINESTR;
        } else if ("s".equals(cellType)) {
            this.nextDataType = CellDataType.SSTINDEX;
        } else if ("str".equals(cellType)) {
            this.nextDataType = CellDataType.FORMULA;
        }
        if (cellStyleStr != null) {
            int styleIndex = Integer.parseInt(cellStyleStr);
            XSSFCellStyle style = this.stylesTable.getStyleAt(styleIndex);
            this.formatIndex = style.getDataFormat();
            this.formatString = style.getDataFormatString();
            if ("m/d/yy" == this.formatString) {
                this.nextDataType = CellDataType.DATE;
                this.formatString = "yyyy-MM-dd hh:mm:ss.SSS";
            }
            if (this.formatString == null) {
                this.nextDataType = CellDataType.NULL;
                this.formatString = BuiltinFormats.getBuiltinFormat((int)this.formatIndex);
            }
        }
    }

    public String getDataValue(String value, String thisStr) {
        switch (this.nextDataType) {
            case BOOL: {
                char first = value.charAt(0);
                thisStr = first == '0' ? "FALSE" : "TRUE";
                break;
            }
            case ERROR: {
                thisStr = "\"ERROR:" + value.toString() + '\"';
                break;
            }
            case FORMULA: {
                thisStr = '\"' + value.toString() + '\"';
                break;
            }
            case INLINESTR: {
                XSSFRichTextString rtsi = new XSSFRichTextString(value.toString());
                thisStr = rtsi.toString();
                rtsi = null;
                break;
            }
            case SSTINDEX: {
                String sstIndex = value.toString();
                try {
                    int idx = Integer.parseInt(sstIndex);
                    XSSFRichTextString rtss = new XSSFRichTextString(this.sst.getEntryAt(idx));
                    thisStr = rtss.toString();
                    rtss = null;
                }
                catch (NumberFormatException ex) {
                    thisStr = value.toString();
                }
                break;
            }
            case NUMBER: {
                thisStr = this.formatString != null ? this.formatter.formatRawCellContents(Double.parseDouble(value), (int)this.formatIndex, this.formatString).trim() : value;
                thisStr = thisStr.replace("_", "").trim();
                break;
            }
            case DATE: {
                thisStr = this.formatter.formatRawCellContents(Double.parseDouble(value), (int)this.formatIndex, this.formatString);
                thisStr = thisStr.replace(" ", "T");
                break;
            }
            default: {
                thisStr = " ";
            }
        }
        return thisStr;
    }

    public int countNullCell(String ref, String preRef) {
        String xfd = ref.replaceAll("\\d+", "");
        String xfd_1 = preRef.replaceAll("\\d+", "");
        xfd = this.fillChar(xfd, 3, '@', true);
        xfd_1 = this.fillChar(xfd_1, 3, '@', true);
        char[] letter = xfd.toCharArray();
        char[] letter_1 = xfd_1.toCharArray();
        int res = (letter[0] - letter_1[0]) * 26 * 26 + (letter[1] - letter_1[1]) * 26 + (letter[2] - letter_1[2]);
        return res - 1;
    }

    String fillChar(String str, int len, char let, boolean isPre) {
        block4: {
            int len_1 = str.length();
            if (len_1 >= len) break block4;
            if (isPre) {
                for (int i = 0; i < len - len_1; ++i) {
                    str = let + str;
                }
            } else {
                for (int i = 0; i < len - len_1; ++i) {
                    str = str + let;
                }
            }
        }
        return str;
    }

    static enum CellDataType {
        BOOL,
        ERROR,
        FORMULA,
        INLINESTR,
        SSTINDEX,
        NUMBER,
        DATE,
        NULL;

    }
}

