/*
 * Decompiled with CFR 0.152.
 */
package com.chinaunicom.base.fileanalyzing;

import com.chinaunicom.base.fileanalyzing.Excel2003Reader;
import com.chinaunicom.base.fileanalyzing.Excel2007Reader;
import com.chinaunicom.base.fileanalyzing.IRowReader;
import com.chinaunicom.base.fileanalyzing.TxtReader;
import com.chinaunicom.common.exception.ResourceException;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileReaderUtil {
    private static final Logger log = LoggerFactory.getLogger(FileReaderUtil.class);
    public static final String EXCEL03_EXTENSION = ".xls";
    public static final String EXCEL07_EXTENSION = ".xlsx";
    public static final String TXT_EXTENSION = ".txt";
    public static final String DATA_EXTENSION = ".data";

    public static <T> int readExcel(IRowReader<T> reader, String fileName) throws Exception {
        String suffix = fileName.substring(fileName.lastIndexOf("."));
        if (EXCEL03_EXTENSION.equalsIgnoreCase(suffix)) {
            Excel2003Reader<T> excel03 = new Excel2003Reader<T>();
            excel03.setRowReader(reader);
            excel03.process(fileName);
        } else if (EXCEL07_EXTENSION.equalsIgnoreCase(suffix)) {
            Excel2007Reader<T> excel07 = new Excel2007Reader<T>();
            excel07.setRowReader(reader);
            excel07.process(fileName);
        } else if (TXT_EXTENSION.equalsIgnoreCase(suffix)) {
            TxtReader<T> txt = new TxtReader<T>();
            txt.setRowReader(reader);
            txt.process(fileName);
        } else if (fileName.endsWith(DATA_EXTENSION)) {
            TxtReader<T> txt = new TxtReader<T>();
            txt.setRowReader(reader);
            txt.process(fileName);
        } else {
            log.error("\u6587\u4ef6\u683c\u5f0f\u9519\u8bef\uff0cfileName\u7684\u6269\u5c55\u540d\u53ea\u80fd\u662fxls\u6216xlsx\u6216\u6587\u672c\u683c\u5f0f");
            throw new ResourceException("S100", "\u6587\u4ef6\u683c\u5f0f\u9519\u8bef\uff0cfileName\u7684\u6269\u5c55\u540d\u53ea\u80fd\u662fxls\u6216xlsx\u6216txt\u3002");
        }
        return reader.getToTalSize();
    }

    public static <T> List<T> readExcelByPage(IRowReader<T> reader, String fileName, int fromSize, int toSize) throws Exception {
        reader.setJustGetTotalSize(true);
        FileReaderUtil.readExcel(reader, fileName);
        reader.setJustGetTotalSize(false);
        reader.setFromSize(fromSize);
        reader.setToSize(toSize);
        reader.setReadByPage(true);
        FileReaderUtil.readExcel(reader, fileName);
        return reader.getFetchData();
    }

    public static <T> int readExcelByBtach(IRowReader<T> reader, String fileName, int batchNum) throws Exception {
        reader.setJustGetTotalSize(true);
        FileReaderUtil.readExcel(reader, fileName);
        reader.setJustGetTotalSize(false);
        reader.setToSize(batchNum);
        return FileReaderUtil.readExcel(reader, fileName);
    }
}

