/*
 * Decompiled with CFR 0.152.
 */
package com.chinaunicom.base.fileanalyzing;

import com.alibaba.fastjson.JSONObject;
import com.chinaunicom.base.fileanalyzing.FileParserResult;
import com.chinaunicom.base.fileanalyzing.ParserFactory;
import com.chinaunicom.base.fileanalyzing.ParserRule;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public class IndexOutParser
extends ParserFactory {
    public IndexOutParser(ParserRule parserRule) {
        super(parserRule);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public FileParserResult parse() {
        File file = this.parserRule.getTargetFile();
        FileParserResult fileParserResult = new FileParserResult();
        ArrayList<Map<String, Object>> result = new ArrayList<Map<String, Object>>();
        try (BufferedReader reader = null;){
            reader = new BufferedReader(new FileReader(file));
            String line = null;
            HashMap<String, String> map = null;
            JSONObject indexToFieldNameRule = this.parserRule.get("keyIndexToFieldName");
            String separator = this.parserRule.getSeparator();
            int i = 0;
            while ((line = reader.readLine()) != null) {
                if (i >= this.parserRule.getLineIndex()) {
                    if (StringUtils.isBlank((CharSequence)line)) continue;
                    map = new HashMap<String, String>();
                    String[] values = line.split(separator);
                    int len = values.length;
                    for (int j = 0; j < len; ++j) {
                        String value = values[j];
                        map.put(indexToFieldNameRule.getString(String.valueOf(j)), value.trim());
                    }
                    result.add(map);
                }
                ++i;
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        fileParserResult.setData(result);
        fileParserResult.setTotal(result.size());
        return fileParserResult;
    }

    public static void main(String[] args) {
        File file = new File("G:\\card_22.txt");
        ParserRule rule = new ParserRule();
        JSONObject indexToFieldNameJson = new JSONObject();
        indexToFieldNameJson.put("0", (Object)"name");
        indexToFieldNameJson.put("1", (Object)"code");
        rule.setSeparator(" ");
        rule.put("keyIndexToFieldName", indexToFieldNameJson);
        rule.setTargetFile(file);
        IndexOutParser indexTxtParser = new IndexOutParser(rule);
        FileParserResult result = indexTxtParser.parse();
        System.out.println(result);
    }
}

