/*
 * Decompiled with CFR 0.152.
 */
package com.chinaunicom.base.fileanalyzing;

import com.alibaba.fastjson.JSONObject;
import com.chinaunicom.base.fileanalyzing.FileParserResult;
import com.chinaunicom.base.fileanalyzing.IndexTxtParser;
import com.chinaunicom.base.fileanalyzing.IndexXlsParser;
import com.chinaunicom.base.fileanalyzing.ParserRule;
import com.chinaunicom.base.fileanalyzing.SimpleTxtParser;
import com.chinaunicom.base.fileanalyzing.SimpleXlsParser;
import com.chinaunicom.base.fileanalyzing.TitleTxtParser;
import com.chinaunicom.base.fileanalyzing.TitleXlsParser;
import java.io.File;

public abstract class ParserFactory {
    public static final String FILE_TYPE_TXT = "txt";
    public static final String FILE_TYPE_XLS = "xls";
    public static final String ANALYZING_TYPE_SIMPLE = "simple";
    public static final String ANALYZING_TYPE_INDEX = "index";
    public static final String ANALYZING_TYPE_TITLE = "title";
    protected ParserRule parserRule;

    public ParserFactory(ParserRule parserRule) {
        this.parserRule = parserRule;
    }

    public abstract FileParserResult parse();

    public static ParserFactory newInstance(ParserRule parserRule) {
        String fileType = parserRule.getTargetFileType();
        String analyzingType = parserRule.getAnalyzingType();
        if (FILE_TYPE_TXT.equalsIgnoreCase(fileType)) {
            if (ANALYZING_TYPE_SIMPLE.equalsIgnoreCase(analyzingType)) {
                return new SimpleTxtParser(parserRule);
            }
            if (ANALYZING_TYPE_INDEX.equalsIgnoreCase(analyzingType)) {
                return new IndexTxtParser(parserRule);
            }
            if (ANALYZING_TYPE_TITLE.equalsIgnoreCase(analyzingType)) {
                return new TitleTxtParser(parserRule);
            }
        }
        if (FILE_TYPE_XLS.equalsIgnoreCase(fileType)) {
            if (ANALYZING_TYPE_SIMPLE.equalsIgnoreCase(analyzingType)) {
                return new SimpleXlsParser(parserRule);
            }
            if (ANALYZING_TYPE_INDEX.equalsIgnoreCase(analyzingType)) {
                return new IndexXlsParser(parserRule);
            }
            if (ANALYZING_TYPE_TITLE.equalsIgnoreCase(analyzingType)) {
                return new TitleXlsParser(parserRule);
            }
        }
        return null;
    }

    public static FileParserResult parseFile(ParserRule parserRule) {
        return ParserFactory.newInstance(parserRule).parse();
    }

    public static void main(String[] args) {
        File file = new File("C:\\Users\\Administrator\\Desktop\\filetest.txt");
        ParserRule rule = new ParserRule();
        JSONObject indexToFieldNameJson = new JSONObject();
        indexToFieldNameJson.put("0", (Object)"name");
        rule.put("keyIndexToFieldName", indexToFieldNameJson);
        rule.setTargetFile(file);
        rule.setTargetFileType(FILE_TYPE_TXT);
        rule.setAnalyzingType(ANALYZING_TYPE_SIMPLE);
        System.out.println(ParserFactory.parseFile(rule));
    }
}

