/*
 * Decompiled with CFR 0.152.
 */
package com.chinaunicom.base.fileanalyzing;

import com.alibaba.fastjson.JSONObject;
import com.chinaunicom.base.fileanalyzing.BaseXlsParser;
import com.chinaunicom.base.fileanalyzing.FileParserResult;
import com.chinaunicom.base.fileanalyzing.ParserRule;
import com.chinaunicom.common.exception.ResourceException;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.WorkbookFactory;

public class SimpleXlsParser
extends BaseXlsParser {
    public SimpleXlsParser(ParserRule parserRule) {
        super(parserRule);
    }

    @Override
    public FileParserResult parse() {
        File file = this.parserRule.getTargetFile();
        FileParserResult fileParserResult = new FileParserResult();
        ArrayList<Map<String, Object>> result = new ArrayList<Map<String, Object>>();
        try {
            Sheet sheet = WorkbookFactory.create((File)file).getSheetAt(0);
            int rowTotal = sheet.getLastRowNum();
            for (int i = this.parserRule.getLineIndex(); i <= rowTotal; ++i) {
                Row row = sheet.getRow(i);
                if (row == null) continue;
                JSONObject indexToFieldNameRule = this.parserRule.get("keyIndexToFieldName");
                HashMap<String, String> map = new HashMap<String, String>();
                String value = this.getStringCellValue(row.getCell(0));
                map.put(indexToFieldNameRule.getString(String.valueOf("0")), value);
                result.add(map);
            }
            fileParserResult.setTotal(rowTotal - this.parserRule.getLineIndex());
        }
        catch (Exception e) {
            throw new ResourceException("F003", "Excel\u89e3\u6790\u5931\u8d25\uff01\u8bf7\u68c0\u67e5excel\u6587\u4ef6\u3010" + file.getName() + "\u3011\uff01", (Throwable)e);
        }
        fileParserResult.setData(result);
        return fileParserResult;
    }

    public static void main(String[] args) {
        File file = new File("g:\\simpleXls.xls");
        ParserRule rule = new ParserRule();
        JSONObject indexToFieldNameJson = new JSONObject();
        indexToFieldNameJson.put("0", (Object)"name");
        rule.put("keyIndexToFieldName", indexToFieldNameJson);
        rule.setTargetFile(file);
        SimpleXlsParser simpleXlsParser = new SimpleXlsParser(rule);
        FileParserResult result = simpleXlsParser.parse();
        System.out.println(result);
    }
}

