/*
 * Decompiled with CFR 0.152.
 */
package com.chinaunicom.base.fileanalyzing;

import com.alibaba.fastjson.JSONObject;
import com.chinaunicom.base.fileanalyzing.FileParserResult;
import com.chinaunicom.base.fileanalyzing.ParserFactory;
import com.chinaunicom.base.fileanalyzing.ParserRule;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public class SyncFileParser
extends ParserFactory {
    public SyncFileParser(ParserRule parserRule) {
        super(parserRule);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public FileParserResult parse() {
        File file = this.parserRule.getTargetFile();
        FileParserResult fileParserResult = new FileParserResult();
        ArrayList<Map<String, Object>> result = new ArrayList<Map<String, Object>>();
        try (BufferedReader reader = null;){
            reader = new BufferedReader(new FileReader(file));
            String line = null;
            HashMap<String, String> map = null;
            JSONObject indexToFieldNameRule = this.parserRule.get("keyIndexToFieldName");
            String separator = this.parserRule.getSeparator();
            while ((line = reader.readLine()) != null) {
                if (StringUtils.isBlank((CharSequence)line) || !line.contains(separator)) continue;
                line = line.replace("0x0d0x0a", "");
                map = new HashMap<String, String>();
                String[] values = line.split("\\" + separator);
                int len = values.length;
                for (int j = 0; j < len; ++j) {
                    String value = values[j];
                    map.put(indexToFieldNameRule.getString(String.valueOf(j)), value.trim());
                }
                result.add(map);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        fileParserResult.setData(result);
        fileParserResult.setTotal(result.size());
        return fileParserResult;
    }

    public static void main(String[] args) {
        File file = new File("G:\\test.DATA");
        ParserRule rule = new ParserRule();
        JSONObject indexToFieldNameJson = new JSONObject();
        indexToFieldNameJson.put("0", (Object)"hlrNo");
        indexToFieldNameJson.put("1", (Object)"hlrName");
        indexToFieldNameJson.put("2", (Object)"hlrDesc");
        indexToFieldNameJson.put("3", (Object)"provCode");
        indexToFieldNameJson.put("4", (Object)"cityCode");
        rule.setSeparator("|");
        rule.put("keyIndexToFieldName", indexToFieldNameJson);
        rule.setTargetFile(file);
        SyncFileParser indexTxtParser = new SyncFileParser(rule);
        FileParserResult result = indexTxtParser.parse();
        System.out.println(result);
    }
}

