/*
 * Decompiled with CFR 0.152.
 */
package com.chinaunicom.base.fileanalyzing;

import com.alibaba.fastjson.JSONObject;
import com.chinaunicom.base.fileanalyzing.FileParserResult;
import com.chinaunicom.base.fileanalyzing.ParserFactory;
import com.chinaunicom.base.fileanalyzing.ParserRule;
import com.chinaunicom.common.exception.ResourceException;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public class TitleTxtParser
extends ParserFactory {
    public TitleTxtParser(ParserRule parserRule) {
        super(parserRule);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public FileParserResult parse() {
        File file = this.parserRule.getTargetFile();
        FileParserResult fileParserResult = new FileParserResult();
        ArrayList<Map<String, Object>> result = new ArrayList<Map<String, Object>>();
        try (BufferedReader reader = null;){
            reader = new BufferedReader(new FileReader(file));
            String line = null;
            String title = reader.readLine();
            if (title == null) {
                throw new ResourceException("F004", "\u8be5\u6a21\u677f\u7c7b\u578b\u5fc5\u987b\u6709\u6807\u9898!");
            }
            HashMap map = null;
            JSONObject titleToFieldNameRule = this.parserRule.get("keyTitleToFieldName");
            String separator = this.parserRule.getSeparator();
            ArrayList<String> titleCode = new ArrayList<String>();
            for (String value : title.split(separator)) {
                String fieldName = titleToFieldNameRule.getString(value);
                titleCode.add(fieldName);
            }
            while ((line = reader.readLine()) != null) {
                if (StringUtils.isBlank((CharSequence)line)) continue;
                map = new HashMap();
                String[] values = line.split(separator);
                int len = values.length;
                for (int j = 0; j < len; ++j) {
                    String value = values[j];
                    map.put(titleCode.get(j), value.trim());
                }
                result.add(map);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        fileParserResult.setData(result);
        fileParserResult.setTotal(result.size());
        return fileParserResult;
    }

    public static void main(String[] args) {
        File file = new File("E:\\filetest\\title.txt");
        ParserRule rule = new ParserRule();
        JSONObject titleToFieldNameJson = new JSONObject();
        titleToFieldNameJson.put("\u59d3\u540d", (Object)"name");
        titleToFieldNameJson.put("\u5e74\u9f84", (Object)"age");
        rule.put("keyTitleToFieldName", titleToFieldNameJson);
        rule.put("ruleDecimalFormatter", "########.##");
        rule.setTargetFile(file);
        TitleTxtParser titleTxtParser = new TitleTxtParser(rule);
        titleTxtParser.parserRule = rule;
        FileParserResult result = titleTxtParser.parse();
        System.out.println(result);
    }
}

