/*
 * Decompiled with CFR 0.152.
 */
package com.chinaunicom.base.fileanalyzing;

import com.alibaba.fastjson.JSONObject;
import com.chinaunicom.base.fileanalyzing.BaseXlsParser;
import com.chinaunicom.base.fileanalyzing.FileParserResult;
import com.chinaunicom.base.fileanalyzing.ParserRule;
import com.chinaunicom.common.exception.ResourceException;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.WorkbookFactory;

public class TitleXlsParser
extends BaseXlsParser {
    public TitleXlsParser(ParserRule parserRule) {
        super(parserRule);
    }

    @Override
    public FileParserResult parse() {
        File file = this.parserRule.getTargetFile();
        FileParserResult fileParserResult = new FileParserResult();
        ArrayList<Map<String, Object>> result = new ArrayList<Map<String, Object>>();
        try {
            Sheet sheet = WorkbookFactory.create((File)file).getSheetAt(0);
            int rowTotal = sheet.getLastRowNum();
            Row titleRow = sheet.getRow(0);
            if (titleRow == null) {
                throw new ResourceException("F004", "\u8be5\u6a21\u677f\u7c7b\u578b\u5fc5\u987b\u6709\u6807\u9898!");
            }
            JSONObject titleToFieldNameRule = this.parserRule.get("keyTitleToFieldName");
            ArrayList<String> titleCode = new ArrayList<String>();
            int columCount = titleRow.getLastCellNum();
            for (int j = 0; j < columCount; ++j) {
                String value = this.getStringCellValue(titleRow.getCell(j));
                String fieldName = titleToFieldNameRule.getString(value);
                titleCode.add(fieldName);
            }
            for (int i = 1; i <= rowTotal; ++i) {
                Row row = sheet.getRow(i);
                if (row == null) continue;
                HashMap map = new HashMap();
                int columCount2 = row.getLastCellNum();
                for (int j = 0; j < columCount2; ++j) {
                    String value = this.getStringCellValue(row.getCell(j));
                    map.put(titleCode.get(j), value);
                }
                result.add(map);
            }
            fileParserResult.setTotal(rowTotal);
        }
        catch (Exception e) {
            throw new ResourceException("F003", "Excel\u89e3\u6790\u5931\u8d25\uff01\u8bf7\u68c0\u67e5excel\u6587\u4ef6\u3010" + file.getName() + "\u3011\uff01", (Throwable)e);
        }
        fileParserResult.setData(result);
        return fileParserResult;
    }

    public static void main(String[] args) {
        File file = new File("E:\\filetest\\test.xlsx");
        ParserRule rule = new ParserRule();
        JSONObject titleToFieldNameJson = new JSONObject();
        titleToFieldNameJson.put("\u59d3\u540d", (Object)"name");
        titleToFieldNameJson.put("\u7f16\u7801", (Object)"code");
        rule.put("keyTitleToFieldName", titleToFieldNameJson);
        rule.put("ruleDecimalFormatter", "########.##");
        rule.setTargetFile(file);
        TitleXlsParser titleXlsParser = new TitleXlsParser(rule);
        titleXlsParser.parserRule = rule;
        FileParserResult result = titleXlsParser.parse();
        System.out.println(result);
    }
}

