/*
 * Decompiled with CFR 0.152.
 */
package com.chinaunicom.base.fileanalyzing;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UnCompressGZFile {
    private static Logger log = LoggerFactory.getLogger(UnCompressGZFile.class);

    public static String getFileName(String fileName) {
        String fname = "";
        int i = fileName.lastIndexOf(46);
        if (i > 0 && i < fileName.length() - 1) {
            fname = fileName.substring(0, i);
        }
        return fname;
    }

    public static String getExtension(String fileName) {
        String ext = "";
        int i = fileName.lastIndexOf(46);
        if (i > 0 && i < fileName.length() - 1) {
            ext = fileName.substring(i + 1);
        }
        return ext;
    }

    public static String unCompressGZFile(String inFile) {
        GZIPInputStream in = null;
        try {
            in = new GZIPInputStream(new FileInputStream(inFile));
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        String outFileName = UnCompressGZFile.getFileName(inFile);
        FileOutputStream fo = null;
        try {
            int len;
            fo = new FileOutputStream(outFileName);
            byte[] buf = new byte[1024];
            while ((len = in.read(buf)) > 0) {
                fo.write(buf, 0, len);
            }
            fo.flush();
            in.close();
            fo.close();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        log.debug("\u4e0b\u8f7d\u5230\u672c\u5730\u8def\u5f84\uff1a" + outFileName);
        return outFileName;
    }

    public static String compressFile(String inFileName, String prefix) {
        File file = new File(inFileName);
        String str = file.getPath().substring(0, file.getPath().indexOf(file.getName())) + prefix + file.getName().substring(1);
        String outFileName = str + ".gz";
        FileInputStream in = null;
        try {
            in = new FileInputStream(new File(inFileName));
        }
        catch (FileNotFoundException e) {
            System.out.println("Could not find the inFile..." + inFileName);
        }
        GZIPOutputStream out = null;
        try {
            out = new GZIPOutputStream(new FileOutputStream(outFileName));
        }
        catch (IOException e) {
            log.debug("Could not find the outFile..." + outFileName);
        }
        byte[] buf = new byte[1024];
        int len = 0;
        try {
            while ((len = in.read(buf)) > 0) {
                out.write(buf, 0, len);
            }
            in.close();
            log.debug("Completing the GZIP file..." + outFileName);
            out.flush();
            out.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return outFileName;
    }

    public static String reNameFile(String inFileName, String prefix) {
        File file = new File(inFileName);
        String str = file.getPath().substring(0, file.getPath().indexOf(file.getName())) + prefix + file.getName().substring(1);
        if (!inFileName.equals(str)) {
            File f = new File(str);
            if (f.exists()) {
                f.delete();
            }
            file.renameTo(f);
        }
        return str;
    }

    public static void main(String[] args) {
        UnCompressGZFile.compressFile("E:\\t_area\\1102\\C_B_09_BSDM_CHL_20161102_0001_A_1.XML", "E");
    }
}

