/*
 * Decompiled with CFR 0.152.
 */
package com.chinaunicom.base.mq;

import com.aliyun.openservices.ons.api.Consumer;
import com.aliyun.openservices.ons.api.MessageListener;
import com.aliyun.openservices.ons.api.ONSFactory;
import com.chinaunicom.base.mq.MqCunsumer;
import com.chinaunicom.base.mq.MqMessageListener;
import com.chinaunicom.base.mq.NativeMqListener;
import com.chinaunicom.base.mq.ProjectNameUtils;
import com.chinaunicom.common.bo.MqSubScribeSingleBO;
import com.chinaunicom.common.cache.service.CacheService;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;

public class MqCunsumerSubscribe
implements ApplicationContextAware {
    private static final Logger log = LoggerFactory.getLogger(MqCunsumerSubscribe.class);
    private final boolean isDebugEnabled = log.isDebugEnabled();
    private static Map<String, Method> localMethods = new HashMap<String, Method>();
    private CacheService cacheService;
    private Properties props;
    private boolean nativeOns = false;
    private static Set<String> excludeConsumerSet = null;
    private static Set<String> excludeReconsumeTimesTopicSet = null;
    public static Map<String, MqCunsumer> nativeTopics = new HashMap<String, MqCunsumer>();

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        ProjectNameUtils pro;
        this.cacheService = (CacheService)applicationContext.getBean("cacheService", CacheService.class);
        this.props = (Properties)applicationContext.getBean("propertyConfigurer", Properties.class);
        if (applicationContext.containsBean("isIntfaceProject") && (pro = (ProjectNameUtils)applicationContext.getBean("isIntfaceProject", ProjectNameUtils.class)).isNeedExcludeMqConsumer()) {
            String[] excludeConsumers = this.props.getProperty("INTERFACE_MQ_CONSUMER", "").split(",");
            excludeConsumerSet = new HashSet<String>(excludeConsumers.length);
            for (String excludeConsumer : excludeConsumers) {
                excludeConsumerSet.add(excludeConsumer.trim());
            }
        }
        String accessKey = this.props.getProperty("ons.AccessKey");
        String secretKey = this.props.getProperty("ons.SecretKey");
        String namesrvAddr = this.props.getProperty("mq.NAMESRV_ADDR");
        String oNSAddr = this.props.getProperty("mq.ONSAddr");
        String maxReconsumeTimes = this.props.getProperty("mq.MAX_RECONSUME_TIMES");
        String excludeReconsumeTimesTopic = this.props.getProperty("mq.EXCLUDE_RECONSUME_TIMES_TOPIC", "");
        if (this.isDebugEnabled) {
            log.debug("excludeReconsumeTimesTopic=[" + excludeReconsumeTimesTopic + "]");
        }
        if (StringUtils.isNotEmpty((CharSequence)excludeReconsumeTimesTopic)) {
            String[] excludeReconsumeTimesTopicArry = excludeReconsumeTimesTopic.split(",");
            excludeReconsumeTimesTopicSet = new HashSet<String>(excludeReconsumeTimesTopicArry.length);
            for (String excludeTopic : excludeReconsumeTimesTopicArry) {
                excludeReconsumeTimesTopicSet.add(excludeTopic.trim());
            }
        }
        if (this.isDebugEnabled) {
            log.debug("namesrvAddr=" + namesrvAddr);
            log.debug("oNSAddr=" + oNSAddr);
            log.debug("maxReconsumeTimes=" + maxReconsumeTimes);
        }
        this.nativeOns = Boolean.parseBoolean(this.props.getProperty("ons.native"));
        Map mqMap = applicationContext.getBeansOfType(MqCunsumer.class);
        for (String key : mqMap.keySet()) {
            MqCunsumer mqc = (MqCunsumer)mqMap.get(key);
            try {
                this.startConsumer(accessKey, secretKey, namesrvAddr, oNSAddr, maxReconsumeTimes, mqc);
            }
            catch (Throwable e) {
                log.error(e.getMessage(), e);
            }
        }
        if (this.nativeOns) {
            NativeMqListener mql = new NativeMqListener(this.cacheService);
            mql.start();
        }
    }

    private void startConsumer(String accessKey, String secretKey, String namesrvAddr, String oNSAddr, String maxReconsumeTimes, MqCunsumer mqc) {
        MqSubScribeSingleBO mqBO;
        if (mqc != null && (mqBO = mqc.subscribe()) != null && StringUtils.isNotBlank((CharSequence)mqBO.getConsumerId()) && StringUtils.isNotBlank((CharSequence)mqBO.getTopic()) && StringUtils.isNotBlank((CharSequence)mqBO.getTag())) {
            if (excludeConsumerSet != null && excludeConsumerSet.contains(mqBO.getConsumerId().trim())) {
                if (this.isDebugEnabled) {
                    log.debug("\u6392\u9664\u7684ConsumerId=" + mqBO.getConsumerId());
                }
                return;
            }
            Properties properties = new Properties();
            String topic = this.props.getProperty(mqBO.getTopic());
            if (StringUtils.isNotBlank((CharSequence)topic)) {
                topic = topic.trim();
            } else {
                log.error("topic\u4e3a" + mqBO.getTopic() + "\u7684\u6d88\u606f\u4e3b\u9898\u914d\u7f6e\u4e0d\u6b63\u786e\uff01\u8bf7\u914d\u7f6e\uff01");
            }
            if (!(CollectionUtils.isNotEmpty(excludeReconsumeTimesTopicSet) && excludeReconsumeTimesTopicSet.contains(mqBO.getTopic().trim()) || !StringUtils.isNotBlank((CharSequence)maxReconsumeTimes))) {
                properties.put("maxReconsumeTimes", maxReconsumeTimes);
            }
            if (this.nativeOns) {
                nativeTopics.put(topic, mqc);
            } else {
                String consumeThreadNumsStr;
                String consumerId = this.props.getProperty(mqBO.getConsumerId());
                if (StringUtils.isNotBlank((CharSequence)consumerId)) {
                    consumerId = consumerId.trim();
                } else {
                    log.error("\u6d88\u8d39\u8005id\u4e3a" + mqBO.getConsumerId() + "\u7684\u6d88\u8d39\u8005\u914d\u7f6e\u4e0d\u6b63\u786e\uff01\u8bf7\u914d\u7f6e\uff01");
                }
                properties.put("ConsumerId", consumerId);
                if (StringUtils.isNotBlank((CharSequence)accessKey)) {
                    properties.put("AccessKey", accessKey);
                }
                if (StringUtils.isNotBlank((CharSequence)secretKey)) {
                    properties.put("SecretKey", secretKey);
                }
                if (StringUtils.isNotBlank((CharSequence)namesrvAddr)) {
                    properties.put("NAMESRV_ADDR", namesrvAddr);
                }
                if (StringUtils.isNotBlank((CharSequence)oNSAddr)) {
                    properties.put("ONSAddr", oNSAddr);
                }
                if (StringUtils.isNotBlank((CharSequence)(consumeThreadNumsStr = this.props.getProperty(mqBO.getConsumerId() + "_THREAD_NUMS")))) {
                    int consumeThreadNums = Integer.parseInt(consumeThreadNumsStr.trim());
                    properties.put("ConsumeThreadNums", (Object)consumeThreadNums);
                } else {
                    properties.put("ConsumeThreadNums", (Object)5);
                }
                Consumer consumer = ONSFactory.createConsumer((Properties)properties);
                consumer.subscribe(topic, mqBO.getTag(), (MessageListener)new MqMessageListener(this.cacheService, mqc, mqBO.getTag()));
                log.info("consumerInfo=" + properties.toString(), (Object)("topic=" + topic), (Object)("tag=" + mqBO.getTag()));
                System.out.println("consumerInfo=" + properties.toString() + ", topic=" + topic + ", tag=" + mqBO.getTag());
                consumer.start();
            }
        }
    }

    private void invokeMethod(Object service, String methodName, Object args) throws Exception {
        Method method = localMethods.get(service + methodName);
        if (method == null) {
            Class<?> c = service.getClass();
            for (Method m : c.getDeclaredMethods()) {
                if (!methodName.equals(m.getName())) continue;
                localMethods.put(service + methodName, m);
                method = m;
                break;
            }
        }
        method.invoke(service, args);
    }
}

