/*
 * Decompiled with CFR 0.152.
 */
package com.chinaunicom.base.mq;

import com.aliyun.openservices.ons.api.Action;
import com.aliyun.openservices.ons.api.ConsumeContext;
import com.aliyun.openservices.ons.api.Message;
import com.aliyun.openservices.ons.api.MessageListener;
import com.chinaunicom.base.mq.MqConstants;
import com.chinaunicom.base.mq.MqCunsumer;
import com.chinaunicom.base.mq.MqCunsumerSubscribe;
import com.chinaunicom.base.util.LogUtils;
import com.chinaunicom.base.util.SerializeUtils;
import com.chinaunicom.common.bo.MessageInfoBO;
import com.chinaunicom.common.cache.service.CacheService;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MqMessageListener
implements MessageListener {
    private static final Logger log = LoggerFactory.getLogger(MqCunsumerSubscribe.class);
    private final boolean isDebugEnabled = log.isDebugEnabled();
    public static final ThreadLocal<String> traceIds = new ThreadLocal();
    private CacheService cacheService;
    private MqCunsumer mqc;
    private String subExpression;

    public MqMessageListener(CacheService cacheService, MqCunsumer mqc, String subExpression) {
        this.cacheService = cacheService;
        this.mqc = mqc;
        this.subExpression = subExpression;
    }

    public void setCacheService(CacheService cacheService) {
        this.cacheService = cacheService;
    }

    public void setMqc(MqCunsumer mqc) {
        this.mqc = mqc;
    }

    public void setTag(String subExpression) {
        this.subExpression = subExpression;
    }

    public Action consume(Message msg, ConsumeContext context) {
        if (this.isDebugEnabled) {
            log.info("msgid:[" + msg.getMsgID() + "]topic[" + msg.getTopic() + "]tag[" + msg.getTag() + "]key[" + msg.getKey() + "]");
        }
        String msgId = msg.getMsgID();
        String topic = msg.getTopic();
        String tag = msg.getTag();
        String key = msg.getKey();
        byte[] body = msg.getBody();
        Action ret = null;
        String[] infos = null;
        try {
            Object msginfo = SerializeUtils.deserialize(body);
            infos = LogUtils.printMQConsumerStartLog(msg, this.mqc, msginfo);
            this.mqc.execute(tag, msginfo);
            ret = Action.CommitMessage;
            LogUtils.printMQConsumerEndLog(infos);
        }
        catch (Exception e) {
            log.error("\u6d88\u8d39\u5931\u8d25\uff01msgId =" + msgId + "\u6d88\u606f\u7684\u4e3b\u9898\u662f" + topic + "\u6d88\u606f\u7684tag=" + tag, (Throwable)e);
            ret = Action.ReconsumeLater;
            LogUtils.printMQConsumerErrorLog(infos, e);
        }
        return ret;
    }

    private void updateMessageInfoBO(MessageInfoBO msgInfo, Integer consumerStatus) {
        msgInfo.setConsumerTime(new Date());
        msgInfo.setConsumerStatus(consumerStatus);
    }

    private void insertMessageInfoBO(MessageInfoBO msgInfo) {
        msgInfo.setConsumerTime(new Date());
        msgInfo.setConsumerStatus(MqConstants.CONSUMER_STATUS_UPDATE);
    }
}

