/*
 * Decompiled with CFR 0.152.
 */
package com.chinaunicom.base.mq;

import com.aliyun.openservices.ons.api.Message;
import com.aliyun.openservices.ons.api.Producer;
import com.chinaunicom.base.mq.MqMessageListener;
import com.chinaunicom.base.mq.MqProducerPool;
import com.chinaunicom.base.util.LogUtils;
import com.chinaunicom.base.util.SerializeUtils;
import com.taobao.eagleeye.EagleEye;
import org.apache.commons.lang3.StringUtils;

public class MqProducer {
    private static MqProducerPool mqProducerPool;

    public void setMqProducerPool(MqProducerPool mqProducerPool) {
        MqProducer.mqProducerPool = mqProducerPool;
    }

    public static void sendMsg(String topic, String tag, Object body) {
        topic = mqProducerPool.getPropertyConfigurer().getProperty(topic);
        Message msg = new Message(topic, tag, SerializeUtils.serialize(body));
        String traceId = MqProducer.getTraceId();
        if (StringUtils.isBlank((CharSequence)traceId)) {
            traceId = MqMessageListener.traceIds.get();
        }
        msg.putUserProperties("TraceId", traceId);
        Producer producer = mqProducerPool.getProducer(topic);
        if (producer == null) {
            producer = mqProducerPool.getSynProducer(topic);
        }
        producer.send(msg);
        LogUtils.printMQProducerLog("MqProducer", "sendMsg", msg, body);
    }

    public static void sendMsg(String topic, String tag, String key, Object body) {
        topic = mqProducerPool.getPropertyConfigurer().getProperty(topic);
        Message msg = new Message(topic, tag, key, SerializeUtils.serialize(body));
        String traceId = MqProducer.getTraceId();
        if (StringUtils.isBlank((CharSequence)traceId)) {
            traceId = MqMessageListener.traceIds.get();
        }
        msg.putUserProperties("TraceId", traceId);
        Producer producer = mqProducerPool.getProducer(topic);
        if (producer == null) {
            producer = mqProducerPool.getSynProducer(topic);
        }
        producer.send(msg);
        LogUtils.printMQProducerLog("MqProducer", "sendMsg", msg, body);
    }

    private static final String getTraceId() {
        String traceId = EagleEye.getTraceId();
        if (StringUtils.isBlank((CharSequence)traceId)) {
            traceId = "";
        }
        return traceId;
    }
}

