/*
 * Decompiled with CFR 0.152.
 */
package com.chinaunicom.base.out;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.chinaunicom.base.out.UniBssUtil;
import com.chinaunicom.base.out.bo.Reserved;
import com.chinaunicom.base.out.bo.UniBssAttached;
import com.chinaunicom.base.out.bo.UniBssHead;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.ArrayList;
import java.util.HashMap;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.message.BasicHeader;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OutSendToAopUtil {
    private static final Logger logger = LoggerFactory.getLogger(OutSendToAopUtil.class);
    private static boolean isDebugEnabled = logger.isDebugEnabled();
    private static final String APPLICATION_JSON = "application/json";
    private static final String CONTENT_TYPE_TEXT_JSON = "text/json";

    public static String toUniBssStringOut(UniBssHead uniBssHead, UniBssAttached uniBssAttached, Object obj) throws Exception {
        JSONObject jsonObj = new JSONObject();
        jsonObj.put("uniBssAttached", (Object)uniBssAttached);
        jsonObj.put("uniBssHead", (Object)uniBssHead);
        JSONObject uniBssBody = new JSONObject();
        String objStr = obj.getClass().getSimpleName();
        uniBssBody.put(UniBssUtil.toLowerHeadString(objStr), obj);
        jsonObj.put("uniBssBody", (Object)uniBssBody);
        ObjectMapper om = new ObjectMapper();
        JsonNode node = null;
        node = om.readTree(jsonObj.toString());
        StringBuilder json = new StringBuilder();
        int deep = 0;
        UniBssUtil.jsonFormat(node, json, deep, true);
        if (isDebugEnabled) {
            logger.debug("OutSendToAopUtil:json-" + json.toString());
        }
        return json.toString();
    }

    public static String requestToAOP(String requestUrl, String requestStr) throws Exception {
        if (isDebugEnabled) {
            logger.debug("requestToAOP:requestUrl-" + requestUrl);
            logger.debug("requestToAOP:requestStr-" + requestStr);
        }
        HttpPost httpPost = new HttpPost(requestUrl);
        httpPost.addHeader("Content-Type", APPLICATION_JSON);
        StringEntity se = new StringEntity(requestStr, "UTF-8");
        se.setContentType(CONTENT_TYPE_TEXT_JSON);
        se.setContentEncoding((Header)new BasicHeader("Content-Type", APPLICATION_JSON));
        httpPost.setEntity((HttpEntity)se);
        DefaultHttpClient client = new DefaultHttpClient();
        HttpResponse response = client.execute((HttpUriRequest)httpPost);
        HttpEntity entity = response.getEntity();
        String responseStr = EntityUtils.toString((HttpEntity)entity);
        if (isDebugEnabled) {
            logger.debug("OutSendToAopUtil:responseStr-" + responseStr);
        }
        return responseStr;
    }

    public static UniBssHead getUniBssHead(String appId, String appSecret) {
        if (isDebugEnabled) {
            logger.debug("getUniBssHead:appId-" + appId);
            logger.debug("getUniBssHead:appSecret-" + appSecret);
        }
        UniBssHead uniBssHead = new UniBssHead();
        String transId = UniBssUtil.getTransId();
        String timestamp = UniBssUtil.getTimeStamp();
        String token = UniBssUtil.getToken(appId, timestamp, transId, appSecret);
        uniBssHead.setAppId(appId);
        uniBssHead.setTimestamp(timestamp);
        uniBssHead.setToken(token);
        uniBssHead.setTransId(transId);
        ArrayList<Reserved> reserved = new ArrayList<Reserved>();
        Reserved res = new Reserved();
        reserved.add(res);
        uniBssHead.setReserved(reserved);
        if (isDebugEnabled) {
            logger.debug("OutSendToAopUtil:uniBssHead-" + uniBssHead.toString());
        }
        return uniBssHead;
    }

    public static String toUniBssStringIn(String aopString) throws Exception {
        if (isDebugEnabled) {
            logger.debug("toUniBssStringIn:aopString-" + aopString);
        }
        ObjectMapper om = new ObjectMapper();
        JsonNode node = null;
        node = om.readTree(aopString);
        StringBuilder json = new StringBuilder();
        int deep = 0;
        UniBssUtil.jsonFormat(node, json, deep, false);
        return json.toString();
    }

    public static Object getObjectByString(String objStr, String aopString) throws Exception {
        if (isDebugEnabled) {
            logger.debug("getObjectByString:objStr-" + objStr);
            logger.debug("getObjectByString:aopString-" + aopString);
        }
        String uniBssString = OutSendToAopUtil.toUniBssStringIn(aopString);
        ObjectMapper om = new ObjectMapper();
        return ((HashMap)om.readValue(uniBssString, HashMap.class)).get(objStr);
    }

    public static UniBssHead getUniBssHead(String aopString) throws Exception {
        if (isDebugEnabled) {
            logger.debug("getUniBssHead:aopString-" + aopString);
        }
        Object uniBssHeadObj = OutSendToAopUtil.getObjectByString("uniBssHead", aopString);
        ObjectMapper om = new ObjectMapper();
        UniBssHead uniBssHead = (UniBssHead)om.readValue(JSON.toJSONString((Object)uniBssHeadObj), UniBssHead.class);
        return uniBssHead;
    }

    public static <V> V getJavaBean(String javaBeanName, String aopString, Class<V> valueType) throws Exception {
        if (isDebugEnabled) {
            logger.debug("getJavaBean:javaBeanName-" + javaBeanName);
            logger.debug("getJavaBean:aopString-" + aopString);
            logger.debug("getJavaBean:valueType-" + valueType);
        }
        Object uniBssBody = OutSendToAopUtil.getObjectByString("uniBssBody", aopString);
        ObjectMapper om = new ObjectMapper();
        Object javaBeanObj = ((HashMap)om.readValue(JSON.toJSONString((Object)uniBssBody), HashMap.class)).get(javaBeanName);
        Object vObj = om.readValue(JSON.toJSONString(javaBeanObj), valueType);
        return (V)vObj;
    }
}

