/*
 * Decompiled with CFR 0.152.
 */
package com.chinaunicom.base.out;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.JsonNodeType;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Iterator;
import java.util.Map;
import java.util.Random;

public class UniBssUtil {
    public static String camelCaseName(String underscoreName) {
        StringBuilder result = new StringBuilder();
        if (underscoreName != null && underscoreName.length() > 0) {
            boolean flag = false;
            for (int i = 0; i < underscoreName.length(); ++i) {
                char ch = underscoreName.charAt(i);
                if ("_".charAt(0) == ch) {
                    flag = true;
                    continue;
                }
                if (flag) {
                    result.append(Character.toUpperCase(ch));
                    flag = false;
                    continue;
                }
                result.append(Character.toLowerCase(ch));
            }
        }
        return result.toString();
    }

    public static String underscoreName(String camelCaseName) {
        StringBuilder result = new StringBuilder();
        int len = camelCaseName.length();
        if (camelCaseName != null && len > 0) {
            result.append(camelCaseName.substring(0, 1).toUpperCase());
            for (int i = 1; i < len; ++i) {
                char ch = camelCaseName.charAt(i);
                if (Character.isUpperCase(ch)) {
                    result.append("_");
                    result.append(ch);
                    continue;
                }
                result.append(Character.toUpperCase(ch));
            }
        }
        return result.toString();
    }

    public static void main(String[] args) throws Exception {
        ObjectMapper om = new ObjectMapper();
        JsonNode node = om.readTree("{\"name_text\":\"demo\",\"name_tex1t\":\"demo1\",\"dd\":[\"a\",\"b\",\"c\"],\"m\":{\"ma\":[1,2,3],\"mb\":\"mb\"}}}");
        StringBuilder json = new StringBuilder();
        int deep = 0;
        UniBssUtil.jsonFormat(node, json, deep, true);
        System.out.println(json.toString());
    }

    public static void jsonFormat(JsonNode node, StringBuilder json, int deep, boolean underScore) {
        JsonNodeType nt = node.getNodeType();
        if (nt == JsonNodeType.ARRAY) {
            ArrayNode an = (ArrayNode)node;
            json.append("[");
            Iterator elements = an.elements();
            ++deep;
            while (elements.hasNext()) {
                UniBssUtil.jsonFormat((JsonNode)elements.next(), json, deep, underScore);
                if (!elements.hasNext()) continue;
                json.append(",");
            }
            --deep;
            json.append("]");
        } else if (nt == JsonNodeType.OBJECT) {
            ObjectNode on = (ObjectNode)node;
            Iterator fields = on.fields();
            json.append("{");
            ++deep;
            while (fields.hasNext()) {
                json.append("\n");
                for (int i = 0; i < deep; ++i) {
                    json.append("        ");
                }
                Map.Entry field = (Map.Entry)fields.next();
                json.append("\"").append(underScore ? UniBssUtil.underscoreName((String)field.getKey()) : UniBssUtil.camelCaseName((String)field.getKey())).append("\":");
                UniBssUtil.jsonFormat((JsonNode)field.getValue(), json, deep, underScore);
                if (!fields.hasNext()) continue;
                json.append(",");
            }
            --deep;
            json.append("\n");
            for (int i = 0; i < deep; ++i) {
                json.append("        ");
            }
            json.append("}");
        } else if (nt == JsonNodeType.STRING) {
            json.append("\"").append(node.asText()).append("\"");
        } else if (nt == JsonNodeType.NULL) {
            json.append(node.asText());
        } else if (nt == JsonNodeType.BOOLEAN) {
            json.append(node.asText());
        } else if (nt == JsonNodeType.NUMBER) {
            json.append(node.asText());
        }
    }

    public static String toLowerHeadString(String str) {
        StringBuilder result = new StringBuilder();
        result.append(str.substring(0, 1).toLowerCase());
        result.append(str.substring(1));
        return result.toString();
    }

    public static String getTimeStamp() {
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss SSS");
        String str = format.format(new Date());
        return str;
    }

    public static String getTransId() {
        SimpleDateFormat format = new SimpleDateFormat("yyyyMMddHHmmssSSS");
        String str = format.format(new Date());
        Random random = new Random();
        int result = random.nextInt(1000000);
        return str + result;
    }

    public static String toMD5Str(String plainText) {
        String re_md5 = new String();
        try {
            MessageDigest md = MessageDigest.getInstance("MD5");
            md.update(plainText.getBytes());
            byte[] b = md.digest();
            StringBuffer buf = new StringBuffer("");
            for (int offset = 0; offset < b.length; ++offset) {
                int i = b[offset];
                if (i < 0) {
                    i += 256;
                }
                if (i < 16) {
                    buf.append("0");
                }
                buf.append(Integer.toHexString(i));
            }
            re_md5 = buf.toString();
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
        }
        return re_md5;
    }

    public static String getToken(String appId, String timestamp, String transId, String appSecret) {
        StringBuffer buf = new StringBuffer("");
        buf.append("APP_ID");
        buf.append(appId);
        buf.append("TIMESTAMP");
        buf.append(timestamp);
        buf.append("TRANS_ID");
        buf.append(transId);
        buf.append(appSecret);
        return UniBssUtil.toMD5Str(buf.toString());
    }
}

