/*
 * Decompiled with CFR 0.152.
 */
package com.chinaunicom.base.querytask;

import com.chinaunicom.common.exception.ResourceException;
import com.chinaunicom.function.bo.ReqFileBO;
import com.chinaunicom.function.bo.ReqPageBO;
import com.chinaunicom.function.bo.RspBatchBO;
import com.chinaunicom.function.bo.RspPageBO;
import com.chinaunicom.function.query.BaseBatchQueryService;
import com.tydic.task.api.BatchQueryCustomResultHandelService;
import com.tydic.task.api.ExportQueryBO;
import com.tydic.task.api.PageInfo;
import com.tydic.task.api.QueryTaskPageBO;
import com.tydic.task.api.filequery.FileQueryTaskService;
import com.tydic.task.api.filequery.bo.FileDaoParamBO;
import com.tydic.task.api.filequery.bo.FileQueryTaskBO;
import com.tydic.task.api.filequery.export.ExportFileQueryTaskService;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.sql.SQLException;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;

public abstract class AbstractBatchFileQueryService<T extends ReqFileBO, D extends FileDaoParamBO, R>
implements BaseBatchQueryService<T, R> {
    private static final Logger log = LoggerFactory.getLogger(AbstractBatchFileQueryService.class);
    private FileQueryTaskService<R, D> fileQueryTaskService;
    private ExportFileQueryTaskService exportFileQueryTaskService;
    private BatchQueryCustomResultHandelService batchQueryCustomResultHandelService;

    public abstract D handleParam(T var1);

    public RspBatchBO createQueryTask(T t) {
        if (StringUtils.isBlank((CharSequence)t.getFilePath())) {
            throw new ResourceException("7777", "\u672a\u4e0a\u4f20\u6587\u4ef6\uff01\u8bf7\u5148\u4e0a\u4f20\u6587\u4ef6\uff01");
        }
        D d = this.handleParam(t);
        FileQueryTaskBO queryTaskBO = new FileQueryTaskBO.Builder(t.getSessionId(), t.getQserviceId(), t.getFilePath(), d, t.getProvinceCode(), t.getStaffId()).setAreaCode(t.getCityCode()).setCountyCode(t.getDistrictCode()).setUserFileName(t.getUserFileName()).build();
        if (log.isDebugEnabled()) {
            log.debug("\u5c01\u88c5\u540e\u5165\u53c2\uff1a{}", (Object)queryTaskBO);
        }
        String batchNo = this.fileQueryTaskService.createQueryTask(queryTaskBO);
        if (log.isDebugEnabled()) {
            log.debug("batchNo\uff1a{}", (Object)batchNo);
        }
        RspBatchBO rspBO = new RspBatchBO();
        rspBO.setBatchNo(batchNo);
        return rspBO;
    }

    public RspPageBO<R> queryTaskSchedule(ReqPageBO pageBO) {
        RspPageBO rspPageBO = new RspPageBO();
        PageInfo pageInfo = this.fileQueryTaskService.queryTaskSchedule(pageBO.getQueryBatchNo(), pageBO.getLimit());
        BeanUtils.copyProperties((Object)pageInfo, (Object)rspPageBO);
        return rspPageBO;
    }

    public RspPageBO<R> queryInfoByPage(T t) {
        Class<R> rType = this.getGenericType(2);
        QueryTaskPageBO queryTaskPageBO = new QueryTaskPageBO.Builder(t.getQserviceId(), t.getQueryBatchNo(), rType).setOffset(t.getOffset()).setLimit(t.getLimit()).setBatchQueryCustomResultHandelService(this.batchQueryCustomResultHandelService).build();
        PageInfo pageInfo = null;
        try {
            pageInfo = this.fileQueryTaskService.queryInfoByPage(queryTaskPageBO);
        }
        catch (SQLException e) {
            log.error("\u6267\u884c\u5206\u9875\u67e5\u8be2\u9519\u8bef\uff01\u8bf7\u68c0\u67e5\u67e5\u8be2\u6761\u4ef6", (Throwable)e);
            throw new ResourceException("7777", "\u6267\u884c\u5206\u9875\u67e5\u8be2\u9519\u8bef\uff01\u8bf7\u68c0\u67e5\u67e5\u8be2\u6761\u4ef6");
        }
        RspPageBO rspPageBO = new RspPageBO();
        BeanUtils.copyProperties((Object)pageInfo, (Object)rspPageBO);
        rspPageBO.setRows(pageInfo.getRows());
        return rspPageBO;
    }

    private Class<R> getGenericType(int len) {
        Type type = ((ParameterizedType)this.getClass().getGenericSuperclass()).getActualTypeArguments()[len];
        return (Class)type;
    }

    public RspBatchBO createExportTask(T t) {
        String batchNo = t.getQueryBatchNo();
        String serviceID = t.getQserviceId();
        RspBatchBO rspBO = new RspBatchBO();
        String templateId = t.getTemplateId();
        try {
            ExportQueryBO exportQueryBO = new ExportQueryBO.Builder(batchNo, serviceID, t.getProvinceCode(), t.getStaffId(), t.getDepartId()).setAreaCode(t.getCityCode()).setCountyCode(t.getDistrictCode()).build();
            exportQueryBO.setTemplateId(templateId);
            this.exportFileQueryTaskService.createExportTask(exportQueryBO, this.batchQueryCustomResultHandelService == null ? null : this.batchQueryCustomResultHandelService.getSpringBeanName());
        }
        catch (Exception e) {
            log.error("\u521b\u5efa\u5bfc\u51fa\u4efb\u52a1\u5931\u8d25", (Throwable)e);
            rspBO.setBatchNo(batchNo);
            rspBO.setRespCode("8888");
            rspBO.setRespDesc("\u521b\u5efa\u5bfc\u51fa\u4efb\u52a1\u5931\u8d25");
            return rspBO;
        }
        rspBO.setBatchNo(batchNo);
        rspBO.setRespCode("0000");
        return rspBO;
    }

    public RspPageBO<Object> queryExportTaskSchedule(ReqPageBO pageBO) {
        RspPageBO rspPageBO = new RspPageBO();
        PageInfo pageInfo = this.exportFileQueryTaskService.queryTaskSchedule(pageBO.getQueryBatchNo());
        BeanUtils.copyProperties((Object)pageInfo, (Object)rspPageBO);
        return rspPageBO;
    }

    public void setFileQueryTaskService(FileQueryTaskService<R, D> fileQueryTaskService) {
        this.fileQueryTaskService = fileQueryTaskService;
    }

    public void setExportFileQueryTaskService(ExportFileQueryTaskService exportFileQueryTaskService) {
        this.exportFileQueryTaskService = exportFileQueryTaskService;
    }

    public void setBatchQueryCustomResultHandelService(BatchQueryCustomResultHandelService batchQueryCustomResultHandelService) {
        this.batchQueryCustomResultHandelService = batchQueryCustomResultHandelService;
    }
}

