/*
 * Decompiled with CFR 0.152.
 */
package com.chinaunicom.base.querytask;

import com.chinaunicom.common.exception.ResourceException;
import com.chinaunicom.function.bo.ReqPageBO;
import com.chinaunicom.function.bo.RspBatchBO;
import com.chinaunicom.function.bo.RspPageBO;
import com.chinaunicom.function.query.BaseBatchQueryService;
import com.tydic.task.api.BatchQueryCustomResultHandelService;
import com.tydic.task.api.ExportQueryBO;
import com.tydic.task.api.ExportTaskApi;
import com.tydic.task.api.PageInfo;
import com.tydic.task.api.QueryTaskApi;
import com.tydic.task.api.QueryTaskBO;
import com.tydic.task.api.QueryTaskPageBO;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.sql.SQLException;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;

public abstract class AbstractBatchQueryService<T extends ReqPageBO, D, R>
implements BaseBatchQueryService<T, R> {
    private static final Logger log = LoggerFactory.getLogger(AbstractBatchQueryService.class);
    private QueryTaskApi<R, D> queryTaskApi;
    private ExportTaskApi exportTaskApi;
    private BatchQueryCustomResultHandelService batchQueryCustomResultHandelService;

    public abstract List<Long> getSubtreasuryList(T var1);

    public abstract D handleParam(T var1);

    public RspBatchBO createQueryTask(T t) {
        List<Long> subtreasuryList = this.getSubtreasuryList(t);
        D d = this.handleParam(t);
        QueryTaskBO queryTaskBO = new QueryTaskBO.Builder(t.getSessionId(), t.getQserviceId(), d, subtreasuryList).build();
        String batchNo = this.queryTaskApi.createQueryTask(queryTaskBO);
        RspBatchBO rspBO = new RspBatchBO();
        rspBO.setBatchNo(batchNo);
        return rspBO;
    }

    public RspPageBO<R> queryTaskSchedule(ReqPageBO pageBO) {
        RspPageBO rspPageBO = new RspPageBO();
        PageInfo pageInfo = this.queryTaskApi.queryTaskSchedule(pageBO.getQueryBatchNo(), pageBO.getLimit());
        BeanUtils.copyProperties((Object)pageInfo, (Object)rspPageBO);
        return rspPageBO;
    }

    public RspPageBO<R> queryInfoByPage(T t) {
        Class<R> rType = this.getGenericType(2);
        QueryTaskPageBO queryTaskPageBO = new QueryTaskPageBO.Builder(t.getQserviceId(), t.getQueryBatchNo(), rType).setOffset(t.getOffset()).setLimit(t.getLimit()).setBatchQueryCustomResultHandelService(this.batchQueryCustomResultHandelService).build();
        PageInfo pageInfo = null;
        try {
            pageInfo = this.queryTaskApi.queryInfoByPage(queryTaskPageBO);
        }
        catch (SQLException e) {
            log.error("\u6267\u884c\u5206\u9875\u67e5\u8be2\u9519\u8bef\uff01\u8bf7\u68c0\u67e5\u67e5\u8be2\u6761\u4ef6", (Throwable)e);
            throw new ResourceException("7777", "\u6267\u884c\u5206\u9875\u67e5\u8be2\u9519\u8bef\uff01\u8bf7\u68c0\u67e5\u67e5\u8be2\u6761\u4ef6");
        }
        RspPageBO rspPageBO = new RspPageBO();
        BeanUtils.copyProperties((Object)pageInfo, (Object)rspPageBO);
        rspPageBO.setRows(pageInfo.getRows());
        return rspPageBO;
    }

    private Class<R> getGenericType(int len) {
        Type type = ((ParameterizedType)this.getClass().getGenericSuperclass()).getActualTypeArguments()[len];
        return (Class)type;
    }

    public RspBatchBO createExportTask(T t) {
        String batchNo = t.getQueryBatchNo();
        String serviceID = t.getQserviceId();
        String templateId = t.getTemplateId();
        RspBatchBO rspBO = new RspBatchBO();
        try {
            ExportQueryBO exportQueryBO = new ExportQueryBO.Builder(batchNo, serviceID, t.getProvinceCode(), t.getStaffId(), t.getDepartId()).setAreaCode(t.getCityCode()).setCountyCode(t.getDistrictCode()).build();
            exportQueryBO.setTemplateId(templateId);
            this.exportTaskApi.createExportTask(exportQueryBO, this.batchQueryCustomResultHandelService == null ? null : this.batchQueryCustomResultHandelService.getSpringBeanName());
        }
        catch (IllegalArgumentException e) {
            log.error("\u521b\u5efa\u5bfc\u51fa\u4efb\u52a1\u5931\u8d25", (Throwable)e);
            rspBO.setBatchNo(batchNo);
            rspBO.setRespCode("8888");
            rspBO.setRespDesc(e.getMessage());
            return rspBO;
        }
        catch (Exception e) {
            log.error("\u521b\u5efa\u5bfc\u51fa\u4efb\u52a1\u5931\u8d25", (Throwable)e);
            rspBO.setBatchNo(batchNo);
            rspBO.setRespCode("8888");
            rspBO.setRespDesc("\u521b\u5efa\u5bfc\u51fa\u4efb\u52a1\u5931\u8d25");
            return rspBO;
        }
        rspBO.setBatchNo(batchNo);
        rspBO.setRespCode("0000");
        return rspBO;
    }

    public RspPageBO<Object> queryExportTaskSchedule(ReqPageBO pageBO) {
        RspPageBO rspPageBO = new RspPageBO();
        PageInfo pageInfo = this.exportTaskApi.queryTaskSchedule(pageBO.getQueryBatchNo());
        BeanUtils.copyProperties((Object)pageInfo, (Object)rspPageBO);
        return rspPageBO;
    }

    public void setQueryTaskApi(QueryTaskApi<R, D> queryTaskApi) {
        this.queryTaskApi = queryTaskApi;
    }

    public void setExportTaskApi(ExportTaskApi exportTaskApi) {
        this.exportTaskApi = exportTaskApi;
    }

    public void setBatchQueryCustomResultHandelService(BatchQueryCustomResultHandelService batchQueryCustomResultHandelService) {
        this.batchQueryCustomResultHandelService = batchQueryCustomResultHandelService;
    }
}

