/*
 * Decompiled with CFR 0.152.
 */
package com.chinaunicom.base.task;

import com.chinaunicom.base.file.FileProcessing;
import com.chinaunicom.base.fileanalyzing.SimpleTxtAnaly;
import com.chinaunicom.base.mq.MqCunsumer;
import com.chinaunicom.base.mq.MqProducer;
import com.chinaunicom.base.mq.MqTransactionProducer;
import com.chinaunicom.common.cache.service.CacheService;
import com.chinaunicom.common.exception.ResourceException;
import com.chinaunicom.common.task.BatchTaskService;
import com.chinaunicom.common.task.TaskDetailJsonBO;
import com.chinaunicom.common.task.TaskDetailStatus;
import com.chinaunicom.common.task.TaskInvokNumBO;
import com.chinaunicom.common.task.TaskJsonBO;
import com.chinaunicom.common.task.TaskStatus;
import com.chinaunicom.common.task.TaskStatusInfoBO;
import java.io.File;
import java.util.List;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor;

public abstract class BatchTaskScheduer<R, F, L, B>
implements BatchTaskService<R, F, L, B>,
MqCunsumer,
ApplicationContextAware {
    private static final Logger log = LoggerFactory.getLogger(BatchTaskScheduer.class);
    private ThreadPoolTaskExecutor threadPoolTaskExecutor;
    protected CacheService cacheService;
    private String topic = null;

    public ThreadPoolTaskExecutor getThreadPoolTaskExecutor() {
        return this.threadPoolTaskExecutor;
    }

    public abstract TaskJsonBO<R, F, L, B> getTaskJsonBO(Long var1);

    public abstract void createTaskDetail(List<TaskDetailJsonBO<B>> var1);

    public abstract void createDetailByCondition(TaskJsonBO<R, F, L, B> var1);

    public abstract void createDetailByFile(TaskJsonBO<R, F, L, B> var1);

    public abstract void createDetailCollection(TaskJsonBO<R, F, L, B> var1);

    public abstract void updateTaskDetailStatus(TaskStatusInfoBO<B> var1);

    public abstract TaskStatus updateBatchCompletedNum(TaskStatusInfoBO<B> var1);

    public abstract void updateBatchTaskCompleted(Long var1);

    public abstract TaskStatus updateBatchCompletedNum(Long var1);

    protected abstract void createDetail(Long var1);

    protected abstract void traversalTask(Long var1);

    public TaskInvokNumBO invokeBusiTaskByBatch(TaskJsonBO<R, F, L, B> jsonBO) {
        return null;
    }

    protected void invokeTask(Object detail) {
        TaskDetailJsonBO e = (TaskDetailJsonBO)detail;
        TaskStatusInfoBO ts = new TaskStatusInfoBO();
        ts.setBatchNo(e.getBatchNo());
        ts.setTaskDetailId(e.getTaskDetailId());
        try {
            e.setStatus(TaskDetailStatus.getStatus((TaskDetailStatus)TaskDetailStatus.SUCCESS));
            ts.setDetailStatus(TaskDetailStatus.getStatus((TaskDetailStatus)TaskDetailStatus.SUCCESS));
            B b = this.getBusiInfo(e);
            if (b != null) {
                e.setBusiData(b);
                ts.setBusiData(b);
            }
            ts.setRespCode("0000");
            ts.setRespDesc("\u6210\u529f");
            MqTransactionProducer.sendMsg(this, "invokeBusiTask", e, this.getTopic(), "result", ts);
        }
        catch (ResourceException e1) {
            log.error("\u4e1a\u52a1\u4efb\u52a1\u5931\u8d25\uff01\uff0c\u53d1\u9001\u4efb\u52a1\u5931\u8d25\u6d88\u606f\uff01", (Throwable)e1);
            e.setStatus(TaskDetailStatus.getStatus((TaskDetailStatus)TaskDetailStatus.FAIL));
            ts.setDetailStatus(TaskDetailStatus.getStatus((TaskDetailStatus)TaskDetailStatus.FAIL));
            ts.setRespCode(e1.getMsgCode());
            ts.setRespDesc(e1.getMessage());
            MqProducer.sendMsg(this.getTopic(), "result", ts);
        }
        catch (Exception e1) {
            log.error("\u4e1a\u52a1\u4efb\u52a1\u5931\u8d25\uff01\uff0c\u53d1\u9001\u4efb\u52a1\u5931\u8d25\u6d88\u606f\uff01", (Throwable)e1);
            e.setStatus(TaskDetailStatus.getStatus((TaskDetailStatus)TaskDetailStatus.FAIL));
            ts.setDetailStatus(TaskDetailStatus.getStatus((TaskDetailStatus)TaskDetailStatus.FAIL));
            ts.setRespCode("8888");
            ts.setRespDesc("\u7cfb\u7edf\u5f02\u5e38");
            MqProducer.sendMsg(this.getTopic(), "result", ts);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void invokeTaskByBatch(TaskJsonBO<R, F, L, B> taskJsonBO) {
        Long batchNo = taskJsonBO.getBatchNo();
        TaskInvokNumBO task = this.invokeBusiTaskByBatch(taskJsonBO);
        long amount = taskJsonBO.getAmount();
        int success = task.getCountSuccess();
        int fail = task.getCountFailed();
        try {
            if (success > 0) {
                this.cacheService.incrExpireTimeBy("t_s_" + batchNo, (long)success, 86400);
            }
            if (fail > 0) {
                this.cacheService.incrExpireTimeBy("t_f_" + batchNo, (long)fail, 86400);
            }
        }
        finally {
            long doingcount = success + fail;
            if (doingcount > 0L) {
                doingcount = this.cacheService.incrExpireTimeBy("t_d_" + batchNo, doingcount, 86400);
            }
            if (doingcount == amount) {
                MqTransactionProducer.sendMsg(this, "updateBatchTaskCompleted", taskJsonBO.getBatchNo(), this.getTopic(), "receipt", taskJsonBO.getBatchNo());
            }
        }
    }

    protected void updateTaskDetailStatusCompleted(TaskStatusInfoBO<B> ts) {
        TaskStatus status = this.updateBatchCompletedNum(ts);
        if (TaskStatus.COMPLETED.equals((Object)status)) {
            MqTransactionProducer.sendMsg(this, "updateBatchTaskCompleted", ts.getBatchNo(), this.getTopic(), "receipt", ts.getBatchNo());
        }
    }

    protected void updateTaskStatusCompleted(Long batchNo) {
        TaskStatus status = this.updateBatchCompletedNum(batchNo);
        if (TaskStatus.COMPLETED.equals((Object)status)) {
            MqProducer.sendMsg(this.getTopic(), "receipt", batchNo);
        }
    }

    protected void receiptTask(Long batchNo) {
    }

    protected B getBusiInfo(TaskDetailJsonBO<B> e) {
        return null;
    }

    @Override
    public void execute(String tag, Object msg) {
        log.debug("\u6279\u91cf\u4efb\u52a1\u6d88\u8d39\u8005\u5f00\u59cb\u4e86---\u6d88\u606f\u7684\u4e3b\u9898=" + this.getTopic() + "\u7684tag=" + tag);
        switch (tag) {
            case "createdetail": {
                this.createDetail((Long)msg);
                break;
            }
            case "loopdetail": {
                this.traversalTask((Long)msg);
                break;
            }
            case "busi": {
                this.invokeTask(msg);
                break;
            }
            case "batchProcessing": {
                this.invokeTaskByBatch((TaskJsonBO)msg);
                break;
            }
            case "result": {
                this.updateTaskDetailStatusCompleted((TaskStatusInfoBO)msg);
                break;
            }
            case "no_result": {
                this.updateTaskStatusCompleted((Long)msg);
                break;
            }
            case "receipt": {
                this.receiptTask((Long)msg);
                break;
            }
        }
    }

    protected String getTopic() {
        if (this.topic == null) {
            this.topic = this.subscribe().getTopic();
        }
        return this.topic;
    }

    protected List<String> analyFile(String filePath, String regex, String sysCenter, String businessType) {
        File file = FileProcessing.downloadFile(filePath, sysCenter, businessType);
        Pattern p = Pattern.compile(regex);
        List<String> list = SimpleTxtAnaly.parse(file, p);
        file.delete();
        return list;
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.threadPoolTaskExecutor = (ThreadPoolTaskExecutor)applicationContext.getBean("threadPoolTaskExecutor", ThreadPoolTaskExecutor.class);
        this.cacheService = (CacheService)applicationContext.getBean("cacheService", CacheService.class);
    }
}

