/*
 * Decompiled with CFR 0.152.
 */
package com.chinaunicom.base.task;

import com.chinaunicom.base.mq.MqTransactionProducer;
import com.chinaunicom.common.exception.ResourceException;
import com.chinaunicom.common.task.TaskDetailJsonBO;
import com.chinaunicom.common.task.TaskDetailStatus;
import com.chinaunicom.common.task.TaskStatusInfoBO;
import java.util.List;
import java.util.concurrent.CountDownLatch;

public class ThreadTraversalTask<B>
implements Runnable {
    private List<TaskDetailJsonBO<B>> list;
    private Object service;
    private String methodName;
    private String topic;
    private String tag;
    private CountDownLatch latch;

    public List<TaskDetailJsonBO<B>> getList() {
        return this.list;
    }

    public void setList(List<TaskDetailJsonBO<B>> list) {
        this.list = list;
    }

    public void setService(Object service) {
        this.service = service;
    }

    public void setMethodName(String methodName) {
        this.methodName = methodName;
    }

    public String getTopic() {
        return this.topic;
    }

    public void setTopic(String topic) {
        this.topic = topic;
    }

    public String getTag() {
        return this.tag;
    }

    public void setTag(String tag) {
        this.tag = tag;
    }

    public Object getService() {
        return this.service;
    }

    public String getMethodName() {
        return this.methodName;
    }

    public CountDownLatch getLatch() {
        return this.latch;
    }

    public void setLatch(CountDownLatch latch) {
        this.latch = latch;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void run() {
        try {
            for (TaskDetailJsonBO<B> t : this.list) {
                TaskStatusInfoBO ts = new TaskStatusInfoBO();
                ts.setBatchNo(t.getBatchNo());
                ts.setTaskDetailId(t.getTaskDetailId());
                ts.setDetailStatus(TaskDetailStatus.getStatus((TaskDetailStatus)TaskDetailStatus.DOING));
                ts.setOldStatus(TaskDetailStatus.getStatus((TaskDetailStatus)TaskDetailStatus.UNEXECUTED));
                try {
                    MqTransactionProducer.sendMsg(this.service, this.methodName, ts, this.topic, this.tag, t);
                }
                catch (ResourceException e) {
                    e.printStackTrace();
                    if ("T001".equals(e.getMsgCode())) {
                        if (this.latch == null) return;
                        this.latch.countDown();
                        return;
                    }
                    try {
                        throw e;
                    }
                    catch (Throwable throwable) {
                        throw throwable;
                        return;
                    }
                }
            }
        }
        finally {
            if (this.latch != null) {
                this.latch.countDown();
            }
        }
    }
}

