/*
 * Decompiled with CFR 0.152.
 */
package com.chinaunicom.base.test;

import com.chinaunicom.base.util.DbUtils;
import com.chinaunicom.base.util.DeleteHsfUUIDFileUtils;
import com.taobao.hsf.standalone.HSFEasyStarter;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.junit.AfterClass;
import org.junit.Before;
import org.junit.BeforeClass;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.test.context.ContextConfiguration;
import org.springframework.test.context.junit4.AbstractJUnit4SpringContextTests;

@ContextConfiguration(locations={"classpath:spring-test.xml"})
public class TestSupport
extends AbstractJUnit4SpringContextTests {
    private static final Logger log = LoggerFactory.getLogger(TestSupport.class);
    public static final String NUMBER_CENTER_DB_PREFIX = "number";
    public static final String CARD_CENTER_DB_PREFIX = "card";
    public static final String USER_CENTER_DB_PREFIX = "user";
    public static final String CONNECT_SYMBOL_WITH_SQL = "=>";
    public static final String BEFORE_SQL = "pre";
    public static final String AFTER_SQL = "del";
    public static final String CONNECT_SYMBOL_WITH_PREFIX = "->";
    public static final String PACKAGE_SEPARATOR = "\\.";
    private static Map<String, Map<String, List<String>>> sqlMap = new HashMap<String, Map<String, List<String>>>();
    private static DbUtils numDbUtils;
    private static DbUtils cardDbUtils;
    private static DbUtils userDbUtils;
    private static boolean isAnalysisSqlFile;
    protected long startTime;
    protected long endTime;

    @Autowired
    public void setNumDbUtils(DbUtils numDbUtils) {
        TestSupport.numDbUtils = numDbUtils;
    }

    @Autowired
    public void setCardDbUtils(DbUtils cardDbUtils) {
        TestSupport.cardDbUtils = cardDbUtils;
    }

    @Autowired
    public void setUserDbUtils(DbUtils userDbUtils) {
        TestSupport.userDbUtils = userDbUtils;
    }

    protected long start() {
        this.startTime = System.currentTimeMillis();
        return this.startTime;
    }

    protected long end() {
        this.endTime = System.currentTimeMillis();
        this.log();
        return this.endTime;
    }

    protected void log() {
        String text = "\n\u5f00\u59cb\u65f6\u95f4 : " + this.startTime + "\n\u7ed3\u675f\u65f6\u95f4 : " + this.endTime + "\n\u6267\u884c\u65f6\u95f4 : " + (this.endTime - this.startTime);
        this.logger.info((Object)text);
    }

    @BeforeClass
    public static void beforeClass() {
        DeleteHsfUUIDFileUtils.deleteHsfUUIDFile();
        String path = System.getenv("taobao-hsf").replace("\\", "/");
        if (path == null) {
            log.error("\u8bf7\u914d\u7f6e\u73af\u5883\u53d8\u91cftaobao-hsf,\u5982\u679c\u4ee5\u914d\u7f6e\u8bf7\u6ce8\u9500\u7535\u8111\u91cd\u65b0\u767b\u5f55\u518d\u6b21\u5c1d\u8bd5\uff01");
        }
        HSFEasyStarter.startFromPath((String)path);
    }

    protected boolean isNeedWaitForSynchronizationToEsEnd() {
        return false;
    }

    @Before
    public void beforeInvokSql() {
        if (isAnalysisSqlFile) {
            return;
        }
        isAnalysisSqlFile = true;
        this.analysisSqlFile();
        TestSupport.invokSql(BEFORE_SQL);
        if (this.isNeedWaitForSynchronizationToEsEnd()) {
            try {
                Thread.sleep(5000L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
    }

    @AfterClass
    public static void afterInvokSql() {
        TestSupport.invokSql(AFTER_SQL);
    }

    protected static void invokSql(String key) {
        String doingSql = null;
        try {
            Map<String, List<String>> map = sqlMap.get(key);
            if (map == null || map.size() == 0) {
                return;
            }
            block12: for (Map.Entry<String, List<String>> entry : map.entrySet()) {
                List<String> sqls = entry.getValue();
                switch (entry.getKey()) {
                    case "number": {
                        String sql;
                        Iterator<String> iterator = sqls.iterator();
                        while (iterator.hasNext()) {
                            doingSql = sql = iterator.next();
                            numDbUtils.execute(sql, null);
                        }
                        continue block12;
                    }
                    case "card": {
                        String sql;
                        Iterator<String> iterator = sqls.iterator();
                        while (iterator.hasNext()) {
                            doingSql = sql = iterator.next();
                            cardDbUtils.execute(sql, null);
                        }
                        continue block12;
                    }
                    case "user": {
                        String sql;
                        Iterator<String> iterator = sqls.iterator();
                        while (iterator.hasNext()) {
                            doingSql = sql = iterator.next();
                            userDbUtils.execute(sql, null);
                        }
                        continue block12;
                    }
                }
            }
        }
        catch (Exception e) {
            log.error("\u6267\u884csql{" + doingSql + "}\u51fa\u9519\u4e86\uff01\u8bf7\u68c0\u67e5\u914d\u7f6e\u6587\u4ef6\u4e2d\u7684sql\uff01", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void analysisSqlFile() {
        String fullName = ((Object)((Object)this)).getClass().getName();
        String[] packageNames = fullName.split(PACKAGE_SEPARATOR);
        String lastPackageName = packageNames[packageNames.length - 3];
        String sqlFileName = "sql/" + lastPackageName + "/" + ((Object)((Object)this)).getClass().getSimpleName() + ".sql";
        InputStream inStream = TestSupport.class.getClassLoader().getResourceAsStream(sqlFileName);
        if (inStream == null) {
            return;
        }
        BufferedReader reader = new BufferedReader(new InputStreamReader(inStream));
        String line = null;
        try {
            while ((line = reader.readLine()) != null) {
                if (StringUtils.isBlank((CharSequence)line) || line.startsWith("#") || !line.contains(CONNECT_SYMBOL_WITH_SQL)) continue;
                TestSupport.putSqlIntoMaps(line);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    private static void putSqlIntoMaps(String line) {
        String[] sqls = line.split(CONNECT_SYMBOL_WITH_SQL);
        String[] keys = sqls[0].trim().split(CONNECT_SYMBOL_WITH_PREFIX);
        Map<String, List<String>> map = TestSupport.getMap(keys[0]);
        List<String> list = TestSupport.getList(keys[1], map);
        list.add(sqls[1].trim());
    }

    private static Map<String, List<String>> getMap(String key) {
        if (sqlMap.containsKey(key)) {
            return sqlMap.get(key);
        }
        HashMap<String, List<String>> map = new HashMap<String, List<String>>();
        sqlMap.put(key, map);
        return map;
    }

    private static List<String> getList(String key, Map<String, List<String>> map) {
        if (map.containsKey(key)) {
            return map.get(key);
        }
        ArrayList<String> list = new ArrayList<String>();
        map.put(key, list);
        return list;
    }

    public static void main(String[] args) {
        String path = System.getenv("taobao-hsf");
        System.out.println(path);
        System.out.println(System.getenv());
    }

    static {
        isAnalysisSqlFile = false;
    }
}

