/*
 * Decompiled with CFR 0.152.
 */
package com.chinaunicom.base.translate;

import com.chinaunicom.base.translate.TranslationConfig;
import com.chinaunicom.translate.TranslationService;
import com.tydic.task.util.SpringContextUtils;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.redis.core.RedisTemplate;

public class TranslationManage {
    private static final Logger log = LoggerFactory.getLogger(TranslationManage.class);
    private RedisTemplate<String, String> redisTemplate;
    private Map<String, TranslationConfig> translationConfigs;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String translateIdToName(String translationType, String id, Map<String, String> tranMap) {
        TranslationConfig config = this.translationConfigs.get(translationType);
        if (config == null) {
            config = (TranslationConfig)SpringContextUtils.getBean((String)translationType, TranslationConfig.class);
            if (config == null) {
                log.error("\u8f6c\u8bd1\u7c7b\u578b\uff1a{} \u5bf9\u5e94\u7684\u63a5\u53e3\u4e0d\u5b58\u5728\uff0c\u8bf7\u68c0\u67e5\u914d\u7f6e\u6587\u4ef6\uff01", (Object)translationType);
                return "";
            }
            Map<String, TranslationConfig> map = this.translationConfigs;
            synchronized (map) {
                this.translationConfigs.put(translationType, config);
            }
        }
        String name = null;
        StringBuilder stb = new StringBuilder(config.getPrefix());
        stb.append(config.getDelimiter());
        if (StringUtils.isNotBlank((CharSequence)config.getParaType())) {
            stb.append(config.getParaType());
            stb.append(config.getDelimiter());
        }
        stb.append(id);
        Object obj = tranMap.get(stb.toString());
        if (obj == null) {
            obj = this.redisTemplate.boundValueOps((Object)stb.toString()).get();
            if (obj == null) {
                TranslationService service = null;
                try {
                    service = config.getTranslationService();
                    name = service.selectNameFromDb(id, config.getParaType());
                }
                catch (Exception e) {
                    log.error("\u4ece\u6570\u636e\u5e93\u4e2d\u67e5\u8be2\u7f13\u5b58\u51fa\u9519\uff01\u8bf7\u68c0\u67e5\u53c2\u6570\uff1a \u67e5\u8be2\u6570\u636e\u5e93\u7684\u63a5\u53e3\uff1a{}\r\n reids\u524d\u7f00\uff1a{}\r\n paraType={}\r\n redisTimeOut={}", new Object[]{service == null ? null : service.getClass(), config.getPrefix(), config.getParaType(), config.getRedisTimeOut()});
                }
                if (StringUtils.isBlank((CharSequence)name)) {
                    name = "";
                }
                this.redisTemplate.boundValueOps((Object)stb.toString()).set((Object)name, config.getRedisTimeOut(), TimeUnit.MINUTES);
            } else {
                name = obj.toString();
            }
            tranMap.put(stb.toString(), name);
        } else {
            name = obj.toString();
        }
        return name;
    }

    public void setRedisTemplate(RedisTemplate<String, String> redisTemplate) {
        this.redisTemplate = redisTemplate;
    }

    public void setTranslationConfigs(Map<String, TranslationConfig> translationConfigs) {
        this.translationConfigs = translationConfigs;
    }
}

