/*
 * Decompiled with CFR 0.152.
 */
package com.chinaunicom.base.util;

import java.lang.reflect.Field;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import org.springframework.aop.framework.AdvisedSupport;
import org.springframework.aop.framework.AopProxy;
import org.springframework.aop.support.AopUtils;

public class ClassUtils {
    public static Class<?> getClass(Type type, int i) {
        if (type instanceof ParameterizedType) {
            return ClassUtils.getGenericClass((ParameterizedType)type, i);
        }
        if (type instanceof TypeVariable) {
            return ClassUtils.getClass(((TypeVariable)type).getBounds()[0], 0);
        }
        return (Class)type;
    }

    public static Class<?> getGenericClass(ParameterizedType parameterizedType, int i) {
        Type genericClass = parameterizedType.getActualTypeArguments()[i];
        if (genericClass instanceof ParameterizedType) {
            return (Class)((ParameterizedType)genericClass).getRawType();
        }
        if (genericClass instanceof GenericArrayType) {
            return (Class)((GenericArrayType)genericClass).getGenericComponentType();
        }
        if (genericClass instanceof TypeVariable) {
            return ClassUtils.getClass(((TypeVariable)genericClass).getBounds()[0], 0);
        }
        return (Class)genericClass;
    }

    public static Object getTarget(Object proxy) throws Exception {
        if (!AopUtils.isAopProxy((Object)proxy)) {
            return proxy;
        }
        if (AopUtils.isJdkDynamicProxy((Object)proxy)) {
            return ClassUtils.getJdkDynamicProxyTargetObject(proxy);
        }
        return ClassUtils.getCglibProxyTargetObject(proxy);
    }

    private static Object getCglibProxyTargetObject(Object proxy) throws Exception {
        Field h = proxy.getClass().getDeclaredField("CGLIB$CALLBACK_0");
        h.setAccessible(true);
        Object dynamicAdvisedInterceptor = h.get(proxy);
        Field advised = dynamicAdvisedInterceptor.getClass().getDeclaredField("advised");
        advised.setAccessible(true);
        Object target = ((AdvisedSupport)advised.get(dynamicAdvisedInterceptor)).getTargetSource().getTarget();
        return target;
    }

    private static Object getJdkDynamicProxyTargetObject(Object proxy) throws Exception {
        Field h = proxy.getClass().getSuperclass().getDeclaredField("h");
        h.setAccessible(true);
        AopProxy aopProxy = (AopProxy)h.get(proxy);
        Field advised = aopProxy.getClass().getDeclaredField("advised");
        advised.setAccessible(true);
        Object target = ((AdvisedSupport)advised.get(aopProxy)).getTargetSource().getTarget();
        return target;
    }
}

