/*
 * Decompiled with CFR 0.152.
 */
package com.chinaunicom.base.util;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.net.Inet4Address;
import java.net.InterfaceAddress;
import java.net.NetworkInterface;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.configuration.PropertiesConfiguration;
import org.apache.commons.lang3.StringUtils;
import org.dom4j.Attribute;
import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.io.OutputFormat;
import org.dom4j.io.SAXReader;
import org.dom4j.io.XMLWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class XmlManageDom4jUtils {
    private static final Logger log = LoggerFactory.getLogger(XmlManageDom4jUtils.class);

    public static void changeMqXmlFromAToB(String a, String b) {
        String path = System.getProperty("user.dir").replace("\\", "/") + "/src/main/resources/spring";
        File file = new File(path);
        File[] tempList = file.listFiles();
        if (tempList != null) {
            for (File f : tempList) {
                if (!f.getName().contains("-" + a + "-")) continue;
                String newPath = f.getPath().replace("-" + a + "-", "-" + b + "-");
                try {
                    XmlManageDom4jUtils.changeMQXml(f.getPath(), newPath);
                }
                catch (Exception e) {
                    log.error("\u8f6c\u6362\u751f\u4ea7\u8005\u51fa\u9519\uff01\u8bf7\u68c0\u67e5\u914d\u7f6e\u6587\u4ef6\u3010" + f.getPath() + "\u3011", (Throwable)e);
                }
            }
        }
    }

    public static void transformationServiceXmlToHsf() {
        String basePath = System.getProperty("user.dir").replace("\\", "/");
        String path = basePath + "/src/main/resources/spring";
        File file = new File(path);
        File[] tempList = file.listFiles();
        InputStream ins = null;
        Properties props = new Properties();
        try {
            ins = XmlManageDom4jUtils.class.getClassLoader().getResourceAsStream("env.properties");
            props.load(ins);
        }
        catch (IOException e) {
            throw new RuntimeException("\u52a0\u8f7denv.properties\u51fa\u9519", e);
        }
        finally {
            if (ins != null) {
                try {
                    ins.close();
                }
                catch (IOException e) {
                    log.error(e.getMessage(), (Throwable)e);
                }
            }
        }
        String[] saleInterfaces = props.getProperty("sale.interface", "").split(",");
        HashSet<String> saleInterfaceSet = new HashSet<String>(saleInterfaces.length);
        boolean openMqCunsumer = Boolean.parseBoolean(props.getProperty("mq.cunsumer.switch", "false").trim());
        for (String saleInterface : saleInterfaces) {
            saleInterfaceSet.add(saleInterface);
        }
        String[] chsfEspecialConfigs = props.getProperty("chsf_especial_config", "").split(",");
        HashMap<String, Set<String>> chsfEspecialConfigMap = new HashMap<String, Set<String>>(chsfEspecialConfigs.length);
        for (String chsfEspecialConfig : chsfEspecialConfigs) {
            String[] values = chsfEspecialConfig.split(":");
            if (values.length != 2) {
                log.error("hsf\u7279\u6b8a\u7684\u914d\u7f6e\u6587\u4ef6\u6709\u95ee\u9898\uff0c\u8bf7\u68c0\u67e5\u914d\u7f6e\u6587\u4ef6\u3010env.properties\u3011\u4e2d\u7684hsf_especial_config");
                continue;
            }
            String[] configs = values[1].split(",");
            HashSet<String> configsSet = new HashSet<String>(configs.length);
            for (String config : configs) {
                configsSet.add(config);
            }
            chsfEspecialConfigMap.put(values[0], configsSet);
        }
        String[] phsfEspecialConfigs = props.getProperty("phsf_especial_config", "").split(",");
        HashMap<String, Set<String>> phsfEspecialConfigMap = new HashMap<String, Set<String>>(phsfEspecialConfigs.length);
        for (String phsfEspecialConfig : phsfEspecialConfigs) {
            String[] values = phsfEspecialConfig.split(":");
            if (values.length != 2) {
                log.error("hsf\u7279\u6b8a\u7684\u914d\u7f6e\u6587\u4ef6\u6709\u95ee\u9898\uff0c\u8bf7\u68c0\u67e5\u914d\u7f6e\u6587\u4ef6\u3010env.properties\u3011\u4e2d\u7684hsf_especial_config");
                continue;
            }
            String[] configs = values[1].split(",");
            HashSet<String> configsSet = new HashSet<String>(configs.length);
            for (String config : configs) {
                configsSet.add(config);
            }
            phsfEspecialConfigMap.put(values[0], configsSet);
        }
        if (tempList != null) {
            for (File f : tempList) {
                String fName = f.getName();
                if (!fName.contains("-service.xml")) continue;
                String[] names = fName.split("-");
                String name = "";
                if (!"busi".equals(names[2]) && !"intfce".equals(names[2]) && !"function".equals(names[2])) continue;
                name = names[2];
                String cBasePath = basePath;
                String pPath = "";
                if (cBasePath.contains("/card_plan_function")) {
                    if (fName.contains("phsf")) continue;
                    if (fName.contains("busi")) {
                        cBasePath = cBasePath.replaceAll("fcenter", "bapi");
                    } else if (fName.contains("function")) {
                        cBasePath = cBasePath.replaceAll("fcenter", "fapi");
                    }
                    System.out.println("cBasePath = " + cBasePath);
                    pPath = basePath;
                    System.out.println("pPath = " + pPath);
                } else {
                    if (cBasePath.endsWith("_interface") && "interface".equals(names[2])) {
                        cBasePath = cBasePath.replace("_interface", "");
                    }
                    if (cBasePath.contains("function") || cBasePath.contains("interface")) {
                        cBasePath = fName.contains("busi") ? cBasePath.replaceAll("impl", "busi_api") : cBasePath.replaceAll("impl", "api");
                    } else if (fName.contains("busi")) {
                        cBasePath = cBasePath.replaceAll("impl", "busi_api");
                    } else if (fName.contains("function")) {
                        cBasePath = cBasePath.replaceAll("impl", "function_api");
                    } else if (fName.contains("intfce")) {
                        cBasePath = cBasePath.replaceAll("impl", "interface_api");
                    }
                    System.out.println("cBasePath = " + cBasePath);
                    pPath = basePath.replaceAll("impl", "center");
                    System.out.println("basePath = " + basePath);
                }
                String cPath = cBasePath + "/src/main/resources/spring/" + fName.replace("-service.xml", "-chsf.xml");
                pPath = pPath + "/src/main/resources/spring/" + fName.replace("-service.xml", "-phsf.xml");
                try {
                    XmlManageDom4jUtils.transformationService(f.getPath(), cPath, pPath, fName, saleInterfaceSet, openMqCunsumer, chsfEspecialConfigMap, phsfEspecialConfigMap);
                }
                catch (Exception e) {
                    log.error("\u751f\u6210hsf\u914d\u7f6e\u6587\u4ef6\u51fa\u9519\uff01\u8bf7\u68c0\u67e5\u914d\u7f6e\u6587\u4ef6\u3010" + f.getPath() + "\u3011", (Throwable)e);
                }
            }
        }
    }

    public static void changePropertiesFile() {
        log.info("\u5f00\u59cb\u4fee\u6539\u6d88\u8d39\u8005env\u914d\u7f6e\u6587\u4ef6\u4e2d\u7684TargetIp");
        String basePath = System.getProperty("user.dir").replace("\\", "/");
        String filePath = basePath + "/src/main/resources/env.properties";
        log.info("basePath = " + basePath);
        log.info("filePath = " + filePath);
        File file = new File(filePath);
        if (!file.exists()) {
            log.info("env.properties\u914d\u7f6e\u6587\u4ef6\u4e0d\u5b58\u5728\uff0c\u65e0\u6cd5\u4fee\u6539\u6d88\u8d39\u8005env\u914d\u7f6e\u6587\u4ef6\u4e2d\u7684TargetIp\u3002");
            return;
        }
        String vpnIp = XmlManageDom4jUtils.getVPNIpAddress();
        log.info("vpnIp = " + vpnIp);
        if (StringUtils.isBlank((CharSequence)vpnIp)) {
            log.info("\u83b7\u53d6\u5230\u7684VPN\u5730\u5740\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5VPN\u8fde\u63a5\u662f\u5426\u6b63\u5e38\uff01");
            return;
        }
        try {
            String timedtasktargetIp;
            String sysmgrTargetIp;
            String searchtargetIp;
            String numtargetIp;
            String usertarget_ip;
            String cardtargetIp;
            PropertiesConfiguration propConfig = new PropertiesConfiguration(filePath);
            propConfig.setAutoSave(true);
            String targetIp = propConfig.getString("target_IP");
            if (StringUtils.isNotBlank((CharSequence)targetIp) && targetIp.contains("127.0.0.1")) {
                targetIp = targetIp.replaceAll("127.0.0.1", vpnIp);
                propConfig.setProperty("target_IP", (Object)targetIp);
            }
            if (StringUtils.isNotBlank((CharSequence)(cardtargetIp = propConfig.getString("CARDTARGET_IP"))) && cardtargetIp.contains("127.0.0.1")) {
                cardtargetIp = cardtargetIp.replaceAll("127.0.0.1", vpnIp);
                propConfig.setProperty("CARDTARGET_IP", (Object)cardtargetIp);
            }
            if (StringUtils.isNotBlank((CharSequence)(usertarget_ip = propConfig.getString("USERTARGET_IP"))) && usertarget_ip.contains("127.0.0.1")) {
                usertarget_ip = usertarget_ip.replaceAll("127.0.0.1", vpnIp);
                propConfig.setProperty("USERTARGET_IP", (Object)usertarget_ip);
            }
            if (StringUtils.isNotBlank((CharSequence)(numtargetIp = propConfig.getString("NUMTARGET_IP"))) && numtargetIp.contains("127.0.0.1")) {
                numtargetIp = numtargetIp.replaceAll("127.0.0.1", vpnIp);
                propConfig.setProperty("NUMTARGET_IP", (Object)numtargetIp);
            }
            if (StringUtils.isNotBlank((CharSequence)(searchtargetIp = propConfig.getString("SEARCHTARGET_IP"))) && searchtargetIp.contains("127.0.0.1")) {
                searchtargetIp = searchtargetIp.replaceAll("127.0.0.1", vpnIp);
                propConfig.setProperty("SEARCHTARGET_IP", (Object)searchtargetIp);
            }
            if (StringUtils.isNotBlank((CharSequence)(sysmgrTargetIp = propConfig.getString("HSF_SYSMGR_TARGET_IP"))) && sysmgrTargetIp.contains("127.0.0.1")) {
                sysmgrTargetIp = sysmgrTargetIp.replaceAll("127.0.0.1", vpnIp);
                propConfig.setProperty("HSF_SYSMGR_TARGET_IP", (Object)sysmgrTargetIp);
            }
            if (StringUtils.isNotBlank((CharSequence)(timedtasktargetIp = propConfig.getString("TIMEDTASKTARGET_IP"))) && timedtasktargetIp.contains("127.0.0.1")) {
                timedtasktargetIp = timedtasktargetIp.replaceAll("127.0.0.1", vpnIp);
                propConfig.setProperty("TIMEDTASKTARGET_IP", (Object)timedtasktargetIp);
            }
        }
        catch (Exception e) {
            log.info("\u4fee\u6539\u6d88\u8d39\u8005env\u914d\u7f6e\u6587\u4ef6\u4e2d\u7684TargetIp\u51fa\u73b0\u5f02\u5e38", (Throwable)e);
        }
    }

    public static String getVPNIpAddress() {
        String ipAddress = null;
        try {
            Enumeration<NetworkInterface> enumeration = NetworkInterface.getNetworkInterfaces();
            while (enumeration.hasMoreElements()) {
                NetworkInterface item = enumeration.nextElement();
                log.debug("item.getDisplayName() = " + item.getDisplayName());
                if (!StringUtils.isNotBlank((CharSequence)item.getDisplayName()) || !item.getDisplayName().contains("VPN")) continue;
                for (InterfaceAddress address : item.getInterfaceAddresses()) {
                    if (!(address.getAddress() instanceof Inet4Address)) continue;
                    Inet4Address inet4Address = (Inet4Address)address.getAddress();
                    ipAddress = inet4Address.getHostAddress();
                    log.debug(inet4Address.getHostAddress());
                }
            }
        }
        catch (IOException ex) {
            log.debug("\u83b7\u53d6VPN IP\u5730\u5740\u5f02\u5e38\uff0c\u8bf7\u68c0\u67e5VPN\u662f\u5426\u5df2\u8fde\u63a5\uff01");
        }
        return ipAddress;
    }

    private static void transformationService(String path, String cPath, String pPath, String fileName, Set<String> saleInterfaces, boolean openMqCunsumer, Map<String, Set<String>> chsfEspecialConfigMap, Map<String, Set<String>> phsfEspecialConfigMap) throws Exception {
        String[] fs = fileName.split("-");
        String projectName = fs[1];
        SAXReader reader = new SAXReader();
        Document document = reader.read(new File(path));
        Element node = document.getRootElement();
        String description = node.element("description").getText();
        Document cdoc = DocumentHelper.createDocument();
        Element cbeans = cdoc.addElement("beans", "http://www.springframework.org/schema/beans");
        Document pdoc = DocumentHelper.createDocument();
        Element pbeans = pdoc.addElement("beans", "http://www.springframework.org/schema/beans");
        cbeans.addElement("description").setText(description.replace("service", "hsf\u670d\u52a1\u8c03\u7528\u8005"));
        pbeans.addElement("description").setText(description.replace("service", "hsf\u670d\u52a1\u63d0\u4f9b\u8005"));
        XmlManageDom4jUtils.setNamespace(cbeans);
        XmlManageDom4jUtils.setNamespace(pbeans);
        List list = node.elements("bean");
        for (Element e : list) {
            String id = e.attributeValue("id");
            String className = null;
            try {
                className = e.attributeValue("class");
                Class<?> claz = Class.forName(className);
                className = claz.getInterfaces()[0].getName();
                if (openMqCunsumer) {
                    if (!saleInterfaces.contains(className) && className.indexOf(".busi.") == -1) continue;
                    log.debug("\u751f\u6210\u63a5\u53e3\u7c7b\u80fd\u529b\uff1a" + className);
                    XmlManageDom4jUtils.setHsfConsumer(cbeans, id, className, projectName, chsfEspecialConfigMap.get(className));
                    XmlManageDom4jUtils.setHsfProvider(pbeans, id, className, projectName, phsfEspecialConfigMap.get(className));
                    continue;
                }
                if (!saleInterfaces.contains(className)) {
                    log.debug("\u751f\u6210\u529f\u80fd\u7c7b\u80fd\u529b\uff1a" + className);
                    XmlManageDom4jUtils.setHsfProvider(pbeans, id, className, projectName, phsfEspecialConfigMap.get(className));
                }
                XmlManageDom4jUtils.setHsfConsumer(cbeans, id, className, projectName, chsfEspecialConfigMap.get(className));
            }
            catch (Exception e1) {
                log.error("\u751f\u6210hsf\u914d\u7f6e\u9519\u8bef\uff0c\u8bf7\u68c0\u67e5\u63a5\u53e3" + className, (Object)e);
            }
        }
        XmlManageDom4jUtils.writer(cdoc, cPath);
        XmlManageDom4jUtils.writer(pdoc, pPath);
    }

    private static void setNamespace(Element beans) {
        beans.addNamespace("xsi", "http://www.w3.org/2001/XMLSchema-instance");
        beans.addNamespace("context", "http://www.springframework.org/schema/context");
        beans.addNamespace("hsf", "http://www.taobao.com/hsf");
        beans.addAttribute("xsi:schemaLocation", "http://www.springframework.org/schema/beans http://www.springframework.org/schema/beans/spring-beans.xsd http://www.springframework.org/schema/context http://www.springframework.org/schema/context/spring-context.xsd http://www.taobao.com/hsf  http://www.taobao.com/hsf/hsf.xsd ");
    }

    private static void setHsfConsumer(Element beans, String id, String className, String projectName, Set<String> chsfEspecialConfig) {
        Element hsfBean = beans.addElement("hsf:consumer");
        hsfBean.addAttribute("id", id);
        hsfBean.addAttribute("interface", className);
        hsfBean.addAttribute("version", "${" + projectName.toUpperCase() + "_VERSION}");
        hsfBean.addAttribute("group", "${" + projectName.toUpperCase() + "_GROUP}");
        if (id.equals("goodNumRuleMaintainCalcBusiService")) {
            hsfBean.addAttribute("clientTimeout", "600000");
        } else {
            hsfBean.addAttribute("clientTimeout", "60000");
        }
        hsfBean.addAttribute("target", "${" + projectName.toUpperCase() + "TARGET_IP}");
        if (CollectionUtils.isNotEmpty(chsfEspecialConfig)) {
            for (String config : chsfEspecialConfig) {
                String[] keyValue = config.split("=");
                hsfBean.addAttribute(keyValue[0], keyValue[1]);
            }
        }
    }

    private static void setHsfProvider(Element beans, String id, String className, String projectName, Set<String> phsfEspecialConfig) {
        Element hsfBean = beans.addElement("hsf:provider");
        hsfBean.addAttribute("id", id + "H");
        hsfBean.addAttribute("interface", className);
        hsfBean.addAttribute("ref", id);
        hsfBean.addAttribute("version", "${" + projectName.toUpperCase() + "_VERSION}");
        hsfBean.addAttribute("group", "${" + projectName.toUpperCase() + "_GROUP}");
        if (id.equals("goodNumRuleMaintainCalcBusiService")) {
            hsfBean.addAttribute("clientTimeout", "600000");
        } else {
            hsfBean.addAttribute("clientTimeout", "60000");
        }
        hsfBean.addAttribute("enableTXC", "true");
        hsfBean.addAttribute("serializeType", "hessian");
        if (CollectionUtils.isNotEmpty(phsfEspecialConfig)) {
            for (String config : phsfEspecialConfig) {
                String[] keyValue = config.split("=");
                hsfBean.addAttribute(keyValue[0], keyValue[1]);
            }
        }
    }

    private static void changeMQXml(String path, String newPath) throws Exception {
        SAXReader reader = new SAXReader();
        Document document = reader.read(new File(path));
        Element node = document.getRootElement();
        List list = node.elements("bean");
        for (Element e : list) {
            String value;
            Attribute attr = e.attribute("class");
            switch (value = attr.getValue()) {
                case "com.chinaunicom.base.mq.rocketmq.OnsProducerImpl": {
                    attr.setValue("com.chinaunicom.base.mq.ons.OnsProducerImpl");
                    XmlManageDom4jUtils.changeProducerPropes(e);
                    break;
                }
                case "com.chinaunicom.base.mq.rocketmq.BaseProducerImpl": {
                    attr.setValue("com.chinaunicom.base.mq.ons.BaseProducerImpl");
                    break;
                }
                case "com.chinaunicom.base.mq.rocketmq.OnsTransProducerImpl": {
                    attr.setValue("com.chinaunicom.base.mq.ons.OnsTransProducerImpl");
                    XmlManageDom4jUtils.changeProducerPropes(e);
                    break;
                }
                case "com.chinaunicom.base.mq.rocketmq.MQLocalTransactionExecuter": {
                    attr.setValue("com.chinaunicom.base.mq.ons.ONSLocalTransactionExecuter");
                    break;
                }
                case "com.chinaunicom.base.mq.ons.OnsProducerImpl": {
                    attr.setValue("com.chinaunicom.base.mq.rocketmq.OnsProducerImpl");
                    XmlManageDom4jUtils.changeProducerPropes(e);
                    break;
                }
                case "com.chinaunicom.base.mq.ons.BaseProducerImpl": {
                    attr.setValue("com.chinaunicom.base.mq.rocketmq.BaseProducerImpl");
                    break;
                }
                case "com.chinaunicom.base.mq.ons.OnsTransProducerImpl": {
                    attr.setValue("com.chinaunicom.base.mq.rocketmq.OnsTransProducerImpl");
                    XmlManageDom4jUtils.changeProducerPropes(e);
                    break;
                }
                case "com.chinaunicom.base.mq.ons.ONSLocalTransactionExecuter": {
                    attr.setValue("com.chinaunicom.base.mq.rocketmq.MQLocalTransactionExecuter");
                    break;
                }
                case "com.chinaunicom.base.mq.rocketmq.BaseConsumerImpl": {
                    attr.setValue("com.chinaunicom.base.mq.ons.BaseConsumerImpl");
                    XmlManageDom4jUtils.changeProducerPropes(e);
                    break;
                }
                case "com.chinaunicom.base.mq.rocketmq.ConsumerProerties": {
                    attr.setValue("com.chinaunicom.base.mq.ons.ConsumerProerties");
                    break;
                }
                case "com.chinaunicom.base.mq.rocketmq.MQCunsumerImpl": {
                    attr.setValue("com.chinaunicom.base.mq.ons.ONSCunsumerImpl");
                    break;
                }
                case "com.chinaunicom.base.mq.ons.BaseConsumerImpl": {
                    attr.setValue("com.chinaunicom.base.mq.rocketmq.BaseConsumerImpl");
                    XmlManageDom4jUtils.changeProducerPropes(e);
                    break;
                }
                case "com.chinaunicom.base.mq.ons.ConsumerProerties": {
                    attr.setValue("com.chinaunicom.base.mq.rocketmq.ConsumerProerties");
                    break;
                }
                case "com.chinaunicom.base.mq.ons.ONSCunsumerImpl": {
                    attr.setValue("com.chinaunicom.base.mq.rocketmq.MQCunsumerImpl");
                    break;
                }
            }
        }
        XmlManageDom4jUtils.writer(document, newPath);
    }

    private static void changeProducerPropes(Element e) {
        Element constructor = e.element("constructor-arg");
        if (constructor != null) {
            XmlManageDom4jUtils.changeProps(constructor);
        } else {
            List propertys = e.elements("property");
            for (Element property : propertys) {
                String nameValue = property.attributeValue("name");
                if (!"properties".equals(nameValue)) continue;
                XmlManageDom4jUtils.changeProps(property);
                break;
            }
        }
    }

    private static void changeProps(Element elem) {
        Element props = elem.element("props");
        List prolist = props.elements("prop");
        for (Element pe : prolist) {
            Attribute pattr = pe.attribute("key");
            String pValue = pattr.getValue();
            if ("NAMESRV_ADDR".equals(pValue)) {
                pattr.setValue("AccessKey");
                pe.setText("${ons.AccessKey}");
                Element prop = props.addElement("prop");
                prop.addAttribute("key", "SecretKey");
                prop.setText("${ons.SecretKey}");
                continue;
            }
            if ("AccessKey".equals(pValue)) {
                pattr.setValue("NAMESRV_ADDR");
                pe.setText("${mq.NAMESRV_ADDR}");
                continue;
            }
            if (!"SecretKey".equals(pValue)) continue;
            props.remove(pe);
        }
    }

    private static void writer(Document document, String newPath) throws Exception {
        OutputFormat format = OutputFormat.createPrettyPrint();
        format.setEncoding("UTF-8");
        File file = new File(newPath);
        FileOutputStream fileOutputStream = new FileOutputStream(file);
        OutputStreamWriter OutputStreamWriter2 = new OutputStreamWriter((OutputStream)fileOutputStream, "UTF-8");
        XMLWriter writer = new XMLWriter((Writer)OutputStreamWriter2, format);
        writer.write(document);
        writer.flush();
        fileOutputStream.close();
        OutputStreamWriter2.close();
        writer.close();
    }
}

